/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.callback;

import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.impl.auth.callback.STSRulesCallback;
import com.ibm.ws.wssecurity.trust.server.sts.STSCallbackHandler;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSConfigUtil;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSUriUtil;
import com.ibm.ws.wssecurity.trust.server.sts.ext.NoEntriesFoundException;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.DefaultIssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IdentityList;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Target;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.TokenTypeRule;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class STSDefaultCallbackHandler
implements STSCallbackHandler {
    private URI appliesTo;
    private URI issuer;
    private URI tokenType;
    private SecurityToken token;
    private final String FFDC_ID_1 = "FFDC-1";
    private static final TraceComponent tc = Tr.register(STSDefaultCallbackHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public void setAppliesTo(URI appliesToURI) {
        this.appliesTo = appliesToURI;
    }

    public URI getAppliesTo() {
        return this.appliesTo;
    }

    public void setIssuer(URI issuerURI) {
        this.issuer = issuerURI;
    }

    public URI getIssuer() {
        return this.issuer;
    }

    public void setTokenType(URI tokenTypeURI) {
        this.tokenType = tokenTypeURI;
    }

    public URI getTokenType() {
        return this.tokenType;
    }

    public void setToken(SecurityToken securityToken) {
        this.token = securityToken;
    }

    public SecurityToken getToken() {
        return this.token;
    }

    public void handle(Callback[] cbs) throws UnsupportedCallbackException {
        String method = "handle";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        for (Callback cb : cbs) {
            if (!(cb instanceof STSRulesCallback)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Handling instance of STSRulesCallback.");
            }
            STSRulesCallback stsRulesCB = (STSRulesCallback)cb;
            try {
                stsRulesCB.setToken(this.token);
                stsRulesCB.setRules(this.extractRules());
                stsRulesCB.setSuccessful(true);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Succesfully extracted rules from the configuration.");
            }
            catch (NoEntriesFoundException e) {
                stsRulesCB.setSuccessful(true);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "No rules found in the configuration.");
            }
            catch (NoSuchElementException e) {
                stsRulesCB.setSuccessful(false);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Failed to extract rules from the configuration.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }

    private IdentityList extractRules() throws NoSuchElementException, NoEntriesFoundException {
        String method = "extractRules";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        if (this.appliesTo == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Callback's appliesTo was not set.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return null;
        }
        if (this.tokenType == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Callback's tokenType was not set.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            if (this.issuer == null) {
                Tr.debug(tc, "Callback's issuer is null: attempting to extract default rule.");
            } else {
                Tr.debug(tc, "Attempting to extract rule.");
            }
        }
        STSTargetMap targetMap = null;
        try {
            targetMap = STSConfigUtil.getSTSTargetMap();
        }
        catch (SoapSecurityException ex) {
            FFDCFilter.processException((Throwable)ex, "STSDefaultCallbackHandler.extractRules", "FFDC-1", this);
            Tr.error(tc, "wssecurity.config.s03");
            throw new NoEntriesFoundException("Failed to get the STS target configuration.");
        }
        List<Target> targets = targetMap.getTarget();
        Iterator<Target> targetsIter = targets.iterator();
        Target endpoint = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Searching Targets for specified AppliesTo: " + this.appliesTo);
        }
        while (targetsIter.hasNext()) {
            Target currentTarget = targetsIter.next();
            String currentAppliesTo = currentTarget.getAppliesTo();
            if (currentAppliesTo != null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Configuration contains a Target with a null AppliesTo.");
                continue;
            }
            if (STSUriUtil.URICompare(currentAppliesTo, this.appliesTo.toString()) != 0) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Target found.");
            }
            endpoint = currentTarget;
            break;
        }
        if (endpoint == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No Target matching the specified AppliesTo was found in the configuration.");
            }
            throw new NoSuchElementException("Target not found.");
        }
        List<TokenTypeRule> ttRules = null;
        DefaultIssuerRule dir = endpoint.getDefaultIssuerRule();
        List<IssuerRule> iRules = endpoint.getIssuerRule();
        if (dir == null && (iRules == null || iRules.size() == 0)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No Issuer Rules found in the configuration, trust authentication NOT configured.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw new NoEntriesFoundException("Issuer Rules not found.");
        }
        if (this.issuer == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Searching for TokenTypeRules under DefaultIssuerRule.");
            }
            if (dir == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No rule exists for a null issuer for this endpoint: " + endpoint.getAppliesTo());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                throw new NoSuchElementException("DefaultIssuerRule not found.");
            }
            ttRules = dir.getTokenTypeRule();
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Searching for TokenTypeRules under IssuerRules for Issuer: " + this.issuer);
            }
            if (iRules == null || iRules.size() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No issuer rule exists for a this endpoint: " + endpoint.getAppliesTo());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                throw new NoSuchElementException("IssuerRule not found.");
            }
            Iterator<IssuerRule> irIter = iRules.iterator();
            IssuerRule iRule = null;
            while (irIter.hasNext()) {
                IssuerRule currentIRule = irIter.next();
                String currentIssuer = currentIRule.getIssuerURI();
                if (currentIssuer != null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Configuration contains an IssuerRule with a null IssuerURI.");
                    continue;
                }
                if (!currentIssuer.equals(this.issuer.toString())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "IssuerRule found.");
                }
                iRule = currentIRule;
                break;
            }
            if (iRule == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No IssuerRule matching the specified IssuerURI was found in the configuration.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                throw new NoSuchElementException("IssuerRule not found.");
            }
            ttRules = iRule.getTokenTypeRule();
        }
        if (ttRules == null || ttRules.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No TokenTypeRules were found under the IssuerRules/DefaultIssuerRule, trust authentication NOT configured.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw new NoEntriesFoundException("TokenTypeRules not found.");
        }
        TokenTypeRule ttRule = null;
        Iterator<TokenTypeRule> ttRulesIter = ttRules.iterator();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Searching through TokenTypeRules for TokenType: " + this.tokenType);
        }
        while (ttRulesIter.hasNext()) {
            TokenTypeRule currentTTRule = ttRulesIter.next();
            String currentTokenType = currentTTRule.getRequiredTokenTypeURI();
            if (currentTokenType != null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Configuration contains a TokenTypeRule with a null RequiredTokenTypeURI.");
                continue;
            }
            if (!currentTokenType.equals(this.tokenType.toString())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TokenTypeRule found.");
            }
            ttRule = currentTTRule;
            break;
        }
        if (ttRule == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No TokenTypeRule matching the specified TokenType was found in the configuration.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw new NoSuchElementException("TokenTypeRule not found.");
        }
        IdentityList rules = ttRule.getIdentityList();
        if (rules == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No IdentityList was found under the matching TokenTypeRule.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw new NoEntriesFoundException("IdentityList not found, trust authentication NOT configured.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IdentityList successfully extracted!");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return rules;
    }
}

