/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler.token;

import com.ibm.ws.wssecurity.token.CacheableTokenCache;
import com.ibm.ws.wssecurity.token.CacheableTokenCacheFactory;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.SecurityUIDGenerator;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.NonceToken;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.ByteArrayOutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;

public class WSNonceManagerImpl
implements NonceManager {
    private static final TraceComponent tc = Tr.register(WSNonceManagerImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String clsName = WSNonceManagerImpl.class.getName();
    private static final String comp = "security.wssecurity";
    private static final String DEFAULT_JCE_PROVIDER = "DEFAULT_JCE_PROVIDER";
    private static final String IBMJCE = "IBMJCE";
    private static final String IBMSEC_RANDOM = "IBMSecureRandom";
    private static final String NONCE_CACHE_SIZE_KEY = "com.ibm.websphere.wssecurity.util.nonceCacheSize";
    private static final String NONCE_LENGTH_KEY = "com.ibm.websphere.wssecurity.util.nonceLength";
    private SecureRandom _random = null;
    private int _nonceLength = 128;
    private int _nonceCacheTimeout = 600000;
    private CacheableTokenCache _nonceCache;

    public WSNonceManagerImpl(String cacheName, int cacheSize, int cacheTimeout, int nonceLength, boolean cacheDistributed) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSNonceManagerImpl(String cacheName[" + cacheName + "]," + "int cacheSize[" + cacheSize + "]," + "int cacheTimeout[" + cacheTimeout + "]," + "int nonceLength[" + nonceLength + "]," + "boolean cacheDistributed[" + cacheDistributed + "])");
        }
        this._nonceCache = CacheableTokenCacheFactory.getNonceInstance();
        if (tc.isDebugEnabled() && this._nonceCache != null) {
            Tr.debug(tc, "Nonce cache instance obtained.");
        }
        this._nonceCacheTimeout = cacheTimeout * 1000;
        String nonceCacheSize = System.getProperty(NONCE_CACHE_SIZE_KEY);
        int size = cacheSize;
        if (nonceCacheSize != null && (nonceCacheSize = nonceCacheSize.trim()).length() != 0) {
            try {
                int i = Integer.parseInt(nonceCacheSize);
                if (i <= 16) {
                    Tr.warning(tc, "security.wssecurity.WSEC0124W", new Object[]{nonceCacheSize, new Integer(16), new Integer(cacheSize)});
                    size = cacheSize;
                } else {
                    size = i;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Nonce cache size from system property (com.ibm.websphere.wssecurity.util.nonceCacheSize) = " + size);
                    }
                }
            }
            catch (NumberFormatException e) {
                Tr.processException((Throwable)e, WSNonceManagerImpl.class.getName() + ".WSNonceManagerImpl", "89", this);
                Tr.warning(tc, "security.wssecurity.WSEC5190W", new Object[]{NONCE_CACHE_SIZE_KEY, nonceCacheSize, new Integer(cacheSize)});
                size = cacheSize;
            }
        }
        if (cacheName == null || cacheName.length() == 0) {
            cacheName = "NonceDistributionCacheMap";
        }
        this._nonceLength = nonceLength;
        String nonceLengthStr = System.getProperty(NONCE_LENGTH_KEY);
        if (nonceLengthStr != null && (nonceLengthStr = nonceLengthStr.trim()).length() != 0) {
            try {
                int i = Integer.parseInt(nonceLengthStr);
                if (i <= 16) {
                    Tr.warning(tc, "security.wssecurity.WSEC0127W", new Object[]{nonceLengthStr, new Integer(16), new Integer(nonceLength)});
                    this._nonceLength = nonceLength;
                } else {
                    this._nonceLength = i;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Nonce length from system property (com.ibm.websphere.wssecurity.util.nonceLength) = " + this._nonceLength);
                    }
                }
            }
            catch (NumberFormatException e) {
                Tr.processException((Throwable)e, WSNonceManagerImpl.class.getName() + ".WSNonceManagerImpl", "124", this);
                Tr.warning(tc, "security.wssecurity.WSEC5190W", new Object[]{NONCE_LENGTH_KEY, nonceLengthStr, new Integer(nonceLength)});
                this._nonceLength = nonceLength;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce length = " + this._nonceLength);
        }
        this.initSecureRandom();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSNonceManagerImpl(String cacheName, int cacheSize, int cacheTimeout,int nonceLength, boolean cacheDistributed)");
        }
    }

    public boolean validate(byte[] nonce) throws SoapSecurityException {
        NonceToken aNonceToken;
        String nonceIdentifier;
        boolean retVal;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        if (nonce == null || nonce.length == 0) {
            Tr.error(tc, "security.wssecurity.WSEC0121E");
            throw SoapSecurityException.format("security.wssecurity.WSEC0121E");
        }
        if (this._nonceCache == null) {
            String key = ".WSEC0122E";
            Tr.error(tc, comp + key);
            throw SoapSecurityException.format(comp + key);
        }
        if (tc.isDebugEnabled()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(nonce, 0, nonce.length);
            Tr.debug(tc, "validating ", out.toString());
        }
        boolean bl = retVal = !this._nonceCache.containsToken(nonceIdentifier = Base64.encode(nonce), aNonceToken = new NonceToken(nonceIdentifier), this._nonceCacheTimeout);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate returns " + retVal);
        }
        return retVal;
    }

    public byte[] generate() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generate()");
        }
        byte[] nonce = null;
        if (this._random != null) {
            nonce = new byte[this._nonceLength];
            this._random.nextBytes(nonce);
            if (tc.isEntryEnabled()) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                out.write(nonce, 0, nonce.length);
                Tr.exit(tc, "generate", out.toString());
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No random number generator");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generate returns null");
            }
        }
        return nonce;
    }

    private void initSecureRandom() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initSecureRandom()");
        }
        String jceProvider = Security.getProperty(DEFAULT_JCE_PROVIDER);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "JCE Default Provider is " + jceProvider);
        }
        if (jceProvider == null || jceProvider.length() == 0) {
            jceProvider = IBMJCE;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JCE Default Provider is null, force to use: " + jceProvider);
            }
        }
        try {
            this._random = SecureRandom.getInstance(IBMSEC_RANDOM, jceProvider);
        }
        catch (NoSuchAlgorithmException e) {
            String msgKey = "security.wssecurity.WSEC5195E";
            Tr.warning(tc, msgKey, new Object[]{IBMSEC_RANDOM, jceProvider, e});
        }
        catch (NoSuchProviderException e) {
            String msgKey = "security.wssecurity.WSEC5195E";
            Tr.warning(tc, msgKey, new Object[]{IBMSEC_RANDOM, jceProvider, e});
        }
        byte[] genBytes = new byte[this._nonceLength];
        this._random.nextBytes(genBytes);
        this._random.setSeed(SecurityUIDGenerator.createUID().getBytes());
        this._random.nextBytes(genBytes);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initSecureRandom()");
        }
    }

    public String toString() {
        return clsName;
    }
}

