/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler.token;

import com.ibm.ws.wssecurity.handler.token.CertCache;
import com.ibm.ws.wssecurity.token.CertCacheManager;
import com.ibm.ws.wssecurity.util.ConfigConstants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.cert.Certificate;

public class WSCertCacheManagerImpl
implements CertCacheManager {
    private static final TraceComponent tc = Tr.register(WSCertCacheManagerImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSCertCacheManagerImpl.class.getName();
    private CertCache _cache = null;

    public WSCertCacheManagerImpl(String cacheName, int cacheSize, int cacheTimeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCertCacheManagerImpl(String cacheName[" + cacheName + "]," + "int cacheSize[" + cacheSize + "]," + "int cacheTimeout[" + cacheTimeout + "])");
        }
        int size = ConfigConstants.validCertCacheSize(cacheSize);
        int timeout = ConfigConstants.validCertCacheTimeout(cacheTimeout);
        if (cacheName == null || cacheName.length() == 0) {
            cacheName = "WSSCertCache";
        }
        this._cache = new CertCache(cacheName, size, timeout * 1000, true, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCertCacheManagerImpl(String cacheName, int cacheSize, int cacheTimeout)");
        }
    }

    public Certificate getCachedCert(String key) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCachedCert(String key[" + key + "])");
        }
        Certificate cert = null;
        if (key == null || key.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified key is null or zero length.");
            }
        } else if (this._cache == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The certificate cache is null.");
            }
        } else {
            Object obj = this._cache.get(key);
            if (obj == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is no object linked with the specified key [" + key + "].");
                }
            } else if (obj instanceof Certificate) {
                cert = (Certificate)obj;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is an object linked with the specified key [" + key + "].  But it's not the Certificate object: " + obj.getClass().getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCachedCert(String key) returns Certificate[" + cert + "]");
        }
        return cert;
    }

    public void cacheCert(String key, Certificate cert) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cacheCert(String key[" + key + "]," + "Certificate cert[" + cert + "]");
        }
        if (key == null || key.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified key is null or zero length.");
            }
        } else if (cert == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified certificate is null.");
            }
        } else if (this._cache == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The certificate cache is null.");
            }
        } else {
            this._cache.put(key, cert);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cacheCert(String key, Token token");
        }
    }
}

