/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler.token;

import com.ibm.ws.wssecurity.handler.token.TokenCache;
import com.ibm.ws.wssecurity.token.PropagationToken;
import com.ibm.ws.wssecurity.token.TokenCacheManager;
import com.ibm.ws.wssecurity.util.ConfigConstants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;

public class TokenCacheManagerImpl
implements TokenCacheManager {
    private static final TraceComponent tc = Tr.register(TokenCacheManagerImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = TokenCacheManagerImpl.class.getName();
    private TokenCache _cache = null;
    private long _cushion = 0L;

    public TokenCacheManagerImpl(String cacheName, int cacheSize, int cacheTimeout, long cushion) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TokenCacheManagerImpl(String cacheName[" + cacheName + "]," + "int cacheSize[" + cacheSize + "]," + "int cacheTimeout[" + cacheTimeout + "]" + "long cushion[" + cushion + "])");
        }
        int size = ConfigConstants.validTokenCacheSize(cacheSize);
        int timeout = ConfigConstants.validTokenCacheTimeout(cacheTimeout);
        if (cacheName == null || cacheName.length() == 0) {
            cacheName = "WSSTokenCache";
        }
        this._cache = new TokenCache(cacheName, size, timeout * 1000, true, false);
        this._cushion = ConfigConstants.validTokenCushion(cushion);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TokenCacheManagerImpl(String cacheName, int cacheSize, int cacheTimeout)");
        }
    }

    public PropagationToken getCachedToken(String key) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCachedToken(String key[" + key + "])");
        }
        PropagationToken token = null;
        if (key == null || key.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified key is null or zero length.");
            }
        } else if (this._cache == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The token cache is null.");
            }
        } else {
            Object obj = this._cache.get(key);
            if (obj == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is no object linked with the specified key [" + key + "].");
                }
            } else if (obj instanceof PropagationToken) {
                token = (PropagationToken)obj;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is an object linked with the specified key [" + key + "].  But it's not the Token object: " + obj.getClass().getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCachedToken(String key) returns Token[" + token + "]");
        }
        return token;
    }

    public void cacheToken(String key, PropagationToken token) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cacheToken(String key[" + key + "]," + "PropagationToken token[" + token + "]");
        }
        if (key == null || key.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified key is null or zero length.");
            }
        } else if (token == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified token is null.");
            }
        } else if (this._cache == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The token cache is null.");
            }
        } else {
            this._cache.put(key, token);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cacheToken(String key, PropagationToken token");
        }
    }

    public long getCushion() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCushion()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCushion() returns " + this._cushion);
        }
        return this._cushion;
    }
}

