/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler.token;

import com.ibm.ws.wssecurity.util.WsObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class CacheEntry
implements Externalizable {
    private Object _id;
    private Object _value;
    private byte[] _serializedId;
    private byte[] _serializedValue;
    private static final long serialVersionUID = -5512338712217731535L;

    public CacheEntry() {
        this._id = null;
        this._value = null;
    }

    public CacheEntry(Object id, Object value) {
        this._id = id;
        this._value = value;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CacheEntry)) {
            return false;
        }
        CacheEntry cacheEntry = (CacheEntry)object;
        if (this._id == null || cacheEntry._id == null) {
            return super.equals(object);
        }
        return this._id.equals(cacheEntry._id);
    }

    public int hashCode() {
        if (this._id == null) {
            return CacheEntry.class.hashCode();
        }
        return this._id.hashCode();
    }

    public String getId() {
        if (this._id != null) {
            return this._id.toString();
        }
        return null;
    }

    public Object getValue() {
        return this._value;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        String id;
        String exceptionMessage = null;
        if (this._serializedId == null) {
            try {
                this._serializedId = CacheEntry.serialize((Serializable)this._id);
            }
            catch (ClassCastException e) {
                exceptionMessage = e.toString();
            }
            catch (IOException e) {
                exceptionMessage = e.toString();
            }
            if (this._serializedId == null) {
                id = this._id == null ? "null" : this._id.getClass().getName();
                String value = this._value == null ? "null" : this._value.getClass().getName();
                throw new IOException("The identifier in the cached object can not be serialized: CacheID={" + id + "}, CacheValue={" + value + "}, Exception={" + exceptionMessage + "}");
            }
        }
        if (this._serializedValue == null) {
            try {
                this._serializedValue = CacheEntry.serialize((Serializable)this._value);
            }
            catch (ClassCastException e) {
                exceptionMessage = e.toString();
            }
            catch (IOException e) {
                exceptionMessage = e.toString();
            }
            if (this._serializedValue == null) {
                id = this._id == null ? "null" : this._id.getClass().getName();
                String value = this._value == null ? "null" : this._value.getClass().getName();
                throw new IOException("The value in the cached object can not be serialized: CacheID={" + id + "}, CacheValue={" + value + "}, Exception={" + exceptionMessage + "}");
            }
        }
        if (this._serializedId != null) {
            out.writeInt(this._serializedId.length);
            out.write(this._serializedId);
        } else {
            out.writeInt(-1);
        }
        if (this._serializedValue != null) {
            out.writeInt(this._serializedValue.length);
            out.write(this._serializedValue);
        } else {
            out.writeInt(-1);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._serializedValue = null;
        this._serializedId = null;
        this._value = null;
        this._id = null;
        int keyLength = in.readInt();
        if (keyLength > 0) {
            this._serializedId = new byte[keyLength];
            in.readFully(this._serializedId);
        } else {
            this._serializedId = null;
        }
        if (this._serializedId != null) {
            this._id = CacheEntry.deserialize(this._serializedId);
        }
        if ((keyLength = in.readInt()) > 0) {
            this._serializedValue = new byte[keyLength];
            in.readFully(this._serializedValue);
        } else {
            this._serializedValue = null;
        }
        if (this._serializedValue != null) {
            this._value = CacheEntry.deserialize(this._serializedValue);
        }
    }

    private static final byte[] serialize(Serializable serializable) throws IOException {
        if (serializable == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        return byteArrayOutputStream.toByteArray();
    }

    private static final Serializable deserialize(byte[] array) throws IOException, ClassNotFoundException {
        return CacheEntry.deserialize(array, 0, array.length);
    }

    private static final Serializable deserialize(byte[] array, int offset, int length) throws IOException, ClassNotFoundException {
        if (array == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(array, offset, length);
        WsObjectInputStream objectInputStream = null;
        byteArrayInputStream.mark(array.length);
        objectInputStream = new WsObjectInputStream(byteArrayInputStream);
        return (Serializable)objectInputStream.readObject();
    }
}

