/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicyTypeLoader;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.wssecurity.handler.Constants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

public class WSSecurityPolicyTypeLoaderImpl
implements PolicyTypeLoader {
    private static final TraceComponent tc = Tr.register(WSSecurityPolicyTypeLoaderImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static JAXBContext jaxbContext = null;

    public void init(Map properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map properties)");
        }
    }

    private static synchronized JAXBContext getJAXBContext() throws JAXBException {
        if (jaxbContext != null) {
            return jaxbContext;
        }
        final ClassLoader cl = WSSecurityPolicyTypeLoaderImpl.class.getClassLoader();
        try {
            jaxbContext = (JAXBContext)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws JAXBException {
                    return JAXBContext.newInstance((String)"org.oasis_open.docs.ws_sx.ws_securitypolicy._200512:org.xmlsoap.schemas.ws._2004._09.policy:com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext:org.oasis_open.docs.ws_sx.ws_securitypolicy._200702:com.ibm.xmlns.prod.websphere._200710.ws_securitypolicy_ext", (ClassLoader)cl);
                }
            });
        }
        catch (PrivilegedActionException pac) {
            Throwable th = pac.getCause();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception received from JAXB. Unable to load PolicySet: " + th);
            }
            if (th instanceof JAXBException) {
                throw (JAXBException)th;
            }
            throw new JAXBException(th.getMessage());
        }
        return jaxbContext;
    }

    public void load(ClassLoader sysCL, VariableExpander vm, InputStream policySetInputStream, PolicySetConfiguration psConfig) throws Exception {
        Policy policy;
        block20: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "load(ClassLoader sysCL, VariableMap vm, String policyTypePathname, PolicySetConfiguration psConfig): ", new Object[]{sysCL, vm, policySetInputStream, psConfig});
            }
            JAXBContext jcPolicy = null;
            try {
                jcPolicy = WSSecurityPolicyTypeLoaderImpl.getJAXBContext();
            }
            catch (Exception e) {
                psConfig.setPolicyTypeConfiguration(Constants.WS_SECURITY_POLICY_JAXBOBJECT_KEY, e);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception received from JAXB. Unable to load PolicySet:  " + e);
                }
                throw e;
            }
            policy = null;
            try {
                final Unmarshaller umPolicy = jcPolicy.createUnmarshaller();
                final InputStream policyInputStream = policySetInputStream;
                Object obj = null;
                try {
                    obj = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws JAXBException {
                            return umPolicy.unmarshal(policyInputStream);
                        }
                    });
                }
                catch (PrivilegedActionException pac) {
                    Throwable th = pac.getCause();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception received from Unmarshaller. Unable to load PolicySet: " + th);
                    }
                    if (th instanceof JAXBException) {
                        throw (JAXBException)th;
                    }
                    throw new JAXBException(th.getMessage());
                }
                finally {
                    policyInputStream.close();
                }
                if (obj instanceof Policy) {
                    policy = (Policy)obj;
                    break block20;
                }
                throw new SoapSecurityException("security.wssecurityUnmarshalled obj is NOT a Policy object");
            }
            catch (Exception e) {
                psConfig.setPolicyTypeConfiguration(Constants.WS_SECURITY_POLICY_JAXBOBJECT_KEY, e);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught. Unable to load PolicySet:  " + e);
                }
                throw e;
            }
            finally {
                policySetInputStream.close();
            }
        }
        psConfig.setPolicyTypeConfiguration(Constants.WS_SECURITY_POLICY_JAXBOBJECT_KEY, policy);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "load(ClassLoader sysCL, VariableMap vm, String policyTypePathname, PolicySetConfiguration psConfig)");
        }
    }

    public String getType() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getType()");
        }
        String type = Constants.WS_SECURITY_POLICY_TYPE_NAME;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getType() returns \"" + type + "\"");
        }
        return type;
    }

    public void destroy() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy()");
        }
    }
}

