/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.ws.wspolicy.domain.PolicyInputStreamHolder;
import com.ibm.ws.wssecurity.handler.WSSecurityAssertionTransform;
import com.ibm.ws.wssecurity.handler.WSSecurityWSPolicyAssertionProcessor;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.w3.ns.ws_policy.Policy;

public class WSSecurityPolicyHolder {
    private static final TraceComponent tc = Tr.register(WSSecurityWSPolicyAssertionProcessor.class, "WS-Policy", "com.ibm.ws.wssecurity.resources.wssmessages");
    private Policy _input = null;
    private Policy _output = null;
    private Policy _main = null;
    private Object _bindings = null;

    protected WSSecurityPolicyHolder(PolicyInputStreamHolder pish) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "WSSecurityPolicyHolder");
        }
        this._main = this.inputStreamToPolicy(pish.getMain());
        this._input = this.inputStreamToPolicy(pish.getInput());
        this._output = this.inputStreamToPolicy(pish.getOutput());
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "WSSecurityPolicyHolder");
        }
    }

    protected WSSecurityPolicyHolder() {
    }

    public Policy getInput() {
        return this._input;
    }

    public void setInput(Policy input) {
        this._input = input;
    }

    public Policy getMain() {
        return this._main;
    }

    public void setMain(Policy neutral) {
        this._main = neutral;
    }

    public Policy getOutput() {
        return this._output;
    }

    public void setOutput(Policy output) {
        this._output = output;
    }

    private Policy inputStreamToPolicy(InputStream policy) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "inputStreamToPolicy");
        }
        ClassLoader cl = WSSecurityAssertionTransform.class.getClassLoader();
        String policyPackages = "org.w3.ns.ws_policy:org.oasis_open.docs.ws_sx.ws_securitypolicy._200702:com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext:com.ibm.xmlns.prod.websphere._200710.ws_securitypolicy_ext";
        Policy result = null;
        try {
            JAXBContext context = JAXBContext.newInstance((String)policyPackages, (ClassLoader)cl);
            final Unmarshaller umPolicy = context.createUnmarshaller();
            final InputStream policyInputStream = policy;
            Object obj = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws JAXBException {
                    return umPolicy.unmarshal(policyInputStream);
                }
            });
            if (obj instanceof Policy) {
                result = (Policy)obj;
            }
            policy.close();
            policyInputStream.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "inputStreamToPolicy");
        }
        return result;
    }

    public Object getBindings() {
        return this._bindings;
    }

    public void setBindings(Object bindings) {
        this._bindings = bindings;
    }
}

