/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.ws.wssecurity.platform.auth.SecureConversationCacheHelper;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.CommonLogUtils;
import com.ibm.ws.wssecurity.util.KRB5TokenCacheUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;

public class WSSecurityInFaultHandler
extends AbstractHandler {
    private static final TraceComponent tc = Tr.register(WSSecurityInFaultHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityInFaultHandler.class.getName();

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(MessageContext msgContext)" + msgContext);
        }
        boolean isServerSide = false;
        try {
            String faultLocalName;
            isServerSide = Axis2Util.isServiceProvider(msgContext);
            if (!isServerSide && (faultLocalName = this.getFaultLocalName(msgContext)) != null) {
                if (faultLocalName.equals("BadContextToken")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalidating SCT entry in the client cache.");
                    }
                    SecureConversationCacheHelper.invalidateCache(msgContext);
                } else if ("InvalidSecurityToken".equals(faultLocalName) || "SecurityTokenUnavailable".equals(faultLocalName)) {
                    KRB5TokenCacheUtil.invalidatetKRB5TokenFromCache(msgContext);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(MessageContext msgContext)" + msgContext);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private String getFaultLocalName(MessageContext msgContext) {
        String faultLocalName;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getFaultLocalName(MessageContext msgContext)");
            }
            faultLocalName = null;
            try {
                SOAPFaultCode code;
                SOAPFaultSubCode subCode;
                OMElement element;
                SOAPEnvelope envelope = msgContext.getEnvelope();
                SOAPFault fault = envelope.getBody().getFault();
                OMDocument doc = DOMUtil.getOwnerDocument(envelope);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The fault message to be processed :");
                    CommonLogUtils.logDebug(doc.getOMDocumentElement(), tc);
                }
                SOAPFaultDetail detail = null;
                detail = fault.getDetail();
                String faultDetailString = null;
                if (detail != null && (element = detail.getFirstElement()) != null) {
                    faultDetailString = element.getText();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Fault Detail = " + faultDetailString);
                }
                if ((subCode = (code = fault.getCode()).getSubCode()) == null) {
                    faultLocalName = code.getTextAsQName().getLocalPart();
                } else {
                    while (subCode.getSubCode() != null) {
                        subCode = subCode.getSubCode();
                    }
                    faultLocalName = subCode.getValue().getTextAsQName().getLocalPart();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SOAP Fault = " + code.getText());
                    Tr.debug(tc, "Fault local name = " + faultLocalName);
                    Tr.debug(tc, "Fault name space = " + code.getTextAsQName().getNamespaceURI());
                }
                SOAPFaultReason reason = fault.getReason();
                String reasonTxt = reason.getText();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Fault reason = " + reasonTxt);
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block12;
                e.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFaultLocalName(MessageContext msgContext) returns result = " + faultLocalName);
        }
        return faultLocalName;
    }
}

