/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.websphere.wssecurity.wssapi.WSSConsumingContext;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.handler.WSSecurityConsumerBase;
import com.ibm.ws.wssecurity.handler.WSSecurityGeneratorHandler;
import com.ibm.ws.wssecurity.handler.WSSecurityGlobalHandler;
import com.ibm.ws.wssecurity.platform.auth.WSSContextFactory;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSPolicySetUtil;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.ConstantsRetrieverFactory;
import com.ibm.ws.wssecurity.util.TokenHolder;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.WSSConsumerTransformImpl;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;

public class WSSecurityConsumerHandler
extends WSSecurityGlobalHandler {
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityConsumerHandler.class.getName();
    private static final long serialVersionUID = 0L;
    private static final TraceComponent tc = Tr.register(WSSecurityConsumerHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private WSSecurityConsumerBase _ch = null;

    public WSSecurityConsumerHandler() {
        this.inboundHandler = true;
    }

    public void init(HandlerDescription handlerdesc) {
        this.handlerDesc = handlerdesc;
        this._ch = new WSSecurityConsumerBase();
        try {
            this._ch.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        boolean isServerSide;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(MessageContext msgContext)");
        }
        if (msgContext != null && (isServerSide = WSSContextManagerFactory.getInstance().processIsServer())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isServerSide == true");
            }
            try {
                PrivilegedExceptionAction invokeAction;
                Handler.InvocationResponse ir;
                final MessageContext fMsgContext = msgContext;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "runWith MessageContext = " + fMsgContext);
                }
                if ((ir = (Handler.InvocationResponse)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(invokeAction = new PrivilegedExceptionAction(){

                    public Object run() throws AxisFault {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "invokeAction, MessageContext");
                        }
                        return WSSecurityConsumerHandler.this._invoke(fMsgContext);
                    }
                }, fMsgContext){
                    final /* synthetic */ PrivilegedExceptionAction val$invokeAction;
                    final /* synthetic */ MessageContext val$fMsgContext;
                    {
                        this.val$invokeAction = privilegedExceptionAction;
                        this.val$fMsgContext = messageContext;
                    }

                    @Override
                    public Object run() throws SoapSecurityException {
                        return (Handler.InvocationResponse)WSSContextFactory.getInstance().runWith(this.val$invokeAction, this.val$fMsgContext);
                    }
                })) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "runWith return non-null response");
                    }
                    return ir;
                }
            }
            catch (PrivilegedActionException pe) {
                Throwable t;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught " + pe.getMessage());
                }
                if ((t = pe.getCause()) instanceof SoapSecurityException) {
                    AxisFault af = AxisFault.makeFault(t);
                    if (((SoapSecurityException)t).getFaultCode() != null) {
                        af.setFaultCode(((SoapSecurityException)t).getFaultCode());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Fault Code =  " + ((SoapSecurityException)t).getFaultCode());
                        }
                    } else if (msgContext.getProperty("com.ibm.ws.wssecurity.sc.FaultCode") != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Fault Code =  " + ((QName)msgContext.getProperty("com.ibm.ws.wssecurity.sc.FaultCode")).toString());
                        }
                        af.setFaultCode((QName)msgContext.getProperty("com.ibm.ws.wssecurity.sc.FaultCode"));
                        msgContext.removeProperty("com.ibm.ws.wssecurity.sc.FaultCode");
                    }
                    throw af;
                }
                throw AxisFault.makeFault(pe);
            }
        }
        return this._invoke(msgContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Handler.InvocationResponse _invoke(MessageContext msgContext) throws AxisFault {
        block73: {
            boolean isServerSide;
            boolean isCancelResponseMessage;
            boolean isBootstrapMode;
            WSSConsumerConfig cCfg;
            block78: {
                block81: {
                    SoapSecurityException se;
                    AxisOperation operation;
                    Parameter aParameter;
                    block79: {
                        block80: {
                            boolean isTrustRequest;
                            block75: {
                                OperationContext opCtx;
                                block74: {
                                    block76: {
                                        Object obj;
                                        block77: {
                                            if (tc.isEntryEnabled()) {
                                                Tr.entry(tc, "_invoke(MessageContext msgContext)");
                                            }
                                            cCfg = null;
                                            aParameter = null;
                                            isBootstrapMode = false;
                                            isTrustRequest = false;
                                            isCancelResponseMessage = false;
                                            if (msgContext == null) break block73;
                                            isServerSide = false;
                                            try {
                                                isServerSide = Axis2Util.isServiceProvider(msgContext);
                                            }
                                            catch (Exception e) {
                                                throw AxisFault.makeFault(e);
                                            }
                                            if (!isServerSide) break block74;
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "isServerSide == true");
                                            }
                                            String actionURI = this.getActionURI(msgContext);
                                            this.setHttpSession(msgContext);
                                            boolean trust = STSPolicySetUtil.isTrustRequest(msgContext, actionURI);
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "isTrustRequest() returned" + trust);
                                            }
                                            String action = null;
                                            if (trust) {
                                                action = STSPolicySetUtil.mapTrustAction(actionURI);
                                                if (action == null) {
                                                    if (tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "action == null");
                                                    }
                                                } else if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "action is " + action);
                                                }
                                            }
                                            PolicySetConfiguration psc = null;
                                            if (!trust || action == null || action.length() <= 0) break block75;
                                            isTrustRequest = true;
                                            try {
                                                psc = STSPolicySetUtil.getTrustPolicySetConfiguration(msgContext, action, WSSecurityGeneratorHandler.class.getClassLoader());
                                            }
                                            catch (Exception e) {
                                                throw AxisFault.makeFault(e);
                                            }
                                            if (psc == null) break block75;
                                            msgContext.setProperty("com.ibm.wssecurity.trust.server.policyset", psc);
                                            obj = psc.getPolicyTypeBinding(PrivateConsumerConfig.class);
                                            if (obj == null) break block76;
                                            if (!(obj instanceof PrivateConsumerConfig)) break block77;
                                            cCfg = (PrivateConsumerConfig)obj;
                                            if (cCfg == null || !tc.isDebugEnabled()) break block75;
                                            Tr.debug(tc, "Loaded trust policy set.");
                                            break block75;
                                        }
                                        if (obj instanceof Exception) {
                                            Exception e = (Exception)obj;
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Unable to process inbound SOAP message.  PolicySet not loaded properly.", e);
                                            }
                                            Tr.processException((Throwable)e, clsName + ".invoke", "%C", this);
                                            if (e instanceof SoapSecurityException) {
                                                throw AxisFault.makeFault(e);
                                            }
                                            Tr.error(tc, "security.wssecurity.WSSecurityConsumerHandler.s02");
                                            SoapSecurityException se2 = SoapSecurityException.format("security.wssecurity.WSSecurityConsumerHandler.s02", e);
                                            throw AxisFault.makeFault(se2);
                                        }
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Unable to process inbound SOAP message. Unexpected object in PolicyTypeBinding: " + obj);
                                        }
                                        Tr.error(tc, "security.wssecurity.WSSecurityConsumerHandler.s03", new Object[]{obj.getClass().getName()});
                                        SoapSecurityException se3 = SoapSecurityException.format("security.wssecurity.WSSecurityConsumerHandler.s03", obj.getClass().getName());
                                        throw AxisFault.makeFault(se3);
                                    }
                                    if (!tc.isDebugEnabled()) break block75;
                                    Tr.debug(tc, "No PolicyType Binding");
                                    break block75;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "isServerSide == false");
                                }
                                if ((opCtx = msgContext.getOperationContext()) == null) {
                                    opCtx = (OperationContext)msgContext.getProperty("unverifiedOperationContext");
                                }
                                if (opCtx != null) {
                                    HashMap allMsgCtxs = opCtx.getMessageContexts();
                                    Set msgContexts = allMsgCtxs.entrySet();
                                    for (Map.Entry singleMsgCtx : msgContexts) {
                                        MessageContext tempMsgCtx = (MessageContext)singleMsgCtx.getValue();
                                        if ((Boolean)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.sc.SCT.Cancel") != null && ((Boolean)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.sc.SCT.Cancel")).booleanValue()) {
                                            isCancelResponseMessage = true;
                                            tempMsgCtx.setProperty("com.ibm.ws.wssecurity.sc.bootstrapProperty", new Boolean(false));
                                            if (!tc.isDebugEnabled()) break;
                                            Tr.debug(tc, "isCancelResponseMessage = " + (Boolean)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.sc.SCT.Cancel"));
                                            break;
                                        }
                                        if ((Boolean)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.sc.bootstrapProperty") == null) continue;
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Bootstrap property = " + (Boolean)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.sc.bootstrapProperty"));
                                        }
                                        if (((Boolean)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.sc.bootstrapProperty")).booleanValue()) {
                                            isBootstrapMode = true;
                                        }
                                        if (!isBootstrapMode) continue;
                                        if ((PrivateGeneratorConfig)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.sc.bootstrapAndAppPolicyConfig") != null && (cCfg = ((PrivateGeneratorConfig)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.sc.bootstrapAndAppPolicyConfig")).getBootstrapConsumerConfig()) != null && tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Valid bootstrap config object");
                                        }
                                        tempMsgCtx.setProperty("com.ibm.ws.wssecurity.sc.bootstrapProperty", new Boolean(false));
                                        Object obj = tempMsgCtx.getProperty("SC_COOKIE_MAP");
                                        if (obj == null || !(obj instanceof Map)) break;
                                        Map cookieMap = (Map)obj;
                                        obj = msgContext.getProperty("Cookie");
                                        if (obj != null) {
                                            cookieMap.put("Cookie", obj);
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Added Cookie property to SC_COOKIE_MAP: " + obj);
                                            }
                                        }
                                        if ((obj = msgContext.getProperty("Location")) == null) break;
                                        cookieMap.put("Location", obj);
                                        if (!tc.isDebugEnabled()) break;
                                        Tr.debug(tc, "Added Location property to SC_COOKIE_MAP: " + obj);
                                        break;
                                    }
                                }
                            }
                            if (cCfg != null || isBootstrapMode || isTrustRequest) break block78;
                            operation = msgContext.getAxisOperation();
                            if (operation == null || (aParameter = operation.getParameter(ConstantsRetrieverFactory.getInstance().getPolicySetKey())) == null) break block79;
                            Object obj = aParameter.getValue();
                            PolicySetConfiguration psc = null;
                            if (obj != null && obj instanceof PolicySetConfiguration) {
                                psc = (PolicySetConfiguration)obj;
                            } else {
                                AxisService service = msgContext.getAxisService();
                                obj = service.getParameter(ConstantsRetrieverFactory.getInstance().getPolicySetKey()).getValue();
                                if (obj != null && obj instanceof PolicySetConfiguration) {
                                    psc = (PolicySetConfiguration)obj;
                                }
                            }
                            if (psc == null) break block79;
                            obj = psc.getPolicyTypeBinding(PrivateConsumerConfig.class);
                            if (obj == null) break block80;
                            if (obj instanceof PrivateConsumerConfig) {
                                cCfg = (PrivateConsumerConfig)obj;
                                if (cCfg != null && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Loaded policy using policy set.");
                                }
                                break block79;
                            } else {
                                if (obj instanceof Exception) {
                                    Exception e = (Exception)obj;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Unable to process inbound SOAP message.  PolicySet not loaded properly.", e);
                                    }
                                    Tr.processException((Throwable)e, clsName + ".invoke", "%C", this);
                                    if (e instanceof SoapSecurityException) {
                                        throw AxisFault.makeFault(e);
                                    }
                                    Tr.error(tc, "security.wssecurity.WSSecurityConsumerHandler.s02");
                                    se = SoapSecurityException.format("security.wssecurity.WSSecurityConsumerHandler.s02", e);
                                    throw AxisFault.makeFault(se);
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Unable to process inbound SOAP message. Unexpected object in PolicyTypeBinding: " + obj);
                                }
                                Tr.error(tc, "security.wssecurity.WSSecurityConsumerHandler.s03", new Object[]{obj.getClass().getName()});
                                SoapSecurityException se4 = SoapSecurityException.format("security.wssecurity.WSSecurityConsumerHandler.s03", obj.getClass().getName());
                                throw AxisFault.makeFault(se4);
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No PolicyType Binding");
                        }
                    }
                    if (operation != null && aParameter != null) break block78;
                    PolicySetConfiguration psc = null;
                    AxisService service = msgContext.getAxisService();
                    if (service == null || (aParameter = service.getParameter(ConstantsRetrieverFactory.getInstance().getPolicySetKey())) == null) break block78;
                    Object obj = aParameter.getValue();
                    if (obj != null && obj instanceof PolicySetConfiguration) {
                        psc = (PolicySetConfiguration)obj;
                    }
                    if (psc == null) break block78;
                    obj = psc.getPolicyTypeBinding(PrivateConsumerConfig.class);
                    if (obj == null) break block81;
                    if (obj instanceof PrivateConsumerConfig) {
                        cCfg = (PrivateConsumerConfig)obj;
                        if (cCfg != null && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Loaded policy using policy set.");
                        }
                        break block78;
                    } else {
                        if (obj instanceof Exception) {
                            Exception e = (Exception)obj;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Unable to process inbound SOAP message.  PolicySet not loaded properly.", e);
                            }
                            Tr.processException((Throwable)e, clsName + ".invoke", "%C", this);
                            if (e instanceof SoapSecurityException) {
                                throw AxisFault.makeFault(e);
                            }
                            Tr.error(tc, "security.wssecurity.WSSecurityConsumerHandler.s02");
                            SoapSecurityException se5 = SoapSecurityException.format("security.wssecurity.WSSecurityConsumerHandler.s02", e);
                            throw AxisFault.makeFault(se5);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Unable to process inbound SOAP message. Unexpected object in PolicyTypeBinding: " + obj);
                        }
                        Tr.error(tc, "security.wssecurity.WSSecurityConsumerHandler.s03", new Object[]{obj.getClass().getName()});
                        se = SoapSecurityException.format("security.wssecurity.WSSecurityConsumerHandler.s03", obj.getClass().getName());
                        throw AxisFault.makeFault(se);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No PolicyType Binding");
                }
            }
            if (!isCancelResponseMessage) {
                boolean consumerBindingsFound = false;
                if (msgContext.getProperty("com.ibm.ws.wssecurity.constants.wssapi.key.consumer") != null) {
                    consumerBindingsFound = true;
                } else {
                    HashMap wssProperties;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cannot find WSSAPI_CONFIG_KEY_CONSUMER on MessageContext. Look in WSS_PROPERTYMAP property map.");
                    }
                    if ((wssProperties = TokenHolder.getWssPropertyMapFromInboundMessageContext(msgContext)) != null) {
                        WSSConsumingContext consCon = (WSSConsumingContext)wssProperties.get("com.ibm.ws.wssecurity.constants.wssapi.key.consumer");
                        if (consCon != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found WSSAPI_CONFIG_KEY_CONSUMER in WSS_PROPERTYMAP map. Putting it on MessageContext Options.");
                            }
                            consumerBindingsFound = true;
                            msgContext.setProperty("com.ibm.ws.wssecurity.constants.wssapi.key.consumer", consCon);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WSS_PROPERTYMAP map not found.");
                    }
                }
                if (tc.isDebugEnabled() && consumerBindingsFound) {
                    Tr.debug(tc, "WSSAPI logPolicySetOverride = " + WSSecurityGeneratorHandler.logPolicySetOverride);
                }
                if (cCfg != null && consumerBindingsFound && !isServerSide && WSSecurityGeneratorHandler.logPolicySetOverride) {
                    Tr.warning(tc, "security.wssecurity.WSSecurityConsumerHandler.s01");
                }
                if (cCfg == null) {
                    if (consumerBindingsFound) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "WSSAPI enables...");
                        }
                        try {
                            cCfg = WSSConsumerTransformImpl.getInstance().transform(msgContext);
                        }
                        catch (Exception e) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Error in WSSAPI: " + e.toString());
                            }
                            throw AxisFault.makeFault(e);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WSSAPI consumer bindings not found. Response message will not be processed by web services security.");
                    }
                }
            }
            if (cCfg == null) {
                return Handler.InvocationResponse.CONTINUE;
            }
            try {
                try {
                    this._ch.invoke(msgContext, cCfg);
                    this.setSelfManagedData(msgContext);
                    if (isBootstrapMode) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting Sandesha2AppProcessingDone to true");
                        }
                        msgContext.setProperty("Sandesha2AppProcessingDone", "true");
                    }
                }
                catch (Exception e) {
                    Tr.processException((Throwable)e, clsName + ".invoke", "%C", this);
                    throw AxisFault.makeFault(e);
                }
                Object var17_28 = null;
            }
            catch (Throwable throwable) {
                Object var17_29 = null;
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_invoke(MessageContext msgContext)");
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void setHttpSession(MessageContext msgContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setHttpSession(MessageContext msgContext)");
        }
        boolean enableSession = false;
        if (msgContext != null) {
            Object obj;
            AxisService service;
            Object obj2;
            Parameter aParameter = null;
            PolicySetConfiguration psc = null;
            AxisOperation operation = msgContext.getAxisOperation();
            if (operation != null && (aParameter = operation.getParameter(ConstantsRetrieverFactory.getInstance().getPolicySetKey())) != null && (obj2 = aParameter.getValue()) != null && obj2 instanceof PolicySetConfiguration) {
                psc = (PolicySetConfiguration)obj2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found PolicySetConfiguration in AxisOperation");
                }
            }
            if (psc == null && (service = msgContext.getAxisService()) != null && (aParameter = service.getParameter(ConstantsRetrieverFactory.getInstance().getPolicySetKey())) != null && (obj = aParameter.getValue()) != null && obj instanceof PolicySetConfiguration) {
                psc = (PolicySetConfiguration)obj;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found PolicySetConfiguration in AxisService");
                }
            }
            if (psc != null) {
                obj2 = psc.getPolicyTypeConfiguration(ConstantsRetrieverFactory.getInstance().getHTTPPolicyKey());
                if (obj2 != null && obj2 instanceof Properties) {
                    Properties attributes = (Properties)obj2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found http policy");
                    }
                    String sessionEnabled = attributes.getProperty(ConstantsRetrieverFactory.getInstance().getMaintainSessionKey());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Session enabled property = " + sessionEnabled);
                    }
                    if (sessionEnabled != null && "yes".equalsIgnoreCase(sessionEnabled)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting enableSession to true");
                        }
                        enableSession = true;
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No http policy found");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No HTTP PolicySetConfiguration object found");
            }
        }
        if (enableSession) {
            Object obj;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempting to enabling session");
            }
            if ((obj = msgContext.getProperty("transport.http.servletRequest")) != null && obj instanceof HttpServletRequest) {
                HttpServletRequest req = (HttpServletRequest)obj;
                HttpSession session = req.getSession(true);
                if (tc.isDebugEnabled()) {
                    if (session != null) {
                        Tr.debug(tc, "HTTP session is " + session.getId());
                    } else {
                        Tr.debug(tc, "HTTP session is null");
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "transport.http.servletRequest is null or not of type HttpServletRequest");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Not enabling session");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setHttpSession(MessageContext msgContext)");
        }
    }
}

