/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.ws.policyset.runtime.BindingLoader;
import com.ibm.ws.policyset.runtime.DefaultBinding;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.wssecurity.handler.Constants;
import com.ibm.ws.wssecurity.handler.PolicyInboundConfig;
import com.ibm.ws.wssecurity.handler.PolicyOutboundConfig;
import com.ibm.ws.wssecurity.handler.WSSBindings;
import com.ibm.ws.wssecurity.handler.WSSPolicy;
import com.ibm.ws.wssecurity.platform.util.ConfigHelperFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

public class WSSecurityBindingLoaderImpl
implements BindingLoader {
    private static final TraceComponent tc = Tr.register(WSSecurityBindingLoaderImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityBindingLoaderImpl.class.getName();
    private static JAXBContext jaxbContext = null;

    public void init(Map properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map properties)");
        }
    }

    private static synchronized JAXBContext getJAXBContext() throws JAXBException {
        if (jaxbContext != null) {
            return jaxbContext;
        }
        final ClassLoader cl = WSSecurityBindingLoaderImpl.class.getClassLoader();
        try {
            jaxbContext = (JAXBContext)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws JAXBException {
                    return JAXBContext.newInstance((String)"com.ibm.xmlns.prod.websphere._200608.ws_securitybinding:com.ibm.xmlns.prod.websphere._200710.ws_securitybinding", (ClassLoader)cl);
                }
            });
        }
        catch (PrivilegedActionException pac) {
            Throwable th = pac.getCause();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception received from JAXB. Unable to load PolicySet: " + th);
            }
            if (th instanceof JAXBException) {
                throw (JAXBException)th;
            }
            throw new JAXBException(th.getMessage());
        }
        return jaxbContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDefault(ClassLoader sysCL, VariableExpander vm, InputStream defaultBindingStream, DefaultBinding defaultBinding) throws Exception {
        SoapSecurityException se;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadDefault(ClassLoader sysCL, VariableExpander vm, InputStream defaultBindingStream, DefaultBinding defaultBinding): ", new Object[]{sysCL, vm, defaultBindingStream, defaultBinding});
        }
        Object securityDefaultBindings = null;
        WSSecurityDefaultConfiguration securityDefaultConfig = new WSSecurityDefaultConfiguration();
        JAXBContext jc = null;
        try {
            jc = WSSecurityBindingLoaderImpl.getJAXBContext();
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught in loadDefault() while getting JAXBContext for Default Bindings");
            }
            se = SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s01", e);
            Tr.processException((Throwable)se, clsName + ".loadDefault", "%C", this);
            securityDefaultConfig.setDefaultBindingsLoadingException(se);
        }
        if (jc != null) {
            try {
                Unmarshaller um = jc.createUnmarshaller();
                if (defaultBindingStream != null) {
                    securityDefaultBindings = um.unmarshal(defaultBindingStream);
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught in loadDefault() while unmarshalling.  Error while loading PolicySet Default Bindings");
                }
                se = SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s01", e);
                Tr.processException((Throwable)se, clsName + ".loadDefault", "%C", this);
                securityDefaultConfig.setDefaultBindingsLoadingException(se);
            }
            finally {
                if (defaultBindingStream != null) {
                    defaultBindingStream.close();
                }
            }
            if (securityDefaultBindings == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSecurity Default Bindings were found.");
                }
                SoapSecurityException se2 = SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s03");
                Tr.processException((Throwable)se2, clsName + ".loadDefault", "%C", this);
                securityDefaultConfig.setDefaultBindingsLoadingException(se2);
            }
        } else {
            SoapSecurityException se3 = SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s02");
            Tr.processException((Throwable)se3, clsName + ".loadDefault", "%C", this);
            securityDefaultConfig.setDefaultBindingsLoadingException(se3);
        }
        ConfigHelperFactory.getInstance().loadConfig(vm, securityDefaultConfig, securityDefaultBindings, defaultBinding);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadDefault(ClassLoader sysCL, VariableExpander vm, String defaultBindingPathname, DefaultBinding defaultBinding)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCustom(ClassLoader appCL, ClassLoader sysCL, VariableExpander vm, InputStream appBindingInputStream, DefaultBinding defaultBinding, PolicySetConfiguration psConfig) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCustom(ClassLoader appCL, ClassLoader sysCL, VariableExpander vm, String appBindingPathname, DefaultBinding defaultBinding, PolicySetConfiguration psConfig): ", new Object[]{appCL, sysCL, vm, appBindingInputStream, defaultBinding, psConfig});
        }
        WSSecurityDefaultConfiguration defaultConfiguration = null;
        String attachmentType = null;
        Policy jcPolicy = null;
        Throwable customBindingException = null;
        Object securityBindings = null;
        if (psConfig == null) {
            Tr.error(tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s08");
            throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s08");
        }
        if (defaultBinding != null) {
            Object defaultBindingObj = defaultBinding.getDefaultBinding(Constants.WS_SECURITY_DEFAULT_BINDING_KEY);
            if (defaultBindingObj != null) {
                if (defaultBindingObj instanceof WSSecurityDefaultConfiguration) {
                    defaultConfiguration = (WSSecurityDefaultConfiguration)defaultBindingObj;
                } else if (defaultBindingObj instanceof Exception) {
                    if (tc.isDebugEnabled()) {
                        Exception e = (Exception)defaultBindingObj;
                        Tr.debug(tc, "Exception retrieved from getDefaultBinding: " + e);
                        defaultConfiguration = new WSSecurityDefaultConfiguration();
                        SoapSecurityException se = SoapSecurityException.format("security.wssecurity.WasConfigHelperImpl.s01", e.toString());
                        defaultConfiguration.setDefaultBindingsLoadingException(se);
                    }
                } else if (tc.isDebugEnabled()) {
                    String msg = "Unexpected object type found for WSSecurityDefaultConfiguration. Found " + defaultBindingObj.getClass().getName() + ". Expected " + Policy.class.getName() + ".";
                    Tr.debug(tc, msg);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No default bindings found.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Default  bindings [" + defaultConfiguration + "]");
            }
        }
        try {
            Object obj;
            JAXBContext jc = WSSecurityBindingLoaderImpl.getJAXBContext();
            if (jc == null) {
                Tr.error(tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s06");
                customBindingException = SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s06");
                Tr.processException(customBindingException, clsName + ".loadDefault", "%C", this);
            } else {
                final Unmarshaller um = jc.createUnmarshaller();
                if (appBindingInputStream != null) {
                    final InputStream bindingInputStream = appBindingInputStream;
                    try {
                        securityBindings = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws JAXBException {
                                return um.unmarshal(bindingInputStream);
                            }
                        });
                    }
                    catch (PrivilegedActionException pac) {
                        Throwable th = pac.getCause();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception received from Unmarshaller. Unable to load PolicySet: " + th);
                        }
                        if (th instanceof JAXBException) {
                            customBindingException = (JAXBException)th;
                            Tr.processException(customBindingException, clsName + ".loadDefault", "%C", this);
                        } else {
                            customBindingException = new JAXBException(th.getMessage());
                            Tr.processException(customBindingException, clsName + ".loadDefault", "%C", this);
                        }
                    }
                    finally {
                        bindingInputStream.close();
                        appBindingInputStream.close();
                    }
                }
            }
            if (securityBindings == null) {
                if (defaultConfiguration == null) {
                    Tr.error(tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s07");
                    throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s07");
                }
                Tr.warning(tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s09");
            }
            if ((obj = psConfig.getPolicyTypeConfiguration(Constants.WS_SECURITY_POLICY_JAXBOBJECT_KEY)) != null) {
                if (!(obj instanceof Policy)) {
                    if (obj instanceof Exception) {
                        Exception e = (Exception)obj;
                        Tr.processException((Throwable)e, clsName + ".loadCustom", "%C", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception retrieved from PolicyTypeLoader: " + e);
                        }
                        throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s11", e);
                    }
                    Tr.error(tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s10", new Object[]{Policy.class.getName(), obj.getClass().getName()});
                    throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s10", Policy.class.getName(), obj.getClass().getName());
                }
            } else {
                Tr.error(tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s08");
                throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s08");
            }
            jcPolicy = (Policy)obj;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found WSSecurity JAXB Policy Object" + jcPolicy + "\"");
            }
            if ((obj = psConfig.getPolicyTypeConfiguration(Constants.POLICY_SET_ATTACHMENT_TYPE)) != null) {
                if (!(obj instanceof String)) {
                    Tr.error(tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s12", new Object[]{obj.getClass().getName()});
                    throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s12", obj.getClass().getName());
                }
            } else {
                Tr.error(tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s13");
                throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s13");
            }
            attachmentType = (String)obj;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found policy set attachment type: \"" + attachmentType + "\"");
            }
            boolean inboundIsRequest = false;
            boolean outboundIsRequest = false;
            if (Constants.CLIENT_ATTACHMENT.equals(attachmentType)) {
                outboundIsRequest = true;
                inboundIsRequest = false;
            } else if (Constants.SERVER_ATTACHMENT.equals(attachmentType)) {
                outboundIsRequest = false;
                inboundIsRequest = true;
            } else if (Constants.TRUST_SERVICE_ATTACHMENT.equals(attachmentType)) {
                outboundIsRequest = false;
                inboundIsRequest = true;
            } else {
                Tr.error(tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s12", new Object[]{attachmentType});
                throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s12", attachmentType);
            }
            if (tc.isDebugEnabled()) {
                if (outboundIsRequest) {
                    Tr.debug(tc, "Outbound message is a request.");
                } else {
                    Tr.debug(tc, "Outbound message is a response.");
                }
                if (inboundIsRequest) {
                    Tr.debug(tc, "Inbound message is a request.");
                } else {
                    Tr.debug(tc, "Inbound message is a response.");
                }
            }
            WSSPolicy wssPolicy = new WSSPolicy(jcPolicy);
            WSSBindings wssBindings = new WSSBindings(securityBindings);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSPolicy: " + wssPolicy);
                Tr.debug(tc, "WSSBindings: " + wssBindings);
            }
            PolicyInboundConfig pic = null;
            pic = new PolicyInboundConfig(wssBindings, wssPolicy, inboundIsRequest, appCL, defaultConfiguration);
            psConfig.setPolicyTypeBinding(PrivateConsumerConfig.class, pic);
            PolicyOutboundConfig poc = null;
            poc = new PolicyOutboundConfig(wssBindings, wssPolicy, outboundIsRequest, appCL, defaultConfiguration);
            psConfig.setPolicyTypeBinding(PrivateGeneratorConfig.class, poc);
        }
        catch (SoapSecurityException se) {
            Tr.processException((Throwable)se, clsName + ".loadCustom", "%C", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught in loadCustom().  Error while loading PolicySet Bindings");
            }
            psConfig.setPolicyTypeBinding(PrivateConsumerConfig.class, se);
            psConfig.setPolicyTypeBinding(PrivateGeneratorConfig.class, se);
            throw se;
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, clsName + ".loadCustom", "%C", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught in loadCustom().  Error while loading PolicySet Bindings");
            }
            SoapSecurityException se = SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s05", e);
            psConfig.setPolicyTypeBinding(PrivateConsumerConfig.class, se);
            psConfig.setPolicyTypeBinding(PrivateGeneratorConfig.class, se);
            throw se;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadCustom(ClassLoader appCL, ClassLoader sysCL, VariableExpander vm, String appBindingPathname, DefaultBinding defaultBinding, PolicySetConfiguration psConfig)");
        }
    }

    public String getType() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getType()");
        }
        String type = Constants.WS_SECURITY_POLICY_TYPE_NAME;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getType() returns \"" + type + "\"");
        }
        return type;
    }

    public void destroy() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy()");
        }
    }
}

