/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.handler.PolicyBinding;
import com.ibm.ws.wssecurity.handler.PolicyConfigUtil;
import com.ibm.ws.wssecurity.handler.Protection;
import com.ibm.ws.wssecurity.handler.ProtectionOrSupportingToken;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.xmlns.prod.websphere._200710.ws_securitypolicy_ext.WssCustomToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.HeaderType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SePartsType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SecureConversationTokenType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.TokenAssertionType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.NestedPolicyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SerElementsType;
import org.w3c.dom.Element;
import org.xmlsoap.schemas.ws._2004._08.addressing.EndpointReferenceType;
import org.xmlsoap.schemas.ws._2004._09.policy.OperatorContentType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSPolicy {
    private static final TraceComponent tc = Tr.register(WSSPolicy.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSPolicy.class.getName();
    private String targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512";
    private List<String> wss10Assertions = new ArrayList<String>();
    private List<String> wss11Assertions = new ArrayList<String>();
    private List<String> trust10Assertions = new ArrayList<String>();
    private List<String> trust13Assertions = new ArrayList<String>();
    private List<Protection> protectionAssertions = new ArrayList<Protection>();
    private List<ProtectionOrSupportingToken> supportingTokens = new ArrayList<ProtectionOrSupportingToken>();
    private List<HashMap<String, ProtectionOrSupportingToken>> callerExactlyOneTokens = new ArrayList<HashMap<String, ProtectionOrSupportingToken>>();
    private PolicyBinding policyBinding = null;

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public List<String> getWss10Assertions() {
        return this.wss10Assertions;
    }

    public List<String> getWss11Assertions() {
        return this.wss11Assertions;
    }

    public List<String> getTrust10Assertions() {
        return this.trust10Assertions;
    }

    public List<String> getTrust13Assertions() {
        return this.trust13Assertions;
    }

    public List<Protection> getProtectionAssertions() {
        return this.protectionAssertions;
    }

    public List<ProtectionOrSupportingToken> getSupportingTokens() {
        return this.supportingTokens;
    }

    public List<HashMap<String, ProtectionOrSupportingToken>> getCallerExactlyOneTokens() {
        return this.callerExactlyOneTokens;
    }

    public PolicyBinding getPolicyBinding() {
        return this.policyBinding;
    }

    public WSSPolicy(Policy appPolicy) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSSPolicy (Policy appPolicy)", new Object[]{appPolicy});
        }
        this.init(appPolicy);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSSPolicy (Policy appPolicy)", new Object[]{appPolicy});
        }
    }

    protected final void init(Policy policy) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Policy policyRoot):", new Object[]{policy});
        }
        Protection protection = null;
        boolean tnsSet = false;
        HashMap<String, Protection> protectionAssertionsMap = new HashMap<String, Protection>();
        if (policy != null) {
            List<Object> children = policy.getPolicyOrAllOrExactlyOne();
            Object obj = null;
            if (children != null) {
                for (int i = 0; i < children.size(); ++i) {
                    obj = children.get(i);
                    if (obj instanceof Policy) {
                        Policy subPolicy = (Policy)obj;
                        String idReference = subPolicy.getId();
                        boolean retrieveAssertions = false;
                        retrieveAssertions = this.retrieveAssertions(idReference);
                        if (!retrieveAssertions) continue;
                        List<Object> subPolicyChildren = subPolicy.getPolicyOrAllOrExactlyOne();
                        for (int j = 0; j < subPolicyChildren.size(); ++j) {
                            obj = subPolicyChildren.get(j);
                            if (obj instanceof JAXBElement) {
                                List<String> encryptedElements;
                                Object encryptedElementAssertion;
                                List<String> signedElements;
                                Object signedElementAssertion;
                                QName newHeaderName;
                                String namespace;
                                String localName;
                                QName headerName;
                                Object header;
                                int a;
                                List<Object> headers;
                                Object bodyPart;
                                Object messageParts;
                                boolean alreadyProcessed;
                                JAXBElement jaxbel = (JAXBElement)obj;
                                QName name = jaxbel.getName();
                                if (PolicyConfigUtil.signedPartsQName.equals(name)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found SignedParts");
                                    }
                                    if (!tnsSet) {
                                        this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512";
                                    } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", this.targetNamespace}));
                                    }
                                    alreadyProcessed = false;
                                    if (protectionAssertionsMap.containsKey(idReference)) {
                                        protection = (Protection)protectionAssertionsMap.get(idReference);
                                        alreadyProcessed = true;
                                    } else {
                                        protection = new Protection(idReference, true);
                                    }
                                    messageParts = (SePartsType)jaxbel.getValue();
                                    bodyPart = ((SePartsType)messageParts).getBody();
                                    if (bodyPart != null) {
                                        protection.setBody(true);
                                    }
                                    if ((headers = ((SePartsType)messageParts).getHeader()) != null) {
                                        for (a = 0; a < headers.size(); ++a) {
                                            header = (HeaderType)headers.get(a);
                                            headerName = ((HeaderType)header).getName();
                                            localName = "";
                                            if (headerName != null) {
                                                localName = headerName.getLocalPart();
                                            }
                                            namespace = ((HeaderType)header).getNamespace();
                                            newHeaderName = new QName(namespace, localName);
                                            protection.addHeader(newHeaderName);
                                        }
                                    }
                                    if (alreadyProcessed) continue;
                                    this.protectionAssertions.add(protection);
                                    protectionAssertionsMap.put(idReference, protection);
                                    continue;
                                }
                                if (PolicyConfigUtil.signedPartsQName12.equals(name)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found SignedParts 1.2");
                                    }
                                    if (!tnsSet) {
                                        this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702";
                                    } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", this.targetNamespace}));
                                    }
                                    alreadyProcessed = false;
                                    if (protectionAssertionsMap.containsKey(idReference)) {
                                        protection = (Protection)protectionAssertionsMap.get(idReference);
                                        alreadyProcessed = true;
                                    } else {
                                        protection = new Protection(idReference, true);
                                    }
                                    messageParts = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType)jaxbel.getValue();
                                    bodyPart = ((org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType)messageParts).getBody();
                                    if (bodyPart != null) {
                                        protection.setBody(true);
                                    }
                                    if ((headers = ((org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType)messageParts).getHeader()) != null) {
                                        for (a = 0; a < headers.size(); ++a) {
                                            header = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.HeaderType)headers.get(a);
                                            headerName = ((org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.HeaderType)header).getName();
                                            localName = "";
                                            if (headerName != null) {
                                                localName = headerName.getLocalPart();
                                            }
                                            namespace = ((org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.HeaderType)header).getNamespace();
                                            newHeaderName = new QName(namespace, localName);
                                            protection.addHeader(newHeaderName);
                                        }
                                    }
                                    if (alreadyProcessed) continue;
                                    this.protectionAssertions.add(protection);
                                    protectionAssertionsMap.put(idReference, protection);
                                    continue;
                                }
                                if (PolicyConfigUtil.encryptedPartsQName.equals(name)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found EncryptedParts");
                                    }
                                    if (!tnsSet) {
                                        this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512";
                                    } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", this.targetNamespace}));
                                    }
                                    alreadyProcessed = false;
                                    if (protectionAssertionsMap.containsKey(idReference)) {
                                        protection = (Protection)protectionAssertionsMap.get(idReference);
                                        alreadyProcessed = true;
                                    } else {
                                        protection = new Protection(idReference, false);
                                    }
                                    messageParts = (SePartsType)jaxbel.getValue();
                                    bodyPart = ((SePartsType)messageParts).getBody();
                                    if (bodyPart != null) {
                                        protection.setBody(true);
                                    }
                                    if ((headers = ((SePartsType)messageParts).getHeader()) != null) {
                                        for (a = 0; a < headers.size(); ++a) {
                                            header = (HeaderType)headers.get(a);
                                            headerName = ((HeaderType)header).getName();
                                            localName = "";
                                            if (headerName != null) {
                                                localName = headerName.getLocalPart();
                                            }
                                            namespace = ((HeaderType)header).getNamespace();
                                            newHeaderName = new QName(namespace, localName);
                                            protection.addHeader(newHeaderName);
                                        }
                                    }
                                    if (alreadyProcessed) continue;
                                    this.protectionAssertions.add(protection);
                                    protectionAssertionsMap.put(idReference, protection);
                                    continue;
                                }
                                if (PolicyConfigUtil.encryptedPartsQName12.equals(name)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found EncryptedParts 1.2");
                                    }
                                    if (!tnsSet) {
                                        this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702";
                                    } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", this.targetNamespace}));
                                    }
                                    alreadyProcessed = false;
                                    if (protectionAssertionsMap.containsKey(idReference)) {
                                        protection = (Protection)protectionAssertionsMap.get(idReference);
                                        alreadyProcessed = true;
                                    } else {
                                        protection = new Protection(idReference, false);
                                    }
                                    messageParts = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType)jaxbel.getValue();
                                    bodyPart = ((org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType)messageParts).getBody();
                                    if (bodyPart != null) {
                                        protection.setBody(true);
                                    }
                                    if ((headers = ((org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType)messageParts).getHeader()) != null) {
                                        for (a = 0; a < headers.size(); ++a) {
                                            header = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.HeaderType)headers.get(a);
                                            headerName = ((org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.HeaderType)header).getName();
                                            localName = "";
                                            if (headerName != null) {
                                                localName = headerName.getLocalPart();
                                            }
                                            namespace = ((org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.HeaderType)header).getNamespace();
                                            newHeaderName = new QName(namespace, localName);
                                            protection.addHeader(newHeaderName);
                                        }
                                    }
                                    if (alreadyProcessed) continue;
                                    this.protectionAssertions.add(protection);
                                    protectionAssertionsMap.put(idReference, protection);
                                    continue;
                                }
                                if (PolicyConfigUtil.signedElementsQName.equals(name)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found SignedElements");
                                    }
                                    if (!tnsSet) {
                                        this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512";
                                    } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", this.targetNamespace}));
                                    }
                                    alreadyProcessed = false;
                                    if (protectionAssertionsMap.containsKey(idReference)) {
                                        protection = (Protection)protectionAssertionsMap.get(idReference);
                                        alreadyProcessed = true;
                                    } else {
                                        protection = new Protection(idReference, true);
                                    }
                                    signedElementAssertion = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SerElementsType)jaxbel.getValue();
                                    signedElements = ((org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SerElementsType)signedElementAssertion).getXPath();
                                    if (signedElements != null) {
                                        protection.addXPathExpressions(signedElements);
                                    }
                                    if (alreadyProcessed) continue;
                                    this.protectionAssertions.add(protection);
                                    protectionAssertionsMap.put(idReference, protection);
                                    continue;
                                }
                                if (PolicyConfigUtil.signedElementsQName12.equals(name)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found SignedElements 1.2");
                                    }
                                    if (!tnsSet) {
                                        this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702";
                                    } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", this.targetNamespace}));
                                    }
                                    alreadyProcessed = false;
                                    if (protectionAssertionsMap.containsKey(idReference)) {
                                        protection = (Protection)protectionAssertionsMap.get(idReference);
                                        alreadyProcessed = true;
                                    } else {
                                        protection = new Protection(idReference, true);
                                    }
                                    signedElementAssertion = (SerElementsType)jaxbel.getValue();
                                    signedElements = ((SerElementsType)signedElementAssertion).getXPath();
                                    if (signedElements != null) {
                                        protection.addXPathExpressions(signedElements);
                                    }
                                    if (alreadyProcessed) continue;
                                    this.protectionAssertions.add(protection);
                                    protectionAssertionsMap.put(idReference, protection);
                                    continue;
                                }
                                if (PolicyConfigUtil.encryptedElementsQName.equals(name)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found EncryptedElements");
                                    }
                                    if (!tnsSet) {
                                        this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512";
                                    } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", this.targetNamespace}));
                                    }
                                    alreadyProcessed = false;
                                    if (protectionAssertionsMap.containsKey(idReference)) {
                                        protection = (Protection)protectionAssertionsMap.get(idReference);
                                        alreadyProcessed = true;
                                    } else {
                                        protection = new Protection(idReference, false);
                                    }
                                    encryptedElementAssertion = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SerElementsType)jaxbel.getValue();
                                    encryptedElements = ((org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SerElementsType)encryptedElementAssertion).getXPath();
                                    if (encryptedElements != null) {
                                        protection.addXPathExpressions(encryptedElements);
                                    }
                                    if (alreadyProcessed) continue;
                                    this.protectionAssertions.add(protection);
                                    protectionAssertionsMap.put(idReference, protection);
                                    continue;
                                }
                                if (PolicyConfigUtil.encryptedElementsQName12.equals(name)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found EncryptedElements 1.2");
                                    }
                                    if (!tnsSet) {
                                        this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702";
                                    } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", this.targetNamespace}));
                                    }
                                    alreadyProcessed = false;
                                    if (protectionAssertionsMap.containsKey(idReference)) {
                                        protection = (Protection)protectionAssertionsMap.get(idReference);
                                        alreadyProcessed = true;
                                    } else {
                                        protection = new Protection(idReference, false);
                                    }
                                    encryptedElementAssertion = (SerElementsType)jaxbel.getValue();
                                    encryptedElements = ((SerElementsType)encryptedElementAssertion).getXPath();
                                    if (encryptedElements != null) {
                                        protection.addXPathExpressions(encryptedElements);
                                    }
                                    if (alreadyProcessed) continue;
                                    this.protectionAssertions.add(protection);
                                    protectionAssertionsMap.put(idReference, protection);
                                    continue;
                                }
                                if (PolicyConfigUtil.contentEncryptedElementsQName12.equals(name)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found ContentEncryptedElements 1.2");
                                    }
                                    if (!tnsSet) {
                                        this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702";
                                    } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", this.targetNamespace}));
                                    }
                                    alreadyProcessed = false;
                                    if (protectionAssertionsMap.containsKey(idReference)) {
                                        protection = (Protection)protectionAssertionsMap.get(idReference);
                                        alreadyProcessed = true;
                                    } else {
                                        protection = new Protection(idReference, false);
                                    }
                                    SerElementsType contentEncryptedElementAssertion = (SerElementsType)jaxbel.getValue();
                                    encryptedElements = contentEncryptedElementAssertion.getXPath();
                                    if (encryptedElements != null) {
                                        protection.addXPathExpressionsForContent(encryptedElements);
                                    }
                                    if (alreadyProcessed) continue;
                                    this.protectionAssertions.add(protection);
                                    protectionAssertionsMap.put(idReference, protection);
                                    continue;
                                }
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s06", new String[]{name.toString()}));
                            }
                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{obj.toString()}));
                        }
                        continue;
                    }
                    if (obj instanceof JAXBElement) {
                        String layoutElement;
                        String algorithmSuiteElement;
                        QName name3;
                        JAXBElement jaxbel3;
                        Object objT;
                        List<Object> tokenChildren;
                        Object potentialPolicy;
                        List<Object> nps;
                        NestedPolicyType np;
                        ProtectionOrSupportingToken protectionToken;
                        QName assertionQName;
                        JAXBElement anAssertion;
                        List<Object> assertions;
                        Object potentialPolicy2;
                        List<Object> nestedPolicies;
                        QName name32;
                        JAXBElement jaxbel32;
                        Object objT2;
                        List<Object> tokenChildren2;
                        org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType np2;
                        ProtectionOrSupportingToken protectionToken2;
                        String assertionName;
                        Object potentialAssertion;
                        List<Object> assertions2;
                        Object nested;
                        boolean retrieveAssertions = false;
                        JAXBElement jaxbel = (JAXBElement)obj;
                        QName name = jaxbel.getName();
                        if (PolicyConfigUtil.asymmetricBindingQName.equals(name)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found AsymmetricBinding");
                            }
                            if (!tnsSet) {
                                this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512";
                            } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", this.targetNamespace}));
                            }
                            this.policyBinding = new PolicyBinding(false);
                            nested = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)jaxbel.getValue();
                            assertions2 = ((org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)nested).getPolicy().getPolicyOrAllOrExactlyOne();
                            for (int j = 0; j < assertions2.size(); ++j) {
                                int k;
                                Policy tokenPolicy;
                                potentialAssertion = assertions2.get(j);
                                if (potentialAssertion instanceof Element) {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{potentialAssertion.toString()}));
                                }
                                if (!(potentialAssertion instanceof JAXBElement)) continue;
                                JAXBElement anAssertion2 = (JAXBElement)potentialAssertion;
                                QName assertionQName2 = anAssertion2.getName();
                                assertionName = assertionQName2.getLocalPart();
                                if (!this.targetNamespace.equals(assertionQName2.getNamespaceURI())) {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{assertionQName2.getNamespaceURI(), this.targetNamespace}));
                                }
                                if (this.isProtectionToken(assertionName)) {
                                    protectionToken2 = this.getProtectionToken(anAssertion2, assertionName, true);
                                    this.policyBinding.addProtectionToken(protectionToken2);
                                    continue;
                                }
                                if (PolicyConfigUtil.algorithmSuiteQName.getLocalPart().equals(assertionName)) {
                                    np2 = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)anAssertion2.getValue();
                                    tokenPolicy = np2.getPolicy();
                                    tokenChildren2 = tokenPolicy.getPolicyOrAllOrExactlyOne();
                                    objT2 = null;
                                    if (tokenChildren2 == null) continue;
                                    for (k = 0; k < tokenChildren2.size(); ++k) {
                                        objT2 = tokenChildren2.get(k);
                                        if (objT2 instanceof Element) {
                                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{objT2.toString()}));
                                        }
                                        if (!(objT2 instanceof JAXBElement)) {
                                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{objT2.toString()}));
                                        }
                                        jaxbel32 = (JAXBElement)objT2;
                                        name32 = jaxbel32.getName();
                                        String algorithmSuiteElement2 = name32.getLocalPart();
                                        this.policyBinding.addAlgorithmSuite(algorithmSuiteElement2);
                                    }
                                    continue;
                                }
                                if (PolicyConfigUtil.layoutQName.getLocalPart().equals(assertionName)) {
                                    np2 = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)anAssertion2.getValue();
                                    tokenPolicy = np2.getPolicy();
                                    tokenChildren2 = tokenPolicy.getPolicyOrAllOrExactlyOne();
                                    objT2 = null;
                                    if (tokenChildren2 == null) continue;
                                    for (k = 0; k < tokenChildren2.size(); ++k) {
                                        objT2 = tokenChildren2.get(k);
                                        if (objT2 instanceof Element) {
                                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{objT2.toString()}));
                                        }
                                        if (!(objT2 instanceof JAXBElement)) {
                                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{objT2.toString()}));
                                        }
                                        jaxbel32 = (JAXBElement)objT2;
                                        name32 = jaxbel32.getName();
                                        String layoutElement2 = name32.getLocalPart();
                                        this.policyBinding.setLayout(layoutElement2);
                                    }
                                    continue;
                                }
                                if (PolicyConfigUtil.wssIncludeTimestampQName.getLocalPart().equals(assertionName)) {
                                    this.policyBinding.setIncludeTimestamp(true);
                                    continue;
                                }
                                if (PolicyConfigUtil.onlySignEntireHeadersAndBodyQName.getLocalPart().equals(assertionName)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "setOnlySignEntireHeadersAndBody");
                                    }
                                    this.policyBinding.setOnlySignEntireHeadersAndBody();
                                    continue;
                                }
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{assertionName}));
                            }
                            continue;
                        }
                        if (PolicyConfigUtil.asymmetricBindingQName12.equals(name)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found AsymmetricBinding 1.2");
                            }
                            if (!tnsSet) {
                                this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702";
                            } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", this.targetNamespace}));
                            }
                            this.policyBinding = new PolicyBinding(false);
                            nested = (NestedPolicyType)jaxbel.getValue();
                            nestedPolicies = ((NestedPolicyType)nested).getAny();
                            OperatorContentType nestedPolicy = null;
                            if (nestedPolicies.size() > 0) {
                                potentialPolicy2 = nestedPolicies.get(0);
                                if (potentialPolicy2 instanceof Policy) {
                                    nestedPolicy = (Policy)potentialPolicy2;
                                } else {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{potentialPolicy2.toString()}));
                                }
                            }
                            assertions = null;
                            if (nestedPolicy != null) {
                                assertions = nestedPolicy.getPolicyOrAllOrExactlyOne();
                            }
                            if (assertions == null) continue;
                            for (int j = 0; j < assertions.size(); ++j) {
                                Object potentialAssertion2 = assertions.get(j);
                                if (potentialAssertion2 instanceof Element) {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{potentialAssertion2.toString()}));
                                }
                                if (potentialAssertion2 instanceof JAXBElement) {
                                    int k;
                                    OperatorContentType npPolicy;
                                    anAssertion = (JAXBElement)potentialAssertion2;
                                    assertionQName = anAssertion.getName();
                                    String assertionName2 = assertionQName.getLocalPart();
                                    if (!this.targetNamespace.equals(assertionQName.getNamespaceURI())) {
                                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{assertionQName.getNamespaceURI(), this.targetNamespace}));
                                    }
                                    if (this.isProtectionToken(assertionName2)) {
                                        protectionToken = this.getProtectionToken12(anAssertion, assertionName2, true);
                                        this.policyBinding.addProtectionToken(protectionToken);
                                        continue;
                                    }
                                    if (PolicyConfigUtil.algorithmSuiteQName12.getLocalPart().equals(assertionName2)) {
                                        np = (NestedPolicyType)anAssertion.getValue();
                                        nps = np.getAny();
                                        npPolicy = null;
                                        if (nps.size() > 0) {
                                            potentialPolicy = nps.get(0);
                                            if (potentialPolicy instanceof Policy) {
                                                npPolicy = (Policy)potentialPolicy;
                                            } else {
                                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{potentialPolicy.toString()}));
                                            }
                                        }
                                        tokenChildren = null;
                                        if (npPolicy != null) {
                                            tokenChildren = npPolicy.getPolicyOrAllOrExactlyOne();
                                        }
                                        objT = null;
                                        if (tokenChildren == null) continue;
                                        for (k = 0; k < tokenChildren.size(); ++k) {
                                            objT = tokenChildren.get(k);
                                            if (objT instanceof Element) {
                                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{objT.toString()}));
                                            }
                                            if (!(objT instanceof JAXBElement)) {
                                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{objT.toString()}));
                                            }
                                            jaxbel3 = (JAXBElement)objT;
                                            name3 = jaxbel3.getName();
                                            algorithmSuiteElement = name3.getLocalPart();
                                            this.policyBinding.addAlgorithmSuite(algorithmSuiteElement);
                                        }
                                        continue;
                                    }
                                    if (PolicyConfigUtil.layoutQName12.getLocalPart().equals(assertionName2)) {
                                        np = (NestedPolicyType)anAssertion.getValue();
                                        nps = np.getAny();
                                        npPolicy = null;
                                        if (nps.size() > 0) {
                                            potentialPolicy = nps.get(0);
                                            if (potentialPolicy instanceof Policy) {
                                                npPolicy = (Policy)potentialPolicy;
                                            } else {
                                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{potentialPolicy.toString()}));
                                            }
                                        }
                                        tokenChildren = null;
                                        if (npPolicy != null) {
                                            tokenChildren = npPolicy.getPolicyOrAllOrExactlyOne();
                                        }
                                        objT = null;
                                        if (tokenChildren == null) continue;
                                        for (k = 0; k < tokenChildren.size(); ++k) {
                                            objT = tokenChildren.get(k);
                                            if (objT instanceof Element) {
                                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{objT.toString()}));
                                            }
                                            if (!(objT instanceof JAXBElement)) {
                                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{objT.toString()}));
                                            }
                                            jaxbel3 = (JAXBElement)objT;
                                            name3 = jaxbel3.getName();
                                            layoutElement = name3.getLocalPart();
                                            this.policyBinding.setLayout(layoutElement);
                                        }
                                        continue;
                                    }
                                    if (PolicyConfigUtil.wssIncludeTimestampQName12.getLocalPart().equals(assertionName2)) {
                                        this.policyBinding.setIncludeTimestamp(true);
                                        continue;
                                    }
                                    if (PolicyConfigUtil.wssEncryptSignatureQName.getLocalPart().equals(assertionName2)) {
                                        this.policyBinding.setEncryptSignature(true);
                                        continue;
                                    }
                                    if (PolicyConfigUtil.wssEncryptBeforeSigningQName.getLocalPart().equals(assertionName2)) {
                                        this.policyBinding.setEncryptBeforeSigning();
                                        continue;
                                    }
                                    if (PolicyConfigUtil.onlySignEntireHeadersAndBodyQName12.getLocalPart().equals(assertionName2)) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "setOnlySignEntireHeadersAndBody");
                                        }
                                        this.policyBinding.setOnlySignEntireHeadersAndBody();
                                        continue;
                                    }
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{assertionName2}));
                                }
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{potentialAssertion2.toString()}));
                            }
                            continue;
                        }
                        if (PolicyConfigUtil.symmetricBindingQName.equals(name)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found SymmetricBinding");
                            }
                            if (!tnsSet) {
                                this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512";
                            } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", this.targetNamespace}));
                            }
                            this.policyBinding = new PolicyBinding(true);
                            nested = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)jaxbel.getValue();
                            assertions2 = ((org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)nested).getPolicy().getPolicyOrAllOrExactlyOne();
                            for (int j = 0; j < assertions2.size(); ++j) {
                                int k;
                                Policy tokenPolicy;
                                potentialAssertion = assertions2.get(j);
                                if (potentialAssertion instanceof Element) {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s16", new String[]{potentialAssertion.toString()}));
                                }
                                if (!(potentialAssertion instanceof JAXBElement)) continue;
                                JAXBElement anAssertion3 = (JAXBElement)potentialAssertion;
                                QName assertionQName3 = anAssertion3.getName();
                                assertionName = assertionQName3.getLocalPart();
                                if (!this.targetNamespace.equals(assertionQName3.getNamespaceURI())) {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{assertionQName3.getNamespaceURI(), this.targetNamespace}));
                                }
                                if (this.isProtectionToken(assertionName)) {
                                    protectionToken2 = this.getProtectionToken(anAssertion3, assertionName, true);
                                    this.policyBinding.addProtectionToken(protectionToken2);
                                    continue;
                                }
                                if (PolicyConfigUtil.algorithmSuiteQName.getLocalPart().equals(assertionName)) {
                                    np2 = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)anAssertion3.getValue();
                                    tokenPolicy = np2.getPolicy();
                                    tokenChildren2 = tokenPolicy.getPolicyOrAllOrExactlyOne();
                                    objT2 = null;
                                    if (tokenChildren2 == null) continue;
                                    for (k = 0; k < tokenChildren2.size(); ++k) {
                                        objT2 = tokenChildren2.get(k);
                                        if (objT2 instanceof Element) {
                                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{objT2.toString()}));
                                        }
                                        if (!(objT2 instanceof JAXBElement)) {
                                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{objT2.toString()}));
                                        }
                                        jaxbel32 = (JAXBElement)objT2;
                                        name32 = jaxbel32.getName();
                                        String algorithmSuiteElement3 = name32.getLocalPart();
                                        this.policyBinding.addAlgorithmSuite(algorithmSuiteElement3);
                                    }
                                    continue;
                                }
                                if (PolicyConfigUtil.layoutQName.getLocalPart().equals(assertionName)) {
                                    np2 = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)anAssertion3.getValue();
                                    tokenPolicy = np2.getPolicy();
                                    tokenChildren2 = tokenPolicy.getPolicyOrAllOrExactlyOne();
                                    objT2 = null;
                                    if (tokenChildren2 == null) continue;
                                    for (k = 0; k < tokenChildren2.size(); ++k) {
                                        objT2 = tokenChildren2.get(k);
                                        if (objT2 instanceof Element) {
                                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{objT2.toString()}));
                                        }
                                        if (!(objT2 instanceof JAXBElement)) {
                                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{objT2.toString()}));
                                        }
                                        jaxbel32 = (JAXBElement)objT2;
                                        name32 = jaxbel32.getName();
                                        String layoutElement3 = name32.getLocalPart();
                                        this.policyBinding.setLayout(layoutElement3);
                                    }
                                    continue;
                                }
                                if (PolicyConfigUtil.wssIncludeTimestampQName.getLocalPart().equals(assertionName)) {
                                    this.policyBinding.setIncludeTimestamp(true);
                                    continue;
                                }
                                if (PolicyConfigUtil.onlySignEntireHeadersAndBodyQName.getLocalPart().equals(assertionName)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "setOnlySignEntireHeadersAndBody");
                                    }
                                    this.policyBinding.setOnlySignEntireHeadersAndBody();
                                    continue;
                                }
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s16", new String[]{assertionName}));
                            }
                            continue;
                        }
                        if (PolicyConfigUtil.symmetricBindingQName12.equals(name)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found SymmetricBinding 1.2");
                            }
                            if (!tnsSet) {
                                this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702";
                            } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", this.targetNamespace}));
                            }
                            this.policyBinding = new PolicyBinding(true);
                            nested = (NestedPolicyType)jaxbel.getValue();
                            nestedPolicies = ((NestedPolicyType)nested).getAny();
                            OperatorContentType nestedPolicy = null;
                            if (nestedPolicies.size() > 0) {
                                potentialPolicy2 = nestedPolicies.get(0);
                                if (potentialPolicy2 instanceof Policy) {
                                    nestedPolicy = (Policy)potentialPolicy2;
                                } else {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{potentialPolicy2.toString()}));
                                }
                            }
                            assertions = null;
                            if (nestedPolicy != null) {
                                assertions = nestedPolicy.getPolicyOrAllOrExactlyOne();
                            }
                            if (assertions == null) continue;
                            for (int j = 0; j < assertions.size(); ++j) {
                                Object potentialAssertion3 = assertions.get(j);
                                if (potentialAssertion3 instanceof Element) {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s16", new String[]{potentialAssertion3.toString()}));
                                }
                                if (potentialAssertion3 instanceof JAXBElement) {
                                    int k;
                                    OperatorContentType npPolicy;
                                    anAssertion = (JAXBElement)potentialAssertion3;
                                    assertionQName = anAssertion.getName();
                                    String assertionName3 = assertionQName.getLocalPart();
                                    if (!this.targetNamespace.equals(assertionQName.getNamespaceURI())) {
                                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{assertionQName.getNamespaceURI(), this.targetNamespace}));
                                    }
                                    if (this.isProtectionToken(assertionName3)) {
                                        protectionToken = this.getProtectionToken12(anAssertion, assertionName3, true);
                                        this.policyBinding.addProtectionToken(protectionToken);
                                        continue;
                                    }
                                    if (PolicyConfigUtil.algorithmSuiteQName12.getLocalPart().equals(assertionName3)) {
                                        np = (NestedPolicyType)anAssertion.getValue();
                                        nps = np.getAny();
                                        npPolicy = null;
                                        if (nps.size() > 0) {
                                            potentialPolicy = nps.get(0);
                                            if (potentialPolicy instanceof Policy) {
                                                npPolicy = (Policy)potentialPolicy;
                                            } else {
                                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{potentialPolicy.toString()}));
                                            }
                                        }
                                        tokenChildren = null;
                                        if (npPolicy != null) {
                                            tokenChildren = npPolicy.getPolicyOrAllOrExactlyOne();
                                        }
                                        objT = null;
                                        if (tokenChildren == null) continue;
                                        for (k = 0; k < tokenChildren.size(); ++k) {
                                            objT = tokenChildren.get(k);
                                            if (objT instanceof Element) {
                                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{objT.toString()}));
                                            }
                                            if (!(objT instanceof JAXBElement)) {
                                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{objT.toString()}));
                                            }
                                            jaxbel3 = (JAXBElement)objT;
                                            name3 = jaxbel3.getName();
                                            algorithmSuiteElement = name3.getLocalPart();
                                            this.policyBinding.addAlgorithmSuite(algorithmSuiteElement);
                                        }
                                        continue;
                                    }
                                    if (PolicyConfigUtil.layoutQName12.getLocalPart().equals(assertionName3)) {
                                        np = (NestedPolicyType)anAssertion.getValue();
                                        nps = np.getAny();
                                        npPolicy = null;
                                        if (nps.size() > 0) {
                                            potentialPolicy = nps.get(0);
                                            if (potentialPolicy instanceof Policy) {
                                                npPolicy = (Policy)potentialPolicy;
                                            } else {
                                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{potentialPolicy.toString()}));
                                            }
                                        }
                                        tokenChildren = null;
                                        if (npPolicy != null) {
                                            tokenChildren = npPolicy.getPolicyOrAllOrExactlyOne();
                                        }
                                        objT = null;
                                        if (tokenChildren == null) continue;
                                        for (k = 0; k < tokenChildren.size(); ++k) {
                                            objT = tokenChildren.get(k);
                                            if (objT instanceof Element) {
                                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{objT.toString()}));
                                            }
                                            if (!(objT instanceof JAXBElement)) {
                                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{objT.toString()}));
                                            }
                                            jaxbel3 = (JAXBElement)objT;
                                            name3 = jaxbel3.getName();
                                            layoutElement = name3.getLocalPart();
                                            this.policyBinding.setLayout(layoutElement);
                                        }
                                        continue;
                                    }
                                    if (PolicyConfigUtil.wssIncludeTimestampQName12.getLocalPart().equals(assertionName3)) {
                                        this.policyBinding.setIncludeTimestamp(true);
                                        continue;
                                    }
                                    if (PolicyConfigUtil.wssEncryptSignatureQName.getLocalPart().equals(assertionName3)) {
                                        this.policyBinding.setEncryptSignature(true);
                                        continue;
                                    }
                                    if (PolicyConfigUtil.wssEncryptBeforeSigningQName.getLocalPart().equals(assertionName3)) {
                                        this.policyBinding.setEncryptBeforeSigning();
                                        continue;
                                    }
                                    if (PolicyConfigUtil.onlySignEntireHeadersAndBodyQName12.getLocalPart().equals(assertionName3)) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "setOnlySignEntireHeadersAndBody");
                                        }
                                        this.policyBinding.setOnlySignEntireHeadersAndBody();
                                        continue;
                                    }
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s16", new String[]{assertionName3}));
                                }
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{potentialAssertion3.toString()}));
                            }
                            continue;
                        }
                        if (PolicyConfigUtil.supportingTokenQName.equals(name)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found SupportingToken");
                            }
                            if (!tnsSet) {
                                this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512";
                            } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", this.targetNamespace}));
                            }
                            nested = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)jaxbel.getValue();
                            Policy supportingTokenPolicy = ((org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)nested).getPolicy();
                            String idReference = supportingTokenPolicy.getId();
                            retrieveAssertions = this.retrieveAssertions(idReference);
                            if (!retrieveAssertions) continue;
                            assertions = supportingTokenPolicy.getPolicyOrAllOrExactlyOne();
                            for (int j = 0; j < assertions.size(); ++j) {
                                Object potentialAssertion4 = assertions.get(j);
                                if (potentialAssertion4 instanceof Element) {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s17", new String[]{potentialAssertion4.toString()}));
                                }
                                if (potentialAssertion4 instanceof JAXBElement) {
                                    anAssertion = (JAXBElement)potentialAssertion4;
                                    assertionQName = anAssertion.getName();
                                    ProtectionOrSupportingToken aTokenAssertion = this.getProtectionToken(anAssertion, idReference, false);
                                    if (aTokenAssertion == null) continue;
                                    this.supportingTokens.add(aTokenAssertion);
                                    continue;
                                }
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{potentialAssertion4.toString()}));
                            }
                            continue;
                        }
                        if (PolicyConfigUtil.supportingTokenQName12.equals(name)) {
                            String idReference;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found SupportingToken 1.2");
                            }
                            if (!tnsSet) {
                                this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702";
                            } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", this.targetNamespace}));
                            }
                            nested = (NestedPolicyType)jaxbel.getValue();
                            nestedPolicies = ((NestedPolicyType)nested).getAny();
                            Policy supportingTokenPolicy = null;
                            if (nestedPolicies.size() > 0) {
                                potentialPolicy2 = nestedPolicies.get(0);
                                if (potentialPolicy2 instanceof Policy) {
                                    supportingTokenPolicy = (Policy)potentialPolicy2;
                                } else {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{potentialPolicy2.toString()}));
                                }
                            }
                            if (!(retrieveAssertions = this.retrieveAssertions(idReference = supportingTokenPolicy.getId()))) continue;
                            List<Object> assertions3 = supportingTokenPolicy.getPolicyOrAllOrExactlyOne();
                            for (int j = 0; j < assertions3.size(); ++j) {
                                Object potentialAssertion5 = assertions3.get(j);
                                if (potentialAssertion5 instanceof Element) {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s17", new String[]{potentialAssertion5.toString()}));
                                }
                                if (potentialAssertion5 instanceof JAXBElement) {
                                    JAXBElement anAssertion4 = (JAXBElement)potentialAssertion5;
                                    QName assertionQName4 = anAssertion4.getName();
                                    String assertionName4 = assertionQName4.getLocalPart();
                                    ProtectionOrSupportingToken aTokenAssertion = this.getProtectionToken12(anAssertion4, idReference, false);
                                    if (aTokenAssertion == null) continue;
                                    this.supportingTokens.add(aTokenAssertion);
                                    continue;
                                }
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{potentialAssertion5.toString()}));
                            }
                            continue;
                        }
                        if (PolicyConfigUtil.wss10QName.equals(name)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found Wss10");
                            }
                            if (!tnsSet) {
                                this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512";
                            } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", this.targetNamespace}));
                            }
                            nested = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)jaxbel.getValue();
                            assertions2 = ((org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)nested).getPolicy().getPolicyOrAllOrExactlyOne();
                            for (int j = 0; j < assertions2.size(); ++j) {
                                potentialAssertion = assertions2.get(j);
                                if (potentialAssertion instanceof Element) {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s18", new String[]{potentialAssertion.toString()}));
                                }
                                if (potentialAssertion instanceof JAXBElement) {
                                    JAXBElement anAssertion5 = (JAXBElement)potentialAssertion;
                                    QName assertionQName5 = anAssertion5.getName();
                                    assertionName = assertionQName5.getLocalPart();
                                    if (!this.targetNamespace.equals(assertionQName5.getNamespaceURI())) {
                                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{assertionQName5.getNamespaceURI(), this.targetNamespace}));
                                    }
                                } else {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{potentialAssertion.toString()}));
                                }
                                this.wss10Assertions.add(assertionName);
                            }
                            continue;
                        }
                        if (PolicyConfigUtil.wss10QName12.equals(name)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found Wss10 1.2");
                            }
                            if (!tnsSet) {
                                this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702";
                            } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", this.targetNamespace}));
                            }
                            nested = (NestedPolicyType)jaxbel.getValue();
                            nestedPolicies = ((NestedPolicyType)nested).getAny();
                            OperatorContentType nestedPolicy = null;
                            if (nestedPolicies.size() > 0) {
                                potentialPolicy2 = nestedPolicies.get(0);
                                if (potentialPolicy2 instanceof Policy) {
                                    nestedPolicy = (Policy)potentialPolicy2;
                                } else {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{potentialPolicy2.toString()}));
                                }
                            }
                            assertions = null;
                            if (nestedPolicy != null) {
                                assertions = nestedPolicy.getPolicyOrAllOrExactlyOne();
                            }
                            if (assertions == null) continue;
                            for (int j = 0; j < assertions.size(); ++j) {
                                String assertionName5;
                                Object potentialAssertion6 = assertions.get(j);
                                if (potentialAssertion6 instanceof Element) {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s18", new String[]{potentialAssertion6.toString()}));
                                }
                                if (potentialAssertion6 instanceof JAXBElement) {
                                    anAssertion = (JAXBElement)potentialAssertion6;
                                    assertionQName = anAssertion.getName();
                                    assertionName5 = assertionQName.getLocalPart();
                                    if (!this.targetNamespace.equals(assertionQName.getNamespaceURI())) {
                                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{assertionQName.getNamespaceURI(), this.targetNamespace}));
                                    }
                                } else {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{potentialAssertion6.toString()}));
                                }
                                this.wss10Assertions.add(assertionName5);
                            }
                            continue;
                        }
                        if (PolicyConfigUtil.wss11QName.equals(name)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found Wss11");
                            }
                            if (!tnsSet) {
                                this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512";
                            } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", this.targetNamespace}));
                            }
                            nested = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)jaxbel.getValue();
                            assertions2 = ((org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)nested).getPolicy().getPolicyOrAllOrExactlyOne();
                            for (int j = 0; j < assertions2.size(); ++j) {
                                potentialAssertion = assertions2.get(j);
                                if (potentialAssertion instanceof Element) {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s19", new String[]{potentialAssertion.toString()}));
                                }
                                if (potentialAssertion instanceof JAXBElement) {
                                    JAXBElement anAssertion6 = (JAXBElement)potentialAssertion;
                                    QName assertionQName6 = anAssertion6.getName();
                                    assertionName = assertionQName6.getLocalPart();
                                    if (!this.targetNamespace.equals(assertionQName6.getNamespaceURI())) {
                                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{assertionQName6.getNamespaceURI(), this.targetNamespace}));
                                    }
                                } else {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{potentialAssertion.toString()}));
                                }
                                this.wss11Assertions.add(assertionName);
                            }
                            continue;
                        }
                        if (PolicyConfigUtil.wss11QName12.equals(name)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found Wss11 1.2");
                            }
                            if (!tnsSet) {
                                this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702";
                            } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", this.targetNamespace}));
                            }
                            nested = (NestedPolicyType)jaxbel.getValue();
                            nestedPolicies = ((NestedPolicyType)nested).getAny();
                            OperatorContentType nestedPolicy = null;
                            if (nestedPolicies.size() > 0) {
                                potentialPolicy2 = nestedPolicies.get(0);
                                if (potentialPolicy2 instanceof Policy) {
                                    nestedPolicy = (Policy)potentialPolicy2;
                                } else {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{potentialPolicy2.toString()}));
                                }
                            }
                            assertions = null;
                            if (nestedPolicy != null) {
                                assertions = nestedPolicy.getPolicyOrAllOrExactlyOne();
                            }
                            if (assertions == null) continue;
                            for (int j = 0; j < assertions.size(); ++j) {
                                String assertionName6;
                                Object potentialAssertion7 = assertions.get(j);
                                if (potentialAssertion7 instanceof Element) {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s19", new String[]{potentialAssertion7.toString()}));
                                }
                                if (potentialAssertion7 instanceof JAXBElement) {
                                    anAssertion = (JAXBElement)potentialAssertion7;
                                    assertionQName = anAssertion.getName();
                                    assertionName6 = assertionQName.getLocalPart();
                                    if (!this.targetNamespace.equals(assertionQName.getNamespaceURI())) {
                                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{assertionQName.getNamespaceURI(), this.targetNamespace}));
                                    }
                                } else {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{potentialAssertion7.toString()}));
                                }
                                this.wss11Assertions.add(assertionName6);
                            }
                            continue;
                        }
                        if (PolicyConfigUtil.trust10QName.equals(name)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found Trust10");
                            }
                            if (!tnsSet) {
                                this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512";
                            } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", this.targetNamespace}));
                            }
                            nested = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)jaxbel.getValue();
                            assertions2 = ((org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)nested).getPolicy().getPolicyOrAllOrExactlyOne();
                            for (int j = 0; j < assertions2.size(); ++j) {
                                potentialAssertion = assertions2.get(j);
                                if (potentialAssertion instanceof Element) {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s20", new String[]{potentialAssertion.toString()}));
                                }
                                if (potentialAssertion instanceof JAXBElement) {
                                    JAXBElement anAssertion7 = (JAXBElement)potentialAssertion;
                                    QName assertionQName7 = anAssertion7.getName();
                                    assertionName = assertionQName7.getLocalPart();
                                    if (!this.targetNamespace.equals(assertionQName7.getNamespaceURI())) {
                                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{assertionQName7.getNamespaceURI(), this.targetNamespace}));
                                    }
                                } else {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{potentialAssertion.toString()}));
                                }
                                this.trust10Assertions.add(assertionName);
                            }
                            continue;
                        }
                        if (PolicyConfigUtil.trust13QName12.equals(name)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found Trust13 1.2");
                            }
                            if (!tnsSet) {
                                this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702";
                            } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", this.targetNamespace}));
                            }
                            nested = (NestedPolicyType)jaxbel.getValue();
                            nestedPolicies = ((NestedPolicyType)nested).getAny();
                            OperatorContentType nestedPolicy = null;
                            if (nestedPolicies.size() > 0) {
                                potentialPolicy2 = nestedPolicies.get(0);
                                if (potentialPolicy2 instanceof Policy) {
                                    nestedPolicy = (Policy)potentialPolicy2;
                                } else {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{potentialPolicy2.toString()}));
                                }
                            }
                            assertions = null;
                            if (nestedPolicy != null) {
                                assertions = nestedPolicy.getPolicyOrAllOrExactlyOne();
                            }
                            if (assertions == null) continue;
                            for (int j = 0; j < assertions.size(); ++j) {
                                String assertionName7;
                                Object potentialAssertion8 = assertions.get(j);
                                if (potentialAssertion8 instanceof Element) {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s20", new String[]{potentialAssertion8.toString()}));
                                }
                                if (potentialAssertion8 instanceof JAXBElement) {
                                    anAssertion = (JAXBElement)potentialAssertion8;
                                    assertionQName = anAssertion.getName();
                                    assertionName7 = assertionQName.getLocalPart();
                                    if (!this.targetNamespace.equals(assertionQName.getNamespaceURI())) {
                                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{assertionQName.getNamespaceURI(), this.targetNamespace}));
                                    }
                                } else {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{potentialAssertion8.toString()}));
                                }
                                this.trust13Assertions.add(assertionName7);
                            }
                            continue;
                        }
                        if (PolicyConfigUtil.exactlyOneQName.equals(name)) {
                            if (!tnsSet) {
                                this.targetNamespace = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702";
                            } else if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", this.targetNamespace}));
                            }
                            OperatorContentType aContentType = (OperatorContentType)jaxbel.getValue();
                            List<Object> wspAllAssertions = aContentType.getPolicyOrAllOrExactlyOne();
                            for (int j = 0; j < wspAllAssertions.size(); ++j) {
                                HashMap<String, ProtectionOrSupportingToken> callerTokens;
                                Object wspAllAssertion = wspAllAssertions.get(j);
                                if (wspAllAssertion instanceof JAXBElement) {
                                    JAXBElement jaxbWspAllAssertion = (JAXBElement)wspAllAssertion;
                                    aContentType = (OperatorContentType)jaxbWspAllAssertion.getValue();
                                    List<Object> supportingTokenAssertions = aContentType.getPolicyOrAllOrExactlyOne();
                                    callerTokens = new HashMap<String, ProtectionOrSupportingToken>();
                                    for (int k = 0; k < supportingTokenAssertions.size(); ++k) {
                                        Object supportingTokenAssertion = supportingTokenAssertions.get(k);
                                        if (supportingTokenAssertion instanceof JAXBElement) {
                                            JAXBElement jaxbSupportingTokenAssertion = (JAXBElement)supportingTokenAssertion;
                                            if (PolicyConfigUtil.supportingTokenQName12.equals(jaxbSupportingTokenAssertion.getName())) {
                                                String idReference;
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Found SupportingToken 1.2");
                                                }
                                                NestedPolicyType nested2 = (NestedPolicyType)jaxbSupportingTokenAssertion.getValue();
                                                List<Object> nestedPolicies2 = nested2.getAny();
                                                Policy supportingTokenPolicy = null;
                                                if (nestedPolicies2.size() > 0) {
                                                    Object potentialPolicy3 = nestedPolicies2.get(0);
                                                    if (potentialPolicy3 instanceof Policy) {
                                                        supportingTokenPolicy = (Policy)potentialPolicy3;
                                                    } else {
                                                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{potentialPolicy3.toString()}));
                                                    }
                                                }
                                                if (!(retrieveAssertions = this.retrieveAssertions(idReference = supportingTokenPolicy.getId()))) continue;
                                                List<Object> assertions4 = supportingTokenPolicy.getPolicyOrAllOrExactlyOne();
                                                for (int l = 0; l < assertions4.size(); ++l) {
                                                    Object potentialAssertion9 = assertions4.get(l);
                                                    if (potentialAssertion9 instanceof Element) {
                                                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s17", new String[]{potentialAssertion9.toString()}));
                                                    }
                                                    if (potentialAssertion9 instanceof JAXBElement) {
                                                        JAXBElement anAssertion8 = (JAXBElement)potentialAssertion9;
                                                        QName assertionQName8 = anAssertion8.getName();
                                                        String assertionName8 = assertionQName8.getLocalPart();
                                                        ProtectionOrSupportingToken aTokenAssertion = this.getProtectionToken12(anAssertion8, idReference, false);
                                                        if (aTokenAssertion == null) continue;
                                                        callerTokens.put(idReference, aTokenAssertion);
                                                        continue;
                                                    }
                                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{potentialAssertion9.toString()}));
                                                }
                                                continue;
                                            }
                                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s17", new String[]{supportingTokenAssertion.toString()}));
                                        }
                                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s20", new String[]{wspAllAssertion.toString()}));
                                    }
                                } else {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s20", new String[]{wspAllAssertion.toString()}));
                                }
                                this.callerExactlyOneTokens.add(callerTokens);
                            }
                            continue;
                        }
                        Tr.debug(tc, "JAXBElement not handled yet: " + name);
                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s05", new String[]{name.toString()}));
                    }
                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{obj.toString()}));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Policy policyRoot)");
        }
    }

    private ProtectionOrSupportingToken getTokenAssertion(String tokenName, List policyAssertionList, boolean isProtectionToken) throws SoapSecurityException {
        ProtectionOrSupportingToken protectionToken = new ProtectionOrSupportingToken(tokenName, isProtectionToken);
        if (tokenName.equals("X509Token") || tokenName.equals("UsernameToken") || tokenName.equals("KerberosToken")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found X509Token, Kerberos or UsernameToken");
            }
            if (policyAssertionList != null && policyAssertionList.size() != 0) {
                for (int a = 0; a < policyAssertionList.size(); ++a) {
                    Object objN = policyAssertionList.get(a);
                    if (objN instanceof Element) {
                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s01", new String[]{objN.toString()}));
                    }
                    if (objN instanceof JAXBElement) {
                        JAXBElement tokenSpecification = (JAXBElement)objN;
                        QName tokenSpecificationQName = tokenSpecification.getName();
                        String tokenSpecificationName = tokenSpecificationQName.getLocalPart();
                        if (!this.targetNamespace.equals(tokenSpecificationQName.getNamespaceURI())) {
                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{tokenSpecificationQName.getNamespaceURI(), this.targetNamespace}));
                        }
                        protectionToken.addTokenAssertion(tokenSpecificationName);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Added token assertion: " + tokenSpecificationName);
                        continue;
                    }
                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{objN.toString()}));
                }
            }
        } else if (tokenName.equals("SecureConversationToken")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found SecureConversationToken");
            }
            protectionToken.setSecureConversationToken(true);
            if (policyAssertionList != null && policyAssertionList.size() != 0) {
                for (int a = 0; a < policyAssertionList.size(); ++a) {
                    Object objN = policyAssertionList.get(a);
                    if (objN instanceof Element) {
                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s02", new String[]{objN.toString()}));
                    }
                    if (objN instanceof JAXBElement) {
                        JAXBElement tokenSpecification = (JAXBElement)objN;
                        QName tokenSpecificationQName = tokenSpecification.getName();
                        String tokenSpecificationName = tokenSpecificationQName.getLocalPart();
                        if (!this.targetNamespace.equals(tokenSpecificationQName.getNamespaceURI())) {
                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{tokenSpecificationQName.getNamespaceURI(), this.targetNamespace}));
                        }
                        protectionToken.addTokenAssertion(tokenSpecificationName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Added token assertion: " + tokenSpecificationName);
                        }
                        if (PolicyConfigUtil.bootstrapPolicyQName.equals(tokenSpecificationQName)) {
                            org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType nestedBootstrapPolicy = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)tokenSpecification.getValue();
                            try {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "About to load bootstrap policy.");
                                }
                                if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", this.targetNamespace}));
                                }
                                Policy bootstrapPolicy = nestedBootstrapPolicy.getPolicy();
                                protectionToken.setBootstrapPolicy(new WSSPolicy(bootstrapPolicy));
                            }
                            catch (Exception e) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception while loading bootstrap config:", e);
                                }
                                Tr.error(tc, "Fail to load Bootstrap configuration:" + e);
                                throw new SoapSecurityException(e.getMessage());
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The assertion for BootstrapPolicy processed");
                            }
                        } else if (PolicyConfigUtil.bootstrapPolicyQName12.equals(tokenSpecificationQName)) {
                            NestedPolicyType nested = (NestedPolicyType)tokenSpecification.getValue();
                            try {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "About to load bootstrap policy.");
                                }
                                if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702")) {
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", this.targetNamespace}));
                                }
                                List<Object> nestedPolicies = nested.getAny();
                                Policy nestedPolicy = null;
                                if (nestedPolicies.size() > 0) {
                                    Object potentialPolicy = nestedPolicies.get(0);
                                    if (potentialPolicy instanceof Policy) {
                                        nestedPolicy = (Policy)potentialPolicy;
                                    } else {
                                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{potentialPolicy.toString()}));
                                    }
                                }
                                protectionToken.setBootstrapPolicy(new WSSPolicy(nestedPolicy));
                            }
                            catch (Exception e) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception while loading bootstrap config:", e);
                                }
                                Tr.error(tc, "Fail to load Bootstrap configuration:" + e);
                                throw new SoapSecurityException(e.getMessage());
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The assertion for BootstrapPolicy processed");
                            }
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "the policy assertion for SECURECONVERSATIONTOKEN ");
                        continue;
                    }
                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{objN.toString()}));
                }
            }
        } else if (tokenName.equals("LTPAToken")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found LTPAToken");
            }
            protectionToken.addWssTokenAssertion(Constants.LTPA_TOKEN);
        } else if (tokenName.equals("LTPAPropagationToken")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found LTPAPropagationToken");
            }
            protectionToken.addWssTokenAssertion(Constants.LTPA_TOKEN_PROPAGATION);
        } else if (tokenName.equals("CustomToken")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found CustomToken");
            }
            if (policyAssertionList != null && policyAssertionList.size() != 0) {
                for (int a = 0; a < policyAssertionList.size(); ++a) {
                    QName tokenType;
                    String localName;
                    String uri;
                    Object wssCustomToken;
                    Object objN = policyAssertionList.get(a);
                    if (objN instanceof com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext.WssCustomToken) {
                        wssCustomToken = null;
                        wssCustomToken = (com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext.WssCustomToken)objN;
                        uri = ((com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext.WssCustomToken)wssCustomToken).getUri();
                        localName = ((com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext.WssCustomToken)wssCustomToken).getLocalname();
                        tokenType = new QName(uri, localName);
                        protectionToken.addWssTokenAssertion(tokenType);
                        continue;
                    }
                    if (objN instanceof WssCustomToken) {
                        wssCustomToken = null;
                        wssCustomToken = (WssCustomToken)objN;
                        uri = ((WssCustomToken)wssCustomToken).getUri();
                        localName = ((WssCustomToken)wssCustomToken).getLocalname();
                        tokenType = new QName(uri, localName);
                        protectionToken.addWssTokenAssertion(tokenType);
                        continue;
                    }
                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{objN.toString()}));
                }
            }
        } else {
            Tr.warning(tc, "security.wssecurity.PolicyInOutboundConfig.s01", new String[]{tokenName});
        }
        return protectionToken;
    }

    private boolean retrieveAssertions(String id) {
        boolean retrieveAssertion = false;
        if (id == null) {
            retrieveAssertion = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No wsu:Id for Policy element found; ignoring.");
            }
        } else if (id.startsWith("request:") || id.startsWith("response:")) {
            retrieveAssertion = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Matching request or response wsu:Id found: " + id);
            }
        } else {
            retrieveAssertion = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsu:Id found not applicable for request or response messages: " + id);
            }
        }
        return retrieveAssertion;
    }

    ProtectionOrSupportingToken getProtectionToken(JAXBElement tokenAssertion, String assertionName, boolean isProtectionToken) throws SoapSecurityException {
        ProtectionOrSupportingToken protectionToken = null;
        OperatorContentType requiredTokenAssertionPolicy = null;
        Object objNestedOrTokenType = tokenAssertion.getValue();
        org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType np = null;
        TokenAssertionType tp = null;
        Policy assertionPolicy = null;
        List<Object> assertionPolicyList = null;
        String includeToken = null;
        EndpointReferenceType issuer = null;
        if (objNestedOrTokenType instanceof org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType) {
            np = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)tokenAssertion.getValue();
            if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", this.targetNamespace}));
            }
            if (np.getPolicy() != null) {
                assertionPolicy = np.getPolicy();
                assertionPolicyList = assertionPolicy.getPolicyOrAllOrExactlyOne();
            } else {
                assertionPolicyList = np.getAny();
            }
        } else if (objNestedOrTokenType instanceof TokenAssertionType) {
            tp = (TokenAssertionType)tokenAssertion.getValue();
            if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", this.targetNamespace}));
            }
            String requiredTokenName = tokenAssertion.getName().getLocalPart();
            if (tp.getAny() != null) {
                List<Object> list = tp.getAny();
                if (list != null && list.size() > 0) {
                    requiredTokenAssertionPolicy = (Policy)list.get(0);
                }
                if (requiredTokenAssertionPolicy != null) {
                    List<Object> policyAssertionList = requiredTokenAssertionPolicy.getPolicyOrAllOrExactlyOne();
                    protectionToken = this.getTokenAssertion(requiredTokenName, policyAssertionList, isProtectionToken);
                }
            }
            if (requiredTokenName.equals("LTPAToken") || requiredTokenName.equals("LTPAPropagationToken")) {
                protectionToken = this.getTokenAssertion(requiredTokenName, assertionPolicyList, isProtectionToken);
            }
        } else {
            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{objNestedOrTokenType.toString()}));
        }
        if (assertionPolicyList != null) {
            for (int x = 0; x < assertionPolicyList.size(); ++x) {
                Object requiredTokenAssertion = assertionPolicyList.get(x);
                if (requiredTokenAssertion instanceof Element) {
                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s02", new String[]{requiredTokenAssertion.toString()}));
                }
                if (requiredTokenAssertion instanceof JAXBElement) {
                    List<Object> policyAssertionList;
                    List<Object> list;
                    Object required;
                    JAXBElement requiredToken = (JAXBElement)requiredTokenAssertion;
                    QName requiredTokenQName = requiredToken.getName();
                    String requiredTokenName = requiredTokenQName.getLocalPart();
                    if (requiredTokenName.equals("SecureConversationToken")) {
                        required = (SecureConversationTokenType)requiredToken.getValue();
                        issuer = ((SecureConversationTokenType)required).getIssuer();
                        list = ((SecureConversationTokenType)required).getAny();
                        if (list != null && list.size() > 0) {
                            for (int i = 0; i < list.size(); ++i) {
                                Object listObj = list.get(i);
                                if (!(listObj instanceof Policy)) continue;
                                requiredTokenAssertionPolicy = (Policy)list.get(i);
                            }
                        }
                        includeToken = ((SecureConversationTokenType)required).getIncludeToken();
                    } else {
                        required = (TokenAssertionType)requiredToken.getValue();
                        list = ((TokenAssertionType)required).getAny();
                        if (list != null && list.size() > 0) {
                            requiredTokenAssertionPolicy = (Policy)list.get(0);
                        }
                        includeToken = ((TokenAssertionType)required).getIncludeToken();
                    }
                    if (requiredTokenAssertionPolicy == null || (protectionToken = this.getTokenAssertion(requiredTokenName, policyAssertionList = requiredTokenAssertionPolicy.getPolicyOrAllOrExactlyOne(), isProtectionToken)) == null) continue;
                    protectionToken.setIncludeToken(includeToken);
                    protectionToken.setIssuer(issuer);
                    continue;
                }
                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{requiredTokenAssertion.toString()}));
            }
        }
        if (protectionToken != null) {
            protectionToken.setName(assertionName);
        }
        return protectionToken;
    }

    ProtectionOrSupportingToken getProtectionToken12(JAXBElement tokenAssertion, String assertionName, boolean isProtectionToken) throws SoapSecurityException {
        ProtectionOrSupportingToken protectionToken = null;
        OperatorContentType requiredTokenAssertionPolicy = null;
        Object objNestedOrTokenType = tokenAssertion.getValue();
        NestedPolicyType np = null;
        org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.TokenAssertionType tp = null;
        List<Object> assertionPolicyList = null;
        String includeToken = null;
        org.w3._2005._08.addressing.EndpointReferenceType issuer = null;
        if (objNestedOrTokenType instanceof NestedPolicyType) {
            np = (NestedPolicyType)tokenAssertion.getValue();
            if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702")) {
                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", this.targetNamespace}));
            }
            List<Object> nestedPolicies = np.getAny();
            OperatorContentType nestedPolicy = null;
            if (nestedPolicies.size() > 0) {
                Object potentialPolicy = nestedPolicies.get(0);
                if (potentialPolicy instanceof Policy) {
                    nestedPolicy = (Policy)potentialPolicy;
                } else {
                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{potentialPolicy.toString()}));
                }
            }
            if (nestedPolicy != null) {
                assertionPolicyList = nestedPolicy.getPolicyOrAllOrExactlyOne();
            }
        } else if (objNestedOrTokenType instanceof org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.TokenAssertionType) {
            tp = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.TokenAssertionType)tokenAssertion.getValue();
            if (!this.targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702")) {
                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s03", new String[]{"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", this.targetNamespace}));
            }
            String requiredTokenName = tokenAssertion.getName().getLocalPart();
            if (tp.getAny() != null) {
                List<Object> list = tp.getAny();
                if (list != null && list.size() > 0) {
                    requiredTokenAssertionPolicy = (Policy)list.get(0);
                }
                if (requiredTokenAssertionPolicy != null) {
                    List<Object> policyAssertionList = requiredTokenAssertionPolicy.getPolicyOrAllOrExactlyOne();
                    protectionToken = this.getTokenAssertion(requiredTokenName, policyAssertionList, isProtectionToken);
                }
            }
            if (requiredTokenName.equals("LTPAToken") || requiredTokenName.equals("LTPAPropagationToken")) {
                protectionToken = this.getTokenAssertion(requiredTokenName, assertionPolicyList, isProtectionToken);
            }
        } else {
            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{objNestedOrTokenType.toString()}));
        }
        if (assertionPolicyList != null) {
            for (int x = 0; x < assertionPolicyList.size(); ++x) {
                Object requiredTokenAssertion = assertionPolicyList.get(x);
                if (requiredTokenAssertion instanceof Element) {
                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s02", new String[]{requiredTokenAssertion.toString()}));
                }
                if (requiredTokenAssertion instanceof JAXBElement) {
                    List<Object> policyAssertionList;
                    List<Object> list;
                    Object required;
                    JAXBElement requiredToken = (JAXBElement)requiredTokenAssertion;
                    QName requiredTokenQName = requiredToken.getName();
                    String requiredTokenName = requiredTokenQName.getLocalPart();
                    if (requiredTokenName.equals("SecureConversationToken")) {
                        required = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SecureConversationTokenType)requiredToken.getValue();
                        issuer = ((org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SecureConversationTokenType)required).getIssuer();
                        list = ((org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SecureConversationTokenType)required).getAny();
                        if (list != null && list.size() > 0) {
                            for (int i = 0; i < list.size(); ++i) {
                                Object listObj = list.get(i);
                                if (!(listObj instanceof Policy)) continue;
                                requiredTokenAssertionPolicy = (Policy)list.get(i);
                            }
                        }
                        includeToken = ((org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SecureConversationTokenType)required).getIncludeToken();
                    } else {
                        required = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.TokenAssertionType)requiredToken.getValue();
                        list = ((org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.TokenAssertionType)required).getAny();
                        if (list != null && list.size() > 0) {
                            requiredTokenAssertionPolicy = (Policy)list.get(0);
                        }
                        includeToken = ((org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.TokenAssertionType)required).getIncludeToken();
                    }
                    if (requiredTokenAssertionPolicy == null || (protectionToken = this.getTokenAssertion(requiredTokenName, policyAssertionList = requiredTokenAssertionPolicy.getPolicyOrAllOrExactlyOne(), isProtectionToken)) == null) continue;
                    protectionToken.setIncludeToken(includeToken);
                    protectionToken.setIssuer200508(issuer);
                    continue;
                }
                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSPolicy.s04", new String[]{requiredTokenAssertion.toString()}));
            }
        }
        if (protectionToken != null) {
            protectionToken.setName(assertionName);
        }
        return protectionToken;
    }

    private boolean isProtectionToken(String assertionName) {
        return "InitiatorToken".equals(assertionName) || "RecipientToken".equals(assertionName) || "InitiatorSignatureToken".equals(assertionName) || "RecipientSignatureToken".equals(assertionName) || "InitiatorEncryptionToken".equals(assertionName) || "RecipientEncryptionToken".equals(assertionName) || "EncryptionToken".equals(assertionName) || "SignatureToken".equals(assertionName) || "ProtectionToken".equals(assertionName);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
        buf.append("targetNamespace=[").append(this.targetNamespace).append("], ");
        buf.append("wss10Assertions=[").append(this.wss10Assertions).append("], ");
        buf.append("wss11Assertions=[").append(this.wss11Assertions).append("], ");
        buf.append("protectionAssertions=[").append(this.protectionAssertions).append("], ");
        buf.append("supportingTokens=[").append(this.supportingTokens).append("], ");
        buf.append("policyBinding=[").append(this.policyBinding).append("]");
        buf.append(")");
        return buf.toString();
    }
}

