/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.ws.wssecurity.handler.WSSBasicAuth;
import com.ibm.ws.wssecurity.handler.WSSCallbackHandler;
import com.ibm.ws.wssecurity.handler.WSSCaller;
import com.ibm.ws.wssecurity.handler.WSSCertPathSettings;
import com.ibm.ws.wssecurity.handler.WSSCollectionCertStores;
import com.ibm.ws.wssecurity.handler.WSSCommonBinding;
import com.ibm.ws.wssecurity.handler.WSSDerivedKeyInfo;
import com.ibm.ws.wssecurity.handler.WSSEncryptionInfo;
import com.ibm.ws.wssecurity.handler.WSSEncryptionPartReference;
import com.ibm.ws.wssecurity.handler.WSSJaasConfig;
import com.ibm.ws.wssecurity.handler.WSSKey;
import com.ibm.ws.wssecurity.handler.WSSKeyInfo;
import com.ibm.ws.wssecurity.handler.WSSKeyStore;
import com.ibm.ws.wssecurity.handler.WSSLdapCertStores;
import com.ibm.ws.wssecurity.handler.WSSSigningInfo;
import com.ibm.ws.wssecurity.handler.WSSSigningPartReference;
import com.ibm.ws.wssecurity.handler.WSSToken;
import com.ibm.ws.wssecurity.handler.WSSTransform;
import com.ibm.ws.wssecurity.handler.WSSTrustAnchor;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.BasicAuth;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CRL;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Caller;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CertStoreList;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Consumerbindingref;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.EncryptionInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Key;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyEncryptionKeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.LdapCertStores;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.LdapServer;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Properties;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TokenReference;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TrustAnchor;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TrustedIdentity;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.ValueType;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.X509Certificates;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CallbackHandler;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CallerIdentity;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CertPathSettings;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CertStoreRef;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CollectionCertStores;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.DataEncryptionKeyInfo;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.DerivedKeyInfo;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.EncryptionPartReference;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.JAASConfig;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.KeyInfo;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.KeyStore;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.RequiredSigningPartReference;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SecurityInboundBindingConfig;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SecurityTokenReference;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SigningKeyInfo;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SigningPartReference;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TokenConsumer;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Transform;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TrustAnchorRef;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TrustAnyCertificate;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSInboundBinding
extends WSSCommonBinding {
    private static final TraceComponent tc = Tr.register(WSSInboundBinding.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSInboundBinding.class.getName();
    private List<WSSCaller> callers = new ArrayList<WSSCaller>();
    private List<WSSTrustAnchor> trustAnchors = new ArrayList<WSSTrustAnchor>();

    public List<WSSCaller> getCallers() {
        return this.callers;
    }

    public List<WSSTrustAnchor> getTrustAnchors() {
        return this.trustAnchors;
    }

    public WSSInboundBinding(SecurityInboundBindingConfig inboundBinding) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSSInboundBinding (SecurityInboundBindingConfig inboundBinding)", new Object[]{inboundBinding});
        }
        this.init(inboundBinding);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSSInboundBinding (SecurityInboundBindingConfig inboundBinding)");
        }
    }

    public WSSInboundBinding(com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityInboundBindingConfig inboundBinding) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSSInboundBinding (SecurityInboundBindingConfig inboundBinding)", new Object[]{inboundBinding});
        }
        this.init(inboundBinding);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSSInboundBinding (SecurityInboundBindingConfig inboundBinding)");
        }
    }

    protected final void init(SecurityInboundBindingConfig inboundBinding) throws SoapSecurityException {
        WSSJaasConfig wssJaas;
        int i;
        int iMax;
        List<com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Properties> propertyList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(SecurityInboundBindingConfig inboundBinding)");
        }
        this.targetNamespace = "com.ibm.xmlns.prod.websphere._200710.ws_securitybinding";
        this.actor = inboundBinding.getActor();
        com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Consumerbindingref conBindingRef = inboundBinding.getConsumerbindingref();
        if (conBindingRef != null) {
            this.bindingReference = conBindingRef.getReference();
        }
        com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CertStoreList certStoreList = inboundBinding.getCertStoreList();
        List<com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.EncryptionInfo> encryptionInfoList = inboundBinding.getEncryptionInfo();
        List<KeyInfo> keyInfoList = inboundBinding.getKeyInfo();
        List<com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SigningInfo> signingInfoList = inboundBinding.getSigningInfo();
        List<TokenConsumer> tokenConsumerList = inboundBinding.getTokenConsumer();
        List<com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Caller> callerList = inboundBinding.getCaller();
        List<com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TrustAnchor> trustAnchorList = inboundBinding.getTrustAnchor();
        this.properties = propertyList = inboundBinding.getProperties();
        String value = null;
        if (encryptionInfoList != null) {
            iMax = encryptionInfoList.size();
            for (i = 0; i < iMax; ++i) {
                List<com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.KeyEncryptionKeyInfo> encryptionKeys;
                com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.EncryptionInfo encryptionInfo = encryptionInfoList.get(i);
                WSSEncryptionInfo wssEncInfo = new WSSEncryptionInfo();
                EncryptionPartReference pref = encryptionInfo.getEncryptionPartReference();
                if (pref != null) {
                    List<DataEncryptionKeyInfo> dataEncryptionKeys;
                    WSSEncryptionPartReference wssEncPartRef = new WSSEncryptionPartReference();
                    value = ConfigUtil.trim(pref.getReference());
                    if (value != null && value.length() > 0) {
                        wssEncPartRef.setReference(value);
                        if (pref.getTimestamp() != null) {
                            wssEncPartRef.setIncludeTimestamp(true);
                        }
                        if (pref.getNonce() != null) {
                            wssEncPartRef.setIncludeNonce(true);
                        }
                    }
                    if ((dataEncryptionKeys = pref.getDataEncryptionKeyInfo()) != null && dataEncryptionKeys.size() > 0) {
                        DataEncryptionKeyInfo encryptionKey = dataEncryptionKeys.get(0);
                        wssEncPartRef.setDataEncryptionKeyInfo(ConfigUtil.trim(encryptionKey.getReference()));
                    }
                    wssEncInfo.setEncryptionPartReference(wssEncPartRef);
                }
                if ((encryptionKeys = encryptionInfo.getKeyEncryptionKeyInfo()) != null && encryptionKeys.size() > 0) {
                    int jMax = encryptionKeys.size();
                    for (int j = 0; j < jMax; ++j) {
                        com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.KeyEncryptionKeyInfo encryptionKey = encryptionKeys.get(j);
                        value = ConfigUtil.trim(encryptionKey.getReference());
                        if (value == null || value.length() <= 0) continue;
                        wssEncInfo.addKeyEncryptionKeyInfo(value);
                    }
                }
                wssEncInfo.setProperties(encryptionInfo.getProperties());
                this.encryptionInfos.add(wssEncInfo);
            }
        }
        if (signingInfoList != null) {
            iMax = signingInfoList.size();
            for (i = 0; i < iMax; ++i) {
                List<SigningKeyInfo> signingKeys;
                com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SigningInfo signingInfo = signingInfoList.get(i);
                WSSSigningInfo wssSignInfo = new WSSSigningInfo();
                List<SigningPartReference> prefs = signingInfo.getSigningPartReference();
                if (prefs != null) {
                    int jMax = prefs.size();
                    for (int j = 0; j < jMax; ++j) {
                        List<Transform> transforms;
                        SigningPartReference pref = prefs.get(j);
                        if (pref == null) continue;
                        WSSSigningPartReference wssSignPartRef = new WSSSigningPartReference();
                        value = ConfigUtil.trim(pref.getReference());
                        if (value != null && value.length() > 0) {
                            wssSignPartRef.setReference(value);
                            if (pref.getTimestamp() != null) {
                                wssSignPartRef.setIncludeTimestamp(true);
                            }
                            if (pref.getNonce() != null) {
                                wssSignPartRef.setIncludeNonce(true);
                            }
                        }
                        if ((transforms = pref.getTransform()) != null) {
                            int kMax = transforms.size();
                            for (int k = 0; k < kMax; ++k) {
                                Transform transform = transforms.get(k);
                                if (transform == null) continue;
                                WSSTransform wssTrans = new WSSTransform();
                                wssTrans.setAlgorithm(ConfigUtil.trim(transform.getAlgorithm()));
                                wssTrans.setProperties(transform.getProperties());
                                wssSignPartRef.addTransform(wssTrans);
                            }
                        }
                        wssSignInfo.addSigningPartReference(wssSignPartRef);
                    }
                }
                if ((signingKeys = signingInfo.getSigningKeyInfo()) != null && signingKeys.size() > 0) {
                    int jMax = signingKeys.size();
                    for (int j = 0; j < jMax; ++j) {
                        SigningKeyInfo signingKey = signingKeys.get(j);
                        wssSignInfo.addSigningKeyInfo(ConfigUtil.trim(signingKey.getReference()));
                    }
                }
                wssSignInfo.setProperties(signingInfo.getProperties());
                this.signingInfos.add(wssSignInfo);
            }
        }
        if (keyInfoList != null) {
            iMax = keyInfoList.size();
            for (i = 0; i < iMax; ++i) {
                DerivedKeyInfo derivedKeyInfo;
                KeyInfo keyInfo = keyInfoList.get(i);
                WSSKeyInfo wssKeyInfo = new WSSKeyInfo();
                wssKeyInfo.setClassname(ConfigUtil.trim(keyInfo.getClassname()));
                com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TokenReference tokenReference = keyInfo.getTokenReference();
                if (tokenReference != null) {
                    wssKeyInfo.setTokenReference(ConfigUtil.trim(tokenReference.getReference()));
                }
                if ((derivedKeyInfo = keyInfo.getDerivedKeyInfo()) != null) {
                    WSSDerivedKeyInfo wssDerivedKeyInfo = new WSSDerivedKeyInfo();
                    wssDerivedKeyInfo.setClientLabel(ConfigUtil.trim(derivedKeyInfo.getClientLabel()));
                    wssDerivedKeyInfo.setServiceLabel(ConfigUtil.trim(derivedKeyInfo.getServiceLabel()));
                    wssDerivedKeyInfo.setKeyLength(ConfigUtil.trim(derivedKeyInfo.getKeyLength()));
                    wssDerivedKeyInfo.setNonceLength(ConfigUtil.trim(derivedKeyInfo.getNonceLength()));
                    if (derivedKeyInfo.getRequireDerivedKeys() != null) {
                        wssDerivedKeyInfo.setRequireDerivedKeys(true);
                    }
                    if (derivedKeyInfo.getRequireImpliedDerivedKeys() != null) {
                        wssDerivedKeyInfo.setRequireImpliedDerivedKeys(true);
                    }
                    if (derivedKeyInfo.getRequireExplicitDerivedKeys() != null) {
                        wssDerivedKeyInfo.setRequireExplicitDerivedKeys(true);
                    }
                    wssKeyInfo.setDerivedKeyInfo(wssDerivedKeyInfo);
                }
                wssKeyInfo.setName(ConfigUtil.trim(keyInfo.getName()));
                wssKeyInfo.setProperties(keyInfo.getProperties());
                this.keyInfos.add(wssKeyInfo);
            }
        }
        if (callerList != null) {
            iMax = callerList.size();
            for (i = 0; i < iMax; ++i) {
                String order;
                CallbackHandler callbackHandler;
                JAASConfig jaasConfig;
                RequiredSigningPartReference requiredSigningPartReference;
                com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TrustedIdentity trustedIdentity;
                String ln;
                com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Caller caller = callerList.get(i);
                if (caller == null) continue;
                WSSCaller wssCaller = new WSSCaller();
                CallerIdentity callerIdentity = caller.getCallerIdentity();
                if (callerIdentity != null) {
                    String uri = ConfigUtil.trim(callerIdentity.getUri());
                    if (uri == null) {
                        uri = "";
                    }
                    ln = ConfigUtil.trim(callerIdentity.getLocalName());
                    wssCaller.setCallerIdentity(new QName(uri, ln));
                }
                if ((trustedIdentity = caller.getTrustedIdentity()) != null) {
                    ln = ConfigUtil.trim(trustedIdentity.getLocalName());
                    if (ln != null && ln.length() > 0) {
                        String uri = ConfigUtil.trim(trustedIdentity.getUri());
                        if (uri == null) {
                            uri = "";
                        }
                        wssCaller.setTrustedIdentity(new QName(uri, ln));
                    } else {
                        wssCaller.setAnyTrustedIdentity(true);
                    }
                }
                if ((requiredSigningPartReference = caller.getRequiredSigningPartReference()) != null && (value = ConfigUtil.trim(requiredSigningPartReference.getReference())) != null && value.length() > 0) {
                    wssCaller.setRequiredSigningPartReference(value);
                }
                if ((jaasConfig = caller.getJAASConfig()) != null) {
                    wssJaas = new WSSJaasConfig();
                    wssJaas.setConfigName(ConfigUtil.trim(jaasConfig.getConfigName()));
                    wssJaas.setProperties(jaasConfig.getProperties());
                    wssCaller.setJaasConfig(wssJaas);
                }
                if ((callbackHandler = caller.getCallbackHandler()) != null) {
                    WSSCallbackHandler wssCallback = new WSSCallbackHandler();
                    wssCallback.setClassname(ConfigUtil.trim(callbackHandler.getClassname()));
                    wssCallback.setProperties(callbackHandler.getProperties());
                    wssCaller.setCallbackHandler(wssCallback);
                }
                if ((order = caller.getOrder()) == null) {
                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSInboundBinding.s01", new String[]{"com.ibm.xmlns.prod.websphere._200710.ws_securitybinding"}));
                }
                wssCaller.setOrder(ConfigUtil.trim(caller.getOrder()));
                this.callers.add(wssCaller);
            }
        }
        if (tokenConsumerList != null) {
            iMax = tokenConsumerList.size();
            for (i = 0; i < iMax; ++i) {
                JAASConfig jaasConfig;
                SecurityTokenReference pref;
                TokenConsumer tokenConsumer = tokenConsumerList.get(i);
                WSSToken wssTokenCon = new WSSToken();
                wssTokenCon.setName(ConfigUtil.trim(tokenConsumer.getName()));
                com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.ValueType valueType = tokenConsumer.getValueType();
                if (valueType != null) {
                    QName qn = new QName(ConfigUtil.trim(valueType.getUri()), ConfigUtil.trim(valueType.getLocalName()));
                    wssTokenCon.setValueType(qn);
                }
                if ((pref = tokenConsumer.getSecurityTokenReference()) != null) {
                    wssTokenCon.setSecurityTokenReference(ConfigUtil.trim(pref.getReference()));
                }
                if (tokenConsumer.getEnforceTokenVersion() != null) {
                    wssTokenCon.setEnforceTokenVersion(true);
                }
                wssTokenCon.setClassname(ConfigUtil.trim(tokenConsumer.getClassname()));
                CallbackHandler callbackHandler = tokenConsumer.getCallbackHandler();
                if (callbackHandler != null) {
                    com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.BasicAuth basicAuth;
                    CertPathSettings certPathSettings;
                    com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Key key;
                    WSSCallbackHandler wssCallback = new WSSCallbackHandler();
                    wssCallback.setClassname(ConfigUtil.trim(callbackHandler.getClassname()));
                    KeyStore keystore = callbackHandler.getKeyStore();
                    if (keystore != null) {
                        WSSKeyStore wssKeystore = new WSSKeyStore();
                        wssKeystore.setType(ConfigUtil.trim(keystore.getType()));
                        wssKeystore.setPath(ConfigUtil.trim(keystore.getPath()));
                        wssKeystore.setStorepass(ConfigUtil.trim(keystore.getStorepass()));
                        wssKeystore.setKeyStoreRef(ConfigUtil.trim(keystore.getKeyStoreRef()));
                        wssCallback.setKeyStore(wssKeystore);
                    }
                    if ((key = callbackHandler.getKey()) != null) {
                        WSSKey wssKey = new WSSKey();
                        wssKey.setAlias(ConfigUtil.trim(key.getAlias()));
                        wssKey.setKeypass(ConfigUtil.trim(key.getKeypass()));
                        wssKey.setName(ConfigUtil.trim(key.getName()));
                        wssCallback.setKey(wssKey);
                    }
                    if ((certPathSettings = callbackHandler.getCertPathSettings()) != null) {
                        WSSCertPathSettings wssCertPath = new WSSCertPathSettings();
                        TrustAnyCertificate trustAnyCertificate = certPathSettings.getTrustAnyCertificate();
                        if (trustAnyCertificate != null) {
                            wssCertPath.setTrustAnyCertificate(true);
                        } else {
                            TrustAnchorRef trustAnchorRef = certPathSettings.getTrustAnchorRef();
                            CertStoreRef certStoreRef = certPathSettings.getCertStoreRef();
                            if (trustAnchorRef != null || certStoreRef != null) {
                                if (trustAnchorRef != null) {
                                    value = ConfigUtil.trim(trustAnchorRef.getReference());
                                    wssCertPath.setTrustAnchorRef(value);
                                    for (int j = 0; j < trustAnchorList.size(); ++j) {
                                        com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TrustAnchor trustAnchor = trustAnchorList.get(j);
                                        WSSTrustAnchor wssTrustAnchor = new WSSTrustAnchor();
                                        wssTrustAnchor.setName(ConfigUtil.trim(trustAnchor.getName()));
                                        keystore = trustAnchor.getKeyStore();
                                        if (keystore != null) {
                                            WSSKeyStore wssKeyStore = new WSSKeyStore();
                                            wssKeyStore.setType(ConfigUtil.trim(keystore.getType()));
                                            wssKeyStore.setPath(ConfigUtil.trim(keystore.getPath()));
                                            wssKeyStore.setStorepass(ConfigUtil.trim(keystore.getStorepass()));
                                            wssKeyStore.setKeyStoreRef(ConfigUtil.trim(keystore.getKeyStoreRef()));
                                            wssTrustAnchor.setKeyStore(wssKeyStore);
                                        }
                                        this.trustAnchors.add(wssTrustAnchor);
                                    }
                                }
                                if (certStoreRef != null) {
                                    value = ConfigUtil.trim(certStoreRef.getReference());
                                    wssCertPath.setCertStoreRef(value);
                                    if (certStoreList != null) {
                                        boolean hasLDAPCertStores = false;
                                        boolean hasCollectionCertStores = false;
                                        List<Object> certStoresCollection = certStoreList.getLdapCertStoresOrCollectionCertStores();
                                        int jMax = certStoresCollection.size();
                                        if (jMax > 0) {
                                            Object certStore = certStoresCollection.get(0);
                                            if (certStore instanceof CollectionCertStores) {
                                                hasCollectionCertStores = true;
                                            } else if (certStore instanceof com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.LdapCertStores) {
                                                hasLDAPCertStores = true;
                                            }
                                        }
                                        if (hasCollectionCertStores) {
                                            for (int j = 0; j < jMax; ++j) {
                                                CollectionCertStores collectionStore = (CollectionCertStores)certStoresCollection.get(j);
                                                WSSCollectionCertStores wssCollectionStore = new WSSCollectionCertStores();
                                                wssCollectionStore.setName(ConfigUtil.trim(collectionStore.getName()));
                                                wssCollectionStore.setProvider(ConfigUtil.trim(collectionStore.getProvider()));
                                                List<Object> x509andCRLs = collectionStore.getX509CertificatesOrCRL();
                                                int kMax = x509andCRLs.size();
                                                for (int k = 0; k < kMax; ++k) {
                                                    Object x509orCRL = x509andCRLs.get(k);
                                                    if (x509orCRL instanceof com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.X509Certificates) {
                                                        com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.X509Certificates x509 = (com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.X509Certificates)x509orCRL;
                                                        wssCollectionStore.addX509Path(ConfigUtil.trim(x509.getPath()));
                                                        continue;
                                                    }
                                                    if (!(x509orCRL instanceof com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CRL)) continue;
                                                    com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CRL crl = (com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CRL)x509orCRL;
                                                    wssCollectionStore.addCRLPath(ConfigUtil.trim(crl.getPath()));
                                                }
                                                this.collectionCertStores.add(wssCollectionStore);
                                            }
                                        }
                                        if (hasLDAPCertStores) {
                                            for (int j = 0; j < jMax; ++j) {
                                                com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.LdapCertStores ldapCertStore = (com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.LdapCertStores)certStoresCollection.get(j);
                                                WSSLdapCertStores wssLdapStores = new WSSLdapCertStores();
                                                wssLdapStores.setName(ConfigUtil.trim(ldapCertStore.getName()));
                                                wssLdapStores.setProvider(ConfigUtil.trim(ldapCertStore.getProvider()));
                                                com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.LdapServer ldapServer = ldapCertStore.getLdapServer();
                                                wssLdapStores.setHost(ConfigUtil.trim(ldapServer.getHost()));
                                                wssLdapStores.setPort(ConfigUtil.trim(ldapServer.getPort()));
                                                this.ldapCertStores.add(wssLdapStores);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        wssCallback.setCertPathSettings(wssCertPath);
                    }
                    if ((basicAuth = callbackHandler.getBasicAuth()) != null) {
                        WSSBasicAuth wssBasic = new WSSBasicAuth();
                        wssBasic.setUserid(ConfigUtil.trim(basicAuth.getUserid()));
                        wssBasic.setPassword(ConfigUtil.trim(basicAuth.getPassword()));
                        wssCallback.setBasicAuth(wssBasic);
                    }
                    wssCallback.setProperties(callbackHandler.getProperties());
                    wssTokenCon.setCallbackHandler(wssCallback);
                }
                if ((jaasConfig = tokenConsumer.getJAASConfig()) != null) {
                    wssJaas = new WSSJaasConfig();
                    wssJaas.setConfigName(ConfigUtil.trim(jaasConfig.getConfigName()));
                    wssJaas.setProperties(jaasConfig.getProperties());
                    wssTokenCon.setJaasConfig(wssJaas);
                }
                wssTokenCon.setProperties(tokenConsumer.getProperties());
                this.tokens.add(wssTokenCon);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(SecurityInboundBindingConfig inboundBinding)");
        }
    }

    protected final void init(com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityInboundBindingConfig inboundBinding) throws SoapSecurityException {
        WSSJaasConfig wssJaas;
        int i;
        int iMax;
        List<Properties> propertyList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(SecurityInboundBindingConfig inboundBinding)");
        }
        this.targetNamespace = "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding";
        this.actor = inboundBinding.getActor();
        Consumerbindingref conBindingRef = inboundBinding.getConsumerbindingref();
        if (conBindingRef != null) {
            this.bindingReference = conBindingRef.getReference();
        }
        CertStoreList certStoreList = inboundBinding.getCertStoreList();
        List<EncryptionInfo> encryptionInfoList = inboundBinding.getEncryptionInfo();
        List<com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyInfo> keyInfoList = inboundBinding.getKeyInfo();
        List<SigningInfo> signingInfoList = inboundBinding.getSigningInfo();
        List<com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TokenConsumer> tokenConsumerList = inboundBinding.getTokenConsumer();
        List<Caller> callerList = inboundBinding.getCaller();
        List<TrustAnchor> trustAnchorList = inboundBinding.getTrustAnchor();
        this.properties = propertyList = inboundBinding.getProperties();
        String value = null;
        if (encryptionInfoList != null) {
            iMax = encryptionInfoList.size();
            for (i = 0; i < iMax; ++i) {
                List<KeyEncryptionKeyInfo> encryptionKeys;
                EncryptionInfo encryptionInfo = encryptionInfoList.get(i);
                WSSEncryptionInfo wssEncInfo = new WSSEncryptionInfo();
                com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.EncryptionPartReference pref = encryptionInfo.getEncryptionPartReference();
                if (pref != null) {
                    List<com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.DataEncryptionKeyInfo> dataEncryptionKeys;
                    WSSEncryptionPartReference wssEncPartRef = new WSSEncryptionPartReference();
                    value = ConfigUtil.trim(pref.getReference());
                    if (value != null && value.length() > 0) {
                        wssEncPartRef.setReference(value);
                        if (pref.getTimestamp() != null) {
                            wssEncPartRef.setIncludeTimestamp(true);
                        }
                        if (pref.getNonce() != null) {
                            wssEncPartRef.setIncludeNonce(true);
                        }
                    }
                    if ((dataEncryptionKeys = pref.getDataEncryptionKeyInfo()) != null && dataEncryptionKeys.size() > 0) {
                        com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.DataEncryptionKeyInfo encryptionKey = dataEncryptionKeys.get(0);
                        wssEncPartRef.setDataEncryptionKeyInfo(ConfigUtil.trim(encryptionKey.getReference()));
                    }
                    wssEncInfo.setEncryptionPartReference(wssEncPartRef);
                }
                if ((encryptionKeys = encryptionInfo.getKeyEncryptionKeyInfo()) != null && encryptionKeys.size() > 0) {
                    int jMax = encryptionKeys.size();
                    for (int j = 0; j < jMax; ++j) {
                        KeyEncryptionKeyInfo encryptionKey = encryptionKeys.get(j);
                        value = ConfigUtil.trim(encryptionKey.getReference());
                        if (value == null || value.length() <= 0) continue;
                        wssEncInfo.addKeyEncryptionKeyInfo(value);
                    }
                }
                wssEncInfo.setProperties(encryptionInfo.getProperties());
                this.encryptionInfos.add(wssEncInfo);
            }
        }
        if (signingInfoList != null) {
            iMax = signingInfoList.size();
            for (i = 0; i < iMax; ++i) {
                List<com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningKeyInfo> signingKeys;
                SigningInfo signingInfo = signingInfoList.get(i);
                WSSSigningInfo wssSignInfo = new WSSSigningInfo();
                List<com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningPartReference> prefs = signingInfo.getSigningPartReference();
                if (prefs != null) {
                    int jMax = prefs.size();
                    for (int j = 0; j < jMax; ++j) {
                        List<com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Transform> transforms;
                        com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningPartReference pref = prefs.get(j);
                        if (pref == null) continue;
                        WSSSigningPartReference wssSignPartRef = new WSSSigningPartReference();
                        value = ConfigUtil.trim(pref.getReference());
                        if (value != null && value.length() > 0) {
                            wssSignPartRef.setReference(value);
                            if (pref.getTimestamp() != null) {
                                wssSignPartRef.setIncludeTimestamp(true);
                            }
                            if (pref.getNonce() != null) {
                                wssSignPartRef.setIncludeNonce(true);
                            }
                        }
                        if ((transforms = pref.getTransform()) != null) {
                            int kMax = transforms.size();
                            for (int k = 0; k < kMax; ++k) {
                                com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Transform transform = transforms.get(k);
                                if (transform == null) continue;
                                WSSTransform wssTrans = new WSSTransform();
                                wssTrans.setAlgorithm(ConfigUtil.trim(transform.getAlgorithm()));
                                wssTrans.setProperties(transform.getProperties());
                                wssSignPartRef.addTransform(wssTrans);
                            }
                        }
                        wssSignInfo.addSigningPartReference(wssSignPartRef);
                    }
                }
                if ((signingKeys = signingInfo.getSigningKeyInfo()) != null && signingKeys.size() > 0) {
                    int jMax = signingKeys.size();
                    for (int j = 0; j < jMax; ++j) {
                        com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningKeyInfo signingKey = signingKeys.get(j);
                        wssSignInfo.addSigningKeyInfo(ConfigUtil.trim(signingKey.getReference()));
                    }
                }
                wssSignInfo.setProperties(signingInfo.getProperties());
                this.signingInfos.add(wssSignInfo);
            }
        }
        if (keyInfoList != null) {
            iMax = keyInfoList.size();
            for (i = 0; i < iMax; ++i) {
                com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyInfo keyInfo = keyInfoList.get(i);
                WSSKeyInfo wssKeyInfo = new WSSKeyInfo();
                wssKeyInfo.setClassname(ConfigUtil.trim(keyInfo.getClassname()));
                TokenReference tokenReference = keyInfo.getTokenReference();
                if (tokenReference != null) {
                    wssKeyInfo.setTokenReference(ConfigUtil.trim(tokenReference.getReference()));
                }
                wssKeyInfo.setName(ConfigUtil.trim(keyInfo.getName()));
                wssKeyInfo.setProperties(keyInfo.getProperties());
                this.keyInfos.add(wssKeyInfo);
            }
        }
        if (callerList != null) {
            iMax = callerList.size();
            for (i = 0; i < iMax; ++i) {
                com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CallbackHandler callbackHandler;
                com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.JAASConfig jaasConfig;
                com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.RequiredSigningPartReference requiredSigningPartReference;
                TrustedIdentity trustedIdentity;
                String ln;
                Caller caller = callerList.get(i);
                if (caller == null) continue;
                WSSCaller wssCaller = new WSSCaller();
                com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CallerIdentity callerIdentity = caller.getCallerIdentity();
                if (callerIdentity != null) {
                    String uri = ConfigUtil.trim(callerIdentity.getUri());
                    if (uri == null) {
                        uri = "";
                    }
                    ln = ConfigUtil.trim(callerIdentity.getLocalName());
                    wssCaller.setCallerIdentity(new QName(uri, ln));
                }
                if ((trustedIdentity = caller.getTrustedIdentity()) != null) {
                    ln = ConfigUtil.trim(trustedIdentity.getLocalName());
                    if (ln != null && ln.length() > 0) {
                        String uri = ConfigUtil.trim(trustedIdentity.getUri());
                        if (uri == null) {
                            uri = "";
                        }
                        wssCaller.setTrustedIdentity(new QName(uri, ln));
                    } else {
                        wssCaller.setAnyTrustedIdentity(true);
                    }
                }
                if ((requiredSigningPartReference = caller.getRequiredSigningPartReference()) != null && (value = ConfigUtil.trim(requiredSigningPartReference.getReference())) != null && value.length() > 0) {
                    wssCaller.setRequiredSigningPartReference(value);
                }
                if ((jaasConfig = caller.getJAASConfig()) != null) {
                    wssJaas = new WSSJaasConfig();
                    wssJaas.setConfigName(ConfigUtil.trim(jaasConfig.getConfigName()));
                    wssJaas.setProperties(jaasConfig.getProperties());
                    wssCaller.setJaasConfig(wssJaas);
                }
                if ((callbackHandler = caller.getCallbackHandler()) != null) {
                    WSSCallbackHandler wssCallback = new WSSCallbackHandler();
                    wssCallback.setClassname(ConfigUtil.trim(callbackHandler.getClassname()));
                    wssCallback.setProperties(callbackHandler.getProperties());
                    wssCaller.setCallbackHandler(wssCallback);
                }
                this.callers.add(wssCaller);
            }
        }
        if (tokenConsumerList != null) {
            iMax = tokenConsumerList.size();
            for (i = 0; i < iMax; ++i) {
                com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.JAASConfig jaasConfig;
                com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityTokenReference pref;
                com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TokenConsumer tokenConsumer = tokenConsumerList.get(i);
                WSSToken wssTokenCon = new WSSToken();
                wssTokenCon.setName(ConfigUtil.trim(tokenConsumer.getName()));
                ValueType valueType = tokenConsumer.getValueType();
                if (valueType != null) {
                    QName qn = new QName(ConfigUtil.trim(valueType.getUri()), ConfigUtil.trim(valueType.getLocalName()));
                    wssTokenCon.setValueType(qn);
                }
                if ((pref = tokenConsumer.getSecurityTokenReference()) != null) {
                    wssTokenCon.setSecurityTokenReference(ConfigUtil.trim(pref.getReference()));
                }
                wssTokenCon.setClassname(ConfigUtil.trim(tokenConsumer.getClassname()));
                com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CallbackHandler callbackHandler = tokenConsumer.getCallbackHandler();
                if (callbackHandler != null) {
                    BasicAuth basicAuth;
                    com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CertPathSettings certPathSettings;
                    Key key;
                    WSSCallbackHandler wssCallback = new WSSCallbackHandler();
                    wssCallback.setClassname(ConfigUtil.trim(callbackHandler.getClassname()));
                    com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyStore keystore = callbackHandler.getKeyStore();
                    if (keystore != null) {
                        WSSKeyStore wssKeystore = new WSSKeyStore();
                        wssKeystore.setType(ConfigUtil.trim(keystore.getType()));
                        wssKeystore.setPath(ConfigUtil.trim(keystore.getPath()));
                        wssKeystore.setStorepass(ConfigUtil.trim(keystore.getStorepass()));
                        wssKeystore.setKeyStoreRef(ConfigUtil.trim(keystore.getKeyStoreRef()));
                        wssCallback.setKeyStore(wssKeystore);
                    }
                    if ((key = callbackHandler.getKey()) != null) {
                        WSSKey wssKey = new WSSKey();
                        wssKey.setAlias(ConfigUtil.trim(key.getAlias()));
                        wssKey.setKeypass(ConfigUtil.trim(key.getKeypass()));
                        wssKey.setName(ConfigUtil.trim(key.getName()));
                        wssCallback.setKey(wssKey);
                    }
                    if ((certPathSettings = callbackHandler.getCertPathSettings()) != null) {
                        WSSCertPathSettings wssCertPath = new WSSCertPathSettings();
                        com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TrustAnyCertificate trustAnyCertificate = certPathSettings.getTrustAnyCertificate();
                        if (trustAnyCertificate != null) {
                            wssCertPath.setTrustAnyCertificate(true);
                        } else {
                            com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TrustAnchorRef trustAnchorRef = certPathSettings.getTrustAnchorRef();
                            com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CertStoreRef certStoreRef = certPathSettings.getCertStoreRef();
                            if (trustAnchorRef != null || certStoreRef != null) {
                                if (trustAnchorRef != null) {
                                    value = ConfigUtil.trim(trustAnchorRef.getReference());
                                    wssCertPath.setTrustAnchorRef(value);
                                    for (int j = 0; j < trustAnchorList.size(); ++j) {
                                        TrustAnchor trustAnchor = trustAnchorList.get(j);
                                        WSSTrustAnchor wssTrustAnchor = new WSSTrustAnchor();
                                        wssTrustAnchor.setName(ConfigUtil.trim(trustAnchor.getName()));
                                        keystore = trustAnchor.getKeyStore();
                                        if (keystore != null) {
                                            WSSKeyStore wssKeyStore = new WSSKeyStore();
                                            wssKeyStore.setType(ConfigUtil.trim(keystore.getType()));
                                            wssKeyStore.setPath(ConfigUtil.trim(keystore.getPath()));
                                            wssKeyStore.setStorepass(ConfigUtil.trim(keystore.getStorepass()));
                                            wssKeyStore.setKeyStoreRef(ConfigUtil.trim(keystore.getKeyStoreRef()));
                                            wssTrustAnchor.setKeyStore(wssKeyStore);
                                        }
                                        this.trustAnchors.add(wssTrustAnchor);
                                    }
                                }
                                if (certStoreRef != null) {
                                    value = ConfigUtil.trim(certStoreRef.getReference());
                                    wssCertPath.setCertStoreRef(value);
                                    if (certStoreList != null) {
                                        boolean hasLDAPCertStores = false;
                                        boolean hasCollectionCertStores = false;
                                        List<Object> certStoresCollection = certStoreList.getLdapCertStoresOrCollectionCertStores();
                                        int jMax = certStoresCollection.size();
                                        if (jMax > 0) {
                                            Object certStore = certStoresCollection.get(0);
                                            if (certStore instanceof com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CollectionCertStores) {
                                                hasCollectionCertStores = true;
                                            } else if (certStore instanceof LdapCertStores) {
                                                hasLDAPCertStores = true;
                                            }
                                        }
                                        if (hasCollectionCertStores) {
                                            for (int j = 0; j < jMax; ++j) {
                                                com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CollectionCertStores collectionStore = (com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CollectionCertStores)certStoresCollection.get(j);
                                                WSSCollectionCertStores wssCollectionStore = new WSSCollectionCertStores();
                                                wssCollectionStore.setName(ConfigUtil.trim(collectionStore.getName()));
                                                wssCollectionStore.setProvider(ConfigUtil.trim(collectionStore.getProvider()));
                                                List<Object> x509andCRLs = collectionStore.getX509CertificatesOrCRL();
                                                int kMax = x509andCRLs.size();
                                                for (int k = 0; k < kMax; ++k) {
                                                    Object x509orCRL = x509andCRLs.get(k);
                                                    if (x509orCRL instanceof X509Certificates) {
                                                        X509Certificates x509 = (X509Certificates)x509orCRL;
                                                        wssCollectionStore.addX509Path(ConfigUtil.trim(x509.getPath()));
                                                        continue;
                                                    }
                                                    if (!(x509orCRL instanceof CRL)) continue;
                                                    CRL crl = (CRL)x509orCRL;
                                                    wssCollectionStore.addCRLPath(ConfigUtil.trim(crl.getPath()));
                                                }
                                                this.collectionCertStores.add(wssCollectionStore);
                                            }
                                        }
                                        if (hasLDAPCertStores) {
                                            for (int j = 0; j < jMax; ++j) {
                                                LdapCertStores ldapCertStore = (LdapCertStores)certStoresCollection.get(j);
                                                WSSLdapCertStores wssLdapStores = new WSSLdapCertStores();
                                                wssLdapStores.setName(ConfigUtil.trim(ldapCertStore.getName()));
                                                wssLdapStores.setProvider(ConfigUtil.trim(ldapCertStore.getProvider()));
                                                LdapServer ldapServer = ldapCertStore.getLdapServer();
                                                wssLdapStores.setHost(ConfigUtil.trim(ldapServer.getHost()));
                                                wssLdapStores.setPort(ConfigUtil.trim(ldapServer.getPort()));
                                                this.ldapCertStores.add(wssLdapStores);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        wssCallback.setCertPathSettings(wssCertPath);
                    }
                    if ((basicAuth = callbackHandler.getBasicAuth()) != null) {
                        WSSBasicAuth wssBasic = new WSSBasicAuth();
                        wssBasic.setUserid(ConfigUtil.trim(basicAuth.getUserid()));
                        wssBasic.setPassword(ConfigUtil.trim(basicAuth.getPassword()));
                        wssCallback.setBasicAuth(wssBasic);
                    }
                    wssCallback.setProperties(callbackHandler.getProperties());
                    wssTokenCon.setCallbackHandler(wssCallback);
                }
                if ((jaasConfig = tokenConsumer.getJAASConfig()) != null) {
                    wssJaas = new WSSJaasConfig();
                    wssJaas.setConfigName(ConfigUtil.trim(jaasConfig.getConfigName()));
                    wssJaas.setProperties(jaasConfig.getProperties());
                    wssTokenCon.setJaasConfig(wssJaas);
                }
                wssTokenCon.setProperties(tokenConsumer.getProperties());
                this.tokens.add(wssTokenCon);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(SecurityInboundBindingConfig inboundBinding)");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
        buf.append("targetNamespace=[").append(this.targetNamespace).append("], ");
        buf.append("actor=[").append(this.actor).append("], ");
        buf.append("bindingReference=[").append(this.bindingReference).append("], ");
        buf.append("collectionCertStores=[").append(this.collectionCertStores).append("], ");
        buf.append("ldapCertStores=[").append(this.ldapCertStores).append("], ");
        buf.append("encryptionInfos=[").append(this.encryptionInfos).append("], ");
        buf.append("keyInfos=[").append(this.keyInfos).append("], ");
        buf.append("signingInfos=[").append(this.signingInfos).append("], ");
        buf.append("tokens=[").append(this.tokens).append("], ");
        buf.append("callers=[").append(this.callers).append("], ");
        buf.append("trustAnchors=[").append(this.trustAnchors).append("], ");
        buf.append("properties=[").append(this.properties).append("], ");
        buf.append("explicitlyProtectSignatureConfirmation=[").append(this.explicitlyProtectSignatureConfirmation).append("], ");
        buf.append("onlySignEntireHeadersAndBody=[").append(this.onlySignEntireHeadersAndBody).append("]");
        buf.append(")");
        return buf.toString();
    }
}

