/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.VariableExpanderFactory;
import com.ibm.ws.wssecurity.config.DerivedKeyInfoConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentGeneratorConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.wssecurity.core.WSSFactory;
import com.ibm.ws.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.wssecurity.core.token.TokenGeneratorComponent;
import com.ibm.ws.wssecurity.handler.PolicyBinding;
import com.ibm.ws.wssecurity.handler.PolicyConfigUtil;
import com.ibm.ws.wssecurity.handler.PolicyInboundConfig;
import com.ibm.ws.wssecurity.handler.Protection;
import com.ibm.ws.wssecurity.handler.ProtectionOrSupportingToken;
import com.ibm.ws.wssecurity.handler.WSSBinding;
import com.ibm.ws.wssecurity.handler.WSSBindings;
import com.ibm.ws.wssecurity.handler.WSSInboundBinding;
import com.ibm.ws.wssecurity.handler.WSSOutboundBinding;
import com.ibm.ws.wssecurity.handler.WSSPolicy;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.wssecurity.platform.util.PasswordUtilFactory;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.ConfigConstants;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Duration;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3._2005._08.addressing.EndpointReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyOutboundConfig
extends PrivateGeneratorConfig {
    WSSecurityDefaultConfiguration defaultConfiguration = null;
    private Map<String, TokenGeneratorConfig> nameToken;
    Map<String, KeyInfoContentGeneratorConfig> nameKeyInfo = new HashMap<String, KeyInfoContentGeneratorConfig>();
    private Map<String, String> encryptionAlgorithms;
    private Map<String, String> keyEncryptionAlgorithms;
    private Map<String, String> asymmetricSignatureAlgorithms;
    private Map<String, String> symmetricSignatureAlgorithms;
    private Map<String, String> canonicalizationAlgorithms;
    private Map<String, String> transformAlgorithms;
    private Map<String, String> digestAlgorithms;
    private String asymmetricSignatureAlgorithm = null;
    private String symmetricSignatureAlgorithm = null;
    private String digestAlgorithm = null;
    private String transformAlgorithm = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private String canonicalizationAlgorithm = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private String encryptionAlgorithm = null;
    private String keyEncryptionAlgorithm = null;
    private WSSPolicy bootstrapPolicy = null;
    private static final TraceComponent tc = Tr.register(PolicyOutboundConfig.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = PolicyOutboundConfig.class.getName();
    private static WSSBindings securityBindings;
    private WSSBinding securityBinding = null;
    private boolean isTargetBindingUsing10NS = false;
    private boolean isDefaultBindingUsing10NS = false;
    private static boolean _avoid70BindingsNSCheck;
    private String origin = "non-ws-security";

    public PolicyOutboundConfig(WSSBindings appBindings, WSSPolicy appPolicy, boolean isRequest, ClassLoader appClassLoader, WSSecurityDefaultConfiguration defaultConfiguration) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PolicyOutboundConfig(WSSBindings appBindings, WSSPolicy appPolicy, boolean isRequest, ClassLoader appClassLoader,WSSecurityDefaultConfiguration defaultConfiguration):", new Object[]{appBindings, appPolicy, isRequest, appClassLoader, defaultConfiguration});
        }
        WSSOutboundBinding binding = null;
        if (appBindings != null) {
            securityBindings = appBindings;
            List<WSSBinding> securityBindingList = securityBindings.getSecurityBindings();
            for (int i = 0; i < securityBindingList.size(); ++i) {
                this.securityBinding = securityBindingList.get(i);
                if (!this.securityBinding.getName().equals("application")) continue;
                binding = this.securityBinding.getSecurityOutboundBindingConfig();
            }
        } else {
            if (defaultConfiguration == null) {
                throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s02");
            }
            Tr.warning(tc, "No Application Bindings found, will use Default Bindings");
        }
        this.init(binding, appPolicy, isRequest, appClassLoader, defaultConfiguration);
        this.origin = "ws-security";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "PolicyOutboundConfig(SecurityBindings appBindings, WSSPolicy appPolicy, boolean isRequest, ClassLoader appClassLoader,WSSecurityDefaultConfiguration defaultConfiguration)", new Object[]{appBindings, appPolicy, isRequest, appClassLoader});
        }
    }

    public PolicyOutboundConfig(WSSOutboundBinding binding, WSSPolicy policy, boolean isRequest, ClassLoader appClassLoader, WSSecurityDefaultConfiguration defaultConfiguration) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PolicyOutboundConfig(WSSOutboundBinding binding, WSSPolicy policy, boolean isRequest, ClassLoader appClassLoader, WSSecurityDefaultConfiguration defaultConfiguration):", new Object[]{binding, policy, isRequest, appClassLoader});
        }
        if (binding == null && defaultConfiguration == null) {
            throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s02");
        }
        this.init(binding, policy, isRequest, appClassLoader, defaultConfiguration);
        this.origin = "ws-security";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "PolicyOutboundConfig(WSSOutboundBinding binding, WSSPolicy policy, boolean isRequest, ClassLoader appClassLoader, WSSecurityDefaultConfiguration defaultConfiguration)", new Object[]{binding, policy, isRequest, appClassLoader});
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected final void init(WSSOutboundBinding binding, WSSPolicy policy, boolean isRequest, ClassLoader appClassLoader, WSSecurityDefaultConfiguration defaultConfiguration) throws SoapSecurityException {
        block492: {
            block487: {
                block488: {
                    if (PolicyOutboundConfig.tc.isEntryEnabled()) {
                        Tr.entry(PolicyOutboundConfig.tc, "init(WSSOutboundBinding binding, WSSPolicy policy, boolean isRequest, ClassLoader appClassLoader,WSSecurityDefaultConfiguration defaultConfiguration):", new Object[]{binding, policy, isRequest, appClassLoader, defaultConfiguration});
                    }
                    value = null;
                    iMax = 0;
                    jMax = 0;
                    kMax = 0;
                    position = 0;
                    aconfig = null;
                    chconfig = null;
                    econfig = null;
                    ksconfig = null;
                    kiconfig = null;
                    kigconfig = null;
                    kicgconfig = null;
                    pconfig = null;
                    rpconfig = null;
                    sconfig = null;
                    srconfig = null;
                    tsconfig = null;
                    tconfig = null;
                    encryptSignaturePartConfig = null;
                    unboundNameConfidentiality = new HashMap<K, V>();
                    unboundNameIntegrity = new HashMap<K, V>();
                    unboundNameToken = new HashMap<String, TokenGeneratorConfig>();
                    factory = WSSFactory.getInstance("soap");
                    nameConfidentiality = new HashMap<String, PrivateCommonConfig.ReferencePartConfImpl>();
                    nameIntegrity = new HashMap<String, PrivateCommonConfig.ReferencePartConfImpl>();
                    this.nameToken = new HashMap<String, TokenGeneratorConfig>();
                    type = new HashMap<Object, Object>();
                    ignoreList = new HashMap<String, ProtectionOrSupportingToken>();
                    order = new ArrayList<ReferencePartConfig>();
                    this.encryptionAlgorithms = new HashMap<String, String>();
                    this.keyEncryptionAlgorithms = new HashMap<String, String>();
                    this.asymmetricSignatureAlgorithms = new HashMap<String, String>();
                    this.symmetricSignatureAlgorithms = new HashMap<String, String>();
                    this.canonicalizationAlgorithms = new HashMap<String, String>();
                    this.transformAlgorithms = new HashMap<String, String>();
                    this.digestAlgorithms = new HashMap<String, String>();
                    signedElementsAndParts = new ArrayList<String>();
                    encryptedElementsAndParts = new ArrayList<String>();
                    aTokenAssertion = null;
                    this._initiatorTokens = new ArrayList<E>();
                    this._initiatorTokenQNames = new ArrayList<E>();
                    this._recipientTokens = new ArrayList<E>();
                    this._recipientTokenQNames = new ArrayList<E>();
                    this._initiatorSignatureTokens = new ArrayList<E>();
                    this._initiatorSignatureTokenQNames = new ArrayList<E>();
                    this._initiatorEncryptionTokens = new ArrayList<E>();
                    this._initiatorEncryptionTokenQNames = new ArrayList<E>();
                    this._recipientSignatureTokens = new ArrayList<E>();
                    this._recipientSignatureTokenQNames = new ArrayList<E>();
                    this._recipientEncryptionTokens = new ArrayList<E>();
                    this._recipientEncryptionTokenQNames = new ArrayList<E>();
                    signSignatureConfirmationSpecified = false;
                    encryptSignatureConfirmationSpecified = false;
                    this.defaultConfiguration = defaultConfiguration;
                    this._useDefault = binding == null;
                    this._request = isRequest;
                    isTargetNamespaceDraft12 = false;
                    addEncryptSignature = false;
                    isSignBeforeEncrypting = false;
                    this._timestampEnabled = false;
                    this._layout = "Lax";
                    this._policyBasedConfig = true;
                    varMap = VariableExpanderFactory.getVariableExpander();
                    this.processPrivateConfig(DOMUtils.getPrivateConfig());
                    if (this._properties == null) {
                        this._properties = new HashMap<K, V>();
                    }
                    bndParameters = null;
                    bndProperties = null;
                    if (this.securityBinding != null) {
                        sbp = this.securityBinding.getParameters();
                        if (sbp != null) {
                            bndParameters = ConfigConstants.getProperties(sbp, varMap);
                        }
                        if (bndParameters != null) {
                            this._properties.putAll(bndParameters);
                        }
                        if (binding != null) {
                            p = binding.getProperties();
                            if (p != null) {
                                bndProperties = ConfigConstants.getProperties(p, varMap);
                            }
                            if (bndProperties != null) {
                                this._properties.putAll(bndProperties);
                            }
                        }
                    }
                    if (binding != null) {
                        if ("com.ibm.xmlns.prod.websphere._200608.ws_securitybinding".equals(binding.getTargetNamespace())) {
                            this.isTargetBindingUsing10NS = true;
                        }
                        if (binding.getActor() != null) {
                            tmpActor = binding.getActor().trim();
                            if (tmpActor.length() != 0) {
                                try {
                                    new URI(tmpActor);
                                }
                                catch (URISyntaxException uriex) {
                                    throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s05", uriex);
                                }
                                this._targetActor = tmpActor;
                            }
                        } else {
                            this._targetActor = null;
                        }
                        v0 = this._onlySignEntireHeadersAndBody = binding.onlySignEntireHeadersAndBody != false || this._onlySignEntireHeadersAndBody != false;
                        if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyOutboundConfig.tc, "processed binding onlySignEntireHeadersAndBody, currently " + this._onlySignEntireHeadersAndBody);
                        }
                    }
                    if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyOutboundConfig.tc, "actorURI = " + this._myActor + ", actor = " + this._targetActor);
                    }
                    if (policy == null) break block487;
                    this._targetNamespace = policy.getTargetNamespace();
                    if (this._targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                        isTargetNamespaceDraft12 = true;
                    }
                    if (!isRequest && !isTargetNamespaceDraft12) {
                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s02", new String[]{this._targetNamespace}));
                    }
                    policyBinding = policy.getPolicyBinding();
                    if (policyBinding != null && !isTargetNamespaceDraft12 && policyBinding.isEncryptSignature()) {
                        signatureKeyword = ConfidentialDialectElementSelector.WASDIALECTS[3];
                        encryptSignaturePartConfig = new PrivateCommonConfig.PartConfImpl();
                        encryptSignaturePartConfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
                        encryptSignaturePartConfig._keyword = signatureKeyword;
                        this._encryptSignature = true;
                    }
                    children = policy.getProtectionAssertions();
                    obj = null;
                    if (children == null) break block488;
                    for (i = 0; i < children.size(); ++i) {
                        block491: {
                            block489: {
                                block490: {
                                    obj = children.get(i);
                                    if (!(obj instanceof Protection)) continue;
                                    subPolicy = obj;
                                    idReference = subPolicy.getId();
                                    retrieveAssertions = false;
                                    retrieveAssertions = this.retrieveAssertions(idReference, isRequest);
                                    if (!retrieveAssertions) continue;
                                    if (!subPolicy.isSignatureProtection()) break block489;
                                    this._signatureEnabled = true;
                                    rpconfig = new PrivateCommonConfig.ReferencePartConfImpl();
                                    rpconfig._order = 0;
                                    rpconfig._oneOfIntegralParts = true;
                                    if (subPolicy.isBody()) {
                                        pconfig = new PrivateCommonConfig.PartConfImpl();
                                        pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
                                        pconfig._keyword = "body";
                                        rpconfig._parts.add(pconfig);
                                    }
                                    if ((headers = subPolicy.getHeaders()) != null) {
                                        for (a = 0; a < headers.size(); ++a) {
                                            header = headers.get(a);
                                            pconfig = new PrivateCommonConfig.PartConfImpl();
                                            pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER;
                                            localPart = header.getLocalPart();
                                            if (localPart != null && localPart.length() > 0) {
                                                pconfig._headerName = localPart;
                                            }
                                            pconfig._headerNamespace = header.getNamespaceURI();
                                            rpconfig._parts.add(pconfig);
                                        }
                                    }
                                    if ((signedElements = subPolicy.getXPathExpressions()) == null) break block490;
                                    signedElementsXPathExpressions = new HashMap<String, String>();
                                    for (x = 0; x < signedElements.size(); ++x) {
                                        pconfig = new PrivateCommonConfig.PartConfImpl();
                                        keyword = null;
                                        xpathExpression = signedElements.get(x);
                                        keyword = PolicyConfigUtil.getKeywordForXPathExpression(xpathExpression, true);
                                        if (keyword == null) ** GOTO lbl176
                                        if (!signedElementsXPathExpressions.containsKey(keyword)) {
                                            if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                                Tr.debug(PolicyOutboundConfig.tc, "PERF: Using keyword: " + keyword);
                                            }
                                            pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
                                            pconfig._keyword = keyword;
                                            signedElementsXPathExpressions.put(keyword, xpathExpression);
                                        } else {
                                            xpathValue = (String)signedElementsXPathExpressions.get(keyword);
                                            if (xpathValue.equals(xpathExpression)) {
                                                if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                                    Tr.debug(PolicyOutboundConfig.tc, "Duplicate xpath element in signedElements will be ignored: " + xpathExpression);
                                                }
                                                Tr.warning(PolicyOutboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s09", new String[]{xpathValue});
                                                continue;
                                            }
                                            if (!PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                                            Tr.debug(PolicyOutboundConfig.tc, "xpath elements with values [" + xpathValue + "] and [" + xpathExpression + "] reference the same message part, so the message part will only be signed once.");
                                            continue;
lbl176:
                                            // 1 sources

                                            if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                                Tr.debug(PolicyOutboundConfig.tc, "PERF: Using XPath: " + xpathExpression);
                                            }
                                            pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH;
                                            pconfig._keyword = xpathExpression;
                                            if (xpathExpression.equals("/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd' and local-name()='SignatureConfirmation']") || xpathExpression.equals("/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd' and local-name()='SignatureConfirmation']")) {
                                                signSignatureConfirmationSpecified = true;
                                            }
                                        }
                                        rpconfig._parts.add(pconfig);
                                    }
                                }
                                this._integralParts.add(rpconfig);
                                if (idReference == null || idReference.length() == 0) {
                                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s21");
                                }
                                if (nameIntegrity.containsKey(idReference) && PolicyOutboundConfig.tc.isDebugEnabled()) {
                                    Tr.debug(PolicyOutboundConfig.tc, "WARNING: required integrity [" + idReference + "] is overwritten.");
                                }
                                if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                    Tr.debug(PolicyOutboundConfig.tc, "Adding required integrity: " + idReference);
                                }
                                nameIntegrity.put(idReference, rpconfig);
                                signedElementsAndParts.add(idReference);
                                continue;
                            }
                            this._encryptionEnabled = true;
                            rpconfig = new PrivateCommonConfig.ReferencePartConfImpl();
                            rpconfig._oneOfIntegralParts = true;
                            rpconfig._order = 0;
                            if (subPolicy.isBody()) {
                                pconfig = new PrivateCommonConfig.PartConfImpl();
                                pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
                                pconfig._keyword = "bodycontent";
                                rpconfig._parts.add(pconfig);
                            }
                            if ((headers = subPolicy.getHeaders()) != null) {
                                for (a = 0; a < headers.size(); ++a) {
                                    header = headers.get(a);
                                    pconfig = new PrivateCommonConfig.PartConfImpl();
                                    pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER;
                                    localPart = header.getLocalPart();
                                    if (localPart != null && localPart.length() > 0) {
                                        pconfig._headerName = localPart;
                                    }
                                    pconfig._headerNamespace = header.getNamespaceURI();
                                    rpconfig._parts.add(pconfig);
                                }
                            }
                            if ((encryptedElements = subPolicy.getXPathExpressions()) == null) break block491;
                            encryptedElementsXPathExpressions = new HashMap<String, String>();
                            if (this._encryptSignature) {
                                encryptedElementsXPathExpressions.put("signature", "/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']");
                            }
                            for (x = 0; x < encryptedElements.size(); ++x) {
                                pconfig = new PrivateCommonConfig.PartConfImpl();
                                keyword = null;
                                xpathExpression = encryptedElements.get(x);
                                keyword = PolicyConfigUtil.getKeywordForXPathExpression(xpathExpression, false);
                                if (keyword == null) ** GOTO lbl252
                                if (!encryptedElementsXPathExpressions.containsKey(keyword)) {
                                    if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                        Tr.debug(PolicyOutboundConfig.tc, "PERF: Using keyword: " + keyword);
                                    }
                                    pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
                                    pconfig._keyword = keyword;
                                    encryptedElementsXPathExpressions.put(keyword, xpathExpression);
                                    if (keyword.equals(ConfidentialDialectElementSelector.WASDIALECTS[6])) {
                                        encryptSignatureConfirmationSpecified = true;
                                    }
                                } else {
                                    xpathValue = (String)encryptedElementsXPathExpressions.get(keyword);
                                    if (xpathValue.equals(xpathExpression)) {
                                        if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                            Tr.debug(PolicyOutboundConfig.tc, "Duplicate xpath element in encryptedElements will be ignored: " + xpathExpression);
                                        }
                                        Tr.warning(PolicyOutboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s10", new String[]{xpathValue});
                                        continue;
                                    }
                                    if (!PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                                    Tr.debug(PolicyOutboundConfig.tc, "xpath elements with values [" + xpathValue + "] and [" + xpathExpression + "] reference the same message part, so the message part will only be encrypted once.");
                                    continue;
lbl252:
                                    // 1 sources

                                    if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                        Tr.debug(PolicyOutboundConfig.tc, "PERF: Using XPath: " + xpathExpression);
                                    }
                                    pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH;
                                    pconfig._keyword = xpathExpression;
                                }
                                rpconfig._parts.add(pconfig);
                            }
                        }
                        if ((contentEncryptedElements = subPolicy.getXPathExpressionsForContent()) != null) {
                            encryptedElementsXPathExpressions = new HashSet<String>();
                            for (x = 0; x < contentEncryptedElements.size(); ++x) {
                                finalxpathExpression = xpathExpression = contentEncryptedElements.get(x);
                                if (!xpathExpression.endsWith("/node()")) {
                                    finalxpathExpression = finalxpathExpression + "/node()";
                                }
                                if (!encryptedElementsXPathExpressions.contains(finalxpathExpression)) {
                                    if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                        Tr.debug(PolicyOutboundConfig.tc, "Processing ContentEncryptedElement for xpath: " + finalxpathExpression);
                                    }
                                    pconfig = new PrivateCommonConfig.PartConfImpl();
                                    pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH;
                                    pconfig._keyword = finalxpathExpression;
                                    rpconfig._parts.add(pconfig);
                                    encryptedElementsXPathExpressions.add(finalxpathExpression);
                                    continue;
                                }
                                if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                    Tr.debug(PolicyOutboundConfig.tc, "Duplicate xpath element in encryptedElements will be ignored: " + finalxpathExpression);
                                }
                                Tr.warning(PolicyOutboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s10", new String[]{finalxpathExpression});
                            }
                        }
                        this._confidentialParts.add(rpconfig);
                        if (idReference == null || idReference.length() == 0) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s21");
                        }
                        if (nameConfidentiality.containsKey(value) && PolicyOutboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyOutboundConfig.tc, "WARNING: required confidentiality [" + idReference + "] is overwritten.");
                        }
                        if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyOutboundConfig.tc, "Adding required confidentiality: " + idReference);
                        }
                        nameConfidentiality.put(idReference, rpconfig);
                        encryptedElementsAndParts.add(idReference);
                        if (addEncryptSignature || isTargetNamespaceDraft12 || !this._encryptSignature || rpconfig._parts.isEmpty()) continue;
                        addEncryptSignature = true;
                    }
                }
                if ((policyBinding = policy.getPolicyBinding()) != null) {
                    this._symmetricBinding = policyBinding.isSymmetricBinding();
                    assertions = policyBinding.getProtectionTokens();
                    for (j = 0; j < assertions.size(); ++j) {
                        potentialAssertion = assertions.get(j);
                        if (!(potentialAssertion instanceof ProtectionOrSupportingToken)) continue;
                        anAssertion = potentialAssertion;
                        assertionName = anAssertion.getName();
                        if ("InitiatorToken".equals(assertionName)) {
                            if (!this._initiatorEncryptionTokens.isEmpty()) {
                                Tr.error(PolicyOutboundConfig.tc, "security.wssecurity.PolicyInboundConfig.s08");
                                throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s08");
                            }
                            if (!this._initiatorSignatureTokens.isEmpty()) {
                                Tr.error(PolicyOutboundConfig.tc, "security.wssecurity.PolicyInboundConfig.s09");
                                throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s09");
                            }
                            aTokenAssertion = this.getTokenTypeAssertion(anAssertion);
                            if (aTokenAssertion != null) {
                                if (!this._initiatorTokenQNames.contains(aTokenAssertion._tokenType)) {
                                    this._initiatorTokens.add(aTokenAssertion);
                                    this._initiatorTokenQNames.add(aTokenAssertion._tokenType);
                                } else {
                                    Tr.error(PolicyOutboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()});
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()}));
                                }
                            }
                            if (!PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                            Tr.debug(PolicyOutboundConfig.tc, "The policy has processed the InitiatorToken");
                            continue;
                        }
                        if ("RecipientToken".equals(assertionName)) {
                            if (!this._recipientEncryptionTokens.isEmpty()) {
                                Tr.error(PolicyOutboundConfig.tc, "security.wssecurity.PolicyInboundConfig.s10");
                                throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s10");
                            }
                            if (!this._recipientSignatureTokens.isEmpty()) {
                                Tr.error(PolicyOutboundConfig.tc, "security.wssecurity.PolicyInboundConfig.s11");
                                throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s11");
                            }
                            aTokenAssertion = this.getTokenTypeAssertion(anAssertion);
                            if (aTokenAssertion != null) {
                                if (!this._recipientTokenQNames.contains(aTokenAssertion._tokenType)) {
                                    this._recipientTokens.add(aTokenAssertion);
                                    this._recipientTokenQNames.add(aTokenAssertion._tokenType);
                                } else {
                                    Tr.error(PolicyOutboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()});
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()}));
                                }
                            }
                            if (!PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                            Tr.debug(PolicyOutboundConfig.tc, "The policy has processed the RecipientToken");
                            continue;
                        }
                        if ("InitiatorSignatureToken".equals(assertionName)) {
                            if (!this._initiatorTokens.isEmpty()) {
                                Tr.error(PolicyOutboundConfig.tc, "security.wssecurity.PolicyInboundConfig.s12");
                                throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s12");
                            }
                            aTokenAssertion = this.getTokenTypeAssertion(anAssertion);
                            if (aTokenAssertion != null) {
                                if (!this._initiatorSignatureTokenQNames.contains(aTokenAssertion._tokenType)) {
                                    this._initiatorSignatureTokens.add(aTokenAssertion);
                                    this._initiatorSignatureTokenQNames.add(aTokenAssertion._tokenType);
                                } else {
                                    Tr.error(PolicyOutboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()});
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()}));
                                }
                            }
                            if (!PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                            Tr.debug(PolicyOutboundConfig.tc, "The policy has processed the InitiatorSignatureToken");
                            continue;
                        }
                        if ("RecipientSignatureToken".equals(assertionName)) {
                            if (!this._recipientTokens.isEmpty()) {
                                Tr.error(PolicyOutboundConfig.tc, "security.wssecurity.PolicyInboundConfig.s13");
                                throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s13");
                            }
                            aTokenAssertion = this.getTokenTypeAssertion(anAssertion);
                            if (aTokenAssertion != null) {
                                if (!this._recipientSignatureTokenQNames.contains(aTokenAssertion._tokenType)) {
                                    this._recipientSignatureTokens.add(aTokenAssertion);
                                    this._recipientSignatureTokenQNames.add(aTokenAssertion._tokenType);
                                } else {
                                    Tr.error(PolicyOutboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()});
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()}));
                                }
                            }
                            if (!PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                            Tr.debug(PolicyOutboundConfig.tc, "The policy has processed the RecipientSignatureToken");
                            continue;
                        }
                        if ("InitiatorEncryptionToken".equals(assertionName)) {
                            if (!this._initiatorTokens.isEmpty()) {
                                Tr.error(PolicyOutboundConfig.tc, "security.wssecurity.PolicyInboundConfig.s14");
                                throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s14");
                            }
                            aTokenAssertion = this.getTokenTypeAssertion(anAssertion);
                            if (aTokenAssertion != null) {
                                if (!this._initiatorEncryptionTokenQNames.contains(aTokenAssertion._tokenType)) {
                                    this._initiatorEncryptionTokens.add(aTokenAssertion);
                                    this._initiatorEncryptionTokenQNames.add(aTokenAssertion._tokenType);
                                } else {
                                    Tr.error(PolicyOutboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()});
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()}));
                                }
                            }
                            if (!PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                            Tr.debug(PolicyOutboundConfig.tc, "The policy has processed the InitiatorEncryptionToken");
                            continue;
                        }
                        if ("RecipientEncryptionToken".equals(assertionName)) {
                            if (!this._recipientTokens.isEmpty()) {
                                Tr.error(PolicyOutboundConfig.tc, "security.wssecurity.PolicyInboundConfig.s15");
                                throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s15");
                            }
                            aTokenAssertion = this.getTokenTypeAssertion(anAssertion);
                            if (aTokenAssertion != null) {
                                if (!this._recipientEncryptionTokenQNames.contains(aTokenAssertion._tokenType)) {
                                    this._recipientEncryptionTokens.add(aTokenAssertion);
                                    this._recipientEncryptionTokenQNames.add(aTokenAssertion._tokenType);
                                } else {
                                    Tr.error(PolicyOutboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()});
                                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()}));
                                }
                            }
                            if (!PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                            Tr.debug(PolicyOutboundConfig.tc, "The policy has processed the RecipientEncryptionToken");
                            continue;
                        }
                        if ("EncryptionToken".equals(assertionName)) {
                            if (this._symmetricProtectionTokenAssertion != null) {
                                Tr.error(PolicyOutboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s11");
                                throw new SoapSecurityException("security.wssecurity.PolicyInOutboundConfig.s11");
                            }
                            this._symmetricEncryptionTokenAssertion = this.getTokenTypeAssertion(anAssertion);
                            if (!PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                            Tr.debug(PolicyOutboundConfig.tc, "The policy has processed the EncryptionToken");
                            continue;
                        }
                        if ("SignatureToken".equals(assertionName)) {
                            if (this._symmetricProtectionTokenAssertion != null) {
                                Tr.error(PolicyOutboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s12");
                                throw new SoapSecurityException("security.wssecurity.PolicyInOutboundConfig.s12");
                            }
                            this._symmetricSignatureTokenAssertion = this.getTokenTypeAssertion(anAssertion);
                            if (!PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                            Tr.debug(PolicyOutboundConfig.tc, "The policy has processed the SignatureToken");
                            continue;
                        }
                        if (!"ProtectionToken".equals(assertionName)) continue;
                        if (this._symmetricEncryptionTokenAssertion != null || this._symmetricSignatureTokenAssertion != null) {
                            Tr.error(PolicyOutboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s13");
                            throw new SoapSecurityException("security.wssecurity.PolicyInOutboundConfig.s13");
                        }
                        this._symmetricProtectionTokenAssertion = this.getTokenTypeAssertion(anAssertion);
                        if (!PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyOutboundConfig.tc, "The policy has processed the ProtectionToken");
                    }
                    layout = policyBinding.getLayout();
                    if (layout != null) {
                        this._layout = this.layoutAssertion(layout);
                        if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyOutboundConfig.tc, "The policy has processed the Layout");
                        }
                    }
                    algorithmSuiteAssertions = policyBinding.getAlgorithmSuites();
                    for (j = 0; j < algorithmSuiteAssertions.size(); ++j) {
                        potentialAssertion = algorithmSuiteAssertions.get(j);
                        if (potentialAssertion instanceof String) {
                            this.algorithmSuiteAssertion(potentialAssertion);
                        }
                        if (!PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyOutboundConfig.tc, "The policy has processed the AlgorithmSuite");
                    }
                    if (policyBinding.isIncludeTimestamp()) {
                        this._timestampEnabled = true;
                        if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyOutboundConfig.tc, "The policy has processed the IncludeTimestamp");
                        }
                    }
                    v1 = this._onlySignEntireHeadersAndBody = this._onlySignEntireHeadersAndBody != false || policyBinding.isOnlySignEntireHeadersAndBody() != false;
                    if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyOutboundConfig.tc, "processed policy binding onlySignEntireHeadersAndBody, currently " + this._onlySignEntireHeadersAndBody);
                    }
                }
                children = policy.getSupportingTokens();
                obj = null;
                if (children != null) {
                    for (i = 0; i < children.size(); ++i) {
                        obj = children.get(i);
                        if (!(obj instanceof ProtectionOrSupportingToken)) continue;
                        supportingTokenPolicy = (ProtectionOrSupportingToken)obj;
                        idReference = supportingTokenPolicy.getName();
                        retrieveAssertions = false;
                        retrieveAssertions = this.retrieveAssertions(idReference, isRequest);
                        if (!retrieveAssertions) continue;
                        this._tokenEnabled = true;
                        tconfig = new PrivateGeneratorConfig.TokenGeneratorConfImpl();
                        tconfig._standAlone = true;
                        aTokenAssertion = this.getTokenTypeAssertion(supportingTokenPolicy);
                        if (aTokenAssertion != null) {
                            tconfig._type = aTokenAssertion._tokenType;
                            tconfig._aTokenAssertion = aTokenAssertion;
                        }
                        this._securityTokens.add(tconfig);
                        if (idReference == null || idReference.length() == 0) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s23");
                        }
                        if (this.nameToken.containsKey(idReference) && PolicyOutboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyOutboundConfig.tc, "WARNING: required security token [" + idReference + "] is overwritten.");
                        }
                        if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyOutboundConfig.tc, "Adding required security token: " + idReference);
                        }
                        this.nameToken.put(idReference, tconfig);
                    }
                }
                children = policy.getWss10Assertions();
                obj = null;
                if (children != null) {
                    for (i = 0; i < children.size(); ++i) {
                        obj = children.get(i);
                        if (!(obj instanceof String)) continue;
                        assertionName = (String)obj;
                        if ("MustSupportRefKeyIdentifier".equals(assertionName)) {
                            if (isTargetNamespaceDraft12 || !PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                            Tr.debug(PolicyOutboundConfig.tc, "The policy has processed the MustSupportRefKeyIdentifier");
                            continue;
                        }
                        if ("MustSupportRefIssuerSerial".equals(assertionName)) {
                            if (isTargetNamespaceDraft12 || !PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                            Tr.debug(PolicyOutboundConfig.tc, "The policy has processed the MustSupportRefIssuerSerial");
                            continue;
                        }
                        if ("MustSupportRefExternalURI".equals(assertionName)) {
                            if (isTargetNamespaceDraft12 || !PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                            Tr.debug(PolicyOutboundConfig.tc, "The policy has processed the MustSupportRefExternalURI");
                            continue;
                        }
                        if ("MustSupportRefEmbeddedToken".equals(assertionName)) {
                            if (isTargetNamespaceDraft12 || !PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                            Tr.debug(PolicyOutboundConfig.tc, "The policy has processed the MustSupportRefEmbeddedToken");
                            continue;
                        }
                        if ("MustSupportRefEncryptedKey".equals(assertionName)) {
                            if (isTargetNamespaceDraft12) continue;
                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s03", new String[]{assertionName}));
                        }
                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s18", new String[]{assertionName}));
                    }
                }
                children = policy.getWss11Assertions();
                obj = null;
                if (children != null) {
                    for (i = 0; i < children.size(); ++i) {
                        obj = children.get(i);
                        if (!(obj instanceof String)) continue;
                        assertionName = (String)obj;
                        if ("RequireSignatureConfirmation".equals(assertionName)) {
                            this._signatureConfirmationRequired = true;
                            if (!PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                            Tr.debug(PolicyOutboundConfig.tc, "The policy has processed RequireSignatureConfirmation");
                            continue;
                        }
                        if ("MustSupportRefKeyIdentifier".equals(assertionName)) {
                            if (isTargetNamespaceDraft12 || !PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                            Tr.debug(PolicyOutboundConfig.tc, "The policy has processed the MustSupportRefKeyIdentifier");
                            continue;
                        }
                        if ("MustSupportRefIssuerSerial".equals(assertionName)) {
                            if (isTargetNamespaceDraft12 || !PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                            Tr.debug(PolicyOutboundConfig.tc, "The policy has processed the MustSupportRefIssuerSerial");
                            continue;
                        }
                        if ("MustSupportRefExternalURI".equals(assertionName)) {
                            if (isTargetNamespaceDraft12 || !PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                            Tr.debug(PolicyOutboundConfig.tc, "The policy has processed the MustSupportRefExternalURI");
                            continue;
                        }
                        if ("MustSupportRefEmbeddedToken".equals(assertionName)) {
                            if (isTargetNamespaceDraft12 || !PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                            Tr.debug(PolicyOutboundConfig.tc, "The policy has processed the MustSupportRefEmbeddedToken");
                            continue;
                        }
                        if ("MustSupportRefThumbprint".equals(assertionName)) {
                            if (isTargetNamespaceDraft12 || !PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                            Tr.debug(PolicyOutboundConfig.tc, "The policy has processed the MustSupportRefThumbprint");
                            continue;
                        }
                        if ("MustSupportRefEncryptedKey".equals(assertionName)) {
                            if (isTargetNamespaceDraft12) continue;
                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s04", new String[]{assertionName}));
                        }
                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s19", new String[]{assertionName}));
                    }
                }
                children = policy.getTrust10Assertions();
                obj = null;
                if (children != null) {
                    for (i = 0; i < children.size(); ++i) {
                        obj = children.get(i);
                        if (!(obj instanceof String) || "MustSupportClientChallenge".equals(assertionName = (String)obj) || "MustSupportServerChallenge".equals(assertionName) || "MustSupportRefExternalURI".equals(assertionName) || "RequireClientEntropy".equals(assertionName) || "RequireServerEntropy".equals(assertionName) || "MustSupportIssuedTokens".equals(assertionName)) continue;
                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s20", new String[]{assertionName}));
                    }
                }
                children = policy.getTrust13Assertions();
                obj = null;
                if (children != null) {
                    for (i = 0; i < children.size(); ++i) {
                        obj = children.get(i);
                        if (!(obj instanceof String)) continue;
                        assertionName = (String)obj;
                        if ("MustSupportClientChallenge".equals(assertionName)) {
                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s14", new String[]{assertionName}));
                        }
                        if ("MustSupportServerChallenge".equals(assertionName)) {
                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s14", new String[]{assertionName}));
                        }
                        if ("RequireClientEntropy".equals(assertionName) || "RequireServerEntropy".equals(assertionName)) continue;
                        if ("MustSupportIssuedTokens".equals(assertionName)) {
                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s14", new String[]{assertionName}));
                        }
                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s14", new String[]{assertionName}));
                    }
                }
                for (x = 0; x < encryptedElementsAndParts.size(); ++x) {
                    part = (String)encryptedElementsAndParts.get(x);
                    this.encryptionAlgorithms.put(part, this.encryptionAlgorithm);
                    this.keyEncryptionAlgorithms.put(part, this.keyEncryptionAlgorithm);
                    this.digestAlgorithms.put(part, this.digestAlgorithm);
                    this.transformAlgorithms.put(part, this.transformAlgorithm);
                    this.canonicalizationAlgorithms.put(part, this.canonicalizationAlgorithm);
                }
                for (x = 0; x < signedElementsAndParts.size(); ++x) {
                    part = (String)signedElementsAndParts.get(x);
                    if (this._symmetricBinding) {
                        this.symmetricSignatureAlgorithms.put(part, this.symmetricSignatureAlgorithm);
                    } else {
                        this.asymmetricSignatureAlgorithms.put(part, this.asymmetricSignatureAlgorithm);
                    }
                    this.digestAlgorithms.put(part, this.digestAlgorithm);
                    this.transformAlgorithms.put(part, this.transformAlgorithm);
                    this.canonicalizationAlgorithms.put(part, this.canonicalizationAlgorithm);
                }
            }
            if (this._timestampEnabled) {
                tsconfig = new PrivateGeneratorConfig.TimestampGeneratorConfImpl();
                tsconfig._myActor = this._myActor != null ? this._myActor : null;
                tsconfig._targetActor = this._targetActor != null ? this._targetActor : null;
                if (this._layout.equals("LaxTsFirst")) {
                    tsconfig._properties.put(Constants.WSSECURITY_TIMESTAMP_DIALECT, com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS);
                    tsconfig._properties.put(Constants.WSSECURITY_TIMESTAMP_KEYWORD, "SecurityFirst");
                }
                if (this._layout.equals("LaxTsLast")) {
                    tsconfig._properties.put(Constants.WSSECURITY_TIMESTAMP_DIALECT, com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS);
                    tsconfig._properties.put(Constants.WSSECURITY_TIMESTAMP_KEYWORD, "SecurityLast");
                }
                if (binding != null && (value = binding.getTimestampExpires()) != null) {
                    try {
                        len = value.length();
                        valueIsInt = true;
                        for (i = 0; i < len; ++i) {
                            ch = value.charAt(i);
                            if (ch >= '0' && '9' >= ch) continue;
                            valueIsInt = false;
                        }
                        ch = Character.valueOf(value.charAt(0));
                        if (!ch.equals(Character.valueOf('P')) && !ch.equals(Character.valueOf('-'))) {
                            if (!valueIsInt) {
                                if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                    Tr.debug(PolicyOutboundConfig.tc, "The value of the first character in the expires string is" + value.charAt(0));
                                }
                                errMsg = "security.wssecurity.PrivateGeneratorConfig.s24";
                                throw SoapSecurityException.format(errMsg, value);
                            }
                            value = "PT" + value + "M";
                        }
                        tsconfig._duration = Duration.parse(value);
                    }
                    catch (ParseException pe) {
                        msgKey = "security.wssecurity.PrivateGeneratorConfig.s24";
                        FFDCFilter.processException((Throwable)pe, PolicyOutboundConfig.clsName + ".PolicyOutboundConfig", "523", this);
                        Tr.error(PolicyOutboundConfig.tc, msgKey, value);
                        throw SoapSecurityException.format(msgKey, value, (Throwable)pe);
                    }
                }
                if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyOutboundConfig.tc, "Adding timestamp: " + this._timestampEnabled);
                }
                this._timestampGenerator = tsconfig;
            }
            try {
                this._nonceManager = (NonceManager)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws SoapSecurityException {
                        return NonceManagerFactory.getInstance();
                    }
                });
            }
            catch (PrivilegedActionException pac) {
                th = pac.getCause();
                if (th instanceof SoapSecurityException) {
                    throw (SoapSecurityException)th;
                }
                throw new SoapSecurityException(th.getMessage());
            }
            if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyOutboundConfig.tc, "NonceManager = " + this._nonceManager);
            }
            if (defaultConfiguration != null && (hwConfigName = defaultConfiguration.getHardwareConfigName()) != null && hwConfigName.length() != 0) {
                this._properties.put("HWCONFIG", hwConfigName);
                if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyOutboundConfig.tc, "Hardware Acceleration is Enabled " + hwConfigName);
                }
                this._properties.put("com.ibm.ws.wssecurity.handler.OffloadAllCryptography", defaultConfiguration.getUseOffloadAllCrypto());
                if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyOutboundConfig.tc, "Hardware Acceleration is Enabled :" + hwConfigName + ", OFFLOAD_ALL_CRYPTO is: " + defaultConfiguration.getUseOffloadAllCrypto());
                }
                this._properties.put("com.ibm.ws.wssecurity.handler.hardwareCacheSize", new Integer(defaultConfiguration.getHardwareCacheSize()));
                if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyOutboundConfig.tc, "Hardware cache size = " + defaultConfiguration.getHardwareCacheSize());
                }
                this._properties.put("com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography", new Boolean(defaultConfiguration.getOffloadRSAPublicKeyCrypto()));
                if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyOutboundConfig.tc, "Offload RSA Public Key crypto = " + defaultConfiguration.getOffloadRSAPublicKeyCrypto());
                }
            }
            if (!this._useDefault && (gref = binding.getBindingReference()) != null && "DEFAULT".equals(gref)) {
                this._useDefault = true;
            }
            if (this._useDefault) {
                if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyOutboundConfig.tc, "Using default binding...");
                }
                if (defaultConfiguration == null) {
                    Tr.warning(PolicyOutboundConfig.tc, "security.wssecurity.PrivateGeneratorConfig.s25");
                } else {
                    dgconfig = defaultConfiguration.getDefaultGeneratorBinding();
                    if (dgconfig != null) {
                        this.initDefaultConfig(dgconfig, order, isRequest, isTargetNamespaceDraft12, policy, encryptSignaturePartConfig, addEncryptSignature, signSignatureConfirmationSpecified, encryptSignatureConfirmationSpecified);
                    } else {
                        if (defaultConfiguration.getDefaultBindingsLoadingException() != null) {
                            se = defaultConfiguration.getDefaultBindingsLoadingException();
                            throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s33", se.toString());
                        }
                        se = SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s03");
                        throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s33", se.toString());
                    }
                }
                this.mapPolicyAssertionsToProperties(isTargetNamespaceDraft12, isRequest);
                this.validate(true, this.nameToken);
                if (PolicyOutboundConfig.tc.isEntryEnabled()) {
                    Tr.exit(PolicyOutboundConfig.tc, "init(SecurityOutboundBindingConfig binding, Policy policy, String actorURI, boolean isRequest, ClassLoader appClassLoader)");
                }
                return;
            }
            collectionCertStores = binding.getCollectionCertStores();
            encryptionInfos = binding.getEncryptionInfos();
            keyInfos = binding.getKeyInfos();
            signingInfos = binding.getSigningInfos();
            tokenGenerators = binding.getTokens();
            timestampAndNonceParts = new ArrayList<PrivateCommonConfig.PartConfImpl>();
            if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                bndparam = bndParameters == null ? "null" : bndParameters.toString();
                bndprop = bndProperties == null ? "null" : bndProperties.toString();
                Tr.debug(PolicyOutboundConfig.tc, "Policy Outbound Binding (SigningInfos, EncryptionInfos, KeyInfos, TokenGenerators, Parameters, Property):", new Object[]{signingInfos, encryptionInfos, keyInfos, tokenGenerators, bndparam, bndprop});
            }
            if (!isRequest) {
                disableImplicitProtectionForSignatureConfirmation = false;
                if (binding.isExplicitlyProtectSignatureConfirmation()) {
                    if (this.isTargetBindingUsing10NS && !PolicyOutboundConfig._avoid70BindingsNSCheck) {
                        throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s42", "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding", "ExplicitlyProtectSignatureConfirmation");
                    }
                    disableImplicitProtectionForSignatureConfirmation = true;
                }
                if (this._signatureConfirmationRequired && !this.isTargetBindingUsing10NS && !disableImplicitProtectionForSignatureConfirmation) {
                    if (!signSignatureConfirmationSpecified) {
                        if (signedElementsAndParts.size() > 0) {
                            idRef = (String)signedElementsAndParts.get(0);
                            rpconfig = (PrivateCommonConfig.ReferencePartConfImpl)nameIntegrity.get(idRef);
                            pconfig = new PrivateCommonConfig.PartConfImpl();
                            pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
                            pconfig._keyword = IntegralDialectElementSelector.WASDIALECTS[14];
                            rpconfig._parts.add(pconfig);
                            if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyOutboundConfig.tc, "Adding SignatureConfirmation to required integrity:" + idRef);
                            }
                        } else {
                            if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyOutboundConfig.tc, "Cannot sign SignatureConfirmation element since nothing else on the message is signed");
                            }
                            Tr.warning(PolicyOutboundConfig.tc, ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s23"));
                        }
                    }
                    if (!encryptSignatureConfirmationSpecified) {
                        if (encryptedElementsAndParts.size() > 0) {
                            idRef = (String)encryptedElementsAndParts.get(0);
                            rpconfig = (PrivateCommonConfig.ReferencePartConfImpl)nameConfidentiality.get(idRef);
                            pconfig = new PrivateCommonConfig.PartConfImpl();
                            pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
                            pconfig._keyword = ConfidentialDialectElementSelector.WASDIALECTS[6];
                            rpconfig._parts.add(pconfig);
                            if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyOutboundConfig.tc, "Adding SignatureConfirmation to required confidentiality: " + idRef);
                            }
                        } else {
                            if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyOutboundConfig.tc, "Cannot encrypt SignatureConfirmation element since nothing else on the message is encrypted");
                            }
                            Tr.warning(PolicyOutboundConfig.tc, ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s22"));
                        }
                    }
                }
            }
            this._clientSetMustUnderstand = ConfigUtil.getIsFalseProperty(this._properties, Constants.WSSECURITY_SET_MUSTUNDERSTAND);
            alwaysTrue = ConfigUtil.getIsTrueProperty(this._properties, Constants.WSSECURITY_GET_MUSTUNDERSTAND);
            v2 = this._serviceGetMustUnderstand = alwaysTrue == false;
            if (encryptionInfos != null) {
                iMax = encryptionInfos.size();
                for (i = 0; i < iMax; ++i) {
                    encryptionInfo = encryptionInfos.get(i);
                    encryptioninfoPropsList = encryptionInfo.getProperties();
                    encryptionInfoProperties = ConfigConstants.getProperties(encryptioninfoPropsList, varMap);
                    this._properties.putAll(encryptionInfoProperties);
                    orderField = encryptionInfo.getOrder();
                    pref = encryptionInfo.getEncryptionPartReference();
                    if (pref == null || (value = pref.getReference()) == null || value.length() <= 0) continue;
                    aConfig = (PrivateCommonConfig.ReferencePartConfImpl)nameConfidentiality.get(value);
                    if (aConfig == null) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                    }
                    if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyOutboundConfig.tc, "Got the part reference: " + value);
                    }
                    aConfig._order = orderField != null ? Integer.parseInt(orderField) : 0;
                    if (isTargetNamespaceDraft12) {
                        processed = false;
                        it = order.iterator();
                        a = 0;
                        while (it.hasNext()) {
                            if (aConfig._order < ((PrivateCommonConfig.ReferencePartConfImpl)it.next())._order) {
                                processed = true;
                                order.add(a, aConfig);
                                break;
                            }
                            ++a;
                        }
                        if (!processed) {
                            order.add(aConfig);
                        }
                    } else {
                        policyBinding = policy.getPolicyBinding();
                        isSignBeforeEncrypting = policyBinding.isSignBeforeEncrypting();
                        if (isSignBeforeEncrypting) {
                            order.add(aConfig);
                        } else {
                            order.add(0, aConfig);
                        }
                    }
                    if (pref.isIncludeTimestamp()) {
                        partsList = aConfig.getParts();
                        for (PrivateCommonConfig.PartConfImpl aPart : partsList) {
                            timestampPartConfig = new PrivateCommonConfig.PartConfImpl();
                            timestampPartConfig.copyAttributesForTimestamp(aPart);
                            timestampAndNonceParts.add(timestampPartConfig);
                        }
                    }
                    if (pref.isIncludeNonce()) {
                        partsList = aConfig.getParts();
                        for (PrivateCommonConfig.PartConfImpl aPart : partsList) {
                            noncePartConfig = new PrivateCommonConfig.PartConfImpl();
                            noncePartConfig.copyAttributesForNonce(aPart);
                            timestampAndNonceParts.add(noncePartConfig);
                        }
                    }
                    for (b = 0; b < timestampAndNonceParts.size(); ++b) {
                        aConfig._parts.add((ReferencePartConfig.PartConfig)timestampAndNonceParts.get(b));
                    }
                    timestampAndNonceParts.clear();
                }
            }
            if (signingInfos != null) {
                iMax = signingInfos.size();
                for (i = 0; i < iMax; ++i) {
                    signingInfo = signingInfos.get(i);
                    signinfoPropsList = signingInfo.getProperties();
                    signingInfoProperties = ConfigConstants.getProperties(signinfoPropsList, varMap);
                    this._properties.putAll(signingInfoProperties);
                    orderField = signingInfo.getOrder();
                    prefs = signingInfo.getSigningPartReferences();
                    if (prefs == null) continue;
                    jMax = prefs.size();
                    for (j = 0; j < jMax; ++j) {
                        pref = prefs.get(j);
                        value = pref.getReference();
                        if (value == null || value.length() <= 0) continue;
                        aConfig = (PrivateCommonConfig.ReferencePartConfImpl)nameIntegrity.get(value);
                        if (aConfig == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                        }
                        if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyOutboundConfig.tc, "Got the part reference: " + value);
                        }
                        aConfig._order = orderField != null ? Integer.parseInt(orderField) : 0;
                        if (isTargetNamespaceDraft12) {
                            processed = false;
                            it = order.iterator();
                            a = 0;
                            while (it.hasNext()) {
                                if (aConfig._order < ((PrivateCommonConfig.ReferencePartConfImpl)it.next())._order) {
                                    processed = true;
                                    order.add(a, aConfig);
                                    break;
                                }
                                ++a;
                            }
                            if (!processed) {
                                order.add(aConfig);
                            }
                        } else {
                            policyBinding = policy.getPolicyBinding();
                            if (policyBinding.isSignBeforeEncrypting()) {
                                order.add(0, aConfig);
                            } else {
                                order.add(aConfig);
                            }
                        }
                        if (pref.isIncludeTimestamp()) {
                            partsList = aConfig.getParts();
                            for (PrivateCommonConfig.PartConfImpl aPart : partsList) {
                                timestampPartConfig = new PrivateCommonConfig.PartConfImpl();
                                timestampPartConfig.copyAttributesForTimestamp(aPart);
                                timestampAndNonceParts.add(timestampPartConfig);
                            }
                        }
                        if (pref.isIncludeNonce()) {
                            partsList = aConfig.getParts();
                            for (PrivateCommonConfig.PartConfImpl aPart : partsList) {
                                noncePartConfig = new PrivateCommonConfig.PartConfImpl();
                                noncePartConfig.copyAttributesForNonce(aPart);
                                timestampAndNonceParts.add(noncePartConfig);
                            }
                        }
                        for (b = 0; b < timestampAndNonceParts.size(); ++b) {
                            aConfig._parts.add((ReferencePartConfig.PartConfig)timestampAndNonceParts.get(b));
                        }
                        timestampAndNonceParts.clear();
                    }
                }
            }
            if (!isTargetNamespaceDraft12) {
                callerTokensList = policy.getCallerExactlyOneTokens();
                iMax = callerTokensList.size();
                matchIndex = 0;
                foundMatch = false;
                for (i = 0; i < iMax && !foundMatch; ++i) {
                    callerMap = callerTokensList.get(i);
                    callerMapSize = callerMap.size();
                    matchesFound = 0;
                    iterator = callerMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        foundTokenMatch = false;
                        aKey = iterator.next();
                        if (tokenGenerators != null) {
                            iterator2 = tokenGenerators.iterator();
                            while (iterator2.hasNext() && !foundTokenMatch) {
                                tokenGenerator = iterator2.next();
                                pref = tokenGenerator.getSecurityTokenReference();
                                if (!aKey.equals(pref)) continue;
                                foundTokenMatch = true;
                                if (++matchesFound != callerMapSize) continue;
                                foundMatch = true;
                                matchIndex = i;
                            }
                        }
                        if (foundTokenMatch || defaultConfiguration == null) continue;
                        dgconfig = defaultConfiguration.getDefaultGeneratorBinding();
                        if (dgconfig == null) {
                            if (defaultConfiguration.getDefaultBindingsLoadingException() != null) {
                                se = defaultConfiguration.getDefaultBindingsLoadingException();
                                throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s32", se.toString());
                            }
                            se = SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s03", value);
                            throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s32", se.toString());
                        }
                        set = dgconfig.getTokenGenerators();
                        iterator3 = set.iterator();
                        aToken = callerMap.get(aKey);
                        tokenType = null;
                        aTokenAssertion = this.getTokenTypeAssertion(aToken);
                        if (aTokenAssertion != null) {
                            tokenType = aTokenAssertion.getTokenType();
                        }
                        while (iterator3.hasNext() && !foundTokenMatch) {
                            tconfig2 = new PrivateGeneratorConfig.TokenGeneratorConfImpl((PrivateGeneratorConfig.TokenGeneratorConfImpl)iterator3.next());
                            tconfigType = tconfig2.getType();
                            if (tokenType == null || !tconfigType.equals(tokenType) || aTokenAssertion == null) continue;
                            if (tconfig2._type.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN) || tconfig2._type.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11)) {
                                if (tconfig2._callbackHandler != null) {
                                    idAssertion = (String)tconfig2._callbackHandler._properties.get(Constants.WSSECURITY_USE_IDASSERTION);
                                    if (idAssertion != null) {
                                        if (idAssertion.equals("true") && !aTokenAssertion._requirePassword) {
                                            ++matchesFound;
                                            foundTokenMatch = true;
                                        } else if (!idAssertion.equals("true") && aTokenAssertion._requirePassword) {
                                            ++matchesFound;
                                            foundTokenMatch = true;
                                        }
                                    } else if (aTokenAssertion._requirePassword) {
                                        ++matchesFound;
                                        foundTokenMatch = true;
                                    }
                                }
                            } else {
                                ++matchesFound;
                                foundTokenMatch = true;
                            }
                            if (matchesFound != callerMapSize) continue;
                            foundMatch = true;
                            matchIndex = i;
                        }
                    }
                }
                if (foundMatch) {
                    callerMap = callerTokensList.get(matchIndex);
                    for (String idReference : callerMap.keySet()) {
                        supportingTokenPolicy = callerMap.get(idReference);
                        retrieveAssertions = false;
                        retrieveAssertions = this.retrieveAssertions(idReference, isRequest);
                        if (!retrieveAssertions) continue;
                        this._tokenEnabled = true;
                        tconfig = new PrivateGeneratorConfig.TokenGeneratorConfImpl();
                        tconfig._standAlone = true;
                        aTokenAssertion = this.getTokenTypeAssertion(supportingTokenPolicy);
                        if (aTokenAssertion != null) {
                            tconfig._type = aTokenAssertion._tokenType;
                            tconfig._aTokenAssertion = aTokenAssertion;
                        }
                        this._securityTokens.add(tconfig);
                        if (idReference == null || idReference.length() == 0) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s23");
                        }
                        if (this.nameToken.containsKey(idReference) && PolicyOutboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyOutboundConfig.tc, "WARNING: required security token [" + idReference + "] is overwritten.");
                        }
                        if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyOutboundConfig.tc, "Adding required security token: " + idReference);
                        }
                        this.nameToken.put(idReference, tconfig);
                    }
                    callerTokensList.remove(matchIndex);
                }
                for (HashMap<String, ProtectionOrSupportingToken> callerMap : callerTokensList) {
                    ignoreList.putAll(callerMap);
                }
            }
            supportingTokens = new HashMap<String, TokenGeneratorConfig>(this.nameToken);
            unboundNameToken.putAll(supportingTokens);
            if (tokenGenerators != null) {
                reference = null;
                iMax = tokenGenerators.size();
                for (i = 0; i < iMax; ++i) {
                    tokenGenerator = tokenGenerators.get(i);
                    qn = tokenGenerator.getValueType();
                    if (qn == null) {
                        throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s15", tokenGenerator.getName());
                    }
                    if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(qn.getLocalPart())) {
                        if (this.isTargetBindingUsing10NS && !PolicyOutboundConfig._avoid70BindingsNSCheck) {
                            throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s42", "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding", qn.getLocalPart());
                        }
                        if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyOutboundConfig.tc, "Token Value Type from Config is different from the policy");
                        }
                        if (this._symmetricProtectionTokenAssertion != null) {
                            this._symmetricProtectionTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                        } else {
                            if (this._symmetricSignatureTokenAssertion != null) {
                                this._symmetricSignatureTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                            }
                            if (this._symmetricEncryptionTokenAssertion != null) {
                                this._symmetricEncryptionTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                            }
                        }
                    }
                    ignoreToken = false;
                    pref = tokenGenerator.getSecurityTokenReference();
                    tconfig = null;
                    reference = null;
                    if (pref != null && (reference = pref) != null && reference.length() > 0) {
                        tconfig = (PrivateGeneratorConfig.TokenGeneratorConfImpl)supportingTokens.get(reference);
                        if (tconfig == null) {
                            anAssertion = (ProtectionOrSupportingToken)ignoreList.get(reference);
                            if (anAssertion == null) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", reference);
                            }
                            ignoreToken = true;
                        } else if (!tconfig.getType().equals(qn)) {
                            if (com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.equals(qn) && com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN.equals(tconfig.getType())) {
                                if (this.isTargetBindingUsing10NS && !PolicyOutboundConfig._avoid70BindingsNSCheck) {
                                    throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s42", "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding", qn.getLocalPart());
                                }
                                if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                    Tr.debug(PolicyOutboundConfig.tc, "LTPA Token Value Type from Config is different from the policy");
                                }
                                tconfig._type = qn = com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN;
                            } else {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s16", new String[]{tconfig.getType().toString(), qn.toString()}));
                            }
                        }
                        if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyOutboundConfig.tc, "Got the part reference: " + reference);
                        }
                    }
                    if (ignoreToken) continue;
                    if (tconfig == null) {
                        tconfig = new PrivateGeneratorConfig.TokenGeneratorConfImpl();
                        tconfig._type = qn;
                    }
                    tconfig._className = tokenGenerator.getClassname();
                    if (!this._defaultTokenGenerators.contains(tconfig._className)) {
                        this._userDefinedComponentsUsed = true;
                        tconfig._userDefinedComponentsUsed = true;
                    }
                    if ((callbackHandler = tokenGenerator.getCallbackHandler()) != null) {
                        chconfig = new PrivateCommonConfig.CallbackHandlerConfImpl();
                        chconfig._className = callbackHandler.getClassname();
                        if (!this._defaultCallbackHandlers.contains(chconfig._className)) {
                            this._userDefinedComponentsUsed = true;
                            tconfig._userDefinedComponentsUsed = true;
                        }
                        if ((keystore = callbackHandler.getKeyStore()) != null) {
                            ksconfig = new PrivateCommonConfig.KeyStoreConfImpl();
                            ksconfig._type = keystore.getType();
                            ksconfig._path = varMap.expand(keystore.getPath());
                            ksconfig._password = PasswordUtilFactory.getInstance().passwordDecode(keystore.getStorepass());
                            ksconfig._ksRef = keystore.getKeyStoreRef();
                            chconfig._keyStore = ksconfig;
                            if (ksconfig._ksRef != null && ksconfig._ksRef.length() != 0) {
                                tconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", ksconfig._ksRef);
                            }
                        }
                        if ((key = callbackHandler.getKey()) != null) {
                            kiconfig = new PrivateCommonConfig.KeyInformationConfImpl();
                            kiconfig._alias = key.getAlias();
                            kiconfig._keypass = PasswordUtilFactory.getInstance().passwordDecode(key.getKeypass());
                            kiconfig._name = key.getName();
                            chconfig._keyInformation = kiconfig;
                        }
                        if ((certPathSettings = callbackHandler.getCertPathSettings()) != null && (certStoreRef = certPathSettings.getCertStoreRef()) != null) {
                            certStores = new ArrayList<CertStore>();
                            provider = null;
                            value = certStoreRef;
                            if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyOutboundConfig.tc, "CertStoreRef = " + value);
                            }
                            if (collectionCertStores != null && (jMax = collectionCertStores.size()) > 0) {
                                for (j = 0; j < jMax; ++j) {
                                    collectionStore = collectionCertStores.get(j);
                                    if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                        Tr.debug(PolicyOutboundConfig.tc, "collectionCertStore.get(" + j + ") = " + collectionStore.getName());
                                    }
                                    if (value == null || !value.equals(collectionStore.getName())) continue;
                                    provider = Security.getProvider(collectionStore.getProvider());
                                    cache = new HashMap<String, CertificateFactory>();
                                    eeCerts = new HashSet<X509Extension>();
                                    x509Paths = collectionStore.getX509Paths();
                                    kMax = x509Paths.size();
                                    if (kMax > 0) {
                                        for (k = 0; k < kMax; ++k) {
                                            x509Path = x509Paths.get(k);
                                            path = null;
                                            path = varMap.expand(x509Path);
                                            provider2 = "";
                                            cfac = (CertificateFactory)cache.get(provider2);
                                            if (cfac == null) {
                                                cfac = ConfigUtil.createCertificateFactory(provider2);
                                                cache.put(provider2, cfac);
                                            }
                                            f = new File(path);
                                            cert = null;
                                            certFactory = cfac;
                                            try {
                                                cert = (X509Certificate)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                                                    @Override
                                                    public Object run() throws SoapSecurityException {
                                                        return ConfigUtil.getX509Certificate(f, certFactory);
                                                    }
                                                });
                                            }
                                            catch (PrivilegedActionException pac) {
                                                th = pac.getCause();
                                                if (th instanceof SoapSecurityException) {
                                                    throw (SoapSecurityException)th;
                                                }
                                                throw new SoapSecurityException(th.getMessage());
                                            }
                                            eeCerts.add(cert);
                                            if (!PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                                            Tr.debug(PolicyOutboundConfig.tc, "Adding the X509 certificate: " + path);
                                        }
                                    }
                                    if ((kMax = (crlPaths = collectionStore.getCRLPaths()).size()) > 0) {
                                        for (k = 0; k < kMax; ++k) {
                                            crlPath = crlPaths.get(k);
                                            path = null;
                                            path = varMap.expand(crlPath);
                                            provider2 = "";
                                            cfac = (CertificateFactory)cache.get(provider2);
                                            if (cfac == null) {
                                                cfac = ConfigUtil.createCertificateFactory(provider2);
                                                cache.put(provider2, cfac);
                                            }
                                            f = new File(path);
                                            eeCerts.add(ConfigUtil.getX509CRL(f, cfac));
                                            if (!PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                                            Tr.debug(PolicyOutboundConfig.tc, "Adding the X509 CRL: " + path);
                                        }
                                    }
                                    algorithm = "Collection";
                                    cparams = null;
                                    try {
                                        cparams = new CollectionCertStoreParameters(eeCerts);
                                        certStore = null;
                                        certStore = provider == null ? CertStore.getInstance(algorithm, cparams) : CertStore.getInstance(algorithm, (CertStoreParameters)cparams, provider);
                                        certStores.add(certStore);
                                        if (!PolicyOutboundConfig.tc.isDebugEnabled()) break;
                                        Tr.debug(PolicyOutboundConfig.tc, "Found CertStore for " + value);
                                        break;
                                    }
                                    catch (NoSuchAlgorithmException e) {
                                        msgKey = "security.wssecurity.CommonReceiverConfig.s20";
                                        Tr.error(PolicyOutboundConfig.tc, msgKey, new Object[]{algorithm});
                                        throw SoapSecurityException.format(msgKey, algorithm, (Throwable)e);
                                    }
                                    catch (InvalidAlgorithmParameterException e) {
                                        msgKey = "security.wssecurity.CommonReceiverConfig.s21";
                                        Tr.error(PolicyOutboundConfig.tc, msgKey, new Object[]{cparams.toString() == null ? "" : cparams.toString()});
                                        throw SoapSecurityException.format(msgKey, cparams.toString() == null ? "" : cparams.toString(), (Throwable)e);
                                    }
                                    catch (Throwable e) {
                                        msgKey = "security.wssecurity.load.collectioncertstore.failed";
                                        Tr.error(PolicyOutboundConfig.tc, msgKey, new String[]{collectionStore.getName(), e.getMessage()});
                                        throw SoapSecurityException.format(msgKey, new String[]{collectionStore.getName(), e.getMessage()}, e);
                                    }
                                }
                            }
                            chconfig._provider = provider;
                            chconfig._certStores = certStores;
                        }
                        if ((basicAuth = callbackHandler.getBasicAuth()) != null) {
                            value = basicAuth.getUserid();
                            if (value != null && value.length() > 0) {
                                chconfig._userId = value;
                            }
                            if ((value = PasswordUtilFactory.getInstance().passwordDecode(basicAuth.getPassword())) != null && value.length() > 0) {
                                chconfig._userPassword = value.toCharArray();
                            }
                        }
                        ConfigConstants.getProperties(chconfig._properties, callbackHandler.getProperties(), varMap);
                        tconfig._callbackHandler = chconfig;
                        if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyOutboundConfig.tc, "Adding the callback handler: " + chconfig.getClassName());
                        }
                    }
                    if ((jaasConfig = tokenGenerator.getJaasConfig()) == null) {
                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s17", new String[]{qn.toString()}));
                    }
                    tconfig._jaasConfig = jaasConfig.getConfigName();
                    if (tconfig._jaasConfig.contains("wss.generate.KRB5BST") && this.isTargetBindingUsing10NS && !PolicyOutboundConfig._avoid70BindingsNSCheck) {
                        throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s42", "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding", "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1");
                    }
                    if (!this._defaultJAASConfigs.contains(tconfig._jaasConfig)) {
                        this._userDefinedComponentsUsed = true;
                        tconfig._userDefinedComponentsUsed = true;
                    }
                    ConfigConstants.getProperties(tconfig._jaasConfigProperties, jaasConfig.getProperties(), varMap);
                    ConfigConstants.getProperties(tconfig._properties, tokenGenerator.getProperties(), varMap);
                    type.clear();
                    type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.custom");
                    type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classname", tconfig._className);
                    if (appClassLoader != null) {
                        type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader", appClassLoader);
                    }
                    properties = new HashMap<Object, Object>();
                    try {
                        tconfig._instance = (TokenGeneratorComponent)factory.createGenerator(type, properties);
                    }
                    catch (SoapSecurityException sse) {
                        Tr.processException((Throwable)sse, PolicyOutboundConfig.clsName + ".init", "%C", this);
                        Tr.warning(PolicyOutboundConfig.tc, "security.wssecurity.Instantiate", new Object[]{tconfig._className});
                    }
                    this._tokenGenerators.add(tconfig);
                    unboundNameToken.remove(reference);
                    value = ConfigUtil.trim(tokenGenerator.getName());
                    if (value == null || value.length() == 0) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s26");
                    }
                    if (this.nameToken.containsKey(value) && PolicyOutboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyOutboundConfig.tc, "WARNING: token generator [" + value + "] is overwritten.");
                    }
                    if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyOutboundConfig.tc, "Adding token generator: " + value);
                    }
                    this.nameToken.put(value, tconfig);
                    tconfig._name = value;
                }
            }
            if (keyInfos != null) {
                iMax = keyInfos.size();
                for (i = 0; i < iMax; ++i) {
                    keyInfo = keyInfos.get(i);
                    kicgconfig = new PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl();
                    kicgconfig._className = keyInfo.getClassname();
                    defaultSystemKeyInfoGenerator = true;
                    ksExist = false;
                    if (!this._defaultKeyInfoContentGenerators.contains(kicgconfig._className)) {
                        this._userDefinedComponentsUsed = true;
                        defaultSystemKeyInfoGenerator = false;
                    }
                    kicgconfig._keyInfoType = keyInfo.getType();
                    tokenReference = keyInfo.getTokenReference();
                    if (tokenReference != null) {
                        value = tokenReference;
                        if (value != null && value.length() > 0) {
                            kicgconfig._tokenGenerator = (PrivateGeneratorConfig.TokenGeneratorConfImpl)this.nameToken.get(value);
                            if (kicgconfig._tokenGenerator == null) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                            }
                            if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyOutboundConfig.tc, "Got the token reference: " + value);
                            }
                            if (!defaultSystemKeyInfoGenerator) {
                                kicgconfig._tokenGenerator._userDefinedComponentsUsed = true;
                            }
                            if (!ksExist) {
                                tconfig = kicgconfig._tokenGenerator;
                                ksRef = (String)tconfig._properties.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                                if (ksRef != null) {
                                    kicgconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", ksRef);
                                }
                            }
                        } else if (kicgconfig._className.equals("com.ibm.ws.webservices.wssecurity.keyinfo.STRReferenceContentGenerator")) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s29");
                        }
                    } else if (kicgconfig._className.equals("com.ibm.ws.webservices.wssecurity.keyinfo.STRReferenceContentGenerator")) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s29");
                    }
                    if (keyInfo.getDerivedKeyInfo() != null) {
                        wssDerivedKeyInfo = keyInfo.getDerivedKeyInfo();
                        derivedKeyInfo = new DerivedKeyInfoConfig();
                        derivedKeyInfo.setClientLabel(wssDerivedKeyInfo.getClientLabel());
                        derivedKeyInfo.setServiceLabel(wssDerivedKeyInfo.getServiceLabel());
                        derivedKeyInfo.setKeyLength(wssDerivedKeyInfo.getKeyLength());
                        derivedKeyInfo.setNonceLength(wssDerivedKeyInfo.getNonceLength());
                        derivedKeyInfo.setRequireDerivedKeys(wssDerivedKeyInfo.isRequireDerivedKeys());
                        derivedKeyInfo.setRequireExplicitDerivedKeys(wssDerivedKeyInfo.isRequireExplicitDerivedKeys());
                        derivedKeyInfo.setRequireImpliedDerivedKeys(wssDerivedKeyInfo.isRequireImpliedDerivedKeys());
                        kicgconfig._derivedKeyInfo = derivedKeyInfo;
                    } else {
                        props = kicgconfig._tokenGenerator.getProperties();
                        keyLength = (String)props.get(Constants.DERIVED_KEY_LENGTH);
                        serviceLabel = (String)props.get("com.ibm.ws.wssecurity.sc.dkt.ServiceLabel");
                        clientLabel = (String)props.get("com.ibm.ws.wssecurity.sc.dkt.ClientLabel");
                        requireImpliedDerivedKeys = (String)props.get("RequiredImpliedDerivedKeys");
                        oldSC = com.ibm.ws.wssecurity.common.Constants.SC_200502.equals(kicgconfig._tokenGenerator._type);
                        if (oldSC) {
                            derivedKeyInfo = new DerivedKeyInfoConfig();
                            derivedKeyInfo.setRequireDerivedKeys(true);
                            derivedKeyInfo.setRequireExplicitDerivedKeys(true);
                            if (keyLength != null && keyLength.length() > 0) {
                                derivedKeyInfo.setKeyLength(keyLength);
                            }
                            if (serviceLabel != null && serviceLabel.length() > 0) {
                                derivedKeyInfo.setServiceLabel(serviceLabel);
                            }
                            if (clientLabel != null && clientLabel.length() > 0) {
                                derivedKeyInfo.setClientLabel(clientLabel);
                            }
                            if ("true".equals(requireImpliedDerivedKeys)) {
                                derivedKeyInfo.setRequireImpliedDerivedKeys(true);
                            }
                            kicgconfig._derivedKeyInfo = derivedKeyInfo;
                        }
                    }
                    ConfigConstants.getProperties(kicgconfig._properties, keyInfo.getProperties(), varMap);
                    type.clear();
                    type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.custom");
                    type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classname", kicgconfig._className);
                    if (kicgconfig._className == null || kicgconfig._className.length() == 0) {
                        throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s03");
                    }
                    if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyOutboundConfig.tc, "KeyInfoContentGenerator classname = " + kicgconfig._className);
                    }
                    if (defaultSystemKeyInfoGenerator) {
                        type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader", this.getClass().getClassLoader());
                    } else if (appClassLoader != null) {
                        type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader", appClassLoader);
                    }
                    if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyOutboundConfig.tc, "ClassLoader used = " + type.get("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader"));
                    }
                    properties = new HashMap<Object, Object>();
                    try {
                        kicgconfig._instance = (KeyInfoContentGeneratorComponent)factory.createGenerator(type, properties);
                    }
                    catch (SoapSecurityException sse) {
                        Tr.processException((Throwable)sse, PolicyOutboundConfig.clsName + ".init", "%C", this);
                        Tr.warning(PolicyOutboundConfig.tc, "security.wssecurity.Instantiate", new Object[]{kicgconfig._className});
                    }
                    value = keyInfo.getName();
                    if (value == null || value.length() == 0) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s28");
                    }
                    if (this.nameKeyInfo.containsKey(value) && PolicyOutboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyOutboundConfig.tc, "WARNING: key info [" + value + "] is overwritten.");
                    }
                    if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyOutboundConfig.tc, "Adding key info: " + value);
                    }
                    kicgconfig._keyName = value;
                    this.nameKeyInfo.put(value, kicgconfig);
                }
            }
            unboundNameConfidentiality.putAll(nameConfidentiality);
            if (encryptionInfos != null) {
                iMax = encryptionInfos.size();
                unboundNameConfidentiality.putAll(nameConfidentiality);
                reference = null;
                for (i = 0; i < iMax; ++i) {
                    encryptionInfo = encryptionInfos.get(i);
                    econfig = new PrivateGeneratorConfig.EncryptionGeneratorConfImpl();
                    dataEncryptionMethod = null;
                    keyEncryptionMethod = null;
                    pref = encryptionInfo.getEncryptionPartReference();
                    if (pref != null) {
                        reference = pref.getReference();
                        if (reference != null && reference.length() > 0) {
                            econfig._reference = (PrivateCommonConfig.ReferencePartConfImpl)nameConfidentiality.get(reference);
                            if (econfig._reference == null) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", reference);
                            }
                            if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyOutboundConfig.tc, "Got the part reference: " + reference);
                            }
                            if (this.encryptionAlgorithms.containsKey(reference)) {
                                dataEncryptionMethod = this.encryptionAlgorithms.get(reference);
                                keyEncryptionMethod = this.keyEncryptionAlgorithms.get(reference);
                            } else if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyOutboundConfig.tc, "WARNING: PartReference part [" + reference + "] on EncryptionInfo does not match a label on EncryptedParts from Policy. Cannot retrieve encryption algorithms from Policy.");
                            }
                        } else if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyOutboundConfig.tc, "WARNING: PartReference part on EncryptionInfo is null or empty. Cannot retrieve encryption algorithms from Policy.");
                        }
                    } else if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyOutboundConfig.tc, "WARNING: PartReference not found on EncryptionInfo. PartReference is required in order to retrieve the encryption algorithms from Policy.");
                    }
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = dataEncryptionMethod;
                    ConfigConstants.getProperties(aconfig._properties, encryptionInfo.getProperties(), varMap);
                    econfig._dataEncryptionMethod = aconfig;
                    dataEncryptionKey = pref.getDataEncryptionKeyInfo();
                    kigconfig = new PrivateGeneratorConfig.KeyInfoGeneratorConfImpl();
                    keyStoreName = null;
                    if (dataEncryptionKey != null && (value = dataEncryptionKey) != null && value.length() > 0) {
                        kicgconfig = (PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)this.nameKeyInfo.get(value);
                        if (kicgconfig == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                        }
                        keyStoreName = (String)kicgconfig._properties.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        tconfig = kicgconfig._tokenGenerator;
                        if (tconfig != null) {
                            tconfig._usedForEncryption = true;
                            tconfig._properties.put("com.ibm.ws.wssecurity.config.TokenGeneratorConfig.usedForEncryption", true);
                            if (this._targetNamespace != null && !this._targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512") && (keyInfoType = this.getKeyInfoTypeForEncryption(tconfig._type, isRequest)) != null) {
                                kicgconfig._keyInfoType = keyInfoType;
                                if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                    Tr.debug(PolicyOutboundConfig.tc, "Setting keyInfoType=[" + keyInfoType + "] from token assertion=[" + tconfig._type + "] for encryption.");
                                }
                            }
                        }
                        kigconfig._contentGenerator = kicgconfig;
                        econfig._encryptionKeyInfo = kigconfig;
                        if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyOutboundConfig.tc, "Got the key info reference: " + value);
                        }
                    }
                    kigconfig = new PrivateGeneratorConfig.KeyInfoGeneratorConfImpl();
                    keyStoreName = null;
                    encryptionKeys = encryptionInfo.getKeyEncryptionKeyInfos();
                    if (encryptionKeys != null && encryptionKeys.size() == 1) {
                        aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                        aconfig._algorithm = keyEncryptionMethod;
                        ConfigConstants.getProperties(aconfig._properties, encryptionInfo.getProperties(), varMap);
                        econfig._keyEncryptionMethod = aconfig;
                        value = encryptionKey = encryptionKeys.get(0);
                        if (value != null && value.length() > 0) {
                            kicgconfig = (PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)this.nameKeyInfo.get(value);
                            if (kicgconfig == null) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                            }
                            keyStoreName = (String)kicgconfig._properties.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                            tconfig = kicgconfig._tokenGenerator;
                            if (tconfig != null) {
                                tconfig._usedForEncryption = true;
                                tconfig._properties.put("com.ibm.ws.wssecurity.config.TokenGeneratorConfig.usedForEncryption", true);
                                if (this._targetNamespace != null && !this._targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512") && (keyInfoType = this.getKeyInfoTypeForEncryption(tconfig._type, isRequest)) != null) {
                                    kicgconfig._keyInfoType = keyInfoType;
                                    if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                        Tr.debug(PolicyOutboundConfig.tc, "Setting keyInfoType=[" + keyInfoType + "] from token assertion=[" + tconfig._type + "] for encryption.");
                                    }
                                }
                            }
                            kigconfig._contentGenerator = kicgconfig;
                            econfig._encryptionKeyInfo = kigconfig;
                            if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyOutboundConfig.tc, "Got the key info reference: " + value);
                            }
                        }
                    }
                    if (keyStoreName != null && ConfigUtil.isHWKeyStore(keyStoreName)) {
                        econfig._properties.put("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", keyStoreName);
                        if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyOutboundConfig.tc, "Hardware KeyStore is used: " + keyStoreName);
                        }
                    }
                    ConfigConstants.getProperties(econfig._properties, encryptionInfo.getProperties(), varMap);
                    position = ConfigUtil.getPosition(order, econfig._reference);
                    ConfigUtil.insertGenerator(this._operationGenerators, order, position, econfig);
                    unboundNameConfidentiality.remove(reference);
                    if (!PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                    Tr.debug(PolicyOutboundConfig.tc, "Adding encryption generator.");
                }
            }
            unboundNameIntegrity.putAll(nameIntegrity);
            if (signingInfos != null) {
                unboundNameIntegrity.putAll(nameIntegrity);
                reference = null;
                iMax = signingInfos.size();
                for (i = 0; i < iMax; ++i) {
                    signingInfo = signingInfos.get(i);
                    sconfig = new PrivateGeneratorConfig.SignatureGeneratorConfImpl();
                    digestMethod = null;
                    canonicalizationMethod = null;
                    signatureMethod = null;
                    prefs = signingInfo.getSigningPartReferences();
                    if (prefs != null) {
                        jMax = prefs.size();
                        for (j = 0; j < jMax; ++j) {
                            pref = prefs.get(j);
                            srconfig = new PrivateCommonConfig.SigningReferenceConfImpl();
                            reference = pref.getReference();
                            if (reference != null && reference.length() > 0) {
                                srconfig._reference = (PrivateCommonConfig.ReferencePartConfImpl)nameIntegrity.get(reference);
                                if (srconfig._reference == null) {
                                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", reference);
                                }
                                if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                    Tr.debug(PolicyOutboundConfig.tc, "Got the part reference: " + reference);
                                }
                            }
                            if (this.digestAlgorithms.containsKey(reference)) {
                                digestMethod = this.digestAlgorithms.get(reference);
                                canonicalizationMethod = this.canonicalizationAlgorithms.get(reference);
                                signatureMethod = this._symmetricBinding ? this.symmetricSignatureAlgorithms.get(reference) : this.asymmetricSignatureAlgorithms.get(reference);
                            } else if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyOutboundConfig.tc, "WARNING: PartReference part [" + reference + "] on SigningInfo does not match a label on SignedParts from Policy. Cannot retrieve signature algorithms from Policy.");
                            }
                            aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                            aconfig._algorithm = digestMethod;
                            srconfig._digestMethod = aconfig;
                            transforms = pref.getTransforms();
                            if (transforms != null) {
                                kMax = transforms.size();
                                for (k = 0; k < kMax; ++k) {
                                    transform = transforms.get(k);
                                    if (transform == null) continue;
                                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                                    aconfig._algorithm = transform.getAlgorithm();
                                    ConfigConstants.getProperties(aconfig._properties, transform.getProperties(), varMap);
                                    if ("http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(aconfig._algorithm)) {
                                        srconfig._transforms.add(0, aconfig);
                                        continue;
                                    }
                                    srconfig._transforms.add(aconfig);
                                }
                            }
                            sconfig._references.add(srconfig);
                        }
                    } else if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyOutboundConfig.tc, "WARNING: PartReference not found on SigningInfo. PartReference is required in order to retrieve the signature algorithms from Policy.");
                    }
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = canonicalizationMethod;
                    sconfig._canonicalizationMethod = aconfig;
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = signatureMethod;
                    sconfig._signatureMethod = aconfig;
                    kigconfig = new PrivateGeneratorConfig.KeyInfoGeneratorConfImpl();
                    keyStoreName = null;
                    signingKeys = signingInfo.getSigningKeyInfos();
                    if ((signingKeys != null || signingKeys.size() == 1) && (value = (signingKey = signingKeys.get(0))) != null && value.length() > 0) {
                        kicgconfig = (PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)this.nameKeyInfo.get(value);
                        if (kicgconfig == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                        }
                        keyStoreName = (String)kicgconfig._properties.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        tconfig = kicgconfig._tokenGenerator;
                        if (tconfig != null) {
                            tconfig._usedForSignature = true;
                            tconfig._properties.put("com.ibm.ws.wssecurity.config.TokenGeneratorConfig.usedForSignature", true);
                            if (this._targetNamespace != null && !this._targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512") && (keyInfoType = this.getKeyInfoTypeForSignature(tconfig._type, isRequest)) != null) {
                                kicgconfig._keyInfoType = keyInfoType;
                                if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                    Tr.debug(PolicyOutboundConfig.tc, "Setting keyInfoType=[" + keyInfoType + "] from token assertion=[" + tconfig._type + "] for signature.");
                                }
                            }
                        }
                        kigconfig._contentGenerator = kicgconfig;
                        if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyOutboundConfig.tc, "Got the key info reference: " + value);
                        }
                    }
                    sconfig._signingKeyInfo = kigconfig;
                    if (keyStoreName != null && ConfigUtil.isHWKeyStore(keyStoreName)) {
                        sconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", keyStoreName);
                        if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyOutboundConfig.tc, "Hardware KeyStore is used: " + keyStoreName);
                        }
                    }
                    ConfigConstants.getProperties(sconfig._properties, signingInfo.getProperties(), varMap);
                    position = ConfigUtil.getMinimumPosition(order, sconfig._references);
                    ConfigUtil.insertGenerator(this._operationGenerators, order, position, sconfig);
                    unboundNameIntegrity.remove(reference);
                    if (!PolicyOutboundConfig.tc.isDebugEnabled()) continue;
                    Tr.debug(PolicyOutboundConfig.tc, "Adding signature generator.");
                }
            }
            if (unboundNameConfidentiality.isEmpty() || defaultConfiguration == null) break block492;
            Tr.warning(PolicyOutboundConfig.tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s09");
            if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyOutboundConfig.tc, "Missing encryption information in custom bindings is being filled in with encryption information from default bindings.");
            }
            tokenSet = unboundNameConfidentiality.keySet();
            references = tokenSet.iterator();
            generatorIterator = null;
            defaultEncryptionGenerator = null;
            econfig = null;
            dgconfig = defaultConfiguration.getDefaultGeneratorBinding();
            if (dgconfig == null) {
                if (defaultConfiguration.getDefaultBindingsLoadingException() != null) {
                    se = defaultConfiguration.getDefaultBindingsLoadingException();
                    throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s30", se.toString());
                }
                se = SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s03", value);
                throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s30", se.toString());
            }
            while (references.hasNext()) {
                reference = (String)references.next();
                aPart = (PrivateCommonConfig.ReferencePartConfImpl)unboundNameConfidentiality.get(reference);
                aList = dgconfig.getOperationGenerators();
                for (Configuration obj : aList) {
                    block493: {
                        if (!(obj instanceof PrivateGeneratorConfig.EncryptionGeneratorConfImpl) || !this.encryptionGeneratorTokenMatch(defaultEncryptionGenerator = (PrivateGeneratorConfig.EncryptionGeneratorConfImpl)obj, isRequest) || aPart == null) continue;
                        if (econfig != null) break block493;
                        econfig = new PrivateGeneratorConfig.EncryptionGeneratorConfImpl();
                        econfig._reference = aPart;
                        econfig._reference.getBindings().add(econfig);
                        aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                        aconfig._algorithm = this.encryptionAlgorithm;
                        econfig._dataEncryptionMethod = aconfig;
                        if (defaultEncryptionGenerator._isKeyEncryption) {
                            aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                            aconfig._algorithm = this.keyEncryptionAlgorithm;
                            econfig._keyEncryptionMethod = aconfig;
                        }
                        econfig._encryptionKeyInfo = defaultEncryptionGenerator._encryptionKeyInfo;
                        econfig._properties.putAll(defaultEncryptionGenerator.getProperties());
                        econfig._reference._order = this._operationGenerators.size() + 1;
                        if (!isTargetNamespaceDraft12) ** GOTO lbl1538
                        orderField = (Integer)econfig._properties.get("com.ibm.ws.wssecurity.constants.order");
                        foundConflict = false;
                        if (orderField != null) {
                            econfig._reference._order = orderField;
                            processed = false;
                            it = order.iterator();
                            a = 0;
                            while (it.hasNext()) {
                                aReferencePart = (PrivateCommonConfig.ReferencePartConfImpl)it.next();
                                if (econfig._reference._order < aReferencePart._order) {
                                    processed = true;
                                    order.add(a, econfig._reference);
                                    break;
                                }
                                if (econfig._reference._order == aReferencePart._order) {
                                    econfig._reference._order = 0x7FFFFFFF;
                                    foundConflict = true;
                                    order.add(econfig._reference);
                                    processed = true;
                                    break;
                                }
                                ++a;
                            }
                            if (!processed) {
                                order.add(econfig._reference);
                            }
                            if (foundConflict) {
                                this._operationGenerators.add(econfig);
                            } else {
                                position = ConfigUtil.getPosition(order, econfig._reference);
                                ConfigUtil.insertGenerator(this._operationGenerators, order, position, econfig);
                            }
                        } else {
                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyOutboundConfig.encorder"));
lbl1538:
                            // 1 sources

                            policyBinding = policy.getPolicyBinding();
                            if (policyBinding.isSignBeforeEncrypting()) {
                                this._operationGenerators.add(econfig);
                            } else {
                                this._operationGenerators.add(0, econfig);
                            }
                        }
                        if ((obj = econfig._encryptionKeyInfo.getContentGenerator()) == null || !(obj instanceof PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl) || (tconfig2 = (PrivateGeneratorConfig.TokenGeneratorConfImpl)(keyInfoGeneratorConf = (PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)obj).getTokenGenerator()) == null) continue;
                        if (com.ibm.ws.wssecurity.common.Constants.SCT_13.equals(tconfig2._type)) {
                            if (this._symmetricProtectionTokenAssertion != null) {
                                this._symmetricProtectionTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                            } else {
                                if (this._symmetricSignatureTokenAssertion != null) {
                                    this._symmetricSignatureTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                                }
                                if (this._symmetricEncryptionTokenAssertion != null) {
                                    this._symmetricEncryptionTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                                }
                            }
                            if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyOutboundConfig.tc, "Replaced sct token Type with [" + com.ibm.ws.wssecurity.common.Constants.SCT_13 + "].");
                            }
                        }
                        if (this._targetNamespace != null && !this._targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512") && (keyInfoType = this.getKeyInfoTypeForEncryption(tconfig2._type, isRequest)) != null) {
                            keyInfoGeneratorConf._keyInfoType = keyInfoType;
                            if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyOutboundConfig.tc, "Setting keyInfoType=[" + keyInfoType + "] from token assertion=[" + tconfig2._type + "] for encryption.");
                            }
                        }
                        this._tokenGenerators.add(tconfig2);
                        references.remove();
                        continue;
                    }
                    econfig._reference._parts.addAll(aPart._parts);
                    references.remove();
                }
                if (!unboundNameConfidentiality.containsKey(reference)) continue;
                throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s26", reference);
            }
        }
        if (!unboundNameIntegrity.isEmpty() && defaultConfiguration != null) {
            Tr.warning(PolicyOutboundConfig.tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s09");
            if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyOutboundConfig.tc, "Missing signature information in custom bindings is being filled in with signature information from default bindings.");
            }
            tokenSet = unboundNameIntegrity.keySet();
            references = tokenSet.iterator();
            generatorIterator = null;
            signatureReferenceIterator = null;
            defaultSignatureGenerator = null;
            defaultSignatureReference = null;
            sconfig = null;
            dgconfig = defaultConfiguration.getDefaultGeneratorBinding();
            if (dgconfig == null) {
                if (defaultConfiguration.getDefaultBindingsLoadingException() != null) {
                    se = defaultConfiguration.getDefaultBindingsLoadingException();
                    throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s31", se.toString());
                }
                se = SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s03", value);
                throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s31", se.toString());
            }
            v3 = this._onlySignEntireHeadersAndBody = dgconfig.isOnlySignEntireHeadersAndBody() != false || this._onlySignEntireHeadersAndBody != false;
            if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyOutboundConfig.tc, "processed default config onlySignEntireHeadersAndBody, currently " + this._onlySignEntireHeadersAndBody);
            }
            while (references.hasNext()) {
                reference = (String)references.next();
                aPart = (PrivateCommonConfig.ReferencePartConfImpl)unboundNameIntegrity.get(reference);
                aList = dgconfig.getOperationGenerators();
                for (Configuration obj : aList) {
                    if (!(obj instanceof PrivateGeneratorConfig.SignatureGeneratorConfImpl) || !this.signatureGeneratorTokenMatch(defaultSignatureGenerator = (PrivateGeneratorConfig.SignatureGeneratorConfImpl)obj, isRequest)) continue;
                    for (PrivateCommonConfig.SigningReferenceConfImpl defaultSignatureReference : defaultSignatureGenerator._references) {
                        if (aPart == null) continue;
                        if (sconfig == null) {
                            sconfig = new PrivateGeneratorConfig.SignatureGeneratorConfImpl();
                            sconfig._properties.putAll(defaultSignatureGenerator._properties);
                            srconfig = new PrivateCommonConfig.SigningReferenceConfImpl();
                            srconfig._reference = aPart;
                            srconfig._reference.getBindings().add(sconfig);
                            orderField = (Integer)sconfig._properties.get("com.ibm.ws.wssecurity.constants.order");
                            foundConflict = false;
                            if (!isTargetNamespaceDraft12) {
                                policyBinding = policy.getPolicyBinding();
                                if (policyBinding.isSignBeforeEncrypting()) {
                                    order.add(0, srconfig._reference);
                                } else {
                                    order.add(srconfig._reference);
                                }
                            } else if (orderField != null && isTargetNamespaceDraft12) {
                                srconfig._reference._order = orderField;
                                processed = false;
                                it = order.iterator();
                                a = 0;
                                while (it.hasNext()) {
                                    aReferencePart = (PrivateCommonConfig.ReferencePartConfImpl)it.next();
                                    if (srconfig._reference._order < aReferencePart._order) {
                                        processed = true;
                                        order.add(a, srconfig._reference);
                                        break;
                                    }
                                    if (srconfig._reference._order == aReferencePart._order) {
                                        srconfig._reference._order = 0;
                                        foundConflict = true;
                                        order.add(0, srconfig._reference);
                                        processed = true;
                                        break;
                                    }
                                    ++a;
                                }
                                if (!processed) {
                                    order.add(srconfig._reference);
                                }
                            } else {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyOutboundConfig.sigorder"));
                            }
                            aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                            aconfig._algorithm = this.digestAlgorithm;
                            srconfig._digestMethod = aconfig;
                            srconfig._transforms.addAll(defaultSignatureReference._transforms);
                            sconfig._references.add(srconfig);
                            aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                            aconfig._algorithm = this.canonicalizationAlgorithm;
                            sconfig._canonicalizationMethod = aconfig;
                            aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                            aconfig._algorithm = this._symmetricBinding != false ? this.symmetricSignatureAlgorithm : this.asymmetricSignatureAlgorithm;
                            sconfig._signatureMethod = aconfig;
                            sconfig._signingKeyInfo = defaultSignatureGenerator._signingKeyInfo;
                            sconfig._properties.putAll(defaultSignatureGenerator._properties);
                            if (isTargetNamespaceDraft12) {
                                if (foundConflict) {
                                    this._operationGenerators.add(0, sconfig);
                                } else {
                                    position = ConfigUtil.getMinimumPosition(order, sconfig._references);
                                    ConfigUtil.insertGenerator(this._operationGenerators, order, position, sconfig);
                                }
                            } else {
                                policyBinding = policy.getPolicyBinding();
                                if (policyBinding.isSignBeforeEncrypting()) {
                                    this._operationGenerators.add(0, sconfig);
                                } else {
                                    this._operationGenerators.add(sconfig);
                                }
                            }
                            if ((obj2 = sconfig._signingKeyInfo.getContentGenerator()) == null || !(obj2 instanceof PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl) || (tconfig2 = (PrivateGeneratorConfig.TokenGeneratorConfImpl)(keyInfoGeneratorConf = (PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)obj2).getTokenGenerator()) == null) continue;
                            if (com.ibm.ws.wssecurity.common.Constants.SCT_13.equals(tconfig2._type)) {
                                if (this._symmetricProtectionTokenAssertion != null) {
                                    this._symmetricProtectionTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                                } else {
                                    if (this._symmetricSignatureTokenAssertion != null) {
                                        this._symmetricSignatureTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                                    }
                                    if (this._symmetricEncryptionTokenAssertion != null) {
                                        this._symmetricEncryptionTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                                    }
                                }
                                if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                    Tr.debug(PolicyOutboundConfig.tc, "Replaced sct token Type with [" + com.ibm.ws.wssecurity.common.Constants.SCT_13 + "].");
                                }
                            }
                            if (this._targetNamespace != null && !this._targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512") && (keyInfoType = this.getKeyInfoTypeForSignature(tconfig2._type, isRequest)) != null) {
                                keyInfoGeneratorConf._keyInfoType = keyInfoType;
                                if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                    Tr.debug(PolicyOutboundConfig.tc, "Setting keyInfoType=[" + keyInfoType + "] from token assertion=[" + tconfig2._type + "] for signature.");
                                }
                            }
                            this._tokenGenerators.add(tconfig2);
                            references.remove();
                            continue;
                        }
                        signReferences = sconfig.getReferences();
                        if (signReferences != null) {
                            aSigningReference = (PrivateCommonConfig.SigningReferenceConfImpl)signReferences.get(0);
                            aRef = aSigningReference.getReference();
                            aRef.getParts().addAll(aPart._parts);
                        }
                        references.remove();
                    }
                }
                if (!unboundNameIntegrity.containsKey(reference)) continue;
                throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s27", reference);
            }
        }
        useDefaultTokenGenerator = false;
        if (!unboundNameToken.isEmpty() && defaultConfiguration != null) {
            Tr.warning(PolicyOutboundConfig.tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s09");
            if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyOutboundConfig.tc, "Missing supporting tokens in custom bindings is being filled in with supporting tokens information from default bindings.");
            }
            set = null;
            tc2 = null;
            i = null;
            standAloneTokenGeneratorTypes = new HashMap<String, PrivateGeneratorConfig.TokenGeneratorConfImpl>();
            supportingTokenTypes = new HashMap<String, PrivateGeneratorConfig.TokenGeneratorConfImpl>();
            numberOfSupportingTokenPerType = new HashMap<QName, Integer>();
            foundLTPAv2TokenGenerator = false;
            dgconfig = defaultConfiguration.getDefaultGeneratorBinding();
            if (dgconfig == null) {
                if (defaultConfiguration.getDefaultBindingsLoadingException() != null) {
                    se = defaultConfiguration.getDefaultBindingsLoadingException();
                    throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s32", se.toString());
                }
                se = SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s03", value);
                throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s32", se.toString());
            }
            set = dgconfig.getTokenGenerators();
            for (PrivateGeneratorConfig.TokenGeneratorConfImpl tconfig2 : set) {
                aType = tconfig2.getType().toString();
                if (com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.equals(tconfig2._type)) {
                    foundLTPAv2TokenGenerator = true;
                } else if ((com.ibm.ws.wssecurity.common.Constants.UNTOKEN.equals(tconfig2._type) || com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.equals(tconfig2._type)) && tconfig2._callbackHandler != null) {
                    idAssertion = (String)tconfig2._callbackHandler._properties.get(Constants.WSSECURITY_USE_IDASSERTION);
                    if (idAssertion != null) {
                        if (idAssertion.equals("true")) {
                            if (standAloneTokenGeneratorTypes.get(aType = aType + Constants.WSSECURITY_USE_IDASSERTION) != null) {
                                throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.s04", tconfig2.getType().toString());
                            }
                        } else if (standAloneTokenGeneratorTypes.get(aType) != null) {
                            throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.s03", tconfig2.getType().toString());
                        }
                    } else if (standAloneTokenGeneratorTypes.get(aType) != null) {
                        throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.s03", tconfig2.getType().toString());
                    }
                }
                if (tconfig2._usedForEncryption || tconfig2._usedForSignature) continue;
                if (standAloneTokenGeneratorTypes.get(aType) == null) {
                    standAloneTokenGeneratorTypes.put(aType, tconfig2);
                    continue;
                }
                throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.s05", aType.toString());
            }
            if (!isTargetNamespaceDraft12) {
                for (TokenGeneratorConfig obj : unboundNameToken.values()) {
                    aType = null;
                    tconfig = null;
                    if (obj instanceof PrivateGeneratorConfig.TokenGeneratorConfImpl) {
                        tconfig = (PrivateGeneratorConfig.TokenGeneratorConfImpl)obj;
                        aType = tconfig.getType().toString();
                        if ((tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN) || tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11)) && !tconfig._aTokenAssertion._requirePassword) {
                            aType = aType + Constants.WSSECURITY_USE_IDASSERTION;
                        } else if (com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN.equals(tconfig._type) && foundLTPAv2TokenGenerator) {
                            tconfig._type = com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN;
                            aType = com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.toString();
                            if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyOutboundConfig.tc, "Replaced ltpa token Type with [" + com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN + "].");
                            }
                        }
                    }
                    if (aType == null || tconfig == null) continue;
                    if (supportingTokenTypes.get(aType) == null) {
                        supportingTokenTypes.put(aType, tconfig);
                        numberOfSupportingTokenPerType = this.updateTokenTypeList(numberOfSupportingTokenPerType, tconfig.getType());
                        continue;
                    }
                    if (tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN) || tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11)) {
                        if (aType.endsWith(Constants.WSSECURITY_USE_IDASSERTION)) {
                            throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s28", tconfig._type.toString());
                        }
                        throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s29", tconfig._type.toString());
                    }
                    throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s25", tconfig._type.toString());
                }
            } else {
                i = unboundNameToken.values().iterator();
                aType = null;
                tconfig = null;
                while (i.hasNext()) {
                    obj = i.next();
                    if (obj instanceof PrivateGeneratorConfig.TokenGeneratorConfImpl) {
                        tconfig = (PrivateGeneratorConfig.TokenGeneratorConfImpl)obj;
                        aType = tconfig.getType().toString();
                        if (tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN) || tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11)) {
                            if (supportingTokenTypes.get(aType) != null && supportingTokenTypes.get(aType + Constants.WSSECURITY_USE_IDASSERTION) == null) {
                                aType = aType + Constants.WSSECURITY_USE_IDASSERTION;
                            } else if (supportingTokenTypes.get(aType) != null && supportingTokenTypes.get(aType + Constants.WSSECURITY_USE_IDASSERTION) != null) {
                                throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s24", aType.toString());
                            }
                        } else if (com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN.equals(tconfig._type) && foundLTPAv2TokenGenerator) {
                            tconfig._type = com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN;
                            aType = com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.toString();
                            if (PolicyOutboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyOutboundConfig.tc, "Replaced ltpa token Type with [" + com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN + "].");
                            }
                        }
                    }
                    if (aType == null || tconfig == null) continue;
                    if (supportingTokenTypes.get(aType) == null) {
                        supportingTokenTypes.put(aType, tconfig);
                        numberOfSupportingTokenPerType = this.updateTokenTypeList(numberOfSupportingTokenPerType, tconfig.getType());
                        continue;
                    }
                    if (tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN) || tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11)) {
                        if (aType.endsWith(Constants.WSSECURITY_USE_IDASSERTION)) {
                            throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s28", tconfig._type.toString());
                        }
                        throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s29", tconfig._type.toString());
                    }
                    throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s25", tconfig._type.toString());
                }
            }
            numUNTokens = null;
            numUNTokens = (Integer)numberOfSupportingTokenPerType.get(com.ibm.ws.wssecurity.common.Constants.UNTOKEN);
            if (numUNTokens != null && numUNTokens == 1 && standAloneTokenGeneratorTypes.containsKey(com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString()) && standAloneTokenGeneratorTypes.containsKey(com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString() + Constants.WSSECURITY_USE_IDASSERTION)) {
                throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.s06", com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString());
            }
            numUNTokens = (Integer)numberOfSupportingTokenPerType.get(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11);
            if (numUNTokens != null && numUNTokens == 1 && standAloneTokenGeneratorTypes.containsKey(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString()) && standAloneTokenGeneratorTypes.containsKey(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString() + Constants.WSSECURITY_USE_IDASSERTION)) {
                throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.s06", com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString());
            }
            keySet = supportingTokenTypes.keySet();
            for (String tokenType : keySet) {
                tconfig2 = (PrivateGeneratorConfig.TokenGeneratorConfImpl)standAloneTokenGeneratorTypes.get(tokenType);
                if (tconfig2 != null) {
                    tc2 = (PrivateGeneratorConfig.TokenGeneratorConfImpl)supportingTokenTypes.get(tokenType);
                    tconfig2._standAlone = tc2._standAlone;
                    tconfig2._aTokenAssertion = tc2._aTokenAssertion;
                    useDefaultTokenGenerator = true;
                    this._tokenGenerators.add(tconfig2);
                    continue;
                }
                if (tokenType.startsWith(com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString())) {
                    throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.s07", com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString());
                }
                if (tokenType.startsWith(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString())) {
                    throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.s07", com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString());
                }
                throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.s07", tokenType);
            }
        }
        this.mapPolicyAssertionsToProperties(isTargetNamespaceDraft12, isRequest);
        if (this._encryptSignature && !isTargetNamespaceDraft12 && addEncryptSignature && this._operationGenerators.size() > 0) {
            i = this._operationGenerators.iterator();
            foundGenerator = false;
            while (i.hasNext() && !foundGenerator) {
                generator = i.next();
                if (!(generator instanceof PrivateGeneratorConfig.EncryptionGeneratorConfImpl)) continue;
                encGenerator = (PrivateGeneratorConfig.EncryptionGeneratorConfImpl)generator;
                if (isSignBeforeEncrypting) {
                    encGenerator._reference._parts.add(encryptSignaturePartConfig);
                    foundGenerator = true;
                    continue;
                }
                signatureEncryptionGenerator = new PrivateGeneratorConfig.EncryptionGeneratorConfImpl(encGenerator);
                encryptSignatureRefPartConfig = new PrivateCommonConfig.ReferencePartConfImpl();
                encryptSignatureRefPartConfig._order = 0;
                encryptSignatureRefPartConfig._parts.add(encryptSignaturePartConfig);
                signatureEncryptionGenerator._reference = encryptSignatureRefPartConfig;
                this._operationGenerators.add(signatureEncryptionGenerator);
                foundGenerator = true;
            }
        }
        this.validate(false, useDefaultTokenGenerator, null);
        if (PolicyOutboundConfig.tc.isEntryEnabled()) {
            Tr.exit(PolicyOutboundConfig.tc, "init(SecurityOutboundBindingConfig binding, Policy policy, String actorURI, boolean isRequest, ClassLoader appClassLoader,WSSecurityDefaultConfiguration defaultConfiguration)");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void initDefaultConfig(WSSGeneratorConfig dgconfig, List<ReferencePartConfig> order, boolean isRequest, boolean isTargetNamespaceDraft12, WSSPolicy policy, PrivateCommonConfig.PartConfImpl encryptSignaturePartConfig, boolean addEncryptSignature, boolean signSignatureConfirmationSpecified, boolean encryptSignatureConfirmationSpecified) throws SoapSecurityException {
        Iterator<Configuration> i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initDefaultConfig(WSSGeneratorConfig, List):", new Object[]{dgconfig, order});
        }
        HashMap<String, PrivateGeneratorConfig.TokenGeneratorConfImpl> standAloneTokenGeneratorTypes = new HashMap<String, PrivateGeneratorConfig.TokenGeneratorConfImpl>();
        HashMap<Object, PrivateGeneratorConfig.TokenGeneratorConfImpl> supportingTokenTypes = new HashMap<Object, PrivateGeneratorConfig.TokenGeneratorConfImpl>();
        HashMap<QName, Integer> numberOfSupportingTokenPerType = new HashMap<QName, Integer>();
        PrivateGeneratorConfig.EncryptionGeneratorConfImpl defaultEncryptionGenerator = null;
        PrivateGeneratorConfig.SignatureGeneratorConfImpl defaultSignatureGenerator = null;
        Object var20_15 = null;
        PrivateGeneratorConfig.EncryptionGeneratorConfImpl econfig = null;
        PrivateGeneratorConfig.SignatureGeneratorConfImpl sconfig = null;
        PrivateCommonConfig.SigningReferenceConfImpl srconfig = null;
        PrivateGeneratorConfig.TokenGeneratorConfImpl tconfig = null;
        PrivateGeneratorConfig.TokenGeneratorConfImpl tc2 = null;
        PrivateCommonConfig.AlgorithmConfImpl aconfig = null;
        boolean isSignBeforeEncrypting = false;
        if ("com.ibm.xmlns.prod.websphere._200608.ws_securitybinding".equals(dgconfig.getDefaultBindingNamespace())) {
            this.isDefaultBindingUsing10NS = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Target default bindings name space = " + dgconfig.getDefaultBindingNamespace());
        }
        boolean foundLTPAv2TokenGenerator = false;
        Set<TokenGeneratorConfig> set = dgconfig.getTokenGenerators();
        for (PrivateGeneratorConfig.TokenGeneratorConfImpl tokenGeneratorConfImpl : set) {
            String aType = tokenGeneratorConfImpl.getType().toString();
            if (tokenGeneratorConfImpl._jaasConfig.contains("wss.generate.KRB5BST") && this.isDefaultBindingUsing10NS && !_avoid70BindingsNSCheck) {
                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s42", "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding", "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1");
            }
            if (com.ibm.ws.wssecurity.common.Constants.SCT_13.equals(tokenGeneratorConfImpl._type)) {
                if (this.isDefaultBindingUsing10NS && !_avoid70BindingsNSCheck) {
                    throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s42", "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding", tokenGeneratorConfImpl.getType().getLocalPart());
                }
                if (this._symmetricProtectionTokenAssertion != null && com.ibm.ws.wssecurity.common.Constants.SC_200502.equals(this._symmetricProtectionTokenAssertion._tokenType)) {
                    this._symmetricProtectionTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                } else {
                    if (this._symmetricSignatureTokenAssertion != null && com.ibm.ws.wssecurity.common.Constants.SC_200502.equals(this._symmetricSignatureTokenAssertion._tokenType)) {
                        this._symmetricSignatureTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                    }
                    if (this._symmetricEncryptionTokenAssertion != null && com.ibm.ws.wssecurity.common.Constants.SC_200502.equals(this._symmetricEncryptionTokenAssertion._tokenType)) {
                        this._symmetricEncryptionTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Replaced sct token Type with [" + com.ibm.ws.wssecurity.common.Constants.SCT_13 + "].");
                }
            } else if (com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.equals(tokenGeneratorConfImpl._type)) {
                foundLTPAv2TokenGenerator = true;
            } else if ((com.ibm.ws.wssecurity.common.Constants.UNTOKEN.equals(tokenGeneratorConfImpl._type) || com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.equals(tokenGeneratorConfImpl._type)) && tokenGeneratorConfImpl._callbackHandler != null) {
                String idAssertion = (String)tokenGeneratorConfImpl._callbackHandler._properties.get(Constants.WSSECURITY_USE_IDASSERTION);
                if (idAssertion != null) {
                    if (idAssertion.equals("true")) {
                        if (standAloneTokenGeneratorTypes.get(aType = aType + Constants.WSSECURITY_USE_IDASSERTION) != null) {
                            throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.s04", tokenGeneratorConfImpl.getType().toString());
                        }
                    } else if (standAloneTokenGeneratorTypes.get(aType) != null) {
                        throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.s03", tokenGeneratorConfImpl.getType().toString());
                    }
                } else if (standAloneTokenGeneratorTypes.get(aType) != null) {
                    throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.s03", tokenGeneratorConfImpl.getType().toString());
                }
            }
            if (tokenGeneratorConfImpl._usedForEncryption || tokenGeneratorConfImpl._usedForSignature) continue;
            if (standAloneTokenGeneratorTypes.get(aType) != null) throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.s05", aType.toString());
            standAloneTokenGeneratorTypes.put(aType, tokenGeneratorConfImpl);
        }
        if (!isTargetNamespaceDraft12) {
            List<HashMap<String, ProtectionOrSupportingToken>> list = policy.getCallerExactlyOneTokens();
            int iMax = list.size();
            int matchIndex = 0;
            boolean foundMatch = false;
            for (int index = 0; index < iMax && !foundMatch; ++index) {
                HashMap<String, ProtectionOrSupportingToken> callerMap = list.get(index);
                int callerMapSize = callerMap.size();
                int matchesFound = 0;
                Iterator<String> iterator = callerMap.keySet().iterator();
                while (iterator.hasNext()) {
                    boolean foundTokenMatch = false;
                    String aKey = iterator.next();
                    ProtectionOrSupportingToken aToken = callerMap.get(aKey);
                    QName tokenType = null;
                    PrivateCommonConfig.TokenAssertion aTokenAssertion = this.getTokenTypeAssertion(aToken);
                    if (aTokenAssertion != null) {
                        tokenType = aTokenAssertion.getTokenType();
                    }
                    set = dgconfig.getTokenGenerators();
                    i = set.iterator();
                    while (i.hasNext() && !foundTokenMatch) {
                        PrivateGeneratorConfig.TokenGeneratorConfImpl tconfig2 = new PrivateGeneratorConfig.TokenGeneratorConfImpl((PrivateGeneratorConfig.TokenGeneratorConfImpl)i.next());
                        QName tconfigType = tconfig2.getType();
                        if (tokenType == null || aTokenAssertion == null || !tconfigType.equals(tokenType)) continue;
                        if (tconfig2._type.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN) || tconfig2._type.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11)) {
                            if (tconfig2._callbackHandler != null) {
                                String idAssertion = (String)tconfig2._callbackHandler._properties.get(Constants.WSSECURITY_USE_IDASSERTION);
                                if (idAssertion != null) {
                                    if (idAssertion.equals("true") && !aTokenAssertion._requirePassword) {
                                        ++matchesFound;
                                        foundTokenMatch = true;
                                    } else if (!idAssertion.equals("true") && aTokenAssertion._requirePassword) {
                                        ++matchesFound;
                                        foundTokenMatch = true;
                                    }
                                } else if (aTokenAssertion._requirePassword) {
                                    ++matchesFound;
                                    foundTokenMatch = true;
                                }
                            }
                        } else {
                            ++matchesFound;
                            foundTokenMatch = true;
                        }
                        if (matchesFound != callerMapSize) continue;
                        foundMatch = true;
                        matchIndex = index;
                    }
                }
            }
            if (foundMatch) {
                HashMap<String, ProtectionOrSupportingToken> callerMap = list.get(matchIndex);
                for (String idReference : callerMap.keySet()) {
                    ProtectionOrSupportingToken supportingTokenPolicy = callerMap.get(idReference);
                    boolean retrieveAssertions = false;
                    retrieveAssertions = this.retrieveAssertions(idReference, isRequest);
                    if (!retrieveAssertions) continue;
                    this._tokenEnabled = true;
                    tconfig = new PrivateGeneratorConfig.TokenGeneratorConfImpl();
                    tconfig._standAlone = true;
                    PrivateCommonConfig.TokenAssertion aTokenAssertion = this.getTokenTypeAssertion(supportingTokenPolicy);
                    if (aTokenAssertion != null) {
                        tconfig._type = aTokenAssertion._tokenType;
                        tconfig._aTokenAssertion = aTokenAssertion;
                    }
                    this._securityTokens.add(tconfig);
                    if (idReference == null || idReference.length() == 0) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s23");
                    }
                    if (this.nameToken.containsKey(idReference) && tc.isDebugEnabled()) {
                        Tr.debug(tc, "WARNING: required security token [" + idReference + "] is overwritten.");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding required security token: " + idReference);
                    }
                    this.nameToken.put(idReference, tconfig);
                }
                list.clear();
            }
        }
        if (!isTargetNamespaceDraft12) {
            for (TokenGeneratorConfig tokenGeneratorConfig : this.nameToken.values()) {
                String aType = null;
                tconfig = null;
                if (tokenGeneratorConfig instanceof PrivateGeneratorConfig.TokenGeneratorConfImpl) {
                    tconfig = (PrivateGeneratorConfig.TokenGeneratorConfImpl)tokenGeneratorConfig;
                    aType = tconfig.getType().toString();
                    if ((tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN) || tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11)) && !tconfig._aTokenAssertion._requirePassword) {
                        aType = aType + Constants.WSSECURITY_USE_IDASSERTION;
                    } else if (com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN.equals(tconfig._type) && foundLTPAv2TokenGenerator) {
                        if (this.isDefaultBindingUsing10NS && !_avoid70BindingsNSCheck) {
                            throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s42", "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding", com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.getLocalPart());
                        }
                        tconfig._type = com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN;
                        aType = com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.toString();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Replaced ltpa token Type with [" + com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN + "].");
                        }
                    }
                }
                if (aType == null || tconfig == null) continue;
                if (supportingTokenTypes.get(aType) == null) {
                    supportingTokenTypes.put(aType, tconfig);
                    numberOfSupportingTokenPerType = this.updateTokenTypeList(numberOfSupportingTokenPerType, tconfig.getType());
                    continue;
                }
                if (!tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN) && !tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11)) throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s25", tconfig._type.toString());
                if (!aType.endsWith(Constants.WSSECURITY_USE_IDASSERTION)) throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s29", tconfig._type.toString());
                throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s28", tconfig._type.toString());
            }
        } else {
            i = this.nameToken.values().iterator();
            Object var29_33 = null;
            tconfig = null;
            while (i.hasNext()) {
                void var29_34;
                TokenGeneratorConfig obj = i.next();
                if (obj instanceof PrivateGeneratorConfig.TokenGeneratorConfImpl) {
                    tconfig = (PrivateGeneratorConfig.TokenGeneratorConfImpl)obj;
                    String string = tconfig.getType().toString();
                    if (tconfig.getType().equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN) || tconfig.getType().equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11)) {
                        if (supportingTokenTypes.get(string) != null && supportingTokenTypes.get(string + Constants.WSSECURITY_USE_IDASSERTION) == null) {
                            String string2 = string + Constants.WSSECURITY_USE_IDASSERTION;
                        } else if (supportingTokenTypes.get(string) != null && supportingTokenTypes.get(string + Constants.WSSECURITY_USE_IDASSERTION) != null) {
                            throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s24", string.toString());
                        }
                    } else if (com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN.equals(tconfig.getType()) && foundLTPAv2TokenGenerator) {
                        tconfig._type = com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN;
                        String string3 = com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.toString();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Replaced ltpa token Type with [" + com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN + "].");
                        }
                    }
                }
                if (var29_34 == null || tconfig == null) continue;
                if (supportingTokenTypes.get(var29_34) == null) {
                    supportingTokenTypes.put(var29_34, tconfig);
                    numberOfSupportingTokenPerType = this.updateTokenTypeList(numberOfSupportingTokenPerType, tconfig.getType());
                    continue;
                }
                if (!tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN) && !tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11)) throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s25", tconfig._type.toString());
                if (!var29_34.endsWith(Constants.WSSECURITY_USE_IDASSERTION)) throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s29", tconfig._type.toString());
                throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s28", tconfig._type.toString());
            }
        }
        Object var29_39 = null;
        Integer n = (Integer)numberOfSupportingTokenPerType.get(com.ibm.ws.wssecurity.common.Constants.UNTOKEN);
        if (n != null && n == 1 && standAloneTokenGeneratorTypes.containsKey(com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString()) && standAloneTokenGeneratorTypes.containsKey(com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString() + Constants.WSSECURITY_USE_IDASSERTION)) {
            throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.s06", com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString());
        }
        Integer n2 = (Integer)numberOfSupportingTokenPerType.get(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11);
        if (n2 != null && n2 == 1 && standAloneTokenGeneratorTypes.containsKey(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString()) && standAloneTokenGeneratorTypes.containsKey(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString() + Constants.WSSECURITY_USE_IDASSERTION)) {
            throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.s06", com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString());
        }
        Set keySet = supportingTokenTypes.keySet();
        for (String tokenType : keySet) {
            PrivateGeneratorConfig.TokenGeneratorConfImpl tconfig2 = (PrivateGeneratorConfig.TokenGeneratorConfImpl)standAloneTokenGeneratorTypes.get(tokenType);
            if (tconfig2 != null) {
                tc2 = (PrivateGeneratorConfig.TokenGeneratorConfImpl)supportingTokenTypes.get(tokenType);
                tconfig2._standAlone = tc2._standAlone;
                tconfig2._aTokenAssertion = tc2._aTokenAssertion;
                this._tokenGenerators.add(tconfig2);
                if (!tconfig2._userDefinedComponentsUsed) continue;
                this._userDefinedComponentsUsed = true;
                continue;
            }
            if (tokenType.startsWith(com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString())) {
                throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.s07", com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString());
            }
            if (!tokenType.startsWith(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString())) throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.s07", tokenType);
            throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.s07", com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString());
        }
        if (!isRequest) {
            boolean disableImplicitProtectionForSignatureConfirmation = false;
            if (dgconfig.isExplicitlyProtectSignatureConfirmation()) {
                if (this.isDefaultBindingUsing10NS && !_avoid70BindingsNSCheck) {
                    throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s42", "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding", "ExplicitlyProtectSignatureConfirmation");
                }
                disableImplicitProtectionForSignatureConfirmation = true;
            }
            if (this._signatureConfirmationRequired && !this.isDefaultBindingUsing10NS && !disableImplicitProtectionForSignatureConfirmation) {
                PrivateCommonConfig.ReferencePartConfImpl rpconfig = null;
                PrivateCommonConfig.PartConfImpl pconfig = null;
                if (!signSignatureConfirmationSpecified) {
                    if (this._integralParts.size() > 0) {
                        rpconfig = (PrivateCommonConfig.ReferencePartConfImpl)this._integralParts.get(0);
                        pconfig = new PrivateCommonConfig.PartConfImpl();
                        pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
                        pconfig._keyword = IntegralDialectElementSelector.WASDIALECTS[14];
                        rpconfig._parts.add(pconfig);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding SignatureConfirmation to required integrity for default binding");
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Cannot sign SignatureConfirmation element since nothing else on the message is signed");
                        }
                        Tr.warning(tc, ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s23"));
                    }
                }
                if (!encryptSignatureConfirmationSpecified) {
                    if (this._confidentialParts.size() > 0) {
                        rpconfig = (PrivateCommonConfig.ReferencePartConfImpl)this._confidentialParts.get(0);
                        pconfig = new PrivateCommonConfig.PartConfImpl();
                        pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
                        pconfig._keyword = ConfidentialDialectElementSelector.WASDIALECTS[6];
                        rpconfig._parts.add(pconfig);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding SignatureConfirmation to required confidentiality for default binding");
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Cannot encrypt SignatureConfirmation element since nothing else on the message is encrypted");
                        }
                        Tr.warning(tc, ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s22"));
                    }
                }
            }
        }
        List<Configuration> list = dgconfig.getOperationGenerators();
        i = list.iterator();
        ArrayList unboundIntegrities = new ArrayList();
        ArrayList unboundConfidentialities = new ArrayList();
        unboundConfidentialities.addAll(this._confidentialParts);
        unboundIntegrities.addAll(this._integralParts);
        while (i.hasNext()) {
            TokenGeneratorConfig tconfig2;
            Iterator<ReferencePartConfig> it;
            PrivateCommonConfig.ReferencePartConfImpl refPart;
            Configuration obj = i.next();
            if (obj instanceof PrivateGeneratorConfig.EncryptionGeneratorConfImpl) {
                defaultEncryptionGenerator = (PrivateGeneratorConfig.EncryptionGeneratorConfImpl)obj;
                if (!this.encryptionGeneratorTokenMatch(defaultEncryptionGenerator, isRequest)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting up encryption generation information from default bindings.");
                }
                Iterator<Object> j = unboundConfidentialities.iterator();
                while (j.hasNext()) {
                    refPart = (PrivateCommonConfig.ReferencePartConfImpl)j.next();
                    j.remove();
                    if (econfig == null) {
                        econfig = new PrivateGeneratorConfig.EncryptionGeneratorConfImpl();
                        econfig._reference = refPart;
                        econfig._reference.getBindings().add(econfig);
                        aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                        aconfig._algorithm = this.encryptionAlgorithm;
                        econfig._dataEncryptionMethod = aconfig;
                        if (defaultEncryptionGenerator._isKeyEncryption) {
                            aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                            aconfig._algorithm = this.keyEncryptionAlgorithm;
                            econfig._keyEncryptionMethod = aconfig;
                        }
                        econfig._encryptionKeyInfo = defaultEncryptionGenerator._encryptionKeyInfo;
                        econfig._properties.putAll(defaultEncryptionGenerator.getProperties());
                        if (isTargetNamespaceDraft12) {
                            Integer orderField = (Integer)econfig._properties.get("com.ibm.ws.wssecurity.constants.order");
                            if (orderField == null) throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyOutboundConfig.encorder"));
                            econfig._reference._order = orderField;
                            boolean processed = false;
                            it = order.iterator();
                            int a = 0;
                            while (it.hasNext()) {
                                if (econfig._reference._order < ((PrivateCommonConfig.ReferencePartConfImpl)it.next())._order) {
                                    processed = true;
                                    order.add(a, econfig._reference);
                                    break;
                                }
                                ++a;
                            }
                            if (!processed) {
                                order.add(econfig._reference);
                            }
                            int position = ConfigUtil.getPosition(order, econfig._reference);
                            ConfigUtil.insertGenerator(this._operationGenerators, order, position, econfig);
                        } else {
                            PolicyBinding policyBinding = policy.getPolicyBinding();
                            isSignBeforeEncrypting = policyBinding.isSignBeforeEncrypting();
                            if (isSignBeforeEncrypting) {
                                this._operationGenerators.add(econfig);
                            } else {
                                this._operationGenerators.add(0, econfig);
                            }
                        }
                        tconfig2 = econfig.getEncryptionKeyInfo().getContentGenerator().getTokenGenerator();
                        this._tokenGenerators.add(tconfig2);
                        if (!((PrivateGeneratorConfig.TokenGeneratorConfImpl)tconfig2)._userDefinedComponentsUsed) continue;
                        this._userDefinedComponentsUsed = true;
                        continue;
                    }
                    econfig._reference._parts.addAll(refPart._parts);
                }
                continue;
            }
            defaultSignatureGenerator = (PrivateGeneratorConfig.SignatureGeneratorConfImpl)obj;
            if (!this.signatureGeneratorTokenMatch(defaultSignatureGenerator, isRequest)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting up signature generation information from default bindings.");
            }
            for (PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl : defaultSignatureGenerator._references) {
                if (unboundIntegrities.isEmpty()) continue;
                Iterator k = unboundIntegrities.iterator();
                while (k.hasNext()) {
                    refPart = (PrivateCommonConfig.ReferencePartConfImpl)k.next();
                    k.remove();
                    if (sconfig == null) {
                        PolicyBinding policyBinding;
                        sconfig = new PrivateGeneratorConfig.SignatureGeneratorConfImpl();
                        srconfig = new PrivateCommonConfig.SigningReferenceConfImpl();
                        sconfig._properties.putAll(defaultSignatureGenerator._properties);
                        srconfig._reference = refPart;
                        srconfig._reference.getBindings().add(sconfig);
                        if (isTargetNamespaceDraft12) {
                            Integer orderField = (Integer)sconfig._properties.get("com.ibm.ws.wssecurity.constants.order");
                            if (orderField == null) throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyOutboundConfig.sigorder"));
                            srconfig._reference._order = orderField;
                            boolean processed = false;
                            it = order.iterator();
                            int a = 0;
                            while (it.hasNext()) {
                                if (srconfig._reference._order < ((PrivateCommonConfig.ReferencePartConfImpl)it.next())._order) {
                                    processed = true;
                                    order.add(a, srconfig._reference);
                                    break;
                                }
                                ++a;
                            }
                            if (!processed) {
                                order.add(srconfig._reference);
                            }
                        } else {
                            policyBinding = policy.getPolicyBinding();
                            if (policyBinding.isSignBeforeEncrypting()) {
                                order.add(0, srconfig._reference);
                            } else {
                                order.add(srconfig._reference);
                            }
                        }
                        aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                        aconfig._algorithm = this.digestAlgorithm;
                        srconfig._digestMethod = aconfig;
                        srconfig._transforms.addAll(signingReferenceConfImpl._transforms);
                        sconfig._references.add(srconfig);
                        aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                        aconfig._algorithm = this.canonicalizationAlgorithm;
                        sconfig._canonicalizationMethod = aconfig;
                        aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                        aconfig._algorithm = this._symmetricBinding ? this.symmetricSignatureAlgorithm : this.asymmetricSignatureAlgorithm;
                        sconfig._signatureMethod = aconfig;
                        sconfig._signingKeyInfo = defaultSignatureGenerator._signingKeyInfo;
                        if (isTargetNamespaceDraft12) {
                            int position = ConfigUtil.getMinimumPosition(order, sconfig._references);
                            ConfigUtil.insertGenerator(this._operationGenerators, order, position, sconfig);
                        } else {
                            policyBinding = policy.getPolicyBinding();
                            if (policyBinding.isSignBeforeEncrypting()) {
                                this._operationGenerators.add(0, sconfig);
                            } else {
                                this._operationGenerators.add(sconfig);
                            }
                        }
                        tconfig2 = sconfig.getSigningKeyInfo().getContentGenerator().getTokenGenerator();
                        this._tokenGenerators.add(tconfig2);
                        if (!((PrivateGeneratorConfig.TokenGeneratorConfImpl)tconfig2)._userDefinedComponentsUsed) continue;
                        this._userDefinedComponentsUsed = true;
                        continue;
                    }
                    List<SigningReferenceConfig> references = sconfig.getReferences();
                    if (references == null) continue;
                    PrivateCommonConfig.SigningReferenceConfImpl aSigningReference = (PrivateCommonConfig.SigningReferenceConfImpl)references.get(0);
                    ReferencePartConfig aRef = aSigningReference.getReference();
                    aRef.getParts().addAll(refPart._parts);
                }
            }
        }
        if (!unboundIntegrities.isEmpty()) {
            throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.s08");
        }
        if (!unboundConfidentialities.isEmpty()) {
            throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.s09");
        }
        if (this._encryptSignature && !isTargetNamespaceDraft12 && addEncryptSignature && this._operationGenerators.size() > 0) {
            i = this._operationGenerators.iterator();
            boolean foundGenerator = false;
            while (i.hasNext() && !foundGenerator) {
                Configuration generator = i.next();
                if (!(generator instanceof PrivateGeneratorConfig.EncryptionGeneratorConfImpl)) continue;
                PrivateGeneratorConfig.EncryptionGeneratorConfImpl encGenerator = (PrivateGeneratorConfig.EncryptionGeneratorConfImpl)generator;
                if (isSignBeforeEncrypting) {
                    encGenerator._reference._parts.add(encryptSignaturePartConfig);
                    foundGenerator = true;
                    continue;
                }
                PrivateGeneratorConfig.EncryptionGeneratorConfImpl signatureEncryptionGenerator = new PrivateGeneratorConfig.EncryptionGeneratorConfImpl(encGenerator);
                PrivateCommonConfig.ReferencePartConfImpl encryptSignatureRefPartConfig = new PrivateCommonConfig.ReferencePartConfImpl();
                encryptSignatureRefPartConfig._order = 0;
                encryptSignatureRefPartConfig._parts.add(encryptSignaturePartConfig);
                signatureEncryptionGenerator._reference = encryptSignatureRefPartConfig;
                this._operationGenerators.add(signatureEncryptionGenerator);
                foundGenerator = true;
            }
        }
        boolean bl = this._onlySignEntireHeadersAndBody = dgconfig.isOnlySignEntireHeadersAndBody() || this._onlySignEntireHeadersAndBody;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processed default config onlySignEntireHeadersAndBody, currently " + this._onlySignEntireHeadersAndBody);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "initDefaultConfig(WSSGeneratorConfig, List):", new Object[]{dgconfig, order});
    }

    private HashMap<QName, Integer> updateTokenTypeList(HashMap<QName, Integer> tokenTypeList, QName aType) {
        Integer numOfOcurrences = tokenTypeList.get(aType);
        if (numOfOcurrences == null) {
            numOfOcurrences = new Integer(1);
            tokenTypeList.put(aType, numOfOcurrences);
        } else {
            Integer n = numOfOcurrences;
            Integer n2 = numOfOcurrences = Integer.valueOf(numOfOcurrences + 1);
            tokenTypeList.put(aType, numOfOcurrences);
        }
        return tokenTypeList;
    }

    final String getOrigin() {
        return this.origin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean encryptionGeneratorTokenMatch(PrivateGeneratorConfig.EncryptionGeneratorConfImpl anEncryptionGeneratorConfig, boolean isRequest) throws SoapSecurityException {
        QName aType = null;
        boolean isMatch = false;
        if (anEncryptionGeneratorConfig.getEncryptionKeyInfo() != null) {
            KeyInfoContentGeneratorConfig aConfig = anEncryptionGeneratorConfig.getEncryptionKeyInfo().getContentGenerator();
            if (aConfig != null) {
                aType = aConfig.getTokenGenerator().getType();
                if (aType == null) return isMatch;
                if (this._symmetricBinding) {
                    if (this._symmetricProtectionTokenAssertion != null) {
                        if (!this._symmetricProtectionTokenAssertion.getTokenType().equals(aType)) return false;
                        return true;
                    }
                    if (this._symmetricEncryptionTokenAssertion == null) return isMatch;
                    if (!this._symmetricEncryptionTokenAssertion.getTokenType().equals(aType)) return false;
                    return true;
                }
                if (isRequest) {
                    if (!this._recipientTokens.isEmpty()) {
                        if (this._recipientTokenQNames.indexOf(aType) < 0) return false;
                        return true;
                    }
                    if (this._recipientEncryptionTokens.isEmpty()) return isMatch;
                    if (this._recipientEncryptionTokenQNames.indexOf(aType) < 0) return false;
                    return true;
                }
                if (!this._initiatorTokens.isEmpty()) {
                    if (this._initiatorTokenQNames.indexOf(aType) < 0) return false;
                    return true;
                }
                if (this._initiatorEncryptionTokens.isEmpty()) return isMatch;
                if (this._initiatorEncryptionTokenQNames.indexOf(aType) < 0) return false;
                return true;
            }
            if (!tc.isDebugEnabled()) throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.KeyInfoGenerator.getKey01"));
            Tr.debug(tc, "No keyInfoContentGenerator found in KeyInfoGeneratorConfig = " + anEncryptionGeneratorConfig.getEncryptionKeyInfo());
            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.KeyInfoGenerator.getKey01"));
        }
        if (!tc.isDebugEnabled()) throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.KeyInfoGenerator.getKey01"));
        Tr.debug(tc, "No EncryptionKeyInfo found in encryptionGeneratorConfig = " + anEncryptionGeneratorConfig);
        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.KeyInfoGenerator.getKey01"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean signatureGeneratorTokenMatch(PrivateGeneratorConfig.SignatureGeneratorConfImpl aSignatureGeneratorConfig, boolean isRequest) throws SoapSecurityException {
        QName aType = null;
        boolean isMatch = false;
        if (aSignatureGeneratorConfig.getSigningKeyInfo() != null) {
            KeyInfoContentGeneratorConfig aConfig = aSignatureGeneratorConfig.getSigningKeyInfo().getContentGenerator();
            if (aConfig != null) {
                aType = aConfig.getTokenGenerator().getType();
                if (aType == null) return isMatch;
                if (this._symmetricBinding) {
                    if (this._symmetricProtectionTokenAssertion != null) {
                        if (!this._symmetricProtectionTokenAssertion.getTokenType().equals(aType)) return false;
                        return true;
                    }
                    if (this._symmetricSignatureTokenAssertion == null) return isMatch;
                    if (!this._symmetricSignatureTokenAssertion.getTokenType().equals(aType)) return false;
                    return true;
                }
                if (isRequest) {
                    if (!this._initiatorTokens.isEmpty()) {
                        if (this._initiatorTokenQNames.indexOf(aType) < 0) return false;
                        return true;
                    }
                    if (this._initiatorSignatureTokens.isEmpty()) return isMatch;
                    if (this._initiatorSignatureTokenQNames.indexOf(aType) < 0) return false;
                    return true;
                }
                if (!this._recipientTokens.isEmpty()) {
                    if (this._recipientTokenQNames.indexOf(aType) < 0) return false;
                    return true;
                }
                if (this._recipientSignatureTokens.isEmpty()) return isMatch;
                if (this._recipientSignatureTokenQNames.indexOf(aType) < 0) return false;
                return true;
            }
            if (!tc.isDebugEnabled()) throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.KeyInfoGenerator.getKey01"));
            Tr.debug(tc, "No keyInfoContentGenerator found in KeyInfoGeneratorConfig = " + aSignatureGeneratorConfig.getSigningKeyInfo());
            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.KeyInfoGenerator.getKey01"));
        }
        if (!tc.isDebugEnabled()) throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.KeyInfoGenerator.getKey01"));
        Tr.debug(tc, "No SigningKeyInfo found in signatureGeneratorConfig = " + aSignatureGeneratorConfig);
        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.KeyInfoGenerator.getKey01"));
    }

    private String getKeyInfoTypeForEncryption(QName tokenType, boolean isRequest) throws SoapSecurityException {
        String keyInfoType = null;
        PrivateCommonConfig.TokenAssertion matchingTokenAssertion = null;
        if (tokenType != null) {
            int index;
            if (this._symmetricBinding) {
                if (this._symmetricProtectionTokenAssertion != null) {
                    if (this._symmetricProtectionTokenAssertion.getTokenType().equals(tokenType)) {
                        matchingTokenAssertion = this._symmetricProtectionTokenAssertion;
                    }
                } else if (this._symmetricEncryptionTokenAssertion != null && this._symmetricEncryptionTokenAssertion.getTokenType().equals(tokenType)) {
                    matchingTokenAssertion = this._symmetricEncryptionTokenAssertion;
                }
            } else if (isRequest) {
                int index2;
                if (!this._recipientTokens.isEmpty()) {
                    int index3 = this._recipientTokenQNames.indexOf(tokenType);
                    if (index3 >= 0) {
                        matchingTokenAssertion = (PrivateCommonConfig.TokenAssertion)this._recipientTokens.get(index3);
                    }
                } else if (!this._recipientEncryptionTokens.isEmpty() && (index2 = this._recipientEncryptionTokenQNames.indexOf(tokenType)) >= 0) {
                    matchingTokenAssertion = (PrivateCommonConfig.TokenAssertion)this._recipientEncryptionTokens.get(index2);
                }
            } else if (!this._initiatorTokens.isEmpty()) {
                int index4 = this._initiatorTokenQNames.indexOf(tokenType);
                if (index4 >= 0) {
                    matchingTokenAssertion = (PrivateCommonConfig.TokenAssertion)this._initiatorTokens.get(index4);
                }
            } else if (!this._initiatorEncryptionTokens.isEmpty() && (index = this._initiatorEncryptionTokenQNames.indexOf(tokenType)) >= 0) {
                matchingTokenAssertion = (PrivateCommonConfig.TokenAssertion)this._initiatorEncryptionTokens.get(index);
            }
        }
        if (matchingTokenAssertion != null) {
            keyInfoType = this.getKeyInfoType(matchingTokenAssertion);
        }
        return keyInfoType;
    }

    private String getKeyInfoTypeForSignature(QName tokenType, boolean isRequest) throws SoapSecurityException {
        PrivateCommonConfig.TokenAssertion matchingTokenAssertion = null;
        String keyInfoType = null;
        if (tokenType != null) {
            int index;
            if (this._symmetricBinding) {
                if (this._symmetricProtectionTokenAssertion != null) {
                    if (this._symmetricProtectionTokenAssertion.getTokenType().equals(tokenType)) {
                        matchingTokenAssertion = this._symmetricProtectionTokenAssertion;
                    }
                } else if (this._symmetricSignatureTokenAssertion != null && this._symmetricSignatureTokenAssertion.getTokenType().equals(tokenType)) {
                    matchingTokenAssertion = this._symmetricSignatureTokenAssertion;
                }
            } else if (isRequest) {
                int index2;
                if (!this._initiatorTokens.isEmpty()) {
                    int index3 = this._initiatorTokenQNames.indexOf(tokenType);
                    if (index3 >= 0) {
                        matchingTokenAssertion = (PrivateCommonConfig.TokenAssertion)this._initiatorTokens.get(index3);
                    }
                } else if (!this._initiatorSignatureTokens.isEmpty() && (index2 = this._initiatorSignatureTokenQNames.indexOf(tokenType)) >= 0) {
                    matchingTokenAssertion = (PrivateCommonConfig.TokenAssertion)this._initiatorSignatureTokens.get(index2);
                }
            } else if (!this._recipientTokens.isEmpty()) {
                int index4 = this._recipientTokenQNames.indexOf(tokenType);
                if (index4 >= 0) {
                    matchingTokenAssertion = (PrivateCommonConfig.TokenAssertion)this._recipientTokens.get(index4);
                }
            } else if (!this._recipientSignatureTokens.isEmpty() && (index = this._recipientSignatureTokenQNames.indexOf(tokenType)) >= 0) {
                matchingTokenAssertion = (PrivateCommonConfig.TokenAssertion)this._recipientSignatureTokens.get(index);
            }
        }
        if (matchingTokenAssertion != null) {
            keyInfoType = this.getKeyInfoType(matchingTokenAssertion);
        }
        return keyInfoType;
    }

    private String getKeyInfoType(PrivateCommonConfig.TokenAssertion aTokenAssertion) {
        String keyInfoType = null;
        if (aTokenAssertion != null) {
            if (aTokenAssertion.requireKeyIdentifierReference()) {
                keyInfoType = "KEYID";
            } else if (aTokenAssertion.requireIssuerSerialReference()) {
                keyInfoType = "X509ISSUER";
            } else if (aTokenAssertion.requireEmbeddedTokenReference()) {
                keyInfoType = "EMB";
            } else if (aTokenAssertion.requireThumbprintReference()) {
                keyInfoType = "THUMBPRINT";
            } else if (aTokenAssertion.requireSTRReference()) {
                keyInfoType = "STRREF";
            }
        }
        return keyInfoType;
    }

    private PrivateCommonConfig.TokenAssertion tokenAssertion(String tokenName, List<?> policyAssertionList) throws SoapSecurityException {
        PrivateCommonConfig.TokenAssertion aTokenAssertion = null;
        if (tokenName != null) {
            if (tokenName.equals("X509Token")) {
                aTokenAssertion = new PrivateCommonConfig.TokenAssertion();
                boolean requireXxxReferenceSpecified = false;
                if (policyAssertionList != null && policyAssertionList.size() != 0) {
                    for (int a = 0; a < policyAssertionList.size(); ++a) {
                        Object objN = policyAssertionList.get(a);
                        if (!(objN instanceof String)) continue;
                        String tokenSpecificationName = (String)objN;
                        if ("RequireDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireDerivedKeys = true;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added RequireDerivedKeys");
                            continue;
                        }
                        if ("RequireImplicitDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireImplicitDerivedKeys = true;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added RequireImplicitDerivedKeys");
                            continue;
                        }
                        if ("RequireExplicitDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireExplicitDerivedKeys = true;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added RequireExplicitDerivedKeys");
                            continue;
                        }
                        if ("WssX509V3Token10".equals(tokenSpecificationName)) {
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.X509V3_OLD;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added WssX509V3Token10");
                            continue;
                        }
                        if ("WssX509Pkcs7Token10".equals(tokenSpecificationName)) {
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.PKCS7;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added WssX509Pkcs7Token10");
                            continue;
                        }
                        if ("WssX509PkiPathV1Token10".equals(tokenSpecificationName)) {
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.PKI_PATH;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added WssX509PkiPathV1Token10");
                            continue;
                        }
                        if ("WssX509V1Token11".equals(tokenSpecificationName)) {
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.X509V3_11_V1;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added WssX509V1Token11");
                            continue;
                        }
                        if ("WssX509V3Token11".equals(tokenSpecificationName)) {
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.X509V3_11_V3;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added WssX509V3Token11");
                            continue;
                        }
                        if ("WssX509Pkcs7Token11".equals(tokenSpecificationName)) {
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.PKCS711;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added WssX509Pkcs7Token11");
                            continue;
                        }
                        if ("WssX509PkiPathV1Token11".equals(tokenSpecificationName)) {
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.PKI_PATH11;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added WssX509PkiPathV1Token11");
                            continue;
                        }
                        if ("RequireKeyIdentifierReference".equals(tokenSpecificationName)) {
                            if (requireXxxReferenceSpecified) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s05", new String[]{tokenSpecificationName}));
                            }
                            requireXxxReferenceSpecified = true;
                            aTokenAssertion._requireKeyIdentifierReference = true;
                            aTokenAssertion._requireSTRReference = false;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added RequireKeyIdentifierReference");
                            continue;
                        }
                        if ("RequireIssuerSerialReference".equals(tokenSpecificationName)) {
                            if (requireXxxReferenceSpecified) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s05", new String[]{tokenSpecificationName}));
                            }
                            requireXxxReferenceSpecified = true;
                            aTokenAssertion._requireIssuerSerialReference = true;
                            aTokenAssertion._requireSTRReference = false;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added RequireIssuerSerialReference");
                            continue;
                        }
                        if ("RequireEmbeddedTokenReference".equals(tokenSpecificationName)) {
                            if (requireXxxReferenceSpecified) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s05", new String[]{tokenSpecificationName}));
                            }
                            requireXxxReferenceSpecified = true;
                            aTokenAssertion._requireEmbeddedTokenReference = true;
                            aTokenAssertion._requireSTRReference = false;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added RequireEmbeddedTokenReference");
                            continue;
                        }
                        if (!"RequireThumbprintReference".equals(tokenSpecificationName)) continue;
                        if (requireXxxReferenceSpecified) {
                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s05", new String[]{tokenSpecificationName}));
                        }
                        requireXxxReferenceSpecified = true;
                        aTokenAssertion._requireThumbprintReference = true;
                        aTokenAssertion._requireSTRReference = false;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "the policy assertion for X509TOKEN has added RequireThumbprintReference");
                    }
                }
            } else if (tokenName.equals("UsernameToken")) {
                aTokenAssertion = new PrivateCommonConfig.TokenAssertion();
                if (policyAssertionList != null && policyAssertionList.size() != 0) {
                    for (int a = 0; a < policyAssertionList.size(); ++a) {
                        Object objN = policyAssertionList.get(a);
                        if (!(objN instanceof String)) continue;
                        String tokenSpecificationName = (String)objN;
                        if ("RequireDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireDerivedKeys = true;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for USERNAMETOKEN has added RequireDerivedKeys");
                            continue;
                        }
                        if ("RequireImplicitDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireImplicitDerivedKeys = true;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for USERNAMETOKEN has added RequireImplicitDerivedKeys");
                            continue;
                        }
                        if ("RequireExplicitDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireExplicitDerivedKeys = true;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for USERNAMETOKEN has added RequireExplicitDerivedKeys");
                            continue;
                        }
                        if ("NoPassword".equals(tokenSpecificationName)) {
                            aTokenAssertion._requirePassword = false;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for USERNAMETOKEN has set requirePassword to false");
                            continue;
                        }
                        if ("WssUsernameToken10".equals(tokenSpecificationName)) {
                            if (aTokenAssertion._tokenType != null) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s18", new String[]{aTokenAssertion._tokenType.toString(), tokenSpecificationName}));
                            }
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.UNTOKEN;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "WssUsernameToken10");
                            continue;
                        }
                        if (!"WssUsernameToken11".equals(tokenSpecificationName)) continue;
                        if (aTokenAssertion._tokenType != null) {
                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s18", new String[]{aTokenAssertion._tokenType.toString(), tokenSpecificationName}));
                        }
                        aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "WssUsernameToken11");
                    }
                }
            } else if (tokenName.equals("KerberosToken")) {
                aTokenAssertion = new PrivateCommonConfig.TokenAssertion();
                if (policyAssertionList != null && policyAssertionList.size() != 0) {
                    for (int a = 0; a < policyAssertionList.size(); ++a) {
                        Object objN = policyAssertionList.get(a);
                        if (!(objN instanceof String)) continue;
                        String tokenSpecificationName = (String)objN;
                        if ("RequireDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireDerivedKeys = true;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for KERBEROS_TOKEN has added RequireDerivedKeys");
                            continue;
                        }
                        if ("RequireImplicitDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireImplicitDerivedKeys = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "the policy assertion for KERBEROS_TOKEN has added RequireImplicitDerivedKeys");
                            }
                            Tr.warning(tc, ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s05", new String[]{tokenSpecificationName}));
                            continue;
                        }
                        if ("RequireExplicitDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireExplicitDerivedKeys = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "the policy assertion for KERBEROS_TOKEN has added RequireExplicitDerivedKeys");
                            }
                            Tr.warning(tc, ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s05", new String[]{tokenSpecificationName}));
                            continue;
                        }
                        if ("RequireKeyIdentifierReference".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireKeyIdentifierReference = true;
                            aTokenAssertion._requireSTRReference = false;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for KERBEROS_TOKEN has added RequireExplicitDerivedKeys");
                            continue;
                        }
                        if ("WssKerberosV5ApReqToken11".equals(tokenSpecificationName)) {
                            if (aTokenAssertion._tokenType != null) {
                                Tr.error(tc, ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s06"));
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s06"));
                            }
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.KERBEROSV5;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "WssKerberosV5ApReqToken11");
                            continue;
                        }
                        if (!"WssGssKerberosV5ApReqToken11".equals(tokenSpecificationName)) continue;
                        if (aTokenAssertion._tokenType != null) {
                            Tr.error(tc, ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s07"));
                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s06"));
                        }
                        aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.KERBEROSV5_GSS;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "WssGssKerberosV5ApReqToken11");
                    }
                }
            } else if (tokenName.equals("SecureConversationToken")) {
                aTokenAssertion = new PrivateCommonConfig.TokenAssertion();
                this._scEnabled = true;
                aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SC_200502;
                if (policyAssertionList != null && policyAssertionList.size() != 0) {
                    for (int a = 0; a < policyAssertionList.size(); ++a) {
                        Object objN = policyAssertionList.get(a);
                        if (!(objN instanceof String)) continue;
                        String tokenSpecificationName = (String)objN;
                        if ("RequireDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireDerivedKeys = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "the policy assertion for SECURECONVERSATIONTOKEN has added RequireDerivedKeys");
                            }
                        } else if ("RequireImplicitDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireImplicitDerivedKeys = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "the policy assertion for SECURECONVERSATIONTOKEN has added RequireImplicitDerivedKeys");
                            }
                        } else if ("RequireExplicitDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireExplicitDerivedKeys = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "the policy assertion for SECURECONVERSATIONTOKEN has added RequireExplicitDerivedKeys");
                            }
                        } else if ("RequireExternalUriReference".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireExternalUriReference = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "the policy assertion for SECURECONVERSATIONTOKEN has added RequireExternalUriReference");
                            }
                        } else if ("SC200502SecurityContextToken".equals(tokenSpecificationName)) {
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SC_200502;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "the policy assertion for SECURECONVERSATIONTOKEN has added SC200502SecurityContextToken");
                            }
                        } else if ("SC13SecurityContextToken".equals(tokenSpecificationName)) {
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "the policy assertion for SECURECONVERSATIONTOKEN has added SC13SecurityContextToken");
                            }
                        } else if ("BootstrapPolicy".equals(tokenSpecificationName)) {
                            if (this._request) {
                                aTokenAssertion._hasBootStrap = true;
                                try {
                                    WSSOutboundBinding outboundBinding = null;
                                    WSSInboundBinding inboundBinding = null;
                                    if (!this._useDefault) {
                                        List<WSSBinding> securityBindingList = securityBindings.getSecurityBindings();
                                        for (int i = 0; i < securityBindingList.size(); ++i) {
                                            WSSBinding securityBinding = securityBindingList.get(i);
                                            if (!securityBinding.getName().equals("bootstrap")) continue;
                                            outboundBinding = securityBinding.getSecurityOutboundBindingConfig();
                                            inboundBinding = securityBinding.getSecurityInboundBindingConfig();
                                            this._bootstrapConsumerConfig = new PolicyInboundConfig(inboundBinding, this.bootstrapPolicy, false, null, this.defaultConfiguration);
                                            this._bootstrapGeneratorConfig = new PolicyOutboundConfig(outboundBinding, this.bootstrapPolicy, true, null, this.defaultConfiguration);
                                        }
                                    } else {
                                        this._bootstrapConsumerConfig = new PolicyInboundConfig(inboundBinding, this.bootstrapPolicy, false, null, this.defaultConfiguration);
                                        this._bootstrapGeneratorConfig = new PolicyOutboundConfig(outboundBinding, this.bootstrapPolicy, true, null, this.defaultConfiguration);
                                    }
                                }
                                catch (Exception e) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Exception while loading bootstrap config:", e);
                                    }
                                    Tr.error(tc, "security.wssecurity.PolicyOutboundConfig.s10", e.getMessage());
                                    throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.s10", e.getMessage());
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "The assertion for BootstrapPolicy processed");
                                }
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "BootstrapPolicy not processed since this is a response.");
                            }
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "The SecureConversation assertion processed");
                    }
                }
            } else if (tokenName.equals("LTPAToken") || tokenName.equals("LTPAPropagationToken") || tokenName.equals("CustomToken")) {
                aTokenAssertion = new PrivateCommonConfig.TokenAssertion();
                if (policyAssertionList != null && policyAssertionList.size() != 0) {
                    for (int a = 0; a < policyAssertionList.size(); ++a) {
                        Object objN = policyAssertionList.get(a);
                        if (!(objN instanceof QName)) continue;
                        aTokenAssertion._tokenType = (QName)objN;
                    }
                }
            } else {
                throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s01", new String[]{tokenName});
            }
        }
        return aTokenAssertion;
    }

    private PrivateCommonConfig.TokenAssertion getTokenTypeAssertion(ProtectionOrSupportingToken anAssertion) throws SoapSecurityException {
        List<QName> wssTokenAssertions;
        String requiredTokenName = anAssertion.getType();
        PrivateCommonConfig.TokenAssertion aTokenAssertion = null;
        List<String> tokenAssertions = anAssertion.getTokenAssertions();
        if (tokenAssertions != null && tokenAssertions.size() > 0) {
            if (anAssertion.isSecureConversationToken()) {
                this.bootstrapPolicy = anAssertion.getBootstrapPolicy();
            }
            aTokenAssertion = this.tokenAssertion(requiredTokenName, tokenAssertions);
        }
        if ((wssTokenAssertions = anAssertion.getWssTokenAssertions()) != null && wssTokenAssertions.size() > 0) {
            aTokenAssertion = this.tokenAssertion(requiredTokenName, wssTokenAssertions);
        }
        if (aTokenAssertion != null) {
            aTokenAssertion._includeToken = anAssertion.getIncludeToken();
            Object issuer = anAssertion.getIssuer();
            if (issuer != null) {
                if (issuer instanceof org.xmlsoap.schemas.ws._2004._08.addressing.EndpointReferenceType) {
                    aTokenAssertion._issuer = anAssertion.getIssuer();
                }
            } else {
                issuer = anAssertion.getIssuer200508();
                if (issuer != null && issuer instanceof EndpointReferenceType) {
                    aTokenAssertion._issuer200508 = anAssertion.getIssuer200508();
                }
            }
        }
        return aTokenAssertion;
    }

    private void algorithmSuiteAssertion(String algorithmSuiteElement) {
        if (PolicyConfigUtil.isValidAlgorithmSuite(algorithmSuiteElement)) {
            if (this._symmetricBinding) {
                this.algorithmSuite = algorithmSuiteElement;
                this.symmetricSignatureAlgorithm = PolicyConfigUtil.getAlgorithm(algorithmSuiteElement, 0);
            } else {
                this.asymmetricSignatureAlgorithm = PolicyConfigUtil.getAlgorithm(algorithmSuiteElement, 1);
            }
            this.digestAlgorithm = PolicyConfigUtil.getAlgorithm(algorithmSuiteElement, 2);
            this.encryptionAlgorithm = PolicyConfigUtil.getAlgorithm(algorithmSuiteElement, 3);
            this.keyEncryptionAlgorithm = PolicyConfigUtil.getAlgorithm(algorithmSuiteElement, 5);
        } else if ("InclusiveC14N".equals(algorithmSuiteElement)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found C14N inclusive");
            }
            this.transformAlgorithm = "http://www.w3.org/2001/10/xml-c14n#";
            this.canonicalizationAlgorithm = "http://www.w3.org/2001/10/xml-c14n#";
        } else if ("SOAPNormalization10".equals(algorithmSuiteElement)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found SOAPNormalization10");
            }
        } else if ("STRTransform10".equals(algorithmSuiteElement)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found STRT10");
            }
        } else if ("XPath10".equals(algorithmSuiteElement)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found XPATH10");
            }
        } else if ("XPath20".equals(algorithmSuiteElement)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found STRT10");
            }
        } else if ("AbsXPath".equals(algorithmSuiteElement)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found ABSXPATH");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WARNING: invalid algorithm suite [" + algorithmSuiteElement + "] specified on EncryptedParts .");
        }
    }

    private String layoutAssertion(String layoutElement) {
        String layoutAssertion = null;
        if ("Strict".equals(layoutElement)) {
            layoutAssertion = "Strict";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found Strict");
            }
        } else if ("Lax".equals(layoutElement)) {
            layoutAssertion = "Lax";
            if (tc.isDebugEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found Lax");
            }
        } else if ("LaxTsFirst".equals(layoutElement)) {
            layoutAssertion = "LaxTsFirst";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found LaxTsFirst");
            }
        } else if ("LaxTsLast".equals(layoutElement)) {
            layoutAssertion = "LaxTsLast";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found LaxTsLast");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WARNING: invalid algorithm suite [" + layoutElement + "] specified on EncryptedParts .");
        }
        return layoutAssertion;
    }

    private boolean retrieveAssertions(String id, boolean isRequest) {
        boolean retrieveAssertion = false;
        if (id == null) {
            retrieveAssertion = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No wsu:Id for Policy element found; ignoring.");
            }
        } else if (id.startsWith("request:") && isRequest) {
            retrieveAssertion = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Matching outbound request wsu:Id found: " + id);
            }
        } else if (id.startsWith("response:") && !isRequest) {
            retrieveAssertion = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Matching outbound response wsu:Id found: " + id);
            }
        } else {
            retrieveAssertion = false;
            if (tc.isDebugEnabled()) {
                if (isRequest) {
                    Tr.debug(tc, "wsu:Id found not applicable for outbound request messages: " + id);
                } else {
                    Tr.debug(tc, "wsu:Id found not applicable for outbound response messages: " + id);
                }
            }
        }
        return retrieveAssertion;
    }

    @Override
    public PrivateGeneratorConfig getBootstrapGeneratorConfig() {
        return this._bootstrapGeneratorConfig;
    }

    @Override
    public PrivateConsumerConfig getBootstrapConsumerConfig() {
        return this._bootstrapConsumerConfig;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String getSymmetricSignatureAlgorithm() {
        return this.symmetricSignatureAlgorithm;
    }

    public String getAlgorithmSuite() {
        return this.algorithmSuite;
    }

    public String getSCTIssuer() {
        if (this._symmetricProtectionTokenAssertion != null) {
            if (this._symmetricProtectionTokenAssertion._issuer != null && this._symmetricProtectionTokenAssertion._issuer.getAddress() != null) {
                return this._symmetricProtectionTokenAssertion._issuer.getAddress().getValue();
            }
            if (this._symmetricProtectionTokenAssertion._issuer200508 != null && this._symmetricProtectionTokenAssertion._issuer200508.getAddress() != null) {
                return this._symmetricProtectionTokenAssertion._issuer200508.getAddress().getValue();
            }
        }
        return null;
    }

    public boolean isTargetBindingsUsing10NS() {
        return this.isTargetBindingUsing10NS;
    }

    public boolean isDefaultBindingsUsing10NS() {
        return this.isDefaultBindingUsing10NS;
    }

    private void mapPolicyAssertionsToProperties(boolean isTargetNamespaceDraft12, boolean isRequest) {
        for (PrivateGeneratorConfig.TokenGeneratorConfImpl tconfig : this._tokenGenerators) {
            PrivateCommonConfig.TokenAssertion anAssertion = null;
            if (tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.SCT_13) || tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.SCT)) {
                if ((this._symmetricProtectionTokenAssertion != null || this._symmetricEncryptionTokenAssertion != null) && tconfig._usedForEncryption) {
                    anAssertion = this._symmetricProtectionTokenAssertion != null ? this._symmetricProtectionTokenAssertion : this._symmetricEncryptionTokenAssertion;
                }
                if ((this._symmetricProtectionTokenAssertion != null || this._symmetricSignatureTokenAssertion != null) && tconfig._usedForSignature) {
                    anAssertion = this._symmetricProtectionTokenAssertion != null ? this._symmetricProtectionTokenAssertion : this._symmetricSignatureTokenAssertion;
                }
                if (anAssertion != null && anAssertion.requireExternalUriReference()) {
                    tconfig.getProperties().put("com.ibm.ws.wssecurity.sc.dkt.externalURIReference", anAssertion._requireExternalUriReference);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added token config property for RequireExternalUriReference");
                    }
                }
            }
            if (!isTargetNamespaceDraft12 && (tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.KERBEROSV5) || tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.KERBEROSV5_GSS))) {
                if ((this._symmetricProtectionTokenAssertion != null || this._symmetricEncryptionTokenAssertion != null) && tconfig._usedForEncryption) {
                    anAssertion = this._symmetricProtectionTokenAssertion != null ? this._symmetricProtectionTokenAssertion : this._symmetricEncryptionTokenAssertion;
                }
                if (this._symmetricProtectionTokenAssertion == null && this._symmetricSignatureTokenAssertion == null || !tconfig._usedForSignature) continue;
                if (this._symmetricProtectionTokenAssertion != null) {
                    anAssertion = this._symmetricProtectionTokenAssertion;
                    continue;
                }
                anAssertion = this._symmetricSignatureTokenAssertion;
                continue;
            }
            if (!isTargetNamespaceDraft12 && (tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN) || tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11))) {
                if (tconfig._aTokenAssertion == null || tconfig._aTokenAssertion._requirePassword || tconfig._callbackHandler == null) continue;
                tconfig._callbackHandler._properties.put(Constants.WSSECURITY_USE_IDASSERTION, "true");
                continue;
            }
            if ((this._symmetricProtectionTokenAssertion != null || this._symmetricEncryptionTokenAssertion != null) && tconfig._usedForEncryption) {
                anAssertion = this._symmetricProtectionTokenAssertion != null ? this._symmetricProtectionTokenAssertion : this._symmetricEncryptionTokenAssertion;
            }
            if ((this._symmetricProtectionTokenAssertion != null || this._symmetricSignatureTokenAssertion != null) && tconfig._usedForSignature) {
                anAssertion = this._symmetricProtectionTokenAssertion != null ? this._symmetricProtectionTokenAssertion : this._symmetricSignatureTokenAssertion;
            }
            if (anAssertion == null || !anAssertion._requireImplicitDerivedKeys) continue;
            tconfig.getProperties().put("RequiredImpliedDerivedKeys", anAssertion._requireImplicitDerivedKeys);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Added token config property for implicit derived keys");
        }
        if (!isTargetNamespaceDraft12) {
            for (String key : this.nameKeyInfo.keySet()) {
                List initiatorTokenList;
                int index;
                List recipientTokenList;
                PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl aKeyInfo = (PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)this.nameKeyInfo.get(key);
                PrivateGeneratorConfig.TokenGeneratorConfImpl aTokenGen = aKeyInfo._tokenGenerator;
                PrivateCommonConfig.TokenAssertion aTokenAssertion = null;
                if (this._symmetricBinding) {
                    if (aTokenGen._usedForEncryption) {
                        if (this._symmetricProtectionTokenAssertion != null || this._symmetricEncryptionTokenAssertion != null) {
                            aTokenAssertion = this._symmetricProtectionTokenAssertion != null ? this._symmetricProtectionTokenAssertion : this._symmetricEncryptionTokenAssertion;
                        }
                    } else if (aTokenGen._usedForSignature && (this._symmetricProtectionTokenAssertion != null || this._symmetricSignatureTokenAssertion != null)) {
                        aTokenAssertion = this._symmetricProtectionTokenAssertion != null ? this._symmetricProtectionTokenAssertion : this._symmetricSignatureTokenAssertion;
                    }
                } else if (aTokenGen._usedForEncryption) {
                    if (isRequest) {
                        if (!this._recipientTokens.isEmpty() || !this._recipientEncryptionTokens.isEmpty()) {
                            recipientTokenList = null;
                            index = 0;
                            if (!this._recipientTokens.isEmpty()) {
                                recipientTokenList = this._recipientTokens;
                                index = this._recipientTokenQNames.indexOf(aTokenGen._type);
                            } else {
                                recipientTokenList = this._recipientEncryptionTokens;
                                index = this._recipientEncryptionTokenQNames.indexOf(aTokenGen._type);
                            }
                            if (index >= 0) {
                                aTokenAssertion = (PrivateCommonConfig.TokenAssertion)recipientTokenList.get(index);
                            }
                        }
                    } else if (!this._initiatorTokens.isEmpty() || !this._initiatorEncryptionTokens.isEmpty()) {
                        initiatorTokenList = null;
                        index = 0;
                        if (!this._initiatorTokens.isEmpty()) {
                            initiatorTokenList = this._initiatorTokens;
                            index = this._initiatorTokenQNames.indexOf(aTokenGen._type);
                        } else {
                            initiatorTokenList = this._initiatorEncryptionTokens;
                            index = this._initiatorEncryptionTokenQNames.indexOf(aTokenGen._type);
                        }
                        if (index >= 0) {
                            aTokenAssertion = (PrivateCommonConfig.TokenAssertion)initiatorTokenList.get(index);
                        }
                    }
                } else if (aTokenGen._usedForSignature) {
                    if (isRequest) {
                        if (!this._initiatorTokens.isEmpty() || !this._initiatorSignatureTokens.isEmpty()) {
                            initiatorTokenList = null;
                            index = 0;
                            if (!this._initiatorTokens.isEmpty()) {
                                initiatorTokenList = this._initiatorTokens;
                                index = this._initiatorTokenQNames.indexOf(aTokenGen._type);
                            } else {
                                initiatorTokenList = this._initiatorSignatureTokens;
                                index = this._initiatorSignatureTokenQNames.indexOf(aTokenGen._type);
                            }
                            if (index >= 0) {
                                aTokenAssertion = (PrivateCommonConfig.TokenAssertion)initiatorTokenList.get(index);
                            }
                        }
                    } else if (!this._recipientTokens.isEmpty() || !this._recipientSignatureTokens.isEmpty()) {
                        recipientTokenList = null;
                        index = 0;
                        if (!this._recipientTokens.isEmpty()) {
                            recipientTokenList = this._recipientTokens;
                            index = this._recipientTokenQNames.indexOf(aTokenGen._type);
                        } else {
                            recipientTokenList = this._recipientSignatureTokens;
                            index = this._recipientSignatureTokenQNames.indexOf(aTokenGen._type);
                        }
                        if (index >= 0) {
                            aTokenAssertion = (PrivateCommonConfig.TokenAssertion)recipientTokenList.get(index);
                        }
                    }
                }
                if (aTokenAssertion == null) continue;
                if (aKeyInfo._derivedKeyInfo == null) {
                    aKeyInfo._derivedKeyInfo = new DerivedKeyInfoConfig();
                }
                if (aKeyInfo._derivedKeyInfo != null) {
                    aKeyInfo._derivedKeyInfo.setRequireDerivedKeys(aTokenAssertion._requireDerivedKeys);
                    aKeyInfo._derivedKeyInfo.setRequireExplicitDerivedKeys(aTokenAssertion._requireExplicitDerivedKeys);
                    aKeyInfo._derivedKeyInfo.setRequireImpliedDerivedKeys(aTokenAssertion._requireImplicitDerivedKeys);
                }
                aKeyInfo._isRequireExternalUriReference = aTokenAssertion._requireExternalUriReference;
            }
        }
    }

    static {
        _avoid70BindingsNSCheck = false;
        String prop = System.getProperty("com.ibm.wsspi.wssecurity.avoid70BindingsNSCheck");
        if (prop != null && ("true".equalsIgnoreCase(prop) || "yes".equalsIgnoreCase(prop) || "1".equalsIgnoreCase(prop) || "on".equalsIgnoreCase(prop))) {
            _avoid70BindingsNSCheck = true;
        }
    }
}

