/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManager;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.PlatformContextUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyConfigUtil {
    protected static String policyNS = "http://schemas.xmlsoap.org/ws/2004/09/policy";
    public static final String secPolicyNS = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512";
    protected static final String secPolicyWebSphereNS = "http://www.ibm.com/xmlns/prod/websphere/200605/ws-securitypolicy-ext";
    protected static final String secPolicyWebSphere11NS = "http://www.ibm.com/xmlns/prod/websphere/200710/ws-securitypolicy-ext";
    public static final String secPolicy12NS = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702";
    public static final String secBindingNS = "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding";
    public static final String secBinding11NS = "com.ibm.xmlns.prod.websphere._200710.ws_securitybinding";
    protected static final String requestIdentifier = "request:";
    protected static final String responseIdentifier = "response:";
    protected static final String algorithmHmacSha1 = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    protected static final String algorithmRsaSha1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    protected static final String algorithmSha1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    protected static final String algorithmSha256 = "http://www.w3.org/2001/04/xmlenc#sha256";
    protected static final String algorithmSha512 = "http://www.w3.org/2001/04/xmlenc#sha512";
    protected static final String algorithmAes128 = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    protected static final String algorithmAes192 = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    protected static final String algorithmAes256 = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    protected static final String algorithmTripleDes = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    protected static final String algorithmKwAes128 = "http://www.w3.org/2001/04/xmlenc#kw-aes128-cbc";
    protected static final String algorithmKwAes192 = "http://www.w3.org/2001/04/xmlenc#kw-aes192-cbc";
    protected static final String algorithmKwAes256 = "http://www.w3.org/2001/04/xmlenc#kw-aes256-cbc";
    protected static final String algorithmKwTripleDes = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
    protected static final String algorithmKwRsaOaep = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    protected static final String algorithmKwRsa15 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    protected static final String algorithmPSha1 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
    protected static final String algorithmPSha1L128 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
    protected static final String algorithmPSha1L192 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
    protected static final String algorithmPSha1L256 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
    protected static final String algorithmXPath = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    protected static final String algorithmXPath20 = "http://www.w3.org/2002/06/xmldsig-filter2";
    protected static final String algorithmC14n = "http://www.w3.org/2001/10/xml-c14n#";
    protected static final String algorithmExC14n = "http://www.w3.org/2001/10/xml-exc-c14n#";
    protected static final String algorithmSNT = "http://www.w3.org/TR/soap12-n11n";
    protected static final String algorithmSTRT10 = "http://docs.oasis-open.org/wss/2004/xx/oasis-2004xx-wss-soap-message-security-1.0#STR-Transform";
    protected static final String BASIC256 = "Basic256";
    protected static final String BASIC192 = "Basic192";
    protected static final String BASIC128 = "Basic128";
    protected static final String TRIPLEDES = "TripleDes";
    protected static final String BASIC256_RSA15 = "Basic256Rsa15";
    protected static final String BASIC192_RSA15 = "Basic192Rsa15";
    protected static final String BASIC128_RSA15 = "Basic128Rsa15";
    protected static final String TRIPLEDES_RSA15 = "TripleDesRsa15";
    protected static final String BASIC256_SHA256 = "Basic256Sha256";
    protected static final String BASIC192_SHA256 = "Basic192Sha256";
    protected static final String BASIC128_SHA256 = "Basic128Sha256";
    protected static final String TRIPLEDES_SHA256 = "TripleDesSha256";
    protected static final String BASIC256_SHA256_RSA15 = "Basic256Sha256Rsa15";
    protected static final String BASIC192_SHA256_RSA15 = "Basic192Sha256Rsa15";
    protected static final String BASIC128_SHA256_RSA15 = "Basic128Sha256Rsa15";
    protected static final String TRIPLEDES_SHA256_RSA15 = "TripleDesSha256Rsa15";
    protected static final String INCLUSIVE_C14N = "InclusiveC14N";
    protected static final String SOAP_NORMALIZATION10 = "SOAPNormalization10";
    protected static final String STRTRANSFORM10 = "STRTransform10";
    protected static final String XPATH10 = "XPath10";
    protected static final String XPATH20 = "XPath20";
    protected static final String ABSXPATH = "AbsXPath";
    protected static final String RECIPIENT_TOKEN = "RecipientToken";
    protected static final String INITIATOR_TOKEN = "InitiatorToken";
    protected static final String INITIATOR_SIGNATURE_TOKEN = "InitiatorSignatureToken";
    protected static final String RECIPIENT_SIGNATURE_TOKEN = "RecipientSignatureToken";
    protected static final String INITIATOR_ENCRYPTION_TOKEN = "InitiatorEncryptionToken";
    protected static final String RECIPIENT_ENCRYPTION_TOKEN = "RecipientEncryptionToken";
    protected static final String ENCRYPTION_TOKEN = "EncryptionToken";
    protected static final String SIGNATURE_TOKEN = "SignatureToken";
    protected static final String PROTECTION_TOKEN = "ProtectionToken";
    protected static final String STRICT = "Strict";
    protected static final String LAX = "Lax";
    protected static final String LAX_TS_FIRST = "LaxTsFirst";
    protected static final String LAX_TS_LAST = "LaxTsLast";
    protected static final String MUST_SUPPORT_REF_KEY_IDENTIFIER = "MustSupportRefKeyIdentifier";
    protected static final String MUST_SUPPORT_REF_KEY_ISSUER_SERIAL = "MustSupportRefIssuerSerial";
    protected static final String MUST_SUPPORT_REF_EXTERNAL_URI = "MustSupportRefExternalURI";
    protected static final String MUST_SUPPORT_REF_EMBEDDED_TOKEN = "MustSupportRefEmbeddedToken";
    protected static final String MUST_SUPPORT_REF_THUMBPRINT = "MustSupportRefThumbprint";
    protected static final String MUST_SUPPORT_REF_ENCRYPTED_KEY = "MustSupportRefEncryptedKey";
    protected static final String REQUIRE_SIGNATURE_CONFIRMATION = "RequireSignatureConfirmation";
    protected static final String ONLY_SIGN_ENTIRE_HEADERS_AND_BODY = "OnlySignEntireHeadersAndBody";
    protected static final String MUST_SUPPORT_CLIENT_CHALLENGE = "MustSupportClientChallenge";
    protected static final String MUST_SUPPORT_SERVER_CHALLENGE = "MustSupportServerChallenge";
    protected static final String REQUIRE_CLIENT_ENTROPY = "RequireClientEntropy";
    protected static final String REQUIRE_SERVER_ENTROPY = "RequireServerEntropy";
    protected static final String MUST_SUPPORT_ISSUED_TOKENS = "MustSupportIssuedTokens";
    protected static final String REQUIRE_DERIVED_KEYS = "RequireDerivedKeys";
    protected static final String REQUIRE_IMPLICIT_DERIVED_KEYS = "RequireImplicitDerivedKeys";
    protected static final String REQUIRE_EXPLICIT_DERIVED_KEYS = "RequireExplicitDerivedKeys";
    protected static final String REQUIRE_IMPLIED_DERIVED_KEYS = "RequireImpliedDerivedKeys";
    public static final String REQUIRE_KEY_IDENTIFIER_REFERENCE = "RequireKeyIdentifierReference";
    public static final String REQUIRE_ISSUER_SERIAL_REFERENCE = "RequireIssuerSerialReference";
    public static final String REQUIRE_EMBEDDED_TOKEN_REFERENCE = "RequireEmbeddedTokenReference";
    public static final String REQUIRE_THUMBPRINT_REFERENCE = "RequireThumbprintReference";
    protected static final String WSS_X509V1_TOKEN10 = "WssX509V1Token10";
    protected static final String WSS_X509V3_TOKEN10 = "WssX509V3Token10";
    protected static final String WSS_X509_PKCS7_TOKEN10 = "WssX509Pkcs7Token10";
    protected static final String WSS_X509_PKI_PATH_V1_TOKEN10 = "WssX509PkiPathV1Token10";
    protected static final String WSS_X509V1_TOKEN11 = "WssX509V1Token11";
    protected static final String WSS_X509V3_TOKEN11 = "WssX509V3Token11";
    protected static final String WSS_X509_PKCS7_TOKEN11 = "WssX509Pkcs7Token11";
    protected static final String WSS_X509_PKI_PATH_V1_TOKEN11 = "WssX509PkiPathV1Token11";
    protected static final String WSS_USERNAME_TOKEN10 = "WssUsernameToken10";
    protected static final String WSS_USERNAME_TOKEN11 = "WssUsernameToken11";
    protected static final String USERNAME_TOKEN_NO_PASSWORD = "NoPassword";
    protected static final String WSS_KERBEROS_TOKENV5 = "WssKerberosV5ApReqToken11";
    protected static final String WSS_KERBEROS_TOKENV5_GSS = "WssGssKerberosV5ApReqToken11";
    protected static final String REQUIRE_EXTERNAL_URI_REFERENCE = "RequireExternalUriReference";
    protected static final String SC200502_SECURITY_CONTEXT_TOKEN = "SC200502SecurityContextToken";
    protected static final String SC13_SECURITY_CONTEXT_TOKEN = "SC13SecurityContextToken";
    protected static final String BOOTSTRAP_POLICY = "BootstrapPolicy";
    protected static final String MUST_NOT_SEND_AMEND = "MustNotSendAmend";
    protected static final String MUST_NOT_SEND_RENEW = "MustNotSendRenew";
    protected static final String MUST_NOT_SEND_CANCEL = "MustNotSendCancel";
    protected static final String WSS_CUSTOM_TOKEN = "WssCustomToken";
    protected static final String KERBEROS_TOKEN_PROFILE_SPEC = "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1";
    protected static final String USERNAME_TOKEN = "UsernameToken";
    protected static final String X509TOKEN = "X509Token";
    protected static final String SECURE_CONVERSATION_TOKEN = "SecureConversationToken";
    protected static final String CUSTOM_TOKEN = "CustomToken";
    protected static final String LTPA_TOKEN = "LTPAToken";
    protected static final String LTPA_PROPAGATION_TOKEN = "LTPAPropagationToken";
    protected static final String KERBEROS_TOKEN = "KerberosToken";
    protected static QName policyQName = new QName(policyNS, "Policy");
    protected static QName signedPartsQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "SignedParts");
    protected static QName signedElementsQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "SignedElements");
    protected static QName encryptedPartsQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "EncryptedParts");
    protected static QName encryptedElementsQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "EncryptedElements");
    protected static QName contentEncryptedElementsQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "ContentEncryptedElements");
    protected static QName usernameTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "UsernameToken");
    protected static QName wssUsernameToken10QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "WssUsernameToken10");
    protected static QName wssUsernameToken11QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "WssUsernameToken11");
    protected static QName requireDerivedKeysQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "RequireDerivedKeys");
    protected static QName requireImplicitDerivedKeysQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "RequireImplicitDerivedKeys");
    protected static QName requireExplicitDerivedKeysQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "RequireExplicitDerivedKeys");
    protected static QName X509TokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "X509Token");
    protected static QName requireKeyIdentifierReferenceQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "RequireKeyIdentifierReference");
    protected static QName requireIssuerSerialReferenceQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "RequireIssuerSerialReference");
    protected static QName requireEmbeddedTokenReferenceQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "RequireEmbeddedTokenReference");
    protected static QName requireThumbprintReferenceQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "RequireThumbprintReference");
    protected static QName WssX509V3Token10QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "WssX509V3Token10");
    protected static QName WssX509Pkcs7Token10QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "WssX509Pkcs7Token10");
    protected static QName WssX509PkiPathV1Token10QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "WssX509PkiPathV1Token10");
    protected static QName WssX509V1Token11QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "WssX509V1Token11");
    protected static QName WssX509V3Token11QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "WssX509V3Token11");
    protected static QName WssX509Pkcs7Token11QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "WssX509Pkcs7Token11");
    protected static QName WssX509PkiPathV1Token11QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "WssX509PkiPathV1Token11");
    protected static QName KerberosTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "KerberosToken");
    protected static QName WssKerberosV5ApReqToken11QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "WssKerberosV5ApReqToken11");
    protected static QName WssGssKerberosV5ApReqToken11QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "WssGssKerberosV5ApReqToken11");
    protected static QName requireExternalURIReferenceQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "RequireExternalUriReference");
    protected static QName SecureConversationTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "SecureConversationToken");
    protected static QName bootstrapPolicyQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "BootstrapPolicy");
    protected static QName SC200502SecurityContextTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "SC200502SecurityContextToken");
    protected static QName algorithmSuiteQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "AlgorithmSuite");
    protected static final QName Basic256QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Basic256");
    protected static final QName Basic192QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Basic192");
    protected static final QName Basic128QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Basic128");
    protected static final QName TripleDesQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "TripleDes");
    protected static final QName Basic256Rsa15QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Basic256Rsa15");
    protected static final QName Basic192Rsa15QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Basic192Rsa15");
    protected static final QName Basic128Rsa15QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Basic128Rsa15");
    protected static final QName TripleDesRsa15QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "TripleDesRsa15");
    protected static final QName Basic256Sha256QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Basic256Sha256");
    protected static final QName Basic192Sha256QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Basic192Sha256");
    protected static final QName Basic128Sha256QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Basic128Sha256");
    protected static final QName TripleDesSha256QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "TripleDesSha256");
    protected static final QName Basic256Sha256Rsa15QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Basic256Sha256Rsa15");
    protected static final QName Basic192Sha256Rsa15QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Basic192Sha256Rsa15");
    protected static final QName Basic128Sha256Rsa15QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Basic128Sha256Rsa15");
    protected static final QName TripleDesSha256Rsa15QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "TripleDesSha256Rsa15");
    protected static final QName InclusiveC14NQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "InclusiveC14N");
    protected static final QName SOAPNormalization10QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "SOAPNormalization10");
    protected static final QName STRTransform10QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "STRTransform10");
    protected static final QName XPath10QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "XPath10");
    protected static final QName XPathFilter20QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "XPathFilter20");
    protected static QName layoutQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Layout");
    protected static final QName StrictQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Strict");
    protected static final QName LaxQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Lax");
    protected static final QName LaxTsFirstQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "LaxTsFirst");
    protected static final QName LaxTsLastQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "LaxTsLast");
    protected static QName wssIncludeTimestampQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "IncludeTimestamp");
    protected static QName symmetricBindingQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "SymmetricBinding");
    protected static QName encryptionTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "EncryptionToken");
    protected static QName SignatureTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "SignatureToken");
    protected static QName ProtectionTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "ProtectionToken");
    protected static QName EncryptBeforeSigningQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "EncryptBeforeSigning");
    protected static QName EncryptSignatureQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "EncryptSignature");
    protected static QName asymmetricBindingQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "AsymmetricBinding");
    protected static QName InitiatorTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "InitiatorToken");
    protected static QName RecipientTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "RecipientToken");
    protected static QName supportingTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "SupportingTokens");
    protected static QName wss10QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Wss10");
    protected static QName MustSupportRefKeyIdentifierQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "MustSupportRefKeyIdentifier");
    protected static QName MustSupportRefIssuerSerialQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "MustSupportRefIssuerSerial");
    protected static QName MustSupportRefExternalURI = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "MustSupportRefExternalURI");
    protected static QName MustSupportRefEmbeddedToken = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "MustSupportRefEmbeddedToken");
    protected static QName wss11QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Wss11");
    protected static QName MustSupportRefThumbprintQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "MustSupportRefThumbprint");
    protected static QName RequireSignatureConfirmationQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "RequireSignatureConfirmation");
    protected static QName onlySignEntireHeadersAndBodyQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "OnlySignEntireHeadersAndBody");
    protected static QName trust10QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Trust10");
    protected static QName MustSupportClientChallengeQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "MustSupportClientChallenge");
    protected static QName MustSupportServerChallengeQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "MustSupportServerChallenge");
    protected static QName RequireClientEntropyQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "RequireClientEntropy");
    protected static QName RequireServerEntropyQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "RequireServerEntropy");
    protected static QName MustSupportIssuedTokensQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "MustSupportIssuedTokens");
    protected static QName bodyQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Body");
    protected static QName headerQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Header");
    protected static QName InitiatorEncryptionTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "InitiatorEncryptionToken");
    protected static QName InitiatorSignatureTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "InitiatorSignatureToken");
    protected static QName RecipientEncryptionTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "RecipientEncryptionToken");
    protected static QName RecipientSignatureTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "RecipientSignatureToken");
    protected static QName LTPATokenQName = new QName("http://www.ibm.com/xmlns/prod/websphere/200605/ws-securitypolicy-ext", "LTPAToken");
    protected static QName LTPAPropagationTokenQName = new QName("http://www.ibm.com/xmlns/prod/websphere/200605/ws-securitypolicy-ext", "LTPAPropagationToken");
    protected static QName CustomTokenQName = new QName("http://www.ibm.com/xmlns/prod/websphere/200605/ws-securitypolicy-ext", "CustomToken");
    protected static QName signedPartsQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SignedParts");
    protected static QName signedElementsQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SignedElements");
    protected static QName encryptedPartsQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "EncryptedParts");
    protected static QName encryptedElementsQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "EncryptedElements");
    protected static QName contentEncryptedElementsQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "ContentEncryptedElements");
    protected static QName asymmetricBindingQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "AsymmetricBinding");
    protected static QName symmetricBindingQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SymmetricBinding");
    protected static QName algorithmSuiteQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "AlgorithmSuite");
    protected static QName wss10QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Wss10");
    protected static QName wss11QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Wss11");
    protected static QName trust13QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Trust13");
    protected static QName supportingTokenQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SupportingTokens");
    protected static QName SignedsupportingTokenQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SignedSupportingTokens");
    protected static QName EncryptedSupportingTokens = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "EncryptedSupportingTokens");
    protected static QName SignedEncryptedSupportingTokensQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SignedEncryptedSupportingTokens");
    protected static QName layoutQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Layout");
    protected static QName usernameTokenQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "UsernameToken");
    protected static QName wssUsernameToken10QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssUsernameToken10");
    protected static QName wssUsernameToken11QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssUsernameToken11");
    protected static QName wssIncludeTimestampQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "IncludeTimestamp");
    protected static QName bootstrapPolicyQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "BootstrapPolicy");
    protected static QName wssEncryptSignatureQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "EncryptSignature");
    protected static QName wssEncryptBeforeSigningQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "EncryptBeforeSigning");
    protected static QName SC13SecurityContextTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SC13SecurityContextToken");
    protected static QName onlySignEntireHeadersAndBodyQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "OnlySignEntireHeadersAndBody");
    protected static QName LTPAToken12QName = new QName("http://www.ibm.com/xmlns/prod/websphere/200710/ws-securitypolicy-ext", "LTPAToken");
    protected static QName LTPAPropagationToken12QName = new QName("http://www.ibm.com/xmlns/prod/websphere/200710/ws-securitypolicy-ext", "LTPAPropagationToken");
    protected static QName CustomToken12QName = new QName("http://www.ibm.com/xmlns/prod/websphere/200710/ws-securitypolicy-ext", "CustomToken");
    protected static QName includeTokenQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "IncludeToken");
    protected static String includeTokenDefault12 = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702/IncludeToken/Always";
    protected static QName encryptionTokenQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "EncryptionToken");
    protected static QName InitiatorTokenQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "InitiatorToken");
    protected static QName KerberosTokenQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "KerberosToken");
    protected static QName ProtectionTokenQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "ProtectionToken");
    protected static QName RecipientTokenQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RecipientToken");
    protected static QName SecureConversationTokenQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SecureConversationToken");
    protected static QName SignatureTokenQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SignatureToken");
    protected static QName X509TokenQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "X509Token");
    protected static QName bodyQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Body");
    protected static QName headerQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Header");
    protected static QName requireDerivedKeysQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireDerivedKeys");
    protected static QName requireImplicitDerivedKeysQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireImplicitDerivedKeys");
    protected static QName requireExplicitDerivedKeysQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireExplicitDerivedKeys");
    protected static QName requireImpliedDerivedKeysQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireImplicitDerivedKeys");
    protected static QName requireIssuerSerialReferenceQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireIssuerSerialReference");
    protected static QName requireEmbeddedTokenReferenceQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireEmbeddedTokenReference");
    protected static QName requireThumbprintReferenceQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireThumbprintReference");
    protected static QName requireExternalURIReferenceQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireExternalUriReference");
    protected static QName requireKeyIdentifierReferenceQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireKeyIdentifierReference");
    protected static QName WssGssKerberosV5ApReqToken11QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssGssKerberosV5ApReqToken11");
    protected static QName WssKerberosV5ApReqToken11QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssKerberosV5ApReqToken11");
    protected static QName WssX509Pkcs7Token10QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "WssX509Pkcs7Token10");
    protected static QName WssX509PkiPathV1Token10QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssX509PkiPathV1Token10");
    protected static QName WssX509V1Token11QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssX509V1Token11");
    protected static QName WssX509V3Token11QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssX509V3Token11");
    protected static QName WssX509Pkcs7Token11QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssX509Pkcs7Token11");
    protected static QName WssX509PkiPathV1Token11QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssX509PkiPathV1Token11");
    protected static QName InitiatorEncryptionTokenQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "InitiatorEncryptionToken");
    protected static QName InitiatorSignatureTokenQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "InitiatorSignatureToken");
    protected static QName RecipientEncryptionTokenQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RecipientEncryptionToken");
    protected static QName RecipientSignatureTokenQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RecipientSignatureToken");
    protected static QName StrictQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Strict");
    protected static QName LaxQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Lax");
    protected static QName LaxTsFirstQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "LaxTsFirst");
    protected static QName Basic256QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Basic256");
    protected static QName Basic192QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Basic192");
    protected static QName Basic128QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Basic128");
    protected static QName TripleDesQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "TripleDes");
    protected static QName LaxTsLastQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "LaxTsLast");
    protected static QName Basic256Rsa15QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Basic256Rsa15");
    protected static QName Basic192Rsa15QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Basic192Rsa15");
    protected static QName Basic128Rsa15QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Basic128Rsa15");
    protected static QName TripleDesRsa15QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "TripleDesRsa15");
    protected static QName Basic256Sha256QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Basic256Sha256");
    protected static QName Basic192Sha256QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Basic192Sha256");
    protected static QName Basic128Sha256QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Basic128Sha256");
    protected static QName TripleDesSha256QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "TripleDesSha256");
    protected static QName Basic256Sha256Rsa15QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Basic256Sha256Rsa15");
    protected static QName Basic192Sha256Rsa15QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Basic192Sha256Rsa15");
    protected static QName Basic128Sha256Rsa15QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Basic128Sha256Rsa15");
    protected static QName TripleDesSha256Rsa15QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "TripleDesSha256Rsa15");
    protected static QName InclusiveC14NQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "InclusiveC14N");
    protected static QName SOAPNormalization10QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SOAPNormalization10");
    protected static QName STRTransform10QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "STRTransform10");
    protected static QName XPath10QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "XPath10");
    protected static QName XPathFilter20QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "XPathFilter20");
    protected static QName trust10QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Trust10");
    protected static QName MustSupportServerChallengeQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "MustSupportServerChallenge");
    protected static QName RequireClientEntropyQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireClientEntropy");
    protected static QName RequireServerEntropyQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireServerEntropy");
    protected static QName MustSupportIssuedTokensQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "MustSupportIssuedTokens");
    protected static QName MustSupportRefKeyIdentifierQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "MustSupportRefKeyIdentifier");
    protected static QName MustSupportRefIssuerSerialQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "MustSupportRefIssuerSerial");
    protected static QName MustSupportRefExternalURI12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "MustSupportRefExternalURI");
    protected static QName MustSupportRefEmbeddedToken12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "MustSupportRefEmbeddedToken");
    protected static QName MustSupportRefThumbprintQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "MustSupportRefThumbprint");
    protected static QName MustSupportClientChallengeQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "MustSupportClientChallenge");
    protected static QName WssX509V3Token10QName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssX509V3Token10");
    protected static QName RequireSignatureConfirmationQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireSignatureConfirmation");
    protected static QName MustNotSendAmendQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "MustNotSendAmend");
    protected static QName MustNotSendCancelQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "MustNotSendCancel");
    protected static QName MustNotSendRenewQName12 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "MustNotSendRenew");
    protected static QName exactlyOneQName = new QName(policyNS, "ExactlyOne");
    protected static QName wspAllQName = new QName(policyNS, "wspAll");
    protected static String xmiNS = "http://schema.omg.org/spec/XMI/1.0";
    protected static QName xmiLabelQName = new QName(xmiNS, "label");
    protected static final int SYMMETRIC_KEY_SIGNATURE_ALGORITHM = 0;
    protected static final int ASYMMETRIC_KEY_SIGNATURE_ALGORITHM = 1;
    protected static final int DIGEST_ALGORITHM = 2;
    protected static final int ENCRYPTION_ALGORITHM = 3;
    protected static final int SYMMETRIC_KEY_WRAP_ALGORITHM = 4;
    protected static final int ASYMMETRIC_KEY_WRAP_ALGORITHM = 5;
    protected static final int COMPUTED_KEY_ALGORITHM = 6;
    protected static final int ENCRYPTION_KEY_DERIVATION_ALGORITHM = 7;
    protected static final int SIGNATURE_KEY_DERIVATION_ALGORITHM = 8;
    protected static final String WS_SEC = "ws-security";
    protected static final String NON_WS_SEC = "non-ws-security";
    protected static final String TIMESTAMP_XPATH_11 = "/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd' and local-name()='Timestamp']";
    protected static final String SIGNATURE_XPATH_11 = "/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']";
    protected static final String USERNAMETOKEN_XPATH_11 = "/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='UsernameToken']";
    protected static final String SIGCONF_XPATH_11 = "/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd' and local-name()='SignatureConfirmation']";
    protected static final String TIMESTAMP_XPATH_12 = "/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd' and local-name()='Timestamp']";
    protected static final String SIGNATURE_XPATH_12 = "/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']";
    protected static final String USERNAMETOKEN_XPATH_12 = "/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='UsernameToken']";
    protected static final String SIGCONF_XPATH_12 = "/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd' and local-name()='SignatureConfirmation']";
    private static final TraceComponent tc = Tr.register(PolicyConfigUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = PolicyConfigUtil.class.getName();

    protected static Set<String> getAllowedAlgorithms(int algorithmType) {
        HashSet<String> allowedAlgorithms = new HashSet<String>();
        switch (algorithmType) {
            case 0: {
                allowedAlgorithms.add(algorithmRsaSha1);
                allowedAlgorithms.add(algorithmHmacSha1);
                break;
            }
            case 1: {
                allowedAlgorithms.add(algorithmHmacSha1);
                allowedAlgorithms.add(algorithmRsaSha1);
                break;
            }
            case 2: {
                allowedAlgorithms.add(algorithmSha256);
                allowedAlgorithms.add(algorithmSha1);
                break;
            }
            case 3: {
                allowedAlgorithms.add(algorithmAes256);
                allowedAlgorithms.add(algorithmAes192);
                allowedAlgorithms.add(algorithmAes128);
                allowedAlgorithms.add(algorithmTripleDes);
                break;
            }
            case 7: {
                allowedAlgorithms.add("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1");
                allowedAlgorithms.add("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1");
                allowedAlgorithms.add("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1");
                break;
            }
            case 5: {
                allowedAlgorithms.add(algorithmKwRsa15);
                allowedAlgorithms.add(algorithmKwRsaOaep);
                allowedAlgorithms.add("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1");
                break;
            }
            case 4: {
                allowedAlgorithms.add(algorithmKwAes256);
                allowedAlgorithms.add(algorithmKwAes192);
                allowedAlgorithms.add(algorithmKwAes128);
                allowedAlgorithms.add(algorithmKwTripleDes);
            }
        }
        return allowedAlgorithms;
    }

    protected static boolean isValidAlgorithmSuite(String algorithmSuite) {
        boolean validFlag = false;
        if (algorithmSuite.equals(BASIC256) || algorithmSuite.equals(BASIC192) || algorithmSuite.equals(BASIC128) || algorithmSuite.equals(TRIPLEDES) || algorithmSuite.equals(BASIC256_RSA15) || algorithmSuite.equals(BASIC192_RSA15) || algorithmSuite.equals(BASIC128_RSA15) || algorithmSuite.equals(TRIPLEDES_RSA15) || algorithmSuite.equals(BASIC256_SHA256) || algorithmSuite.equals(BASIC192_SHA256) || algorithmSuite.equals(BASIC128_SHA256) || algorithmSuite.equals(TRIPLEDES_SHA256) || algorithmSuite.equals(BASIC256_SHA256_RSA15) || algorithmSuite.equals(BASIC192_SHA256_RSA15) || algorithmSuite.equals(BASIC128_SHA256_RSA15) || algorithmSuite.equals(TRIPLEDES_SHA256_RSA15)) {
            validFlag = true;
        }
        return validFlag;
    }

    protected static String getAlgorithm(String algorithmSuite, int algorithmType) {
        String algorithm = null;
        switch (algorithmType) {
            case 0: {
                algorithm = algorithmHmacSha1;
                break;
            }
            case 1: {
                algorithm = algorithmRsaSha1;
                break;
            }
            case 6: {
                algorithm = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
                break;
            }
            case 2: {
                if (algorithmSuite.contains("Sha256")) {
                    algorithm = algorithmSha256;
                    break;
                }
                algorithm = algorithmSha1;
                break;
            }
            case 3: {
                if (algorithmSuite.contains(BASIC256)) {
                    algorithm = algorithmAes256;
                    break;
                }
                if (algorithmSuite.contains(BASIC192)) {
                    algorithm = algorithmAes192;
                    break;
                }
                if (algorithmSuite.contains(BASIC128)) {
                    algorithm = algorithmAes128;
                    break;
                }
                algorithm = algorithmTripleDes;
                break;
            }
            case 4: {
                if (algorithmSuite.contains(BASIC256)) {
                    algorithm = algorithmKwAes256;
                    break;
                }
                if (algorithmSuite.contains(BASIC192)) {
                    algorithm = algorithmKwAes192;
                    break;
                }
                if (algorithmSuite.contains(BASIC128)) {
                    algorithm = algorithmKwAes128;
                    break;
                }
                algorithm = algorithmKwTripleDes;
                break;
            }
            case 5: {
                if (algorithmSuite.contains("Rsa15")) {
                    algorithm = algorithmKwRsa15;
                    break;
                }
                algorithm = algorithmKwRsaOaep;
                break;
            }
            case 7: {
                if (algorithmSuite.contains(BASIC256)) {
                    algorithm = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
                    break;
                }
                if (algorithmSuite.contains(BASIC128)) {
                    algorithm = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
                    break;
                }
                algorithm = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
                break;
            }
            case 8: {
                algorithm = algorithmSuite.contains(BASIC128) ? "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1" : "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
            }
        }
        return algorithm;
    }

    public static String getMinimumSymmetricKeyLength(String algorithmSuite) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMinimumSymmetricKeyLength(algorithmSuite " + algorithmSuite + " )");
        }
        String keyLength = "128";
        if (algorithmSuite.contains(BASIC256)) {
            keyLength = "256";
        } else if (algorithmSuite.contains(BASIC192)) {
            keyLength = "192";
        } else if (algorithmSuite.contains(BASIC128)) {
            keyLength = "128";
        } else if (algorithmSuite.contains(TRIPLEDES)) {
            keyLength = "192";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMinimumSymmetricKeyLength(algorithmSuite " + algorithmSuite + " )" + ", returns keyLength = " + keyLength);
        }
        return keyLength;
    }

    public static String getKeywordForXPathExpression(String xpathExpression, boolean signedParts) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeywordForXPathExpression(String xpathExpression " + xpathExpression + ", boolean signedParts " + signedParts + " )");
        }
        String keyword = null;
        if (signedParts) {
            if (TIMESTAMP_XPATH_11.equals(xpathExpression) || TIMESTAMP_XPATH_12.equals(xpathExpression)) {
                keyword = IntegralDialectElementSelector.WASDIALECTS[1];
            } else if (SIGCONF_XPATH_11.equals(xpathExpression) || SIGCONF_XPATH_12.equals(xpathExpression)) {
                keyword = IntegralDialectElementSelector.WASDIALECTS[14];
            }
        } else if (SIGNATURE_XPATH_11.equals(xpathExpression) || SIGNATURE_XPATH_12.equals(xpathExpression)) {
            keyword = ConfidentialDialectElementSelector.WASDIALECTS[3];
        } else if (USERNAMETOKEN_XPATH_11.equals(xpathExpression) || USERNAMETOKEN_XPATH_12.equals(xpathExpression)) {
            keyword = ConfidentialDialectElementSelector.WASDIALECTS[1];
        } else if (TIMESTAMP_XPATH_11.equals(xpathExpression) || TIMESTAMP_XPATH_12.equals(xpathExpression)) {
            keyword = ConfidentialDialectElementSelector.WASDIALECTS[5];
        } else if (SIGCONF_XPATH_11.equals(xpathExpression) || SIGCONF_XPATH_12.equals(xpathExpression)) {
            keyword = ConfidentialDialectElementSelector.WASDIALECTS[6];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeywordForXPathExpression(String xpathExpression, boolean signedParts), returns keyword = " + keyword);
        }
        return keyword;
    }

    public static void checkLTPATokenValid(QName qn, PrivateGeneratorConfig.TokenGeneratorConfImpl tconfig) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkLTPATokenValid(QName qn=" + qn.toString() + ", TokenGeneratorConfImpl tconfig=" + tconfig + ")");
        }
        if (PlatformContextUtil.isWebSphereThinClient()) {
            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyOutboundConfig.s02"));
        }
        if (com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN.equals(qn)) {
            boolean sso_interop = false;
            WSSContextManager ctxMgr = WSSContextManagerFactory.getInstance();
            if (ctxMgr != null) {
                sso_interop = ctxMgr.getSSOInteropModeEnabled();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSO_INTEROP_MODE_ENABLED = [" + sso_interop + "]");
            }
            tconfig._properties.put("com.ibm.ws.security.ssoInteropModeEnabled", Boolean.toString(sso_interop));
            boolean previousTokenGeneratorBehavior = false;
            Map<Object, Object> props = tconfig.getProperties();
            String previousTokenGeneratorBehaviorString = (String)props.get(Constants.LTPAV1_TOKEN_GENERATE_PRE_V7);
            if (previousTokenGeneratorBehaviorString != null) {
                previousTokenGeneratorBehavior = ConfigUtil.isTrue(previousTokenGeneratorBehaviorString);
            }
            if (!sso_interop && !previousTokenGeneratorBehavior) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The configuration requires LTPA v1 token, but the token stored in the Subject is LTPA v2. This is because SSO_INTEROP_MODE_ENABLED is false.");
                }
                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyOutboundConfig.s01", new String[]{qn.toString(), "com.ibm.ws.security.ssoInteropModeEnabled", com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.toString()}));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkLTPATokenValid(QName qn, TokenGeneratorConfImpl tconfig)");
            }
        }
    }
}

