/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.ws.wssecurity.handler.ProtectionOrSupportingToken;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyBinding {
    private boolean symmetricBinding = false;
    private boolean includeTimestamp = false;
    private List<ProtectionOrSupportingToken> protectionTokens = new ArrayList<ProtectionOrSupportingToken>();
    private List<String> algorithmSuiteAssertions = new ArrayList<String>();
    private String layoutAssertion = null;
    private boolean encryptSignature = false;
    private boolean signBeforeEncrypting = true;
    private boolean onlySignEntireHeadersAndBody = false;

    public PolicyBinding(boolean isSymmetricBinding) {
        this.symmetricBinding = isSymmetricBinding;
    }

    public void setIncludeTimestamp(boolean timestamp) {
        this.includeTimestamp = timestamp;
    }

    public void addAlgorithmSuite(String algorithmSuite) {
        this.algorithmSuiteAssertions.add(algorithmSuite);
    }

    public void setLayout(String layout) {
        this.layoutAssertion = layout;
    }

    public void addProtectionToken(ProtectionOrSupportingToken token) {
        this.protectionTokens.add(token);
    }

    public boolean isSymmetricBinding() {
        return this.symmetricBinding;
    }

    public boolean isIncludeTimestamp() {
        return this.includeTimestamp;
    }

    public List<ProtectionOrSupportingToken> getProtectionTokens() {
        return this.protectionTokens;
    }

    public List<String> getAlgorithmSuites() {
        return this.algorithmSuiteAssertions;
    }

    public String getLayout() {
        return this.layoutAssertion;
    }

    public void setEncryptSignature(boolean encryptSignature) {
        this.encryptSignature = encryptSignature;
    }

    public boolean isEncryptSignature() {
        return this.encryptSignature;
    }

    public void setEncryptBeforeSigning() {
        this.signBeforeEncrypting = false;
    }

    public void setSignBeforeEncrypting() {
        this.signBeforeEncrypting = true;
    }

    public boolean isSignBeforeEncrypting() {
        return this.signBeforeEncrypting;
    }

    public void setOnlySignEntireHeadersAndBody() {
        this.onlySignEntireHeadersAndBody = true;
    }

    public boolean isOnlySignEntireHeadersAndBody() {
        return this.onlySignEntireHeadersAndBody;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
        buf.append("symmetricBinding=[").append(this.symmetricBinding).append("], ");
        buf.append("includeTimestamp=[").append(this.includeTimestamp).append("], ");
        buf.append("algorithmSuites=[").append(this.algorithmSuiteAssertions).append("], ");
        buf.append("layout=[").append(this.layoutAssertion).append("], ");
        buf.append("protectionTokens=[").append(this.protectionTokens).append("], ");
        buf.append("onlySignEntireHeadersAndBody=[").append(this.onlySignEntireHeadersAndBody).append("]");
        buf.append(")");
        return buf.toString();
    }
}

