/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.filter.util;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;

public class StringSequentialSortedSet {
    private static final TraceComponent tc = Tr.register(StringSequentialSortedSet.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected static final int INIT = 10;
    protected String[] set = new String[10];
    protected String[] setNsUri = new String[10];
    protected int size = 0;

    public void reset() {
        this.size = 0;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.set[i] = null;
            this.setNsUri[i] = null;
        }
    }

    private void expandArray() {
        int nextCapacity = this.set.length * 2;
        String[] tmpSet = new String[nextCapacity];
        System.arraycopy(this.set, 0, tmpSet, 0, this.size);
        this.set = tmpSet;
        tmpSet = new String[nextCapacity];
        System.arraycopy(this.setNsUri, 0, tmpSet, 0, this.size);
        this.setNsUri = tmpSet;
    }

    public void add(String prefix) {
        int i;
        for (i = 0; i < this.size; ++i) {
            int comp = this.set[i].compareTo(prefix);
            if (comp == 0) {
                return;
            }
            if (comp > 0) break;
        }
        for (int j = this.size; j > i; --j) {
            this.set[j] = this.set[j - 1];
            this.setNsUri[j] = this.setNsUri[j - 1];
        }
        this.set[i] = prefix;
        ++this.size;
        if (this.size >= this.set.length) {
            this.expandArray();
        }
    }

    public void add(String prefix, String nsUri) {
        int i;
        for (i = 0; i < this.size; ++i) {
            int comp = this.set[i].compareTo(prefix);
            if (comp == 0) {
                return;
            }
            if (comp > 0) break;
        }
        for (int j = this.size; j > i; --j) {
            this.set[j] = this.set[j - 1];
            this.setNsUri[j] = this.setNsUri[j - 1];
        }
        this.set[i] = prefix;
        this.setNsUri[i] = nsUri;
        ++this.size;
        if (this.size >= this.set.length) {
            this.expandArray();
        }
    }

    public int getSize() {
        return this.size;
    }

    public String getPrefix(int index) {
        if (index >= this.size) {
            return null;
        }
        return this.set[index];
    }

    public String getNsUri(int index) {
        if (index >= this.size) {
            return null;
        }
        return this.setNsUri[index];
    }

    public String getNsUri(String prefix) {
        if (prefix == null) {
            return null;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!prefix.equals(this.set[i])) continue;
            return this.setNsUri[i];
        }
        return null;
    }

    public String[] toArray() {
        String[] ret = new String[this.size];
        System.arraycopy(this.set, 0, ret, 0, this.size);
        return ret;
    }
}

