/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.filter.util;

public class ElementNameStack {
    private static final int INIT = 10;
    private String[] elemPrefix = new String[10];
    private String[] elemLocal = new String[10];
    private int max = 10;
    private int size = 0;
    private String[] ret = new String[2];

    public void reset(int initSize) {
        this.size = 0;
        if (initSize > this.max) {
            this.expandArray(initSize);
        }
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.elemPrefix[i] = null;
            this.elemLocal[i] = null;
        }
    }

    private void expandArray(int initSize) {
        this.max = initSize > this.max ? initSize : (this.max *= 2);
        String[] tmpPrefix = new String[this.max];
        String[] tmpLocal = new String[this.max];
        System.arraycopy(this.elemPrefix, 0, tmpPrefix, 0, this.size);
        System.arraycopy(this.elemLocal, 0, tmpLocal, 0, this.size);
        this.elemPrefix = tmpPrefix;
        this.elemLocal = tmpLocal;
    }

    public void push(String prefix, String local) {
        this.elemPrefix[this.size] = prefix;
        this.elemLocal[this.size] = local;
        ++this.size;
        if (this.size >= this.max) {
            this.expandArray(this.max * 2);
        }
    }

    public String[] pop() {
        --this.size;
        this.ret[0] = this.elemPrefix[this.size];
        this.ret[1] = this.elemLocal[this.size];
        return this.ret;
    }

    public int getSize() {
        return this.size;
    }

    public String getPrefix(int index) {
        if (index >= this.size) {
            return null;
        }
        return this.elemPrefix[index];
    }

    public String getLocal(int index) {
        if (index >= this.size) {
            return null;
        }
        return this.elemLocal[index];
    }
}

