/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.filter.util;

import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.filter.DecryptionFilter;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.ArrayList;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecryptionFilterResultSet
implements Result {
    private static final TraceComponent tc = Tr.register(DecryptionFilterResultSet.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected ArrayList<DecryptionFilterResult> decryptionFitlerResults = new ArrayList();

    public void addDecryptionFilterResult(DecryptionFilterResult result) {
        this.decryptionFitlerResults.add(result);
    }

    public DecryptionFilterResult getDecryptionFilterResult(String key) {
        if (key == null) {
            return null;
        }
        int size = this.decryptionFitlerResults.size();
        if (size == 0) {
            return null;
        }
        for (int i = 0; i < size; ++i) {
            DecryptionFilterResult decryptionFilterResult = this.decryptionFitlerResults.get(i);
            if (!key.equals(decryptionFilterResult.id)) continue;
            this.decryptionFitlerResults.remove(i);
            return decryptionFilterResult;
        }
        return null;
    }

    public final ArrayList<DecryptionFilterResult> getDecryptionFitlerResults() {
        return this.decryptionFitlerResults;
    }

    public static final class DecryptionFilterResult
    implements Result {
        protected final OMNode decryptedTopNode;
        protected final DecryptionFilter.EncryptedData encryptedData;
        protected final String id;

        public DecryptionFilterResult(OMNode decryptedTopNode, DecryptionFilter.EncryptedData encryptedData, String id) {
            if (encryptedData == null) {
                throw new NullPointerException("encryptedData is null.");
            }
            if (id == null) {
                throw new NullPointerException("id is null.");
            }
            if (encryptedData.getType() == null) {
                throw new NullPointerException("encryptedData.type is null");
            }
            this.decryptedTopNode = decryptedTopNode;
            this.encryptedData = encryptedData;
            this.id = id;
        }

        public final OMNode getDecryptedTopNode() {
            return this.decryptedTopNode;
        }

        public final DecryptionFilter.EncryptedData getEncryptedData() {
            return this.encryptedData;
        }

        public final String getId() {
            return this.id;
        }

        public String toString() {
            StringBuffer strBuff = new StringBuffer();
            strBuff.append("+DecryptionFilterResult\n");
            strBuff.append("+id:        ").append(this.id).append("\n");
            strBuff.append("+Type: ").append(this.encryptedData.toString()).append("\n");
            return strBuff.toString();
        }
    }
}

