/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.filter.util;

import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.io.Base64Table;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class C14NFilterResultSet
implements Result {
    private static final TraceComponent tc = Tr.register(C14NFilterResultSet.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected ArrayList<C14NFilterResult> c14nResultById = new ArrayList(8);

    public void addC14NResultById(C14NFilterResult result) {
        this.c14nResultById.add(result);
    }

    public C14NFilterResult removeC14nResultById(String key) {
        if (key == null) {
            return null;
        }
        int size = this.c14nResultById.size();
        if (size == 0) {
            return null;
        }
        for (int i = 0; i < size; ++i) {
            C14NFilterResult c14nFilterResult = this.c14nResultById.get(i);
            if (!key.equals(c14nFilterResult.key)) continue;
            this.c14nResultById.remove(i);
            return c14nFilterResult;
        }
        return null;
    }

    public ArrayList<C14NFilterResult> getC14nResultById() {
        return this.c14nResultById;
    }

    public void clear() {
        this.c14nResultById.clear();
    }

    public static final class C14NFilterResult
    implements Result {
        public static final int TYPE_DIGEST_VALUE = 1;
        public static final int TYPE_CANONICAL_FORM = 2;
        protected String key;
        protected String transformAlgorithm;
        protected String[] inclusiveNamespacesPrefixList;
        protected String digestAlgorithm;
        protected int type;
        protected byte[] byteArray;

        public C14NFilterResult(String key, String transformAlgorithm, String[] inclusiveNamespacesPrefixList, String digestAlgorithm, int type, byte[] byteArray) {
            this.key = key;
            this.transformAlgorithm = transformAlgorithm;
            this.inclusiveNamespacesPrefixList = inclusiveNamespacesPrefixList;
            this.digestAlgorithm = digestAlgorithm;
            this.type = type;
            this.byteArray = byteArray;
            if (type != 2 && type != 1) {
                throw new IllegalArgumentException("C14NFilterResult: type=" + type + " is not supported.");
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getTransformAlgorithm() {
            return this.transformAlgorithm;
        }

        public String getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public byte[] getByteArray() {
            return this.byteArray;
        }

        public String toString() {
            StringBuffer strBuff = new StringBuffer();
            strBuff.append("+C14NFilterResult\n");
            strBuff.append("+key:        ").append(this.key).append("\n");
            strBuff.append("+transformAlgorithm: ").append(this.transformAlgorithm).append("\n");
            if (this.inclusiveNamespacesPrefixList != null) {
                strBuff.append("+inclusiveNamespacesPrefixList: [");
                for (int i = 0; i < this.inclusiveNamespacesPrefixList.length; ++i) {
                    strBuff.append(this.inclusiveNamespacesPrefixList[i]).append(", ");
                }
                strBuff.append("]\n");
            }
            strBuff.append("+digestAlgorithm:  ").append(this.digestAlgorithm).append("\n");
            if (this.type == 1) {
                strBuff.append("+digest : ").append(Base64Table.encode(this.byteArray, 0, this.byteArray.length));
            } else {
                String cf = new String(this.byteArray);
                strBuff.append("+CanonicalForm : ").append(cf).append("\n");
            }
            return strBuff.toString();
        }
    }
}

