/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.impl.llom.OMNavigator;

public class OMtoXMLStreamReader
implements XMLStreamReader {
    protected OMNavigator omNavigator;
    protected Stack<OMNode> omNodeStack;
    protected OMNode stopOmNode;
    protected boolean finished;
    protected int tEventType;
    protected int tNodeType;
    protected OMNode tOMNode;
    protected OMElement tOMElement;
    protected OMNamespace tOMNamespace;
    protected boolean tNamespaceDeclsCached;
    protected ArrayList<OMNamespace> tOMNamespaceDecls;
    protected boolean tAttributesCached;
    protected ArrayList<OMAttribute> tOMAttributes;
    protected OMText tOMText;

    public OMtoXMLStreamReader(OMNode startOmNode) {
        this.omNavigator = new OMNavigator(startOmNode);
        this.omNodeStack = new Stack();
        this.reset();
    }

    public OMtoXMLStreamReader(OMNode startOmNode, OMNode stopOmNode) {
        this(startOmNode);
        this.stopOmNode = stopOmNode;
    }

    public void reset() {
        this.finished = false;
        this.resetEventData();
    }

    private void resetEventData() {
        this.tEventType = 7;
        this.tNodeType = -1;
        this.tOMNode = null;
        this.tOMElement = null;
        this.tOMNamespace = null;
        this.tNamespaceDeclsCached = false;
        if (this.tOMAttributes != null) {
            this.tOMNamespaceDecls.clear();
        }
        this.tAttributesCached = false;
        if (this.tOMAttributes != null) {
            this.tOMAttributes.clear();
        }
        this.tOMText = null;
    }

    public void init(OMNode omNode) throws XMLStreamException {
        this.tOMNode = omNode;
        if (this.tOMNode == null) {
            this.tEventType = 8;
        }
        this.tNodeType = this.tOMNode.getType();
        switch (this.tNodeType) {
            case 1: {
                if (this.omNodeStack.empty() || this.tOMNode != this.omNodeStack.peek()) {
                    this.tEventType = 1;
                    this.omNodeStack.push(this.tOMNode);
                } else {
                    this.tEventType = 2;
                    this.omNodeStack.pop();
                    if (this.omNodeStack.empty()) {
                        this.finished = true;
                    }
                }
                this.tOMElement = (OMElement)this.tOMNode;
                this.tNamespaceDeclsCached = false;
                this.tAttributesCached = false;
                break;
            }
            case 4: {
                this.tEventType = 4;
                this.tOMText = (OMText)this.tOMNode;
                break;
            }
            case 12: {
                this.tEventType = 12;
                break;
            }
            case 5: {
                this.tEventType = 5;
                break;
            }
            case 11: {
                this.tEventType = 11;
                break;
            }
            case 3: {
                this.tEventType = 3;
                break;
            }
            case 9: {
                this.tEventType = 9;
                break;
            }
            case 6: {
                this.tEventType = 6;
                break;
            }
            default: {
                throw new XMLStreamException("Unknown not type." + this.tNodeType);
            }
        }
    }

    private void cacheNamespaceDecls() {
        if (this.tOMNamespaceDecls == null) {
            this.tOMNamespaceDecls = new ArrayList();
        } else {
            this.tOMNamespaceDecls.clear();
        }
        Iterator iterator = this.tOMElement.getAllDeclaredNamespaces();
        while (iterator.hasNext()) {
            OMNamespace omn = (OMNamespace)iterator.next();
            this.tOMNamespaceDecls.add(omn);
        }
        this.tNamespaceDeclsCached = true;
    }

    private void cacheAttributes() {
        if (this.tOMAttributes == null) {
            this.tOMAttributes = new ArrayList();
        } else {
            this.tOMAttributes.clear();
        }
        Iterator iterator = this.tOMElement.getAllAttributes();
        while (iterator.hasNext()) {
            OMAttribute oma = (OMAttribute)iterator.next();
            this.tOMAttributes.add(oma);
        }
        this.tAttributesCached = true;
    }

    public int next() throws XMLStreamException {
        if (this.finished) {
            return 8;
        }
        OMNode node = this.omNavigator.next();
        if (node == this.stopOmNode) {
            this.finished = true;
            return 8;
        }
        this.init(node);
        return this.tEventType;
    }

    public void close() throws XMLStreamException {
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.finished) {
            return false;
        }
        return this.tEventType != 8;
    }

    public int getEventType() {
        return this.tNodeType;
    }

    public Object getProperty(String arg0) throws IllegalArgumentException {
        if (this.tOMElement == null) {
            return null;
        }
        OMXMLParserWrapper wrapper = this.tOMElement.getBuilder();
        if (wrapper instanceof StAXBuilder) {
            StAXBuilder builder = (StAXBuilder)wrapper;
            return builder.getReaderProperty(arg0);
        }
        return null;
    }

    public String getLocalName() {
        return this.tOMElement.getLocalName();
    }

    public String getNamespaceURI() {
        if (this.tOMNamespace == null) {
            this.tOMNamespace = this.tOMElement.getNamespace();
        }
        if (this.tOMNamespace == null) {
            return null;
        }
        return this.tOMNamespace.getNamespaceURI();
    }

    public String getPrefix() {
        if (this.tOMNamespace == null) {
            this.tOMNamespace = this.tOMElement.getNamespace();
        }
        if (this.tOMNamespace == null) {
            return null;
        }
        return this.tOMNamespace.getPrefix();
    }

    public QName getName() {
        return this.tOMElement.getQName();
    }

    public int getNamespaceCount() {
        if (!this.tNamespaceDeclsCached) {
            this.cacheNamespaceDecls();
        }
        return this.tOMNamespaceDecls.size();
    }

    public String getNamespacePrefix(int arg0) {
        if (!this.tNamespaceDeclsCached) {
            this.cacheNamespaceDecls();
        }
        return this.tOMNamespaceDecls.get(arg0).getPrefix();
    }

    public String getNamespaceURI(int arg0) {
        if (!this.tNamespaceDeclsCached) {
            this.cacheNamespaceDecls();
        }
        return this.tOMNamespaceDecls.get(arg0).getNamespaceURI();
    }

    public String getNamespaceURI(String prefix) {
        OMNamespace omn = this.tOMElement.findNamespaceURI(prefix);
        if (omn == null) {
            return null;
        }
        return omn.getNamespaceURI();
    }

    public int getAttributeCount() {
        if (!this.tAttributesCached) {
            this.cacheAttributes();
        }
        return this.tOMAttributes.size();
    }

    public String getAttributeLocalName(int arg0) {
        if (!this.tAttributesCached) {
            this.cacheAttributes();
        }
        return this.tOMAttributes.get(arg0).getLocalName();
    }

    public QName getAttributeName(int arg0) {
        if (!this.tAttributesCached) {
            this.cacheAttributes();
        }
        return this.tOMAttributes.get(arg0).getQName();
    }

    public String getAttributeNamespace(int arg0) {
        if (!this.tAttributesCached) {
            this.cacheAttributes();
        }
        return this.tOMAttributes.get(arg0).getNamespace().getNamespaceURI();
    }

    public String getAttributePrefix(int arg0) {
        if (!this.tAttributesCached) {
            this.cacheAttributes();
        }
        return this.tOMAttributes.get(arg0).getNamespace().getPrefix();
    }

    public String getAttributeValue(int arg0) {
        if (!this.tAttributesCached) {
            this.cacheAttributes();
        }
        return this.tOMAttributes.get(arg0).getAttributeValue();
    }

    public String getAttributeValue(String namespaceUri, String localname) {
        return this.tOMElement.getAttributeValue(new QName(namespaceUri, localname));
    }

    public String getAttributeType(int arg0) {
        return null;
    }

    public String getText() {
        return this.tOMText.getText();
    }

    public char[] getTextCharacters() {
        return this.tOMText.getTextCharacters();
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        if (target.length > targetStart + length) {
            length = target.length - targetStart;
        }
        if (this.tOMText.isCharacters()) {
            char[] characters = this.tOMText.getTextCharacters();
            int sourceLength = characters.length;
            if (sourceLength > sourceStart + length) {
                length = sourceLength - sourceStart;
            }
            System.arraycopy(characters, sourceStart, target, targetStart, length);
            return length;
        }
        String text = this.tOMText.getText();
        int sourceLength = text.length();
        if (sourceLength > sourceStart + length) {
            length = sourceLength - sourceStart;
        }
        text.getChars(sourceStart, sourceStart + length, target, targetStart);
        return length;
    }

    public int getTextLength() {
        if (this.tOMText.isCharacters()) {
            char[] characters = this.tOMText.getTextCharacters();
            return characters.length;
        }
        String text = this.tOMText.getText();
        return text.length();
    }

    public int getTextStart() {
        return 0;
    }

    public String getElementText() throws XMLStreamException {
        return null;
    }

    public String getCharacterEncodingScheme() {
        return null;
    }

    public String getEncoding() {
        return null;
    }

    public Location getLocation() {
        return null;
    }

    public NamespaceContext getNamespaceContext() {
        return null;
    }

    public String getPIData() {
        return null;
    }

    public String getPITarget() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    public boolean hasName() {
        return false;
    }

    public boolean hasText() {
        return false;
    }

    public boolean isAttributeSpecified(int arg0) {
        return false;
    }

    public boolean isCharacters() {
        return false;
    }

    public boolean isEndElement() {
        return false;
    }

    public boolean isStandalone() {
        return false;
    }

    public boolean isStartElement() {
        return false;
    }

    public boolean isWhiteSpace() {
        return false;
    }

    public int nextTag() throws XMLStreamException {
        return 0;
    }

    public void require(int arg0, String arg1, String arg2) throws XMLStreamException {
    }

    public boolean standaloneSet() {
        return false;
    }
}

