/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.filter;

import com.ibm.ws.wssecurity.filter.C14NFilter;
import com.ibm.ws.wssecurity.filter.XMLStreamWriterFilterImpl;
import com.ibm.ws.wssecurity.filter.util.AttributeSortedSet;
import com.ibm.ws.wssecurity.filter.util.C14NWriter;
import com.ibm.ws.wssecurity.filter.util.ElementNameStack;
import com.ibm.ws.wssecurity.filter.util.NamespaceStack;
import com.ibm.ws.wssecurity.filter.util.StringSequentialSortedSet;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

public class C14NWriterFilter
extends XMLStreamWriterFilterImpl {
    private static final TraceComponent tc = Tr.register(C14NWriterFilter.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected static final String DEFAULT_NAMESPACE_PREFIX_INDICATOR = C14NFilter.DEFAULT_NAMESPACE_PREFIX_INDICATOR;
    protected static final String DEFAULT_NAMESPACE_PREFIX = C14NFilter.DEFAULT_NAMESPACE_PREFIX;
    protected static final String EMPTY_NAMESPACE_URI = C14NFilter.EMPTY_NAMESPACE_URI;
    protected static final String[] ZERO_ARRAY = C14NFilter.ZERO_ARRAY;
    public static final int INCL_NS_NO_PREFIXE = 0;
    public static final int INCL_NS_ALL_PREFIXES = 1;
    public static final String GATHERED_INC_NS_ALL_PREFIXES = "com.ibm.ws.wssecurity.filterC14NWriterFilter.GATHERED_INC_NS_ALL_PREFIXES".intern();
    protected boolean inStartTag = false;
    protected boolean inEmptyTag = false;
    protected int attrIndex = -1;
    protected int c14nDepth = 0;
    protected C14NWriter c14nWriter = new C14NWriter();
    protected NamespaceStack nsRendered = new NamespaceStack();
    protected AttributeSortedSet attrSortedSet = new AttributeSortedSet();
    protected StringSequentialSortedSet tobeRenderedSet = new StringSequentialSortedSet();
    protected Set<String> inclusiveNamespacesPrefixList = new HashSet<String>();
    protected int inclusiveNamespacesPrefixListSize = 0;
    protected ElementNameStack elemStack = new ElementNameStack();
    protected int inclNsMode = 0;

    public C14NWriterFilter() {
        this.reset();
    }

    public void reset() {
        super.reset();
        this.inStartTag = false;
        this.inEmptyTag = false;
        this.attrIndex = 0;
        this.c14nDepth = 0;
        this.c14nWriter.reset();
        this.c14nWriter.setMode(true);
        this.attrSortedSet.reset(0);
        this.nsRendered.reset();
        this.tobeRenderedSet.reset();
        this.inclusiveNamespacesPrefixList.clear();
        this.inclusiveNamespacesPrefixListSize = 0;
        this.elemStack.reset(0);
        this.inclNsMode = 0;
    }

    public void setC14NMode(boolean c14nWriterMode) {
        this.c14nWriter.setMode(c14nWriterMode);
    }

    public void setInclNsMode(int mode) {
        this.inclNsMode = mode;
    }

    public int getInclNsMode() {
        return this.inclNsMode;
    }

    public String getInclNsPrefixListAsString() {
        StringBuffer buffer = new StringBuffer();
        for (String pre : this.inclusiveNamespacesPrefixList) {
            if (pre == null || pre.length() == 0) {
                pre = DEFAULT_NAMESPACE_PREFIX_INDICATOR;
            }
            buffer.append(pre);
            buffer.append(" ");
        }
        return buffer.toString();
    }

    public byte[] getDigestValue() throws IOException {
        return this.c14nWriter.toDigestByteArray();
    }

    public byte[] getCanonicalForm() {
        return this.c14nWriter.toByteArray();
    }

    public void setMode(boolean mode) {
        this.c14nWriter.setMode(mode);
    }

    private void processStartTagOpen(String elemPrefix, String elemLocal, String elemNsUri) throws XMLStreamException {
        try {
            if (this.inStartTag) {
                this.processStartTagClose();
            }
            if (this.inEmptyTag) {
                this.processEndTag();
            }
            this.inStartTag = true;
            ++this.c14nDepth;
            this.nsRendered.pushContext();
            if (elemPrefix == null) {
                elemPrefix = DEFAULT_NAMESPACE_PREFIX;
            }
            this.c14nWriter.writeStartTagOpen(elemPrefix, elemLocal);
            this.elemStack.push(elemPrefix, elemLocal);
            if (this.inclusiveNamespacesPrefixList.isEmpty() || !this.inclusiveNamespacesPrefixList.contains(elemPrefix)) {
                String renderedNsUri;
                if (elemNsUri == null) {
                    elemNsUri = EMPTY_NAMESPACE_URI;
                }
                if ((renderedNsUri = this.nsRendered.getURI(elemPrefix)) == null) {
                    this.tobeRenderedSet.add(elemPrefix, elemNsUri);
                } else if (!renderedNsUri.equals(elemNsUri)) {
                    this.tobeRenderedSet.add(elemPrefix, elemNsUri);
                }
            }
            this.attrSortedSet.reset(0);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    private void processStartTagClose() throws IOException {
        int i;
        this.inStartTag = false;
        int tobeRenderedSize = this.tobeRenderedSet.getSize();
        for (i = 0; i < tobeRenderedSize; ++i) {
            String toBeRenderedPrefix = this.tobeRenderedSet.getPrefix(i);
            String toBeRenderedUri = this.tobeRenderedSet.getNsUri(i);
            this.c14nWriter.writeNamespaceDeclaration(toBeRenderedPrefix, toBeRenderedUri);
            this.nsRendered.declarePrefix(toBeRenderedPrefix, toBeRenderedUri);
        }
        this.tobeRenderedSet.reset();
        for (i = 0; i < this.attrIndex; ++i) {
            String attrPrefix = this.attrSortedSet.getPrefix(i);
            String attrLocalName = this.attrSortedSet.getLocal(i);
            String attrValue = this.attrSortedSet.getValue(i);
            this.c14nWriter.writeAttribute(attrPrefix, attrLocalName, attrValue);
        }
        this.attrSortedSet.reset(0);
        this.attrIndex = 0;
        this.c14nWriter.writeStartTagClose();
    }

    private void checkNamespaceDecl(String nsDeclPrefix, String nsDeclUri) {
        if (nsDeclPrefix == null) {
            nsDeclPrefix = DEFAULT_NAMESPACE_PREFIX;
        }
        if (this.inclNsMode == 1) {
            this.inclusiveNamespacesPrefixList.add(nsDeclPrefix);
        }
        if (this.inclusiveNamespacesPrefixList.contains(nsDeclPrefix)) {
            String renderedNsUri;
            if (nsDeclUri == null) {
                nsDeclUri = EMPTY_NAMESPACE_URI;
            }
            if ((renderedNsUri = this.nsRendered.getURI(nsDeclPrefix)) == null) {
                this.tobeRenderedSet.add(nsDeclPrefix, nsDeclUri);
            } else if (!renderedNsUri.equals(nsDeclUri)) {
                this.tobeRenderedSet.add(nsDeclPrefix, nsDeclUri);
            }
        }
    }

    private void checkAttribute(String attrLocal, String attrPrefix, String attrNsUri, String attrValue) {
        if (attrNsUri == null) {
            attrNsUri = EMPTY_NAMESPACE_URI;
        }
        this.attrSortedSet.add(this.attrIndex, attrNsUri, attrLocal, attrPrefix, attrValue);
        ++this.attrIndex;
        if (!(attrPrefix == null || attrPrefix.equals("") || !this.inclusiveNamespacesPrefixList.isEmpty() && this.inclusiveNamespacesPrefixList.contains(attrPrefix))) {
            String renderedNsUri = this.nsRendered.getURI(attrPrefix);
            if (renderedNsUri == null) {
                this.tobeRenderedSet.add(attrPrefix, attrNsUri);
            } else if (!renderedNsUri.equals(attrNsUri)) {
                this.tobeRenderedSet.add(attrPrefix, attrNsUri);
            }
        }
    }

    private void processEndTag() throws IOException {
        String[] elemName = this.elemStack.pop();
        boolean success = this.c14nWriter.writeEndTagByUsingCache();
        if (!success) {
            String prefix = elemName[0];
            String local = elemName[1];
            if (prefix == null) {
                prefix = DEFAULT_NAMESPACE_PREFIX;
            }
            this.c14nWriter.writeEndTag(prefix, local);
        }
        this.nsRendered.popContext();
        this.inEmptyTag = false;
        --this.c14nDepth;
        if (this.c14nDepth == 0) {
            this.setResult();
            this.remove();
        }
    }

    protected void setResult() {
        if (this.context != null && this.inclusiveNamespacesPrefixList != null && this.inclusiveNamespacesPrefixList.size() > 0) {
            this.context.put(GATHERED_INC_NS_ALL_PREFIXES, this.getInclNsPrefixListAsString());
        }
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(localName, value);
        this.checkAttribute(localName, null, null, value);
    }

    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(namespaceURI, localName, value);
        this.checkAttribute(localName, this.writer.getPrefix(namespaceURI), namespaceURI, value);
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(prefix, namespaceURI, localName, value);
        this.checkAttribute(localName, prefix, namespaceURI, value);
    }

    public void writeCData(String data) throws XMLStreamException {
        this.writer.writeCData(data);
        try {
            if (this.inStartTag) {
                this.processStartTagClose();
            }
            if (this.inEmptyTag) {
                this.processEndTag();
            }
            this.c14nWriter.writeText(data);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.writer.writeCharacters(text, start, len);
        try {
            if (this.inStartTag) {
                this.processStartTagClose();
            }
            if (this.inEmptyTag) {
                this.processEndTag();
            }
            this.c14nWriter.writeText(new String(text, start, len));
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeCharacters(String text) throws XMLStreamException {
        this.writer.writeCharacters(text);
        try {
            if (this.inStartTag) {
                this.processStartTagClose();
            }
            if (this.inEmptyTag) {
                this.processEndTag();
            }
            this.c14nWriter.writeText(text);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeComment(String arg0) throws XMLStreamException {
        this.writer.writeComment(arg0);
    }

    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.writer.writeDefaultNamespace(namespaceURI);
        this.checkNamespaceDecl("", namespaceURI);
    }

    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.writer.writeNamespace(prefix, namespaceURI);
        this.checkNamespaceDecl(prefix, namespaceURI);
    }

    public void writeDTD(String arg0) throws XMLStreamException {
        this.writer.writeDTD(arg0);
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writer.writeEmptyElement(localName);
        this.processEmptyTag("", localName, this.writer.getNamespaceContext().getNamespaceURI(""));
    }

    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writer.writeEmptyElement(namespaceURI, localName);
        this.processEmptyTag(this.writer.getPrefix(namespaceURI), localName, namespaceURI);
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writer.writeEmptyElement(prefix, localName, namespaceURI);
        this.processEmptyTag(prefix, localName, namespaceURI);
    }

    private void processEmptyTag(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.processStartTagOpen(prefix, localName, namespaceURI);
        this.inEmptyTag = true;
    }

    public void writeEndDocument() throws XMLStreamException {
        this.writer.writeEndDocument();
    }

    public void writeEndElement() throws XMLStreamException {
        this.writer.writeEndElement();
        try {
            if (this.inStartTag) {
                this.processStartTagClose();
            }
            this.processEndTag();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writer.writeProcessingInstruction(target);
        try {
            if (this.inStartTag) {
                this.processStartTagClose();
            }
            if (this.inEmptyTag) {
                this.processEndTag();
            }
            this.c14nWriter.writePI(target, null);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.writer.writeProcessingInstruction(target, data);
        try {
            if (this.inStartTag) {
                this.processStartTagClose();
            }
            if (this.inEmptyTag) {
                this.processEndTag();
            }
            this.c14nWriter.writePI(target, data);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        this.writer.writeStartElement(localName);
        this.processStartTagOpen("", localName, this.writer.getNamespaceContext().getNamespaceURI(""));
    }

    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writer.writeStartElement(namespaceURI, localName);
        this.processStartTagOpen(this.writer.getPrefix(namespaceURI), localName, namespaceURI);
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writer.writeStartElement(prefix, localName, namespaceURI);
        this.processStartTagOpen(prefix, localName, namespaceURI);
    }
}

