/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.filter;

import com.ibm.ws.wssecurity.filter.XMLStreamReaderFilterImpl;
import com.ibm.ws.wssecurity.filter.util.AttributeSortedSet;
import com.ibm.ws.wssecurity.filter.util.C14NWriter;
import com.ibm.ws.wssecurity.filter.util.NamespaceStack;
import com.ibm.ws.wssecurity.filter.util.StringSequentialSortedSet;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.context.MessageContext;

public class BodyC14NFilter
extends XMLStreamReaderFilterImpl {
    private static final TraceComponent tc = Tr.register(BodyC14NFilter.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    public static final String BODY_CONTENT_C14N_RESULT = "com.ibm.ws.wssecurity.filter.BodyC14NFilter.BODY_CONTENT_C14N_RESULT";
    private static final String DEFAULT_NAMESPACE_PREFIX = "";
    private static final String EMPTY_NAMESPACE_URI = "";
    private static final String[] ZERO_ARRAY = new String[0];
    private static final byte[] ZERO_ARRAY_BYTE = new byte[0];
    private String c14nMethod = null;
    private String digestAlgorithm = null;
    private String signatureAlgorithm = null;
    private Set<String> inclusiveNamespacesPrefixList = new HashSet<String>();
    private int c14nDepth = 0;
    private String bodyPrefix = null;
    private byte[] bodyC14NBytes = null;
    protected C14NWriter writer = new C14NWriter();
    private NamespaceStack nsRendered = new NamespaceStack();
    private AttributeSortedSet attrSortedSet = new AttributeSortedSet();
    private StringSequentialSortedSet tobeRenderedSet = new StringSequentialSortedSet();
    private int inclNsMode = 0;
    public static final int INCL_NS_NO_PREFIXE = 0;
    public static final int INCL_NS_ALL_PREFIXES = 1;

    public BodyC14NFilter() {
    }

    public BodyC14NFilter(XMLStreamReader reader) {
        this();
        this.reader = reader;
    }

    public void setInclNsMode(int mode) {
        this.inclNsMode = mode;
    }

    public int getInclNsMode() {
        return this.inclNsMode;
    }

    public String getInclNsPrefixListAsString() {
        StringBuffer buffer = new StringBuffer();
        for (String pre : this.inclusiveNamespacesPrefixList) {
            if (pre == null || pre.length() == 0) {
                pre = "#default";
            }
            buffer.append(pre);
            buffer.append(" ");
        }
        return buffer.toString();
    }

    public byte[] getBodyC14NBytes() {
        return this.bodyC14NBytes;
    }

    public XMLStreamReader init(XMLStreamReader reader, MessageContext context, OMElement bodyElem, int mode) {
        this.inclNsMode = mode;
        return this.init(reader, context, bodyElem);
    }

    public XMLStreamReader init(XMLStreamReader reader, MessageContext context, OMElement bodyElem) {
        XMLStreamReader ret = super.init(reader, context);
        try {
            int i;
            String bodyNsUri;
            this.writer.setMode(false);
            OMNamespace bodyNS = bodyElem.getNamespace();
            this.bodyPrefix = bodyNS.getPrefix();
            if (this.bodyPrefix == null) {
                this.bodyPrefix = "";
            }
            if ((bodyNsUri = bodyNS.getNamespaceURI()) == null) {
                bodyNsUri = "";
            }
            this.writer.writeStartTagOpen(this.bodyPrefix, bodyElem.getLocalName());
            this.tobeRenderedSet.add(this.bodyPrefix, bodyNsUri);
            int attrCount = 0;
            Iterator bodyAttrs = bodyElem.getAllAttributes();
            while (bodyAttrs.hasNext()) {
                OMAttribute tmpAttr = (OMAttribute)bodyAttrs.next();
                String attrLocal = tmpAttr.getLocalName();
                OMNamespace attrNs = tmpAttr.getNamespace();
                String attrPrefix = "";
                String attrNsUri = "";
                if (attrNs != null) {
                    attrPrefix = attrNs.getPrefix();
                    if (attrPrefix == null) {
                        attrPrefix = "";
                    }
                    if ((attrNsUri = attrNs.getNamespaceURI()) == null) {
                        attrNsUri = "";
                    }
                }
                String attrValue = tmpAttr.getAttributeValue();
                this.attrSortedSet.add(attrCount, attrNsUri, attrLocal, attrPrefix, attrValue);
                this.tobeRenderedSet.add(attrPrefix, attrNsUri);
                ++attrCount;
            }
            if (this.inclNsMode == 1) {
                OMElement envElem = (OMElement)bodyElem.getParent();
                Iterator envNsIte = envElem.getAllDeclaredNamespaces();
                while (envNsIte.hasNext()) {
                    OMNamespace tmpNs = (OMNamespace)envNsIte.next();
                    String tmpPrefix = "";
                    String tmpNsUri = "";
                    if (tmpNs != null) {
                        tmpPrefix = tmpNs.getPrefix();
                        if (tmpPrefix == null) {
                            tmpPrefix = "";
                        }
                        if ((tmpNsUri = tmpNs.getNamespaceURI()) == null) {
                            tmpNsUri = "";
                        }
                    }
                    this.tobeRenderedSet.add(tmpPrefix, tmpNsUri);
                    this.inclusiveNamespacesPrefixList.add(tmpPrefix);
                }
                Iterator bodyNsIte = bodyElem.getAllDeclaredNamespaces();
                while (bodyNsIte.hasNext()) {
                    OMNamespace tmpNs = (OMNamespace)bodyNsIte.next();
                    String tmpPrefix = "";
                    String tmpNsUri = "";
                    if (tmpNs != null) {
                        tmpPrefix = tmpNs.getPrefix();
                        if (tmpPrefix == null) {
                            tmpPrefix = "";
                        }
                        if ((tmpNsUri = tmpNs.getNamespaceURI()) == null) {
                            tmpNsUri = "";
                        }
                    }
                    this.tobeRenderedSet.add(tmpPrefix, tmpNsUri);
                    this.inclusiveNamespacesPrefixList.add(tmpPrefix);
                }
            }
            int tobeRenderedSize = this.tobeRenderedSet.getSize();
            for (i = 0; i < tobeRenderedSize; ++i) {
                String toBeRenderedPrefix = this.tobeRenderedSet.getPrefix(i);
                String toBeRenderedUri = this.tobeRenderedSet.getNsUri(i);
                this.writer.writeNamespaceDeclaration(toBeRenderedPrefix, toBeRenderedUri);
                this.nsRendered.declarePrefix(toBeRenderedPrefix, toBeRenderedUri);
            }
            this.tobeRenderedSet.reset();
            for (i = 0; i < attrCount; ++i) {
                String attrPrefix = this.attrSortedSet.getPrefix(i);
                String attrLocalName = this.attrSortedSet.getLocal(i);
                String attrValue = this.attrSortedSet.getValue(i);
                this.writer.writeAttribute(attrPrefix, attrLocalName, attrValue);
            }
            this.writer.writeStartTagClose();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset", this);
        }
        super.reset();
        this.inclusiveNamespacesPrefixList.clear();
        this.c14nMethod = null;
        this.digestAlgorithm = null;
        this.signatureAlgorithm = null;
        this.c14nDepth = 0;
        this.writer.reset();
        this.nsRendered.reset();
        this.attrSortedSet.reset(0);
        this.tobeRenderedSet.reset();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public void setC14nMethod(String method) {
        this.c14nMethod = method;
    }

    public void setDigestAlgorithm(String algorithm) {
        this.digestAlgorithm = algorithm;
    }

    public int next() throws XMLStreamException {
        int eventType = this.reader.next();
        try {
            this.c14n(eventType);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
        return eventType;
    }

    private void c14n(int ret) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "c14n");
        }
        switch (ret) {
            case 1: {
                int tobeRenderedSize;
                String attrValue;
                String attrPrefix;
                int attrCount;
                String elemPrefix;
                ++this.c14nDepth;
                this.nsRendered.pushContext();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "[C14N] START_ELEMENT=" + this.reader.getLocalName());
                }
                if ((elemPrefix = this.reader.getPrefix()) == null) {
                    elemPrefix = "";
                }
                this.writer.writeStartTagOpen(elemPrefix, this.reader.getLocalName());
                if (this.inclusiveNamespacesPrefixList.isEmpty() || !this.inclusiveNamespacesPrefixList.contains(elemPrefix)) {
                    String renderedNsUri;
                    String elemNsUri = this.reader.getNamespaceURI();
                    if (elemNsUri == null) {
                        elemNsUri = "";
                    }
                    if ((renderedNsUri = this.nsRendered.getURI(elemPrefix)) == null) {
                        this.tobeRenderedSet.add(elemPrefix, elemNsUri);
                    } else if (!renderedNsUri.equals(elemNsUri)) {
                        this.tobeRenderedSet.add(elemPrefix, elemNsUri);
                    }
                }
                if ((attrCount = this.reader.getAttributeCount()) > 0) {
                    this.attrSortedSet.reset(attrCount);
                    for (int i = 0; i < attrCount; ++i) {
                        String attrLocal = this.reader.getAttributeLocalName(i);
                        attrPrefix = this.reader.getAttributePrefix(i);
                        String attrNsUri = this.reader.getAttributeNamespace(i);
                        if (attrNsUri == null) {
                            attrNsUri = "";
                        }
                        attrValue = this.reader.getAttributeValue(i);
                        this.attrSortedSet.add(i, attrNsUri, attrLocal, attrPrefix, attrValue);
                        if (attrPrefix == null || !this.inclusiveNamespacesPrefixList.isEmpty() && this.inclusiveNamespacesPrefixList.contains(attrPrefix)) continue;
                        String renderedNsUri = this.nsRendered.getURI(attrPrefix);
                        if (renderedNsUri == null) {
                            this.tobeRenderedSet.add(attrPrefix, attrNsUri);
                            continue;
                        }
                        if (renderedNsUri.equals(attrNsUri)) continue;
                        this.tobeRenderedSet.add(attrPrefix, attrNsUri);
                    }
                }
                if (!this.inclusiveNamespacesPrefixList.isEmpty()) {
                    int nsDeclCount = this.reader.getNamespaceCount();
                    for (int i = 0; i < nsDeclCount; ++i) {
                        String renderedNsUri;
                        String nsDeclPrefix = this.reader.getNamespacePrefix(i);
                        if (nsDeclPrefix == null) {
                            nsDeclPrefix = "";
                        }
                        if (this.inclNsMode == 1) {
                            this.inclusiveNamespacesPrefixList.add(nsDeclPrefix);
                        }
                        if (!this.inclusiveNamespacesPrefixList.contains(nsDeclPrefix)) continue;
                        String nsDeclUri = this.reader.getNamespaceURI(i);
                        if (nsDeclUri == null) {
                            nsDeclUri = "";
                        }
                        if ((renderedNsUri = this.nsRendered.getURI(nsDeclPrefix)) == null) {
                            this.tobeRenderedSet.add(nsDeclPrefix, nsDeclUri);
                            continue;
                        }
                        if (renderedNsUri.equals(nsDeclUri)) continue;
                        this.tobeRenderedSet.add(nsDeclPrefix, nsDeclUri);
                    }
                }
                if ((tobeRenderedSize = this.tobeRenderedSet.getSize()) > 0) {
                    for (int i = 0; i < tobeRenderedSize; ++i) {
                        String toBeRenderedPrefix = this.tobeRenderedSet.getPrefix(i);
                        String toBeRenderedUri = this.tobeRenderedSet.getNsUri(i);
                        this.writer.writeNamespaceDeclaration(toBeRenderedPrefix, toBeRenderedUri);
                        this.nsRendered.declarePrefix(toBeRenderedPrefix, toBeRenderedUri);
                    }
                    this.tobeRenderedSet.reset();
                }
                for (int i = 0; i < attrCount; ++i) {
                    attrPrefix = this.attrSortedSet.getPrefix(i);
                    String attrLocalName = this.attrSortedSet.getLocal(i);
                    attrValue = this.attrSortedSet.getValue(i);
                    this.writer.writeAttribute(attrPrefix, attrLocalName, attrValue);
                }
                this.writer.writeStartTagClose();
                break;
            }
            case 2: {
                String elemPrefixEnd = this.reader.getPrefix();
                if (elemPrefixEnd == null) {
                    elemPrefixEnd = "";
                }
                this.writer.writeEndTag(elemPrefixEnd, this.reader.getLocalName());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "[C14N] END_ELEMENT=" + this.reader.getLocalName());
                }
                this.nsRendered.popContext();
                --this.c14nDepth;
                if (this.c14nDepth != 0) break;
                this.writer.writeEndTag(this.bodyPrefix, "Body");
                this.bodyC14NBytes = this.writer.toByteArray();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "[C14N] bodyC14NBytes = " + new String(this.bodyC14NBytes, "UTF8"));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "[C14N] inclusiveNamespacesPrefixList = " + this.inclusiveNamespacesPrefixList);
                }
                this.remove();
                break;
            }
            case 3: {
                this.writer.writePI(this.reader.getPITarget(), this.reader.getPIData());
                break;
            }
            case 4: {
                this.writer.writeText(this.reader.getText());
                break;
            }
            case 12: {
                this.writer.writeText(this.reader.getText());
                break;
            }
            case 5: {
                break;
            }
            case 9: {
                break;
            }
            case 6: {
                this.writer.writeText(this.reader.getText());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "c14n");
        }
    }
}

