/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.enc;

import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.ws.wssecurity.common.WSSAlgorithmFactory;
import com.ibm.ws.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.wssecurity.config.KeyInfoGeneratorConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.core.WSSGeneratorComponent;
import com.ibm.ws.wssecurity.core.XMLElement;
import com.ibm.ws.wssecurity.dsig.WSSObjectSignatureGenerator;
import com.ibm.ws.wssecurity.enc.XMLPartList;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.CommonLogUtils;
import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdAttributeValue;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.QNameHeaderSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSObjectUtils;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.Signature;
import com.ibm.ws.wssecurity.wssobject.impl.wsse10.Security;
import com.ibm.ws.wssecurity.wssobject.impl.xenc.EncryptedData;
import com.ibm.ws.wssecurity.wssobject.interfaces.BelongsToNamespace;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObject;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.NamespacePrefixPair;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartAttributeValue;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptionContext;
import com.ibm.ws.wssecurity.xml.xss4j.enc.ResourceShower;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherData;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherValue;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.DataReference;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedHeader;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedType;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.ReferenceList;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.ByteArrayInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11BodyImpl;
import org.apache.axiom.soap.impl.llom.soap12.SOAP12BodyImpl;
import org.apache.axis2.context.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSObjectEncryptionGenerator
implements WSSGeneratorComponent {
    private static final TraceComponent tc = Tr.register(WSSObjectEncryptionGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSObjectEncryptionGenerator.class.getName();
    private IdUtils _idResolver = null;
    private Map<Object, Object> _selectors = null;
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtils)map.get("com.ibm.ws.wssecurity.util.selector.IDResolver");
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMDocument doc, OMElement parent, Map<Object, Object> context) throws SoapSecurityException {
        VariablePartAttributeValue attr;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "OMElement parent[" + DOMUtils.getDisplayName(parent) + "]," + "Map context)");
        }
        OMFactory omFactory = doc.getOMDocumentElement().getOMFactory();
        Object obj = context.get("com.ibm.ws.wssecurity.constants.soapVersion");
        int soapVersion = 0;
        if (obj != null && obj instanceof Integer) {
            soapVersion = (Integer)obj;
        }
        String nsSoap = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[2][soapVersion];
        obj = context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][wssVersion];
        String nsWsu = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][wssVersion];
        Security security = WSSObjectUtils.getWSSObjectSecurityHeader(context);
        WSSObjectDocumentImpl wssObjectDocument = security.getWSSObjectDocument();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security header at start of encryption generation = " + security);
        }
        if (security == null) {
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s15");
        }
        NamespacePrefixPair nspp = security.getNamespace();
        String ns = nspp.getUri();
        String pWsse = nspp.getPrefix();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security namespace prefix = " + pWsse);
            Tr.debug(tc, "Security namespace = " + ns);
        }
        if (NamespaceUtil.isWsse(ns) != wssVersion) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s03", "{" + ns + "}Security", "{" + nsWsse + "}Security");
        }
        String act = null;
        String role = null;
        String mu = null;
        String relay = null;
        if (soapVersion == 1) {
            attr = security.getSoap12Role();
            if (attr != null) {
                role = attr.toString();
            }
            if ((attr = security.getSoap12MustUnderstand()) != null) {
                mu = attr.toString();
            }
            if ((attr = security.getSoap12Relay()) != null) {
                relay = attr.toString();
            }
        } else if (soapVersion == 0) {
            attr = security.getSoapActor();
            if (attr != null) {
                act = attr.toString();
            }
            if ((attr = security.getSoapMustUnderstand()) != null) {
                mu = attr.toString();
            }
        }
        context.put("com.ibm.ws.wssecurity.constants.mustUnderstandAttr", mu);
        context.put("com.ibm.ws.wssecurity.constants.actorAttr", act);
        context.put("com.ibm.ws.wssecurity.constants.roleAttr", role);
        context.put("com.ibm.ws.wssecurity.constants.relayAttr", relay);
        WSSGeneratorConfig gconfig = (WSSGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        EncryptionGeneratorConfig config2 = (EncryptionGeneratorConfig)context.remove("com.ibm.ws.wssecurity.impl.config.encryptionGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "EncryptionGeneratorConfig [" + config2 + "].");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Examining encrypting parts.");
        }
        boolean encryptSomething = false;
        boolean encryptNonce = false;
        HashMap<Object, Object> selectorMap = new HashMap<Object, Object>(context);
        selectorMap.put(NonceManager.class, gconfig.getNonceManager());
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.IDResolver", this._idResolver);
        XMLPartList parts = null;
        ArrayList<IdAttributeValue> idList = new ArrayList<IdAttributeValue>();
        ArrayList<ArrayList<XMLElement>> pList = new ArrayList<ArrayList<XMLElement>>();
        ArrayList<ArrayList<XMLElement>> hList = new ArrayList<ArrayList<XMLElement>>();
        ArrayList<XMLElement> eList = new ArrayList<XMLElement>();
        ReferencePartConfig rpconfig = config2.getReference();
        Map<Object, Object> props = config2.getProperties();
        boolean encHeaderWSS10 = false;
        String encHeader = (String)props.get(Constants.ENCRYPTED_HEADER_GENERATE_WSS10);
        if (encHeader != null && encHeader.length() != 0 && encHeader.equalsIgnoreCase("true")) {
            encHeaderWSS10 = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Property com.ibm.wsspi.wssecurity.encryptedHeader.generate.WSS1.0 specified as true.");
            }
        }
        boolean isEncryptHeaderByQName = false;
        if (rpconfig != null && rpconfig.getParts() != null && rpconfig.getParts().iterator() != null) {
            for (ReferencePartConfig.PartConfig pconfig : rpconfig.getParts()) {
                if (pconfig.isTimestamp() || pconfig.isNonce()) {
                    encryptNonce = true;
                    continue;
                }
                String dialect = pconfig.getDialect();
                String keyword = pconfig.getKeyword();
                Class elemSelector = ConfidentialDialectElementSelector.class;
                boolean foundHeader = false;
                if (dialect.equals(com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER)) {
                    isEncryptHeaderByQName = true;
                    foundHeader = true;
                    selectorMap.put("com.ibm.ws.wssecurity.util.selector.headername", pconfig.getHeaderName());
                    selectorMap.put("com.ibm.ws.wssecurity.util.selector.headernamespace", pconfig.getHeaderNamespace());
                    if (act != null) {
                        selectorMap.put("com.ibm.ws.wssecurity.util.selector.actorOrRole", act);
                    } else {
                        selectorMap.put("com.ibm.ws.wssecurity.util.selector.actorOrRole", role);
                    }
                    elemSelector = QNameHeaderSelector.class;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Looking for header to encrypt with header name [" + pconfig.getHeaderName() + " and header namspace [" + pconfig.getHeaderNamespace() + "]");
                    }
                }
                if ((parts = (XMLPartList)WSSObjectSignatureGenerator.getMessagePart(doc, dialect, keyword, "encryption_mode", this._selectors, elemSelector, selectorMap)) == null || parts.size() <= 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, parts.size() + " parts found.");
                }
                if (foundHeader && !encHeaderWSS10) {
                    hList.add(parts);
                } else {
                    pList.add(parts);
                }
                for (int j = 0; j < parts.size(); ++j) {
                    eList.add(parts.get(j));
                    boolean added = false;
                    while (!added) {
                        IdAttributeValue idAttrVal = IdUtils.getInstance().makeUniqueId(context);
                        if (idList.contains(idAttrVal)) continue;
                        idList.add(idAttrVal);
                        added = true;
                    }
                    encryptSomething = true;
                }
            }
        }
        if (!encryptSomething) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke(Document doc, Element parent, Map context)");
            }
            return;
        }
        if (isEncryptHeaderByQName && !encHeaderWSS10) {
            context.put("com.ibm.ws.wssecurity.constants.soapNsForAttr", nsSoap);
        }
        HashMap<Object, Object> type = new HashMap<Object, Object>(2);
        EncryptionContext econtext = new EncryptionContext();
        String encAlgorithm = null;
        AlgorithmConfig encMethod = config2.getKeyEncryptionMethod();
        if (encMethod != null) {
            encAlgorithm = encMethod.getAlgorithm();
        }
        econtext.setEncAlgorithm(encAlgorithm);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Encryption Algorithm : " + encAlgorithm);
        }
        WSSAlgorithmFactory afactory = gconfig.getAlgorithmFactory();
        econtext.setAlgorithmFactory(afactory);
        econtext.setHWConfig(gconfig, config2);
        boolean mtomOptimizeFlag = false;
        String mtomOptimize = (String)props.get(Constants.WSSECURITY_MTOM_OPTIMIZE_ENCRYPTED_DATA);
        if (mtomOptimize != null && mtomOptimize.length() != 0 && mtomOptimize.equalsIgnoreCase("true")) {
            mtomOptimizeFlag = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MTOM optimize property was specified for EncryptionInfo");
            }
        }
        econtext.setMTOMOptimize(mtomOptimizeFlag);
        if (tc.isDebugEnabled()) {
            econtext.setResourceShower(ShowerImpl.getInstance());
        }
        String keyencMethod = null;
        if (config2.getKeyEncryptionMethod() != null) {
            keyencMethod = config2.getKeyEncryptionMethod().getAlgorithm();
        }
        String dataEncMethod = null;
        dataEncMethod = config2.getDataEncryptionMethod().getAlgorithm();
        context.put("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm", dataEncMethod);
        boolean keygen = keyencMethod != null && keyencMethod.length() > 0;
        com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData ed = WSSObjectEncryptionGenerator.createEncryptedData(config2, omFactory, !keygen && gconfig.isUserDefinedComponentsUsed(), afactory);
        WSSObjectElement el = null;
        Key dek = null;
        if (keygen) {
            EncryptedKey ek = WSSObjectEncryptionGenerator.createEncryptedKey(config2, idList, afactory, omFactory, nsSoap, nsWsse, nsWsu, gconfig.isUserDefinedComponentsUsed());
            try {
                el = ek.createElement(wssObjectDocument);
                el = WSSObjectEncryptionGenerator.insertEncryptionElement(security, el, pList);
            }
            catch (StructureException e) {
                Tr.processException(e, clsName + ".invoke", "438");
                throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s01", new String[]{"EncryptedKey", e.getMessage()}, (Throwable)e);
            }
            ek.setWSSObjectBase(el);
            Key kek = WSSObjectSignatureGenerator.callKeyInfoGenerator(config2.getEncryptionKeyInfo(), "EncryptingKey", type, this._selectors, doc, el, context);
            if (context.get("com.ibm.ws.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress") != null) {
                String endpointReference = context.get("com.ibm.ws.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress").toString();
                if (config2 != null) {
                    endpointReference = endpointReference + config2.hashCode();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The target End point address = " + context.get("com.ibm.ws.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress").toString());
                }
                econtext.setEndpointReference(endpointReference);
            }
            dek = WSSObjectEncryptionGenerator.generateKey(econtext, ed, wssObjectDocument, kek);
            WSSObjectEncryptionGenerator.encryptKey(econtext, ek, dek, kek);
        } else {
            ReferenceList rl = WSSObjectEncryptionGenerator.createReferenceList(idList, nsSoap, nsWsse, nsWsu);
            try {
                el = rl.createElement(wssObjectDocument);
                el = WSSObjectEncryptionGenerator.insertEncryptionElement(security, el, pList);
            }
            catch (StructureException e) {
                Tr.processException(e, clsName + ".invoke", "476");
                throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s01", new String[]{"ReferenceList", e.getMessage()}, (Throwable)e);
            }
            dek = null;
        }
        WSSObjectEncryptionGenerator.encrypt(config2.getEncryptionKeyInfo(), type, this._selectors, doc, context, config2.remainSignatureAfterEncryption(), pList, idList, hList, econtext, el, ed, dek, gconfig.isUserDefinedComponentsUsed());
        context.remove("com.ibm.ws.wssecurity.constants.mustUnderstandAttr");
        context.remove("com.ibm.ws.wssecurity.constants.actorAttr");
        context.remove("com.ibm.ws.wssecurity.constants.roleAttr");
        context.remove("com.ibm.ws.wssecurity.constants.relayAttr");
        if (isEncryptHeaderByQName && !encHeaderWSS10) {
            context.remove("com.ibm.ws.wssecurity.constants.soapNsForAttr");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(OMDocument doc, OMElement parent, Map context)");
        }
    }

    private static EncryptedKey createEncryptedKey(EncryptionGeneratorConfig config2, List<IdAttributeValue> ids, WSSAlgorithmFactory factory, OMFactory doc, String nsSoap, String nsWsse, String nsWsu, boolean userDefinedComponentsUsed) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEncryptedKey(EncryptionGeneratorConfig config,List ids[" + ids + "]," + "WSSAlgorithmFactory factory[" + factory + "]," + "OMFactory doc[" + doc + "]," + "String nsSoap[" + nsSoap + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "]," + "boolean userDefinedComponentsUsed[" + userDefinedComponentsUsed + "])");
        }
        EncryptedKey ek = new EncryptedKey();
        ek.setEncryptionMethod(WSSObjectEncryptionGenerator.createEncryptionMethod(config2.getKeyEncryptionMethod(), factory));
        ek.setCipherData(WSSObjectEncryptionGenerator.createCipherData());
        ek.setReferenceList(WSSObjectEncryptionGenerator.createReferenceList(ids, nsSoap, nsWsse, nsWsu));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEncryptedKey(EncryptionGeneratorConfig config,List ids,WSSAlgorithmFactory factory,OMFactory doc,String nsSoap,String nsWsse,String nsWsu,boolean userDefinedComponentsUsed) returns EncryptedKey[" + ek + "]");
        }
        return ek;
    }

    private static EncryptionMethod createEncryptionMethod(AlgorithmConfig aconfig, WSSAlgorithmFactory factory) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEncryptionMethod(AlgorithmConfig aconfig[" + aconfig + "]," + "WSSAlgorithmFactory factory[" + factory + "])");
        }
        EncryptionMethod em = new EncryptionMethod();
        em.setAlgorithm(aconfig.getAlgorithm());
        try {
            AlgorithmParameterSpec spec = factory.convertParameter(aconfig.getAlgorithm(), aconfig.getProperties());
            if (spec != null) {
                em.setParameterSpec(factory, spec);
            }
        }
        catch (InvalidAlgorithmParameterException e) {
            Tr.processException(e, clsName + ".createEncryptionMethod", "588");
            Tr.error(tc, "security.wssecurity.EncryptionGenerator.s14", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s14", new String[]{e.getMessage()}, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            Tr.processException(e, clsName + ".createEncryptionMethod", "592");
            Tr.error(tc, "security.wssecurity.EncryptionGenerator.s14", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s14", new String[]{e.getMessage()}, (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEncryptionMethod(AlgorithmConfig aconfig,WSSAlgorithmFactory factory) returns EncryptionMethod[" + em + "]");
        }
        return em;
    }

    private static KeyInfo createKeyInfo(OMFactory factory) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createKeyInfo(OMFactory factory[" + factory + "])");
        }
        KeyInfo ki = new KeyInfo();
        ki.addElement(factory.createOMElement("dummy", "", ""));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createKeyInfo(Document doc) returns KeyInfo[" + ki + "]");
        }
        return ki;
    }

    private static CipherData createCipherData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCipherData()");
        }
        CipherValue cv = new CipherValue();
        CipherData cd = new CipherData();
        cd.setCipherValue(cv);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCipherData() returns CipherData[" + cd + "]");
        }
        return cd;
    }

    private static ReferenceList createReferenceList(List<IdAttributeValue> ids, String nsSoap, String nsWsse, String nsWsu) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createReferenceList(List ids[" + ids + "]," + "String nsSoap[" + nsSoap + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "])");
        }
        ReferenceList rl = new ReferenceList();
        for (IdAttributeValue id : ids) {
            DataReference dataRef = new DataReference();
            dataRef.setVariablePartURI(id.getVariablePartRefValue());
            rl.addDataReference(dataRef);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createReferenceList(List ids,Document doc,String nsSoap,String nsWsse,String nsWsu) returns ReferenceList[" + rl + "]");
        }
        return rl;
    }

    public static com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData createEncryptedData(EncryptionGeneratorConfig config2, OMFactory doc, boolean createKeyInfo, WSSAlgorithmFactory factory) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEncryptedData(EncryptionGeneratorConfig config,OMFactory doc[" + doc + "]," + "boolean createKeyInfo[" + createKeyInfo + "]," + "WSSAlgorithmFactory factory[" + factory + "])");
        }
        com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData ed = new com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData();
        ed.setEncryptionMethod(WSSObjectEncryptionGenerator.createEncryptionMethod(config2.getDataEncryptionMethod(), factory));
        if (createKeyInfo) {
            ed.setKeyInfo(WSSObjectEncryptionGenerator.createKeyInfo(doc));
        }
        ed.setCipherData(WSSObjectEncryptionGenerator.createCipherData());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEncryptedData(EncryptionGeneratorConfig config,Document doc,boolean createKeyInfo,WSSAlgorithmFactory factory) returns EncryptedData[" + ed + "]");
        }
        return ed;
    }

    private static Key generateKey(EncryptionContext econtext, com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData ed, WSSObjectDocumentImpl doc, Key kek) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateKey(EncryptionContext econtext[" + econtext + "]," + "EncryptedData ed[" + ed + "]," + "WSSObjectDocument doc," + "Key kek[" + kek + "])");
        }
        Key key = null;
        try {
            econtext.setEncryptedType(ed, null, null, null);
            key = econtext.generateKey();
        }
        catch (Exception e) {
            Tr.processException(e, clsName + ".generateKey", "726");
            Tr.error(tc, "security.wssecurity.EncryptionGenerator.s11", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s11", new String[]{e.getMessage()}, (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateKey(EncryptionContext econtext,EncryptedData ed,WSSObjectDocument doc,Key kek) returns Key[" + key + "]");
        }
        return key;
    }

    private static void encrypt(KeyInfoGeneratorConfig config2, Map<Object, Object> type, Map<Object, Object> properties, OMDocument doc, Map<Object, Object> context, boolean sigAfterEnc, List<ArrayList<XMLElement>> pList, List<IdAttributeValue> idList, List<ArrayList<XMLElement>> hList, EncryptionContext econtext, WSSObjectElement einfo, com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData ed, Key dek, boolean userDefinedComponentsUsed) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encrypt(KeyInfoGeneratorConfig config,Map type,Map properties,OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "Map context," + "boolean sigAfterEnc," + "List pList[pList]," + "List idList[" + idList + "]," + "List hList[ hList]," + "EncryptionContext econtext[" + econtext + "]," + "WSSObjectElement einfo[" + einfo + "]," + "EncryptedData ed[" + ed + "]," + "Key dek[" + dek + "], " + "boolean userDefinedComponentsUsed[" + userDefinedComponentsUsed + "])");
            Tr.debug(tc, "List pList is a List of XMLElement ArrayLists. Listing now its contents.");
            CommonLogUtils.logDebugXMLElement(pList, tc);
            Tr.debug(tc, "List hList is a List of XMLElement ArrayLists. Listing now its contents.");
            CommonLogUtils.logDebugXMLElement(hList, tc);
        }
        OMFactory factory = doc.getOMDocumentElement().getOMFactory();
        if (dek == null && userDefinedComponentsUsed) {
            ed.setKeyInfo(WSSObjectEncryptionGenerator.createKeyInfo(factory));
        }
        MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        try {
            int idp = idList.size() - 1;
            for (XMLPartList xMLPartList : pList) {
                for (int j = 0; j < xMLPartList.getLength(); ++j) {
                    OMNode child;
                    String encType = xMLPartList.getType();
                    XMLElement xel = xMLPartList.item(j);
                    OMElement el = null;
                    WSSObjectElement wsso = null;
                    if (xel.getType() == 1) {
                        el = (OMElement)xel.getOMNode();
                    } else if (xel.getType() == 2) {
                        wsso = xel.getWSSObject();
                    }
                    IdAttributeValue idAttributeValue = idList.get(idp--);
                    ed.setVariablePartId(idAttributeValue.getVariablePartValue());
                    ed.setType(encType);
                    if (tc.isDebugEnabled()) {
                        if (xel.getType() == 1) {
                            Tr.debug(tc, "plist: el is of type " + el.getClass().getName());
                        } else if (xel.getType() == 2) {
                            Tr.debug(tc, "plist: WSSObject element is " + wsso.getQName());
                        }
                    }
                    byte[] bodyBytes = null;
                    ByteArrayHolder encryptedBodyBytes = null;
                    WSSObjectElement eed = null;
                    com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData bodyEncryptedData = null;
                    if (el != null && (el instanceof SOAP11BodyImpl || el instanceof SOAP12BodyImpl) && (child = el.getFirstOMChild()) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "child: el is of type " + child.getClass().getName());
                        }
                        if (child instanceof OMSourcedElementImpl) {
                            if (messageContext != null) {
                                bodyBytes = (byte[])messageContext.getProperty("com.ibm.ws.wssecurity.filter.BodyC14NFilter.BODY_CONTENT_C14N_RESULT");
                                messageContext.setProperty("com.ibm.ws.wssecurity.filter.BodyC14NFilter.BODY_CONTENT_C14N_RESULT", null);
                            }
                            if (tc.isDebugEnabled()) {
                                if (bodyBytes == null || bodyBytes.length == 0) {
                                    Tr.debug(tc, "Could not retrieve C14N body content byte[] from MessageContext");
                                } else {
                                    Tr.debug(tc, "Retrieved C14N body content byte[] from MessageContext");
                                }
                            }
                            if (messageContext != null) {
                                encryptedBodyBytes = (ByteArrayHolder)messageContext.getProperty("com.ibm.ws.wssecurity.enc.EncryptedBodyByteArrayHolder");
                                messageContext.setProperty("com.ibm.ws.wssecurity.enc.EncryptedBodyByteArrayHolder", null);
                            }
                            if (encryptedBodyBytes == null || encryptedBodyBytes.getLength() == 0) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Could not retrieve encrypted body content ByteArrayHolder from MessageContext; using OMSourcedElement");
                                }
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Retrieved encrypted body content ByteArrayHolder from MessageContext");
                                }
                                if ((bodyEncryptedData = (com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData)context.get("com.ibm.ws.wssecurity.enc.BodyEncryptedDataElement")) != null && bodyEncryptedData.getWSSObjectBase() != null) {
                                    eed = bodyEncryptedData.getWSSObjectBase();
                                    EncryptedData encData = (EncryptedData)eed;
                                    encData.setId(VariablePartFactory.getInstance().createAttrValueWithString(Util.normalize(ed.getId())));
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Retrieved WSSObject EncryptedData element from context");
                                    }
                                } else if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Did not retrieve WSSObject EncryptedData element from context");
                                }
                            }
                        }
                    }
                    if (bodyBytes != null && bodyBytes.length > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting byte[] to EncryptionContext");
                        }
                        econtext.setData(bodyBytes);
                    } else if (encryptedBodyBytes != null && encryptedBodyBytes.getLength() > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting ByteArrayHolder to EncryptionContext");
                        }
                        econtext.setEncryptedData(encryptedBodyBytes);
                    } else if (xel.getType() == 1) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting OMElement to EncryptionContext");
                        }
                        econtext.setData(el);
                    } else if (xel.getType() == 2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting WSSObjectElement to EncryptionContext");
                        }
                        econtext.setData(wsso);
                    }
                    if (eed == null) {
                        if (xel.getType() == 1) {
                            eed = WSSObjectEncryptionGenerator.createEncryptedData(ed, el);
                        } else if (xel.getType() == 2) {
                            eed = WSSObjectEncryptionGenerator.createEncryptedData(ed, wsso);
                        }
                        ed.setWSSObjectBase(eed);
                        if (dek == null) {
                            Key key = WSSObjectSignatureGenerator.callKeyInfoGenerator(config2, "EncryptingKey", type, properties, doc, eed, context);
                            econtext.setKey(key);
                        } else {
                            econtext.setKey(dek);
                        }
                        econtext.setEncryptedType(ed, null, null, null);
                    } else {
                        if (dek != null) {
                            econtext.setKey(dek);
                        }
                        econtext.setEncryptedType(bodyEncryptedData, null, null, null);
                    }
                    econtext.encrypt();
                    if (bodyBytes != null && bodyBytes.length > 0 || encryptedBodyBytes != null && encryptedBodyBytes.getLength() > 0) {
                        econtext.replace(el);
                    } else {
                        econtext.replace();
                    }
                    econtext.clearEncryptedType();
                    if (!tc.isDebugEnabled()) continue;
                    if (xel.getType() == 1) {
                        Tr.debug(tc, "Encrypted part with id[" + idAttributeValue + "] for part with name[" + el.getLocalName() + "] and namespace[" + el.getNamespace().getNamespaceURI() + "]");
                        continue;
                    }
                    if (xel.getType() != 2) continue;
                    Tr.debug(tc, "Encrypted part with id[" + idAttributeValue + "] for part with QName[" + wsso.getQName() + "]");
                }
            }
            String string = (String)context.get("com.ibm.ws.wssecurity.constants.mustUnderstandAttr");
            String act = (String)context.get("com.ibm.ws.wssecurity.constants.actorAttr");
            String role = (String)context.get("com.ibm.ws.wssecurity.constants.roleAttr");
            String relay = (String)context.get("com.ibm.ws.wssecurity.constants.relayAttr");
            String nsSoap = (String)context.get("com.ibm.ws.wssecurity.constants.soapNsForAttr");
            EncryptedHeader eh = new EncryptedHeader();
            eh.setMustUnderstand(string);
            eh.setActor(act);
            eh.setRole(role);
            eh.setRelay(relay);
            eh.setSoapNs(nsSoap);
            eh.initFromEncryptedData(ed);
            for (XMLPartList xMLPartList : hList) {
                for (int j = 0; j < xMLPartList.getLength(); ++j) {
                    String encType = xMLPartList.getType();
                    XMLElement xel = xMLPartList.item(j);
                    IdAttributeValue id = idList.get(idp--);
                    eh.setVariablePartId(id.getVariablePartValue());
                    eh.setType(encType);
                    OMElement el = null;
                    if (xel.getType() == 1) {
                        el = (OMElement)xel.getOMNode();
                        econtext.setData(el);
                    } else if (xel.getType() == 2) {
                        throw new RuntimeException("Internal error: SOAP header element to encrypt cannot be WSSObject");
                    }
                    WSSObjectElement eeh = WSSObjectEncryptionGenerator.createEncryptedData((com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData)eh, el);
                    eh.setWSSObjectBase(eeh);
                    if (dek == null) {
                        WSSObjectElement eed = (WSSObjectElement)eeh.getChild(0);
                        Key key = WSSObjectSignatureGenerator.callKeyInfoGenerator(config2, "EncryptingKey", type, properties, doc, eed, context);
                        econtext.setKey(key);
                    } else {
                        econtext.setKey(dek);
                    }
                    econtext.setEncryptedType(eh, null, null, null);
                    econtext.encrypt();
                    econtext.replace();
                    econtext.clearEncryptedType();
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "EncryptedHeader with id[" + id + "] for header with name[" + el.getLocalName() + "] and namespace[" + el.getNamespace().getNamespaceURI() + "]");
                }
            }
        }
        catch (Exception e) {
            Tr.processException(e, clsName + ".encrypt", "1018");
            Tr.error(tc, "security.wssecurity.EncryptionGenerator.s12", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s12", new String[]{e.getMessage()}, (Throwable)e);
        }
        finally {
            econtext.finalizeHWConfig();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encrypt(KeyInfoGeneratorConfig config,Map type,Map properties,OMDocument doc,Map context,boolean sigAfterEnc,List pList,List idList,List hList,EncryptionContext econtext,OMElement einfo,EncryptedData ed,Document doc,Key dek, boolean userDefinedComponentsUsed)");
        }
    }

    private static void encryptKey(EncryptionContext econtext, EncryptedType et, Key dek, Key kek) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptKey(EncryptionContext econtext[" + econtext + "]," + "EncryptedType et[" + et + "]," + "Key dek[" + dek + "]," + "Key kek[" + kek + "])");
        }
        try {
            econtext.setData(dek);
            econtext.setEncryptedType(et, null, null, null);
            if (econtext.isHWAccelerationProvider()) {
                econtext.setHWKeyFromCache((PublicKey)kek);
            } else {
                econtext.setKey(kek);
            }
            econtext.encrypt();
        }
        catch (PKCS11Exception pkcse) {
            String rc = new Long(pkcse.getCode()).toString();
            Tr.error(tc, "Encrypting the key fails with PKCS11Exception and error code = " + pkcse.getCode());
            Tr.processException(pkcse, clsName + ".encryptKeyPKCS11", "1073");
            throw new SoapSecurityException("Encrypting the key for data encryption fails with exception " + pkcse.getMessage() + " and error code = " + rc, pkcse);
        }
        catch (Exception e) {
            Tr.processException(e, clsName + ".encryptKey", "1077");
            Tr.error(tc, "security.wssecurity.EncryptionGenerator.s13", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s13", new String[]{e.getMessage()}, (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptKey(EncryptionContext econtext,EncryptedType et,Key dek,Key kek)");
        }
    }

    private static WSSObjectElement createEncryptedData(com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData ed, OMElement el) throws StructureException {
        WSSObjectDocumentImpl wssObjectDocument = new WSSObjectDocumentImpl(1);
        OMContainer parent = el.getParent();
        if (parent instanceof OMElement) {
            wssObjectDocument.getNamespacesInAncestor().gatherDeclaredOMNamespacesInAncestor((OMElement)parent);
        } else {
            wssObjectDocument.getNamespacesInAncestor().gatherDeclaredOMNamespacesInAncestor(el);
        }
        WSSObjectElement eed = ed.createElement(wssObjectDocument);
        if (eed instanceof BelongsToNamespace) {
            WSSObjectElement belongsToNamespace = eed;
            wssObjectDocument.declareNamespace(belongsToNamespace.getNamespace());
        }
        eed.setParent(wssObjectDocument);
        wssObjectDocument.setRootWSSObject(eed);
        return eed;
    }

    private static WSSObjectElement createEncryptedData(com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData ed, WSSObjectElement el) throws StructureException {
        WSSObjectDocumentImpl wssObjectDocument = el.getWSSObjectDocument();
        WSSObjectElement eed = ed.createElement(wssObjectDocument);
        return eed;
    }

    private static WSSObjectElement insertEncryptionElement(Security parent, WSSObjectElement elem, List<ArrayList<XMLElement>> pList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insertEncryptionElement(Security parent[" + parent + "]," + "WSSObjectElement elem[" + elem + "]," + "List<ArrayList<XMLElement>> pList)");
        }
        HashSet<WSSObjectElement> set = null;
        WSSObject nextElem = null;
        WSSObject lastElem = null;
        ArrayList<WSSObject> children = null;
        if (parent != null && (children = parent.getChildren()) != null && children.size() > 0) {
            Iterator<WSSObject> iter = children.iterator();
            WSSObject el = null;
            while (iter.hasNext()) {
                lastElem = el = iter.next();
                if (el instanceof Signature || el instanceof EncryptedKey || el instanceof ReferenceList) {
                    nextElem = el;
                    break;
                }
                if (set == null) {
                    set = new HashSet<WSSObjectElement>();
                    Iterator<ArrayList<XMLElement>> i = pList.iterator();
                    block1: while (i.hasNext() && nextElem == null) {
                        XMLPartList parts = (XMLPartList)i.next();
                        for (int j = 0; j < parts.getLength(); ++j) {
                            XMLElement xel = parts.item(j);
                            OMElement encElem = null;
                            WSSObjectElement wsso = null;
                            if (xel.getType() == 1) {
                                encElem = (OMElement)xel.getOMNode();
                                continue;
                            }
                            if (xel.getType() != 2) continue;
                            wsso = xel.getWSSObject();
                            if (el.equals(wsso)) {
                                nextElem = el;
                                continue block1;
                            }
                            set.add(wsso);
                        }
                    }
                }
                if (nextElem != null) break;
                if (set == null || !set.contains(el)) continue;
                nextElem = el;
                break;
            }
        }
        if (lastElem == null) {
            parent.addChild(elem);
        } else if (nextElem == null) {
            parent.addChild(elem);
        } else {
            int index = children.indexOf(nextElem);
            parent.insertChildBefore(index, elem);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insertEncryptionElement(Security parent,WSSObjectElement elem,List<ArrayList<XMLElement>> pList) returns WSSObjectElement[" + elem + "]");
        }
        return elem;
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        public void showEncryptedResource(byte[] content, Object data, OMElement encType) {
            ByteArrayInputStream in = new ByteArrayInputStream(content);
            if (com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData.isOfType(encType) || EncryptedHeader.isOfType(encType)) {
                Tr.debug(tc, "ResourceShower logs encrypt-" + encType.getAttributeValue(new QName("", "Id")) + ": ");
                CommonLogUtils.logDebug(in, "UTF-8", tc);
            } else {
                Tr.debug(tc, "ResourceShower logs encrypt-EncryptedKey: ");
                CommonLogUtils.logDebugEncode64(content, tc);
            }
            try {
                in.close();
            }
            catch (Exception e) {
                Tr.debug(tc, "Caugh exception closing input stream: e=" + e.getMessage());
            }
        }

        public void showEncryptedResource(byte[] content, Object data, WSSObjectElement encType) {
            ByteArrayInputStream in = new ByteArrayInputStream(content);
            if (encType instanceof EncryptedData || encType instanceof com.ibm.ws.wssecurity.wssobject.impl.wsse11.EncryptedHeader) {
                String id = WSSObjectUtils.getIdAttributeValue(encType);
                Tr.debug(tc, "ResourceShower logs encrypt-" + id + ": ");
                CommonLogUtils.logDebug(in, "UTF-8", tc);
            } else {
                Tr.debug(tc, "ResourceShower logs encrypt-EncryptedKey: ");
                CommonLogUtils.logDebugEncode64(content, tc);
            }
            try {
                in.close();
            }
            catch (Exception e) {
                Tr.debug(tc, "Caugh exception closing input stream: e=" + e.getMessage());
            }
        }
    }
}

