/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.enc;

import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.ws.wssecurity.common.WSSAlgorithmFactory;
import com.ibm.ws.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.wssecurity.config.KeyInfoGeneratorConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.core.RequestMessagePool;
import com.ibm.ws.wssecurity.core.WSSGeneratorComponent;
import com.ibm.ws.wssecurity.dsig.SignatureGenerator;
import com.ibm.ws.wssecurity.enc.PartList;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.CommonLogUtils;
import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.QNameHeaderSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSObjectUtils;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.wssobject.impl.xenc.EncryptedData;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptionContext;
import com.ibm.ws.wssecurity.xml.xss4j.enc.ResourceShower;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherData;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherValue;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.DataReference;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedHeader;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.ReferenceList;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.ByteArrayInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11BodyImpl;
import org.apache.axiom.soap.impl.llom.soap12.SOAP12BodyImpl;
import org.apache.axis2.context.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptionGenerator
implements WSSGeneratorComponent {
    private static final TraceComponent tc = Tr.register(EncryptionGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = EncryptionGenerator.class.getName();
    private IdUtils _idResolver = null;
    private Map<Object, Object> _selectors = null;
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtils)map.get("com.ibm.ws.wssecurity.util.selector.IDResolver");
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMDocument doc, OMElement parent, Map<Object, Object> context) throws SoapSecurityException {
        String ehPreV7Compatibility;
        String ns;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "OMElement parent[" + DOMUtils.getDisplayName(parent) + "]," + "Map context)");
        }
        OMFactory omFactory = doc.getOMDocumentElement().getOMFactory();
        Object obj = context.get("com.ibm.ws.wssecurity.constants.soapVersion");
        int soapVersion = 0;
        if (obj != null && obj instanceof Integer) {
            soapVersion = (Integer)obj;
        }
        String nsSoap = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[2][soapVersion];
        obj = context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][wssVersion];
        String nsWsu = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][wssVersion];
        if (parent == null) {
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s15");
        }
        String ln = parent.getLocalName();
        String string = ns = parent.getNamespace() == null ? null : parent.getNamespace().getName();
        if (NamespaceUtil.isWsse(ns) != wssVersion || !"Security".equals(ln)) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s03", DOMUtils.getQualifiedName(parent), "Security");
        }
        String act = null;
        String role = null;
        String mu = null;
        String relay = null;
        if (soapVersion == 1) {
            role = parent.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP12_ROLE_Q);
            mu = parent.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP12_MU_Q);
            relay = parent.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP12_RELAY_Q);
        } else if (soapVersion == 0) {
            act = parent.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP11_ACTOR_Q);
            mu = parent.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP11_MU_Q);
        }
        context.put("com.ibm.ws.wssecurity.constants.mustUnderstandAttr", mu);
        context.put("com.ibm.ws.wssecurity.constants.actorAttr", act);
        context.put("com.ibm.ws.wssecurity.constants.roleAttr", role);
        context.put("com.ibm.ws.wssecurity.constants.relayAttr", relay);
        WSSGeneratorConfig gconfig = (WSSGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        EncryptionGeneratorConfig config2 = (EncryptionGeneratorConfig)context.remove("com.ibm.ws.wssecurity.impl.config.encryptionGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "EncryptionGeneratorConfig [" + config2 + "].");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Examining encrypting parts.");
        }
        boolean encryptSomething = false;
        boolean encryptNonce = false;
        HashSet<ReferencePartConfig.PartConfig> nonces = new HashSet<ReferencePartConfig.PartConfig>();
        HashMap<Object, Object> selectorMap = new HashMap<Object, Object>(context);
        selectorMap.put(NonceManager.class, gconfig.getNonceManager());
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.IDResolver", this._idResolver);
        PartList parts = null;
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<ArrayList<OMNode>> pList = new ArrayList<ArrayList<OMNode>>();
        ArrayList<ArrayList<OMNode>> hList = new ArrayList<ArrayList<OMNode>>();
        ArrayList<OMNode> eList = new ArrayList<OMNode>();
        ReferencePartConfig rpconfig = config2.getReference();
        Map<Object, Object> props = config2.getProperties();
        boolean encHeaderWSS10 = false;
        String encHeader = (String)props.get(Constants.ENCRYPTED_HEADER_GENERATE_WSS10);
        if (encHeader != null && encHeader.length() != 0 && encHeader.equalsIgnoreCase("true")) {
            encHeaderWSS10 = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Property com.ibm.wsspi.wssecurity.encryptedHeader.generate.WSS1.0 specified as true.");
            }
        }
        if ((ehPreV7Compatibility = (String)props.get(Constants.ENCRYPTED_HEADER_PRE_V7_COMPATIBILITY)) != null && ehPreV7Compatibility.length() != 0) {
            context.put(Constants.ENCRYPTED_HEADER_PRE_V7_COMPATIBILITY, ehPreV7Compatibility);
        }
        boolean encHeaderWSS11PreFP13 = false;
        encHeader = (String)props.get(Constants.ENCRYPTED_HEADER_GENERATE_WSS11_PRE_FP13);
        if (encHeader != null && encHeader.length() != 0 && encHeader.equalsIgnoreCase("true")) {
            encHeaderWSS11PreFP13 = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Property com.ibm.wsspi.wssecurity.encryptedHeader.generate.WSS1.1.pre.fp13 specified as true.");
            }
        }
        boolean isEncryptHeaderByQName = false;
        if (rpconfig != null && rpconfig.getParts() != null && rpconfig.getParts().iterator() != null) {
            for (ReferencePartConfig.PartConfig pconfig : rpconfig.getParts()) {
                if (pconfig.isTimestamp() || pconfig.isNonce()) {
                    encryptNonce = true;
                    nonces.add(pconfig);
                    continue;
                }
                String dialect = pconfig.getDialect();
                String keyword = pconfig.getKeyword();
                Class elemSelector = ConfidentialDialectElementSelector.class;
                boolean foundHeader = false;
                if (dialect.equals(com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER)) {
                    isEncryptHeaderByQName = true;
                    foundHeader = true;
                    selectorMap.put("com.ibm.ws.wssecurity.util.selector.headername", pconfig.getHeaderName());
                    selectorMap.put("com.ibm.ws.wssecurity.util.selector.headernamespace", pconfig.getHeaderNamespace());
                    if (act != null) {
                        selectorMap.put("com.ibm.ws.wssecurity.util.selector.actorOrRole", act);
                    } else {
                        selectorMap.put("com.ibm.ws.wssecurity.util.selector.actorOrRole", role);
                    }
                    elemSelector = QNameHeaderSelector.class;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Looking for header to encrypt with header name [" + pconfig.getHeaderName() + " and header namspace [" + pconfig.getHeaderNamespace() + "]");
                    }
                }
                if ((parts = (PartList)SignatureGenerator.getMessagePart(doc, dialect, keyword, "encryption_mode", this._selectors, elemSelector, selectorMap)) == null || parts.size() <= 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, parts.size() + " parts found.");
                }
                if (foundHeader && !encHeaderWSS10) {
                    hList.add(parts);
                } else {
                    pList.add(parts);
                }
                for (int j = 0; j < parts.size(); ++j) {
                    eList.add(parts.get(j));
                    boolean added = false;
                    while (!added) {
                        String newid = IdUtils.getInstance().makeUniqueId(context, "wssecurity_encryption_id_");
                        if (idList.contains(newid)) continue;
                        idList.add(newid);
                        added = true;
                    }
                    encryptSomething = true;
                }
            }
        }
        if (!encryptSomething) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke(Document doc, Element parent, Map context)");
            }
            return;
        }
        if (isEncryptHeaderByQName && !encHeaderWSS11PreFP13 && !encHeaderWSS10) {
            context.put("com.ibm.ws.wssecurity.constants.soapNsForAttr", nsSoap);
            context.put("com.ibm.ws.wssecurity.constants.wsuNsForAttr", nsWsu);
            String prefix = DOMUtils.getNamespacePrefix(parent, nsSoap);
            if (prefix == null || prefix.length() <= 0) {
                prefix = "env";
                context.put("com.ibm.ws.wssecurity.constants.soapNsPrefixForAttrDecl", "true");
            }
            context.put("com.ibm.ws.wssecurity.constants.soapNsPrefixForAttr", prefix);
            prefix = DOMUtils.getNamespacePrefix(parent, nsWsu);
            if (prefix == null || prefix.length() <= 0) {
                prefix = "wsu";
                context.put("com.ibm.ws.wssecurity.constants.wsuNsPrefixForAttrDecl", "true");
            }
            context.put("com.ibm.ws.wssecurity.constants.wsuNsPrefixForAttr", prefix);
            prefix = DOMUtils.getNamespacePrefix(parent, com.ibm.ws.wssecurity.common.Constants.NS_WSSE11);
            if (prefix == null || prefix.length() <= 0) {
                prefix = "wsse11";
                context.put("com.ibm.ws.wssecurity.constants.wsse11NsPrefixForAttrDecl", "true");
            }
            context.put("com.ibm.ws.wssecurity.constants.wsse11NsPrefixForAttr", prefix);
        }
        HashMap<Object, Object> type = new HashMap<Object, Object>();
        EncryptionContext econtext = new EncryptionContext();
        String encAlgorithm = null;
        AlgorithmConfig encMethod = config2.getKeyEncryptionMethod();
        if (encMethod != null) {
            encAlgorithm = encMethod.getAlgorithm();
        }
        econtext.setEncAlgorithm(encAlgorithm);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Encryption Algorithm : " + encAlgorithm);
        }
        WSSAlgorithmFactory afactory = gconfig.getAlgorithmFactory();
        econtext.setAlgorithmFactory(afactory);
        econtext.setHWConfig(gconfig, config2);
        boolean mtomOptimizeFlag = false;
        String mtomOptimize = (String)props.get(Constants.WSSECURITY_MTOM_OPTIMIZE_ENCRYPTED_DATA);
        if (mtomOptimize != null && mtomOptimize.length() != 0 && mtomOptimize.equalsIgnoreCase("true")) {
            mtomOptimizeFlag = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MTOM optimize property was specified for EncryptionInfo");
            }
        }
        econtext.setMTOMOptimize(mtomOptimizeFlag);
        if (tc.isDebugEnabled()) {
            econtext.setResourceShower(ShowerImpl.getInstance());
        }
        String keyencMethod = null;
        if (config2.getKeyEncryptionMethod() != null) {
            keyencMethod = config2.getKeyEncryptionMethod().getAlgorithm();
        }
        String dataEncMethod = null;
        dataEncMethod = config2.getDataEncryptionMethod().getAlgorithm();
        context.put("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm", dataEncMethod);
        boolean keygen = keyencMethod != null && keyencMethod.length() > 0;
        com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData ed = EncryptionGenerator.createEncryptedData(config2, omFactory, !keygen && gconfig.isUserDefinedComponentsUsed(), afactory);
        OMElement el = null;
        Key dek = null;
        if (keygen) {
            EncryptedKey ek = EncryptionGenerator.createEncryptedKey(config2, idList, afactory, omFactory, nsSoap, nsWsse, nsWsu, gconfig.isUserDefinedComponentsUsed());
            try {
                el = ek.createElement(omFactory, null);
                el = EncryptionGenerator.insertEncryptionElement(parent, el, pList);
            }
            catch (StructureException e) {
                Tr.processException(e, clsName + ".invoke", "322");
                throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s01", new String[]{"EncryptedKey", e.getMessage()}, (Throwable)e);
            }
            Key kek = SignatureGenerator.callKeyInfoGenerator(config2.getEncryptionKeyInfo(), "EncryptingKey", type, this._selectors, doc, el, context);
            if (context.get("com.ibm.ws.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress") != null) {
                String endpointReference = context.get("com.ibm.ws.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress").toString();
                if (config2 != null) {
                    endpointReference = endpointReference + config2.hashCode();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The target End point address = " + context.get("com.ibm.ws.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress").toString());
                }
                econtext.setEndpointReference(endpointReference);
            }
            dek = EncryptionGenerator.generateKey(econtext, ed, omFactory, kek);
            EncryptionGenerator.encryptKey(econtext, el, doc, dek, kek);
            DOMUtils.getOneChildElement(el, com.ibm.ws.wssecurity.common.Constants.NS_ENC, "ReferenceList");
        } else {
            ReferenceList rl = EncryptionGenerator.createReferenceList(idList, nsSoap, nsWsse, nsWsu);
            try {
                el = rl.createElement(omFactory, null);
                el = EncryptionGenerator.insertEncryptionElement(parent, el, pList);
            }
            catch (StructureException e) {
                Tr.processException(e, clsName + ".invoke", "355");
                throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s01", new String[]{"ReferenceList", e.getMessage()}, (Throwable)e);
            }
            dek = null;
        }
        if (encryptNonce) {
            Object[] objs = eList.toArray();
            for (ReferencePartConfig.PartConfig pconfig : nonces) {
                parts = (PartList)SignatureGenerator.getNoncePart(doc, objs, pconfig, "encryption_mode", this._selectors, ConfidentialDialectElementSelector.class, selectorMap);
            }
        }
        EncryptionGenerator.encrypt(config2.getEncryptionKeyInfo(), type, this._selectors, doc, context, config2.remainSignatureAfterEncryption(), pList, idList, hList, econtext, el, ed, dek, gconfig.isUserDefinedComponentsUsed());
        context.remove("com.ibm.ws.wssecurity.constants.mustUnderstandAttr");
        context.remove("com.ibm.ws.wssecurity.constants.actorAttr");
        context.remove("com.ibm.ws.wssecurity.constants.roleAttr");
        context.remove("com.ibm.ws.wssecurity.constants.relayAttr");
        if (isEncryptHeaderByQName && !encHeaderWSS11PreFP13 && !encHeaderWSS10) {
            context.remove("com.ibm.ws.wssecurity.constants.soapNsForAttr");
            context.remove("com.ibm.ws.wssecurity.constants.soapNsPrefixForAttr");
            context.remove("com.ibm.ws.wssecurity.constants.soapNsPrefixForAttrDecl");
            context.remove("com.ibm.ws.wssecurity.constants.wsuNsForAttr");
            context.remove("com.ibm.ws.wssecurity.constants.wsuNsPrefixForAttr");
            context.remove("com.ibm.ws.wssecurity.constants.wsuNsPrefixForAttrDecl");
            context.remove("com.ibm.ws.wssecurity.constants.wsse11NsPrefixForAttr");
            context.remove("com.ibm.ws.wssecurity.constants.wsse11NsPrefixForAttrDecl");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(OMDocument doc, OMElement parent, Map context)");
        }
    }

    private static EncryptedKey createEncryptedKey(EncryptionGeneratorConfig config2, List<String> ids, WSSAlgorithmFactory factory, OMFactory doc, String nsSoap, String nsWsse, String nsWsu, boolean userDefinedComponentsUsed) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEncryptedKey(EncryptionGeneratorConfig config,List ids[" + ids + "]," + "WSSAlgorithmFactory factory[" + factory + "]," + "OMFactory doc[" + doc + "]," + "String nsSoap[" + nsSoap + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "]," + "boolean userDefinedComponentsUsed[" + userDefinedComponentsUsed + "])");
        }
        EncryptedKey ek = new EncryptedKey();
        ek.setEncryptionMethod(EncryptionGenerator.createEncryptionMethod(config2.getKeyEncryptionMethod(), factory));
        if (userDefinedComponentsUsed) {
            ek.setKeyInfo(EncryptionGenerator.createKeyInfo(doc));
        }
        ek.setCipherData(EncryptionGenerator.createCipherData());
        ek.setReferenceList(EncryptionGenerator.createReferenceList(ids, nsSoap, nsWsse, nsWsu));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEncryptedKey(EncryptionGeneratorConfig config,List ids,WSSAlgorithmFactory factory,OMFactory doc,String nsSoap,String nsWsse,String nsWsu,boolean userDefinedComponentsUsed) returns EncryptedKey[" + ek + "]");
        }
        return ek;
    }

    private static EncryptionMethod createEncryptionMethod(AlgorithmConfig aconfig, WSSAlgorithmFactory factory) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEncryptionMethod(AlgorithmConfig aconfig[" + aconfig + "]," + "WSSAlgorithmFactory factory[" + factory + "])");
        }
        EncryptionMethod em = new EncryptionMethod();
        em.setAlgorithm(aconfig.getAlgorithm());
        try {
            AlgorithmParameterSpec spec = factory.convertParameter(aconfig.getAlgorithm(), aconfig.getProperties());
            if (spec != null) {
                em.setParameterSpec(factory, spec);
            }
        }
        catch (InvalidAlgorithmParameterException e) {
            Tr.processException(e, clsName + ".createEncryptionMethod", "493");
            Tr.error(tc, "security.wssecurity.EncryptionGenerator.s14", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s14", new String[]{e.getMessage()}, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            Tr.processException(e, clsName + ".createEncryptionMethod", "497");
            Tr.error(tc, "security.wssecurity.EncryptionGenerator.s14", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s14", new String[]{e.getMessage()}, (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEncryptionMethod(AlgorithmConfig aconfig,WSSAlgorithmFactory factory) returns EncryptionMethod[" + em + "]");
        }
        return em;
    }

    private static KeyInfo createKeyInfo(OMFactory factory) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createKeyInfo(OMFactory factory[" + factory + "])");
        }
        KeyInfo ki = new KeyInfo();
        ki.addElement(factory.createOMElement("dummy", "", ""));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createKeyInfo(Document doc) returns KeyInfo[" + ki + "]");
        }
        return ki;
    }

    private static CipherData createCipherData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCipherData()");
        }
        CipherValue cv = new CipherValue();
        CipherData cd = new CipherData();
        cd.setCipherValue(cv);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCipherData() returns CipherData[" + cd + "]");
        }
        return cd;
    }

    private static ReferenceList createReferenceList(List<String> ids, String nsSoap, String nsWsse, String nsWsu) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createReferenceList(List ids[" + ids + "]," + "String nsSoap[" + nsSoap + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "])");
        }
        ReferenceList rl = new ReferenceList();
        for (String id : ids) {
            DataReference dataRef = new DataReference();
            dataRef.setURI("#" + id);
            rl.addDataReference(dataRef);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createReferenceList(List ids,Document doc,String nsSoap,String nsWsse,String nsWsu) returns ReferenceList[" + rl + "]");
        }
        return rl;
    }

    private static com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData createEncryptedData(EncryptionGeneratorConfig config2, OMFactory doc, boolean createKeyInfo, WSSAlgorithmFactory factory) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEncryptedData(EncryptionGeneratorConfig config,OMFactory doc[" + doc + "]," + "boolean createKeyInfo[" + createKeyInfo + "]," + "WSSAlgorithmFactory factory[" + factory + "])");
        }
        com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData ed = new com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData();
        ed.setEncryptionMethod(EncryptionGenerator.createEncryptionMethod(config2.getDataEncryptionMethod(), factory));
        if (createKeyInfo) {
            ed.setKeyInfo(EncryptionGenerator.createKeyInfo(doc));
        }
        ed.setCipherData(EncryptionGenerator.createCipherData());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEncryptedData(EncryptionGeneratorConfig config,Document doc,boolean createKeyInfo,WSSAlgorithmFactory factory) returns EncryptedData[" + ed + "]");
        }
        return ed;
    }

    private static Key generateKey(EncryptionContext econtext, com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData ed, OMFactory factory, Key kek) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateKey(EncryptionContext econtext[" + econtext + "]," + "EncryptedData ed[" + ed + "]," + "OMFactory factory[" + factory + "]," + "Key kek[" + kek + "])");
        }
        Key key = null;
        try {
            econtext.setEncryptedType(ed.createElement(factory, null), null, null, null);
            key = econtext.generateKey();
        }
        catch (Exception e) {
            Tr.processException(e, clsName + ".generateKey", "638");
            Tr.error(tc, "security.wssecurity.EncryptionGenerator.s11", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s11", new String[]{e.getMessage()}, (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateKey(EncryptionContext econtext,EncryptedData ed,OMFactory factory,Key kek) returns Key[" + key + "]");
        }
        return key;
    }

    private static void encrypt(KeyInfoGeneratorConfig config2, Map<Object, Object> type, Map<Object, Object> properties, OMDocument doc, Map<Object, Object> context, boolean sigAfterEnc, List<ArrayList<OMNode>> pList, List<String> idList, List<ArrayList<OMNode>> hList, EncryptionContext econtext, OMElement einfo, com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData ed, Key dek, boolean userDefinedComponentsUsed) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encrypt(KeyInfoGeneratorConfig config,Map type,Map properties,OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "Map context," + "boolean sigAfterEnc," + "List pList[plist]" + "List idList[" + idList + "]," + "List hList[hlist]," + "EncryptionContext econtext[" + econtext + "]," + "OMElement einfo[" + DOMUtils.getDisplayName(einfo) + "]," + "EncryptedData ed[" + ed + "]," + "Key dek[" + dek + "], " + "boolean userDefinedComponentsUsed[" + userDefinedComponentsUsed + "])");
            Tr.debug(tc, "List pList is a List of OMNode ArrayLists. Listing now its contents.");
            CommonLogUtils.logDebug(pList, tc);
            Tr.debug(tc, "List hList is a List of OMNode ArrayLists. Listing now its contents.");
            CommonLogUtils.logDebug(hList, tc);
        }
        OMFactory factory = doc.getOMDocumentElement().getOMFactory();
        if (dek == null && userDefinedComponentsUsed) {
            ed.setKeyInfo(EncryptionGenerator.createKeyInfo(factory));
        }
        MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        RequestMessagePool.addDocument(context, doc, pList, hList, sigAfterEnc);
        try {
            String declWsse11NsPrefix;
            String declWsuNsPrefix;
            int idp = idList.size() - 1;
            for (PartList partList : pList) {
                for (int j = 0; j < partList.getLength(); ++j) {
                    OMNode child;
                    String encType = partList.getType();
                    OMElement el = (OMElement)partList.item(j);
                    String id = idList.get(idp--);
                    ed.setId(id);
                    ed.setType(encType);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "plist: el is of type " + el.getClass().getName());
                    }
                    byte[] bodyBytes = null;
                    ByteArrayHolder encryptedBodyBytes = null;
                    if ((el instanceof SOAP11BodyImpl || el instanceof SOAP12BodyImpl) && (child = el.getFirstOMChild()) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "child: el is of type " + child.getClass().getName());
                        }
                        if (child instanceof OMSourcedElementImpl) {
                            if (messageContext != null) {
                                bodyBytes = (byte[])messageContext.getProperty("com.ibm.ws.wssecurity.filter.BodyC14NFilter.BODY_CONTENT_C14N_RESULT");
                                messageContext.setProperty("com.ibm.ws.wssecurity.filter.BodyC14NFilter.BODY_CONTENT_C14N_RESULT", null);
                            }
                            if (tc.isDebugEnabled()) {
                                if (bodyBytes == null || bodyBytes.length == 0) {
                                    Tr.debug(tc, "Could not retrieve C14N body content byte[] from MessageContext; using OMSourcedElement");
                                } else {
                                    Tr.debug(tc, "Retrieved C14N body content byte[] from MessageContext");
                                }
                            }
                            if (messageContext != null) {
                                encryptedBodyBytes = (ByteArrayHolder)messageContext.getProperty("com.ibm.ws.wssecurity.enc.EncryptedBodyByteArrayHolder");
                                messageContext.setProperty("com.ibm.ws.wssecurity.enc.EncryptedBodyByteArrayHolder", null);
                            }
                            if (tc.isDebugEnabled()) {
                                if (encryptedBodyBytes == null || encryptedBodyBytes.getLength() == 0) {
                                    Tr.debug(tc, "Could not retrieve encrypted body content byte[] from MessageContext; using OMSourcedElement");
                                } else {
                                    Tr.debug(tc, "Retrieved encrypted body content byte[] from MessageContext");
                                }
                            }
                        }
                    }
                    if (bodyBytes != null && bodyBytes.length > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting byte[] to EncryptionContext");
                        }
                        econtext.setData(bodyBytes);
                    } else if (encryptedBodyBytes != null && encryptedBodyBytes.getLength() > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting ByteArrayHolder to EncryptionContext");
                        }
                        econtext.setEncryptedData(encryptedBodyBytes);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting OMElement to EncryptionContext");
                        }
                        econtext.setData(el);
                    }
                    OMElement eed = ed.createElement(factory, null);
                    if (dek == null) {
                        Key key = SignatureGenerator.callKeyInfoGenerator(config2, "EncryptingKey", type, properties, doc, eed, context);
                        econtext.setKey(key);
                    } else {
                        econtext.setKey(dek);
                    }
                    econtext.setEncryptedType(eed, null, null, null);
                    econtext.encrypt();
                    if (bodyBytes != null && bodyBytes.length > 0 || encryptedBodyBytes != null && encryptedBodyBytes.getLength() > 0) {
                        econtext.replace(el);
                    } else {
                        econtext.replace();
                    }
                    RequestMessagePool.addElement(context, el, econtext.getEncryptedTypeAsElement(), einfo);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Encrypted part with id[" + id + "] for part with name[" + el.getLocalName() + "] and namespace[" + el.getNamespace().getNamespaceURI() + "]");
                }
            }
            String string = (String)context.get("com.ibm.ws.wssecurity.constants.mustUnderstandAttr");
            String act = (String)context.get("com.ibm.ws.wssecurity.constants.actorAttr");
            String role = (String)context.get("com.ibm.ws.wssecurity.constants.roleAttr");
            String relay = (String)context.get("com.ibm.ws.wssecurity.constants.relayAttr");
            String nsSoap = (String)context.get("com.ibm.ws.wssecurity.constants.soapNsForAttr");
            String nsWsu = (String)context.get("com.ibm.ws.wssecurity.constants.wsuNsForAttr");
            String nsSoapPrefix = (String)context.get("com.ibm.ws.wssecurity.constants.soapNsPrefixForAttr");
            String nsWsuPrefix = (String)context.get("com.ibm.ws.wssecurity.constants.wsuNsPrefixForAttr");
            String nsWsse11Prefix = (String)context.get("com.ibm.ws.wssecurity.constants.wsse11NsPrefixForAttr");
            String preV7Compatibility = (String)context.get(Constants.ENCRYPTED_HEADER_PRE_V7_COMPATIBILITY);
            EncryptedHeader eh = new EncryptedHeader();
            eh.setMustUnderstand(string);
            eh.setActor(act);
            eh.setRole(role);
            eh.setRelay(relay);
            eh.setSoapNs(nsSoap);
            eh.setWsuNs(nsWsu);
            eh.setSoapNsPrefix(nsSoapPrefix);
            eh.setWsuNsPrefix(nsWsuPrefix);
            eh.setWsse11NsPrefix(nsWsse11Prefix);
            eh.initFromEncryptedData(ed);
            if ("true".equalsIgnoreCase(preV7Compatibility)) {
                eh.setPreV7Compatibility(true);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Property " + Constants.ENCRYPTED_HEADER_PRE_V7_COMPATIBILITY + " specified as true.");
                }
            }
            boolean isDeclSoapNsPrefix = false;
            boolean isDeclWsuNsPrefix = false;
            boolean isDeclWsse11NsPrefix = false;
            String declSoapNsPrefix = (String)context.get("com.ibm.ws.wssecurity.constants.soapNsPrefixForAttrDecl");
            if (declSoapNsPrefix != null && declSoapNsPrefix.length() != 0 && declSoapNsPrefix.equalsIgnoreCase("true")) {
                isDeclSoapNsPrefix = true;
            }
            if ((declWsuNsPrefix = (String)context.get("com.ibm.ws.wssecurity.constants.wsuNsPrefixForAttrDecl")) != null && declWsuNsPrefix.length() != 0 && declWsuNsPrefix.equalsIgnoreCase("true")) {
                isDeclWsuNsPrefix = true;
            }
            if ((declWsse11NsPrefix = (String)context.get("com.ibm.ws.wssecurity.constants.wsse11NsPrefixForAttrDecl")) != null && declWsse11NsPrefix.length() != 0 && declWsse11NsPrefix.equalsIgnoreCase("true")) {
                isDeclWsse11NsPrefix = true;
            }
            for (PartList partList : hList) {
                for (int j = 0; j < partList.getLength(); ++j) {
                    String encType = partList.getType();
                    OMElement el = (OMElement)partList.item(j);
                    String id = idList.get(idp--);
                    eh.setId(id);
                    eh.setType(encType);
                    econtext.setData(el);
                    OMElement eeh = eh.createElement(factory, true, isDeclSoapNsPrefix, isDeclWsuNsPrefix, isDeclWsse11NsPrefix);
                    if (dek == null) {
                        OMElement eed = eeh.getFirstElement();
                        Key key = SignatureGenerator.callKeyInfoGenerator(config2, "EncryptingKey", type, properties, doc, eed, context);
                        econtext.setKey(key);
                    } else {
                        econtext.setKey(dek);
                    }
                    econtext.setEncryptedType(eeh, null, null, null);
                    econtext.encrypt();
                    econtext.replace();
                    RequestMessagePool.addElement(context, el, econtext.getEncryptedTypeAsElement(), einfo);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "EncryptedHeader with id[" + id + "] for header with name[" + el.getLocalName() + "] and namespace[" + el.getNamespace().getNamespaceURI() + "]");
                }
            }
        }
        catch (Exception e) {
            Tr.processException(e, clsName + ".encrypt", "730");
            Tr.error(tc, "security.wssecurity.EncryptionGenerator.s12", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s12", new String[]{e.getMessage()}, (Throwable)e);
        }
        finally {
            econtext.finalizeHWConfig();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encrypt(KeyInfoGeneratorConfig config,Map type,Map properties,OMDocument doc,Map context,boolean sigAfterEnc,List pList,List idList,List hList,EncryptionContext econtext,OMElement einfo,EncryptedData ed,Document doc,Key dek, boolean userDefinedComponentsUsed)");
        }
    }

    private static void encryptKey(EncryptionContext econtext, OMElement ed, OMDocument doc, Key dek, Key kek) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptKey(EncryptionContext econtext[" + econtext + "]," + "OMElement ed[" + ed + "]," + "OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "Key dek[" + dek + "]," + "Key kek[" + kek + "])");
        }
        try {
            econtext.setData(dek);
            econtext.setEncryptedType(ed, null, null, null);
            if (econtext.isHWAccelerationProvider()) {
                econtext.setHWKeyFromCache((PublicKey)kek);
            } else {
                econtext.setKey(kek);
            }
            econtext.encrypt();
        }
        catch (PKCS11Exception pkcse) {
            String rc = new Long(pkcse.getCode()).toString();
            Tr.error(tc, "Encrypting the key fails with PKCS11Exception and error code = " + pkcse.getCode());
            Tr.processException(pkcse, clsName + ".encryptKeyPKCS11", "1102");
            throw new SoapSecurityException("Encrypting the key for data encryption fails with exception " + pkcse.getMessage() + " and error code = " + rc, pkcse);
        }
        catch (Exception e) {
            Tr.processException(e, clsName + ".encryptKey", "1106");
            Tr.error(tc, "security.wssecurity.EncryptionGenerator.s13", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s13", new String[]{e.getMessage()}, (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptKey(EncryptionContext econtext,OMElement ed,OMDocument doc,Key dek,Key kek)");
        }
    }

    private static OMElement insertEncryptionElement(OMElement parent, OMElement elem, List<ArrayList<OMNode>> pList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insertEncryptionElement(OMElement parent[" + DOMUtils.getDisplayName(parent) + "]," + "OMElement elem[" + DOMUtils.getDisplayName(elem) + "]," + "List<ArrayList<OMNode>> pList)");
        }
        HashSet<OMElement> set = null;
        String lnSign = "Signature";
        String lnEncKey = "EncryptedKey";
        String lnRefList = "ReferenceList";
        OMNode nextElem = null;
        OMElement lastElem = null;
        if (parent != null) {
            OMElement el = DOMUtils.getFirstElement(parent);
            while (el != null) {
                lastElem = el;
                String ns = el.getNamespace() == null ? null : el.getNamespace().getNamespaceURI();
                String ln = el.getLocalName();
                if (com.ibm.ws.wssecurity.common.Constants.NS_ENC.equals(ns) && (lnEncKey.equals(ln) || lnRefList.equals(ln)) || com.ibm.ws.wssecurity.common.Constants.NS_DSIG.equals(ns) && lnSign.equals(ln)) {
                    nextElem = el;
                    break;
                }
                if (set == null) {
                    set = new HashSet<OMElement>();
                    Iterator<ArrayList<OMNode>> i = pList.iterator();
                    block1: while (i.hasNext() && nextElem == null) {
                        PartList parts = (PartList)i.next();
                        for (int j = 0; j < parts.getLength(); ++j) {
                            OMElement encElem = (OMElement)parts.item(j);
                            if (el.equals(encElem)) {
                                nextElem = el;
                                continue block1;
                            }
                            set.add(encElem);
                        }
                    }
                }
                if (nextElem != null) break;
                if (set != null && set.contains(el)) {
                    nextElem = el;
                    break;
                }
                el = DOMUtils.getNextElement(el);
            }
        }
        if (lastElem == null) {
            parent.addChild(elem);
        } else if (nextElem == null) {
            parent.addChild(elem);
        } else {
            nextElem.insertSiblingBefore(elem);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insertEncryptionElement(OMElement parent,OMElement elem,List<ArrayList<OMNode>> pList) returns Element[" + DOMUtils.getDisplayName(elem) + "]");
        }
        return elem;
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        public void showEncryptedResource(byte[] content, Object data, OMElement encType) {
            ByteArrayInputStream in = new ByteArrayInputStream(content);
            if (com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData.isOfType(encType) || EncryptedHeader.isOfType(encType)) {
                Tr.debug(tc, "ResourceShower logs encrypt-" + encType.getAttributeValue(new QName("", "Id")));
                CommonLogUtils.logDebug(in, "UTF-8", tc);
            } else {
                Tr.debug(tc, "ResourceShower logs encrypt-EncryptedKey: ");
                CommonLogUtils.logDebugEncode64(content, tc);
            }
            try {
                in.close();
            }
            catch (Exception e) {
                Tr.debug(tc, "Caugh exception closing input stream: e=" + e.getMessage());
            }
        }

        public void showEncryptedResource(byte[] content, Object data, WSSObjectElement encType) {
            ByteArrayInputStream in = new ByteArrayInputStream(content);
            if (encType instanceof EncryptedData || encType instanceof com.ibm.ws.wssecurity.wssobject.impl.wsse11.EncryptedHeader) {
                String id = WSSObjectUtils.getIdAttributeValue(encType);
                Tr.debug(tc, "ResourceShower logs encrypt-" + id + ": ");
                CommonLogUtils.logDebug(in, "UTF-8", tc);
            } else {
                Tr.debug(tc, "ResourceShower logs encrypt-EncryptedKey: ");
                CommonLogUtils.logDebugEncode64(content, tc);
            }
            try {
                in.close();
            }
            catch (Exception e) {
                Tr.debug(tc, "Caugh exception closing input stream: e=" + e.getMessage());
            }
        }
    }
}

