/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.dsig;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.WSSAlgorithmFactory;
import com.ibm.ws.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.wssecurity.config.KeyInfoGeneratorConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.SignatureGeneratorConfig;
import com.ibm.ws.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.core.ElementSelector;
import com.ibm.ws.wssecurity.core.RequestMessagePool;
import com.ibm.ws.wssecurity.core.WSSGeneratorComponent;
import com.ibm.ws.wssecurity.core.XMLElement;
import com.ibm.ws.wssecurity.dsig.STRDTKeyInfoResolver;
import com.ibm.ws.wssecurity.dsig.WSSSignatureContext;
import com.ibm.ws.wssecurity.handler.WSSecurityGeneratorHandler;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoGenerator;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoGeneratorComponent;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.CommonLogUtils;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdAttributeValue;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.MappingIdResolver;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.QNameHeaderSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSPFunctionElementSelector;
import com.ibm.ws.wssecurity.util.WSSObjectUtils;
import com.ibm.ws.wssecurity.util.XPathElementSelector;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.CanonicalizationMethod;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.Signature;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.SignedInfo;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.Transform;
import com.ibm.ws.wssecurity.wssobject.impl.wsse10.Security;
import com.ibm.ws.wssecurity.wssobject.impl.xc14n.InclusiveNamespaces;
import com.ibm.ws.wssecurity.wssobject.impl.xenc.EncryptedKey;
import com.ibm.ws.wssecurity.wssobject.impl.xenc.ReferenceList;
import com.ibm.ws.wssecurity.wssobject.interfaces.Parent;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObject;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.NamespacePrefixPair;
import com.ibm.ws.wssecurity.wssobject.util.NamespacePrefixPairSortedSet;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartTextValue;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsQNames;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsVariableParts;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMNamespaceWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ResourceShower;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.WSSObjectReference;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.WSSObjectTemplateGenerator;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.HWKeyCache;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import java.io.ByteArrayInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.saaj.SOAPElementImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSObjectSignatureGenerator
implements WSSGeneratorComponent {
    private static final TraceComponent tc = Tr.register(WSSObjectSignatureGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSObjectSignatureGenerator.class.getName();
    private static final String SIGNATURE_PREFIX = "ds";
    private IdUtils _idResolver = null;
    private Map<Object, Object> _selectors = null;
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtils)map.get("com.ibm.ws.wssecurity.util.selector.IDResolver");
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMDocument doc, OMElement parent, Map<Object, Object> context) throws SoapSecurityException {
        int index;
        ArrayList<XMLElement> parts;
        SigningReferenceConfig srconfig;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(Document doc[" + DOMUtils.getDisplayName(doc) + "]," + "Element parent[" + DOMUtils.getDisplayName(parent) + "]," + "Map context)");
        }
        OMFactory omFactory = doc.getOMDocumentElement().getOMFactory();
        Object object = context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (object != null && object instanceof Integer) {
            wssVersion = (Integer)object;
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        String nsWsu = Constants.NAMESPACES[1][wssVersion];
        Security security = WSSObjectUtils.getWSSObjectSecurityHeader(context);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security header at start of signature generation = " + security);
        }
        if (security == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s13", "ds:Signature");
        }
        NamespacePrefixPair nspp = security.getNamespace();
        String ns = nspp.getUri();
        String pWsse = nspp.getPrefix();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security namespace prefix = " + pWsse);
            Tr.debug(tc, "Security namespace = " + ns);
        }
        if (NamespaceUtil.isWsse(ns) != wssVersion) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s03", "{" + ns + "}Security", "{" + nsWsse + "}Security");
        }
        WSSGeneratorConfig gconfig = (WSSGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        SignatureGeneratorConfig config2 = (SignatureGeneratorConfig)context.remove("com.ibm.ws.wssecurity.impl.config.signatureGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SignatureGeneratorConfig [" + config2 + "].");
        }
        HashMap<Object, Object> type = new HashMap<Object, Object>(2);
        WSSObjectDocumentImpl wssObjectDocument = security.getWSSObjectDocument();
        String canonicalizationMethod = config2.getCanonicalizationMethod().getAlgorithm();
        String signatureMethod = config2.getSignatureMethod().getAlgorithm();
        WSSObjectTemplateGenerator gen = new WSSObjectTemplateGenerator(omFactory, null, canonicalizationMethod, signatureMethod, wssObjectDocument);
        gen.setPrefix(SIGNATURE_PREFIX);
        boolean isGoldenPath = false;
        if (gconfig instanceof PrivateGeneratorConfig) {
            boolean isNormalBodyProcessing = gconfig.isNormalBodyProcessing();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isNormalBodyProcessing = " + isNormalBodyProcessing);
            }
            if (isNormalBodyProcessing) {
                MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                if (messageContext == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "no MessageContext");
                    }
                } else {
                    boolean securityIsLastPhase = false;
                    ArrayList outPhases = messageContext.getConfigurationContext().getAxisConfiguration().getOutFlowPhases();
                    if (outPhases != null && outPhases.size() > 0) {
                        Phase lastPhase = (Phase)outPhases.get(outPhases.size() - 1);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "last phase = " + lastPhase.getName());
                        }
                        if ("Security".equals(lastPhase.getName())) {
                            for (Object handler : lastPhase.getHandlers()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "handler class = " + handler.getClass().getName());
                                }
                                if (!(handler instanceof WSSecurityGeneratorHandler)) continue;
                                securityIsLastPhase = true;
                                break;
                            }
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "securityIsLastPhase = " + securityIsLastPhase);
                    }
                    if (securityIsLastPhase) {
                        context.put("com.ibm.ws.wssecurity.filter.BodyC14NFilter.IS_OUTBOUND_GOLDEN_PATH", Boolean.TRUE);
                        if (config2.addInclusiveNamespaces()) {
                            context.put("com.ibm.ws.wssecurity.filter.BodyC14NFilter.IS_INCL_NS_ALL_PREFIXES", Boolean.TRUE);
                        }
                        isGoldenPath = true;
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isGoldenPth = " + isGoldenPath);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Examining signing parts.");
        }
        OMElement root = doc.getOMDocumentElement();
        boolean signSomething = false;
        boolean signNonce = false;
        HashSet<ReferencePartConfig.PartConfig> nonces1 = null;
        HashMap<ReferencePartConfig.PartConfig, SigningReferenceConfig> nonces2 = null;
        HashMap<ReferencePartConfig.PartConfig, HashMap<Object, Object>> nonces3 = null;
        boolean signSpecial = false;
        HashSet<ReferencePartConfig.PartConfig> specials1 = null;
        HashMap<ReferencePartConfig.PartConfig, SigningReferenceConfig> specials2 = null;
        HashMap<ReferencePartConfig.PartConfig, HashMap<Object, Object>> specials3 = null;
        HashMap<String, XMLElement> idToPart = new HashMap<String, XMLElement>();
        ArrayList<XMLElement> list = new ArrayList<XMLElement>();
        Iterator<SigningReferenceConfig> i1 = null;
        if (config2 != null && config2.getReferences() != null && config2.getReferences().iterator() != null) {
            i1 = config2.getReferences().iterator();
        }
        if (i1 != null) {
            while (i1.hasNext()) {
                HashMap<Object, Object> cpSelectorMap = new HashMap<Object, Object>(context);
                cpSelectorMap.put("com.ibm.ws.wssecurity.util.selector.IDResolver", this._idResolver);
                cpSelectorMap.put(NonceManager.class, gconfig.getNonceManager());
                cpSelectorMap.put("com.ibm.ws.wssecurity.util.selector.config", gconfig.getTokenGenerators());
                srconfig = i1.next();
                WSSObjectSignatureGenerator.prepareTransform(srconfig, cpSelectorMap);
                ReferencePartConfig rpconfig = srconfig.getReference();
                if (rpconfig == null || rpconfig.getParts() == null || rpconfig.getParts().iterator() == null) continue;
                block13: for (ReferencePartConfig.PartConfig pconfig : rpconfig.getParts()) {
                    if (pconfig.isTimestamp() || pconfig.isNonce()) {
                        signNonce = true;
                        if (nonces1 == null) {
                            nonces1 = new HashSet<ReferencePartConfig.PartConfig>();
                            nonces2 = new HashMap<ReferencePartConfig.PartConfig, SigningReferenceConfig>();
                            nonces3 = new HashMap<ReferencePartConfig.PartConfig, HashMap<Object, Object>>();
                        }
                        nonces1.add(pconfig);
                        nonces2.put(pconfig, srconfig);
                        nonces3.put(pconfig, cpSelectorMap);
                        continue;
                    }
                    if (Constants.DIALECT_WAS.equals(pconfig.getDialect()) && (IntegralDialectElementSelector.WASDIALECTS[2].equals(pconfig.getKeyword()) || IntegralDialectElementSelector.WASDIALECTS[3].equals(pconfig.getKeyword())) || Constants.DIALECT_XPATH.equals(pconfig.getDialect())) {
                        signSpecial = true;
                        if (specials1 == null) {
                            specials1 = new HashSet<ReferencePartConfig.PartConfig>();
                            specials2 = new HashMap<ReferencePartConfig.PartConfig, SigningReferenceConfig>();
                            specials3 = new HashMap<ReferencePartConfig.PartConfig, HashMap<Object, Object>>();
                        }
                        specials1.add(pconfig);
                        specials2.put(pconfig, srconfig);
                        specials3.put(pconfig, cpSelectorMap);
                        continue;
                    }
                    boolean processed = false;
                    String dialect = pconfig.getDialect();
                    String keyword = pconfig.getKeyword();
                    Class elemSelector = IntegralDialectElementSelector.class;
                    if (dialect.equals(Constants.DIALECT_HEADER)) {
                        cpSelectorMap.put("com.ibm.ws.wssecurity.util.selector.headername", pconfig.getHeaderName());
                        cpSelectorMap.put("com.ibm.ws.wssecurity.util.selector.headernamespace", pconfig.getHeaderNamespace());
                        elemSelector = QNameHeaderSelector.class;
                    }
                    OMDocument doc2 = doc;
                    int docOrder = -1;
                    while (doc2 != null) {
                        parts = WSSObjectSignatureGenerator.getMessagePart(doc2, dialect, keyword, "signature_mode", this._selectors, elemSelector, cpSelectorMap);
                        if (parts != null && parts.size() > 0) {
                            processed = false;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, parts.size() + " parts found.");
                            }
                            for (int j = 0; j < parts.size(); ++j) {
                                WSSObjectReference ref;
                                XMLElement part = parts.get(j);
                                if (docOrder >= 0) {
                                    String elemName;
                                    IdAttributeValue idAttrVal;
                                    XMLElement xel;
                                    RequestMessagePool.EncryptedObject eobj = null;
                                    if (eobj == null) continue;
                                    if (eobj.getEncryptedData() != null) {
                                        xel = new XMLElement(eobj.getEncryptedData());
                                        idAttrVal = WSSObjectSignatureGenerator.addWsuId(doc, xel, nsWsu, idToPart, context);
                                        WSSObjectReference ref2 = gen.createReference(idAttrVal.getVariablePartRefValue());
                                        ref2.setDigestMethod(srconfig.getDigestMethod().getAlgorithm());
                                        WSSObjectSignatureGenerator.addTransforms(ref2, xel, srconfig.getTransforms(), config2.addInclusiveNamespaces(), isGoldenPath, wssObjectDocument);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Security header after adding Transform = " + security);
                                        }
                                        gen.addReference(ref2);
                                        signSomething = true;
                                        list.add(part);
                                        if (tc.isDebugEnabled()) {
                                            elemName = null;
                                            if (part.getType() == 1) {
                                                elemName = DOMUtils.getDisplayName(part.getOMNode());
                                            } else if (part.getType() == 2) {
                                                elemName = part.getWSSObject().getQName().toString();
                                            }
                                            Tr.debug(tc, "Added the encrypted data[" + DOMUtils.getDisplayName(eobj.getEncryptedData()) + "] because the element[" + elemName + "] has already encrypted.");
                                        }
                                    }
                                    if (eobj.getHeaderInfo() == null) continue;
                                    xel = new XMLElement(eobj.getHeaderInfo());
                                    idAttrVal = WSSObjectSignatureGenerator.addWsuId(doc, xel, nsWsu, idToPart, context);
                                    WSSObjectReference ref2 = gen.createReference(idAttrVal.getVariablePartRefValue());
                                    ref2.setDigestMethod(srconfig.getDigestMethod().getAlgorithm());
                                    WSSObjectSignatureGenerator.addTransforms(ref2, xel, srconfig.getTransforms(), config2.addInclusiveNamespaces(), isGoldenPath, wssObjectDocument);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Security header after adding Transform = " + security);
                                    }
                                    gen.addReference(ref2);
                                    signSomething = true;
                                    list.add(part);
                                    if (!tc.isDebugEnabled()) continue;
                                    elemName = null;
                                    if (part.getType() == 1) {
                                        elemName = DOMUtils.getDisplayName(part.getOMNode());
                                    } else if (part.getType() == 2) {
                                        elemName = part.getWSSObject().getQName().toString();
                                    }
                                    Tr.debug(tc, "Added the header info[" + DOMUtils.getDisplayName(eobj.getHeaderInfo()) + "] because the element[" + elemName + "] has already encrypted.");
                                    continue;
                                }
                                if (part.getType() == 1 && DOMUtils.equals(part.getOMNode(), root)) {
                                    String idname = "";
                                    ref = gen.createReference(idname);
                                } else {
                                    IdAttributeValue idAttrVal = WSSObjectSignatureGenerator.addWsuId(doc, part, nsWsu, idToPart, context);
                                    ref = gen.createReference(idAttrVal.getVariablePartRefValue());
                                }
                                ref.setDigestMethod(srconfig.getDigestMethod().getAlgorithm());
                                WSSObjectSignatureGenerator.addTransforms(ref, part, srconfig.getTransforms(), config2.addInclusiveNamespaces(), isGoldenPath, wssObjectDocument);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Security header after adding Transform = " + security);
                                }
                                gen.addReference(ref);
                                signSomething = true;
                                list.add(part);
                                if (!tc.isDebugEnabled()) continue;
                                String elemName = null;
                                if (part.getType() == 1) {
                                    elemName = DOMUtils.getDisplayName(part.getOMNode());
                                } else if (part.getType() == 2) {
                                    elemName = part.getWSSObject().getQName().toString();
                                }
                                Tr.debug(tc, "Added the element[" + elemName + "].");
                            }
                            processed = true;
                            continue block13;
                        }
                        processed = true;
                        doc2 = RequestMessagePool.getDocument(context, ++docOrder);
                    }
                }
            }
        }
        if (!signSomething && !signSpecial) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke(Document doc, Element parent, Map context)");
            }
            return;
        }
        boolean addDummy = false;
        if (!signSomething) {
            addDummy = true;
            WSSObjectReference ref = gen.createReference("#dummy001");
            gen.addReference(ref);
        }
        WSSAlgorithmFactory afactory = gconfig.getAlgorithmFactory();
        AlgorithmConfig aconfig = config2.getSignatureMethod();
        Signature signature = null;
        try {
            AlgorithmParameterSpec spec = afactory.convertParameter(aconfig.getAlgorithm(), aconfig.getProperties());
            if (spec != null) {
                gen.setSignatureMethodParameter(spec);
            }
            signature = gen.getSignatureElement(afactory);
        }
        catch (InvalidAlgorithmParameterException e) {
            Tr.processException(e, clsName + ".invoke", "424");
            Tr.error(tc, "security.wssecurity.SignatureGenerator.s11", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s11", new String[]{e.getMessage()}, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            Tr.processException(e, clsName + ".invoke", "428");
            Tr.error(tc, "security.wssecurity.SignatureGenerator.s11", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s11", new String[]{e.getMessage()}, (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            Tr.processException(e, clsName + ".invoke", "432");
            Tr.error(tc, "security.wssecurity.SignatureGenerator.s11", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s11", new String[]{e.getMessage()}, (Throwable)e);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security header before inserting Signature = " + security);
        }
        signature = (Signature)WSSObjectSignatureGenerator.insertSignatureElement(security, signature);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security header after inserting Signature = " + security);
        }
        context.put("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm", config2.getSignatureMethod().getAlgorithm());
        Key key = WSSObjectSignatureGenerator.callKeyInfoGenerator(config2.getSigningKeyInfo(), "SigningKey", type, this._selectors, doc, signature, context);
        SignedInfo sinfo = signature.signedInfo;
        if (config2.addInclusiveNamespaces() && ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(canonicalizationMethod) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(canonicalizationMethod))) {
            CanonicalizationMethod c14nMethod = sinfo.getCanonicalizationMethod();
            String prefixList = WSSObjectSignatureGenerator.getPrefixList(c14nMethod);
            InclusiveNamespaces inc = WSSObjectSignatureGenerator.createInclusiveNamespaces(c14nMethod.getWSSObjectDocument(), prefixList);
            if (inc != null) {
                c14nMethod.addChild(inc);
            }
        }
        if (addDummy && (index = WSSObjectUtils.getChildIndex(sinfo, Utf8ByteConstantsQNames.DSIG.QN_REFERENCE)) >= 0) {
            sinfo.removeChild(index);
        }
        if (signSpecial) {
            block16: for (ReferencePartConfig.PartConfig pconfig : specials1) {
                srconfig = (SigningReferenceConfig)specials2.get(pconfig);
                Map cpSelectorMap = (Map)specials3.get(pconfig);
                boolean processed = false;
                String dialect = pconfig.getDialect();
                String keyword = pconfig.getKeyword();
                OMDocument doc2 = doc;
                int docOrder = -1;
                while (doc2 != null) {
                    parts = WSSObjectSignatureGenerator.getSpecialPart(doc2, pconfig, "signature_mode", this._selectors, cpSelectorMap);
                    if (parts != null && parts.size() > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, parts.size() + " parts found.");
                        }
                        processed = false;
                        for (int j = 0; j < parts.size(); ++j) {
                            WSSObjectReference ref;
                            XMLElement part = parts.get(j);
                            if (docOrder >= 0) {
                                String elemName;
                                IdAttributeValue idAttrVal;
                                XMLElement xel;
                                RequestMessagePool.EncryptedObject eobj = null;
                                if (eobj == null) continue;
                                if (eobj.getEncryptedData() != null) {
                                    xel = new XMLElement(eobj.getEncryptedData());
                                    idAttrVal = WSSObjectSignatureGenerator.addWsuId(doc, xel, nsWsu, idToPart, context);
                                    WSSObjectReference ref3 = gen.createReference(idAttrVal.getVariablePartRefValue());
                                    ref3.setDigestMethod(srconfig.getDigestMethod().getAlgorithm());
                                    WSSObjectSignatureGenerator.addTransforms(ref3, xel, srconfig.getTransforms(), config2.addInclusiveNamespaces(), isGoldenPath, wssObjectDocument);
                                    sinfo.addChild(ref3.getReferenceElement());
                                    list.add(part);
                                    if (tc.isDebugEnabled()) {
                                        elemName = null;
                                        if (part.getType() == 1) {
                                            elemName = DOMUtils.getDisplayName(part.getOMNode());
                                        } else if (part.getType() == 2) {
                                            elemName = part.getWSSObject().getQName().toString();
                                        }
                                        Tr.debug(tc, "Added the encrypted data[" + DOMUtils.getDisplayName(eobj.getEncryptedData()) + "] because the element[" + elemName + "] has already encrypted.");
                                    }
                                }
                                if (eobj.getHeaderInfo() == null) continue;
                                xel = new XMLElement(eobj.getHeaderInfo());
                                idAttrVal = WSSObjectSignatureGenerator.addWsuId(doc, xel, nsWsu, idToPart, context);
                                WSSObjectReference ref3 = gen.createReference(idAttrVal.getVariablePartRefValue());
                                ref3.setDigestMethod(srconfig.getDigestMethod().getAlgorithm());
                                WSSObjectSignatureGenerator.addTransforms(ref3, xel, srconfig.getTransforms(), config2.addInclusiveNamespaces(), isGoldenPath, wssObjectDocument);
                                sinfo.addChild(ref3.getReferenceElement());
                                list.add(part);
                                if (!tc.isDebugEnabled()) continue;
                                elemName = null;
                                if (part.getType() == 1) {
                                    elemName = DOMUtils.getDisplayName(part.getOMNode());
                                } else if (part.getType() == 2) {
                                    elemName = part.getWSSObject().getQName().toString();
                                }
                                Tr.debug(tc, "Added the header info[" + DOMUtils.getDisplayName(eobj.getHeaderInfo()) + "] because the element[" + elemName + "] has already encrypted.");
                                continue;
                            }
                            if (part.getType() == 1 && DOMUtils.equals(part.getOMNode(), root)) {
                                String idname = "";
                                ref = gen.createReference(idname);
                            } else {
                                IdAttributeValue idAttrVal = WSSObjectSignatureGenerator.addWsuId(doc, part, nsWsu, idToPart, context);
                                ref = gen.createReference(idAttrVal.getVariablePartRefValue());
                            }
                            ref.setDigestMethod(srconfig.getDigestMethod().getAlgorithm());
                            WSSObjectSignatureGenerator.addTransforms(ref, part, srconfig.getTransforms(), config2.addInclusiveNamespaces(), isGoldenPath, wssObjectDocument);
                            sinfo.addChild(ref.getReferenceElement());
                            list.add(part);
                            if (!tc.isDebugEnabled()) continue;
                            String elemName = null;
                            if (part.getType() == 1) {
                                elemName = DOMUtils.getDisplayName(part.getOMNode());
                            } else if (part.getType() == 2) {
                                elemName = part.getWSSObject().getQName().toString();
                            }
                            Tr.debug(tc, "Added the element[" + elemName + "].");
                        }
                        processed = true;
                        continue block16;
                    }
                    processed = true;
                    doc2 = RequestMessagePool.getDocument(context, ++docOrder);
                }
            }
        }
        if (signNonce) {
            Object[] objs = list.toArray();
            for (ReferencePartConfig.PartConfig pconfig : nonces1) {
                srconfig = (SigningReferenceConfig)nonces2.get(pconfig);
                Map cpSelectorMap = (Map)nonces3.get(pconfig);
                parts = WSSObjectSignatureGenerator.getNoncePart(doc, objs, pconfig, "signature_mode", this._selectors, IntegralDialectElementSelector.class, cpSelectorMap);
                if (parts == null || parts.size() <= 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, parts.size() + " parts found.");
                }
                for (int j = 0; j < parts.size(); ++j) {
                    WSSObjectReference ref;
                    XMLElement part = parts.get(j);
                    if (part.getType() == 1 && DOMUtils.equals(part.getOMNode(), root)) {
                        String idname = "";
                        ref = gen.createReference(idname);
                    } else {
                        IdAttributeValue idAttrVal = WSSObjectSignatureGenerator.addWsuId(doc, part, nsWsu, idToPart, context);
                        ref = gen.createReference(idAttrVal.getVariablePartRefValue());
                    }
                    ref.setDigestMethod(srconfig.getDigestMethod().getAlgorithm());
                    WSSObjectSignatureGenerator.addTransforms(ref, part, srconfig.getTransforms(), config2.addInclusiveNamespaces(), isGoldenPath, wssObjectDocument);
                    sinfo.addChild(ref.getReferenceElement());
                    list.add(part);
                    if (!tc.isDebugEnabled()) continue;
                    String elemName = null;
                    if (part.getType() == 1) {
                        elemName = DOMUtils.getDisplayName(part.getOMNode());
                    } else if (part.getType() == 2) {
                        elemName = part.getWSSObject().getQName().toString();
                    }
                    Tr.debug(tc, "Added the element[" + elemName + "].");
                }
            }
        }
        WSSSignatureContext scontext = new WSSSignatureContext();
        if (tc.isDebugEnabled()) {
            scontext.setResourceShower(ShowerImpl.getInstance());
        }
        MappingIdResolver idResolver = new MappingIdResolver(idToPart);
        scontext.setXMLIdResolver(idResolver);
        scontext.setAlgorithmFactory(afactory);
        scontext.setDocument(doc);
        if (config2.getKeyInfoSignature() != null) {
            scontext.setKeyInfoSignature(config2.getKeyInfoSignature().getAlgorithm());
        } else {
            scontext.setKeyInfoSignature(null);
        }
        if (isGoldenPath) {
            scontext.setContext(context);
        }
        HashSet<Configuration> dsigKConfig = new HashSet<Configuration>();
        HashSet<Configuration> encKConfig = new HashSet<Configuration>();
        for (Configuration configuration : gconfig.getOperationGenerators()) {
            if (configuration instanceof SignatureGeneratorConfig) {
                dsigKConfig.add(((SignatureGeneratorConfig)configuration).getSigningKeyInfo());
                continue;
            }
            if (!(configuration instanceof EncryptionGeneratorConfig)) continue;
            encKConfig.add(((EncryptionGeneratorConfig)configuration).getEncryptionKeyInfo());
        }
        STRDTKeyInfoResolver skiResolver = new STRDTKeyInfoResolver();
        skiResolver.setContext(context);
        skiResolver.setSelectors(this._selectors);
        skiResolver.setDsigKeyInfoSet(dsigKConfig);
        skiResolver.setEncKeyInfoSet(encKConfig);
        skiResolver.setGeneration(true);
        scontext.setSTRDTKeyInfoResolver(skiResolver);
        String sigAlgorithm = null;
        AlgorithmConfig sigMethod = config2.getSignatureMethod();
        if (sigMethod != null) {
            sigAlgorithm = sigMethod.getAlgorithm();
        }
        scontext.setSigAlgorithm(sigAlgorithm);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Signature Algorithm = " + sigAlgorithm);
        }
        Map<Object, Object> props = config2.getProperties();
        Map<Object, Object> gprops = gconfig.getProperties();
        scontext.setHWConfigName((String)gprops.get("HWCONFIG"));
        scontext.setOffload(Boolean.TRUE);
        if (scontext.shouldChangeProvider()) {
            Provider p1;
            HWKeyCache fHWKeyCache = HWKeyCache.getInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Acceleration enabled, Key Store Name is: " + scontext.getHWConfigName());
            }
            if ((p1 = ConfigUtil.getHWCryptoProviderInstance(scontext.getHWConfigName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware acceleration, continue processing.");
            } else {
                scontext.setHWAccelerationProvider(p1);
                Integer hardwareCacheSize = (Integer)gprops.get("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
                fHWKeyCache.setProvider(p1, hardwareCacheSize);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for HW Acceleration" + p1.getName());
                }
            }
            try {
                key = fHWKeyCache.translate(key);
            }
            catch (Exception e) {
                throw new SoapSecurityException(e);
            }
        }
        scontext.setHWKeyStoreName((String)props.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef"));
        if (scontext.useHWKeyStore()) {
            Provider p2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Key Store Name is: " + scontext.getHWKeyStoreName());
            }
            if ((p2 = ConfigUtil.getHWCryptoProviderInstance(scontext.getHWKeyStoreName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
            } else {
                scontext.setHWKeyStoreProvider(p2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for the HW KeyStore" + p2.getName());
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Signing started.");
        }
        try {
            VariablePartTextValue signatureValue;
            Signature signatureWithValue = scontext.sign(signature, key);
            List signatureCache = (List)context.get("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
            if (signatureCache != null && (signatureValue = signatureWithValue.signatureValue) != null) {
                String sigValue = signatureValue.toString();
                signatureCache.add(sigValue);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cached signature value for SignatureConfirmation: " + sigValue);
                }
            }
        }
        catch (XSignatureException e) {
            Exception ex = e.getException();
            Tr.processException(ex, clsName + ".invoke", "711");
            Tr.error(tc, "security.wssecurity.SignatureGenerator.s12", ex);
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s12", new String[]{ex.getMessage()}, (Throwable)ex);
        }
        finally {
            if (scontext.isHWAccelerationProvider()) {
                ConfigUtil.returnHWCryptoProviderInstance(scontext.getHWConfigName(), scontext.getHWAccelerationProvider());
            }
            if (scontext.useHWKeyStore()) {
                ConfigUtil.returnHWCryptoProviderInstance(scontext.getHWKeyStoreName(), scontext.getHWKeyStoreProvider());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Signing done.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element parent, Map context)");
        }
    }

    public static ArrayList<XMLElement> getMessagePart(OMDocument doc, String dialect, String keyword, String type, Map<Object, Object> selectors, Class dialectSelector, Map<Object, Object> selectorMap) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessagePart(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "String dialect[" + dialect + "]," + "String keyword[" + keyword + "]," + "String type[" + type + "]," + "Map selectors," + "Class dialectSelector[" + dialectSelector + "]," + "Map selectorMap)");
        }
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.dialect", dialect);
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.keyword", keyword);
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.operation", type);
        ElementSelector esel = null;
        if (Constants.DIALECT_WAS.equals(dialect)) {
            esel = (ElementSelector)selectors.get(dialectSelector);
        } else if (Constants.DIALECT_FUNCTION.equals(dialect)) {
            esel = (ElementSelector)selectors.get(WSPFunctionElementSelector.class);
        } else if (Constants.DIALECT_XPATH.equals(dialect)) {
            esel = (ElementSelector)selectors.get(XPathElementSelector.class);
        } else if (Constants.DIALECT_HEADER.equals(dialect)) {
            esel = (ElementSelector)selectors.get(QNameHeaderSelector.class);
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", dialect);
        }
        ArrayList<XMLElement> list = esel.getXMLElements(doc.getOMDocumentElement(), selectorMap);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getMessagePart returns an XMLElement Array List. Contents follow:");
            CommonLogUtils.logDebugXMLElement(list, tc);
            Tr.exit(tc, "getMessagePart(OMDocument doc,String dialect,String keyword,String type,Map selectors,Class dialectSelector,Map selectorMap,Map context) returns XMLElement ArrayList[list ]");
        }
        return list;
    }

    private static ArrayList<XMLElement> getSpecialPart(OMDocument doc, ReferencePartConfig.PartConfig pconfig, String type, Map selectors, Map<Object, Object> selectorMap) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSpecialPart(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "PartConfig pconfig[" + pconfig + "]," + "String type[" + type + "]," + "Map selectors," + "Map selectorMap)");
        }
        String dialect = pconfig.getDialect();
        String keyword = pconfig.getKeyword();
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.dialect", dialect);
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.keyword", keyword);
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.operation", type);
        ElementSelector esel = (ElementSelector)selectors.get(IntegralDialectElementSelector.class);
        if (Constants.DIALECT_XPATH.equals(dialect)) {
            esel = (ElementSelector)selectors.get(XPathElementSelector.class);
        }
        ArrayList<XMLElement> list = esel.getXMLElements(doc.getOMDocumentElement(), selectorMap);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getSpecialPart returns an XMLElement ArrayList. Contents follow:");
            CommonLogUtils.logDebugXMLElement(list, tc);
            Tr.exit(tc, "getSpecialPart(OMDocument doc,PartConfig pconfig,String type,Map selectors,Map selectorMap) returns XMLElement ArrayList[list]");
        }
        return list;
    }

    public static ArrayList<XMLElement> getNoncePart(OMDocument doc, Object[] parents, ReferencePartConfig.PartConfig pconfig, String type, Map<Object, Object> selectors, Class dialectSelector, Map<Object, Object> selectorMap) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNoncePart(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "Object[] parents[" + parents + "]," + "PartConfig pconfig[" + pconfig + "]," + "String type[" + type + "]," + "Map selectors," + "Class dialectSelector[" + dialectSelector + "]," + "Map selectorMap)");
        }
        String dialect = pconfig.getDialect();
        String keyword = pconfig.getKeyword();
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.dialect", dialect);
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.keyword", keyword);
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.operation", type);
        if (parents != null) {
            selectorMap.put("com.ibm.ws.wssecurity.util.selector.element", parents);
        }
        if (pconfig.isTimestamp()) {
            selectorMap.put("com.ibm.ws.util.selector.processType", "timestamp");
        } else if (pconfig.isNonce()) {
            selectorMap.put("com.ibm.ws.util.selector.processType", "nonce");
        }
        ElementSelector esel = null;
        if (Constants.DIALECT_WAS.equals(dialect)) {
            esel = (ElementSelector)selectors.get(dialectSelector);
        } else if (Constants.DIALECT_FUNCTION.equals(dialect)) {
            esel = (ElementSelector)selectors.get(WSPFunctionElementSelector.class);
        } else if (Constants.DIALECT_XPATH.equals(dialect)) {
            esel = (ElementSelector)selectors.get(XPathElementSelector.class);
        } else if (Constants.DIALECT_HEADER.equals(dialect)) {
            esel = (ElementSelector)selectors.get(QNameHeaderSelector.class);
            selectorMap.put("com.ibm.ws.wssecurity.util.selector.headername", pconfig.getHeaderName());
            selectorMap.put("com.ibm.ws.wssecurity.util.selector.headernamespace", pconfig.getHeaderNamespace());
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", dialect);
        }
        ArrayList<XMLElement> list = esel.getXMLElements(doc.getOMDocumentElement(), selectorMap);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getNoncePart returns an XMLElement ArrayList. Contents follow:");
            CommonLogUtils.logDebugXMLElement(list, tc);
            Tr.exit(tc, "getNoncePart(OMDocument doc,Object[] parents,PartConfig pconfig,String typeMap selectors,Class dialectSelector,Map selectorMap) returns XMLElement ArrayList[list]");
        }
        return list;
    }

    private static IdAttributeValue addWsuId(OMDocument doc, XMLElement part, String nsWsu, Map<String, XMLElement> idToPart, Map context) {
        IdAttributeValue idAttrValue = null;
        if (part != null) {
            if (part.getType() == 1) {
                idAttrValue = WSSObjectSignatureGenerator.addWsuId(doc, part, (OMElement)part.getOMNode(), nsWsu, idToPart, context);
            } else if (part.getType() == 2) {
                idAttrValue = WSSObjectSignatureGenerator.addWsuId(doc, part, part.getWSSObject(), nsWsu, idToPart, context);
            }
        }
        return idAttrValue;
    }

    private static IdAttributeValue addWsuId(OMDocument doc, XMLElement wrapper, OMElement part, String nsWsu, Map<String, XMLElement> idToPart, Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addWsuId(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "XMLElement wrapper," + "OMElement part[" + DOMUtils.getDisplayName(part) + "]," + "String nsWsu[" + nsWsu + "]," + "Map idToPart," + "Map context)");
        }
        String idname = null;
        IdAttributeValue idAttrValue = null;
        QName attrname = IdUtils.getInstance().getIdAttributeName(part);
        if (attrname != null) {
            idname = part.getAttributeValue(attrname);
        }
        if (idname == null || idname.length() == 0) {
            String ns = part.getNamespace() == null ? null : part.getNamespace().getName();
            String ln = part.getLocalName();
            int nsHash = ns == null ? 0 : ns.hashCode();
            int hash = nsHash * 31;
            hash += ln == null ? 0 : ln.hashCode();
            if (nsHash == Constants.HASH_DS) {
                if (hash == Constants.HASH_DS_SIGNATURE || hash == Constants.HASH_DS_SIGNATUREVALUE || hash == Constants.HASH_DS_SIGNEDINFO || hash == Constants.HASH_DS_REFERENCE || hash == Constants.HASH_DS_KEYINFO || hash == Constants.HASH_DS_OBJECT || hash == Constants.HASH_DS_MANIFEST || hash == Constants.HASH_DS_SIGNATUREPROPS || hash == Constants.HASH_DS_SIGNATUREPROP) {
                    idAttrValue = IdUtils.getInstance().makeUniqueId(context);
                    idname = idAttrValue.getStringValue();
                    part.addAttribute("Id", idname, null);
                }
            } else if (nsHash == Constants.HASH_ENC && (hash == Constants.HASH_ENC_ENCRYPTEDKEY || hash == Constants.HASH_ENC_ENCRYPTEDDATA || hash == Constants.HASH_ENC_ENCRYPTIONPROPS || hash == Constants.HASH_ENC_ENCRYPTIONPROP)) {
                idAttrValue = IdUtils.getInstance().makeUniqueId(context);
                idname = idAttrValue.getStringValue();
                part.addAttribute("Id", idname, null);
            }
            if (idname == null) {
                idAttrValue = IdUtils.getInstance().makeUniqueId(context);
                idname = idAttrValue.getStringValue();
                String prefix = DOMUtils.getNamespacePrefix(part, nsWsu);
                if (prefix == null) {
                    prefix = "wsu";
                }
                part.declareNamespace(nsWsu, prefix);
                part.addAttribute("Id", idname, part.getOMFactory().createOMNamespace(nsWsu, prefix));
            }
        } else {
            idAttrValue = IdUtils.getInstance().getIdAttributeValue(idname);
        }
        if (idToPart != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding to the idToPart Map: id = " + idname + ", part = " + DOMUtils.getDisplayName(part));
            }
            idToPart.put(idname, wrapper);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addWsuId(Document doc,Element part,String nsWsu,Map idToPart,Map context) returns IdAttributeValue[" + idname + "]");
        }
        return idAttrValue;
    }

    private static IdAttributeValue addWsuId(OMDocument doc, XMLElement wrapper, WSSObjectElement part, String nsWsu, Map<String, XMLElement> idToPart, Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addWsuId(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "XMLElement wrapper," + "WSSObjectElement part[" + part.getQName() + "]," + "String nsWsu[" + nsWsu + "]," + "Map idToPart," + "Map context)");
        }
        String idname = WSSObjectUtils.getIdAttributeValue(part);
        IdAttributeValue idAttrValue = null;
        if (idname == null || idname.length() == 0) {
            String ln = part.getQName().getLocalName();
            NamespacePrefixPair nspp = part.getNamespace();
            String ns = nspp == null ? null : nspp.getUri();
            int nsHash = ns == null ? 0 : ns.hashCode();
            int hash = nsHash * 31;
            hash += ln == null ? 0 : ln.hashCode();
            if (nsHash == Constants.HASH_DS) {
                if (hash == Constants.HASH_DS_SIGNATURE || hash == Constants.HASH_DS_SIGNATUREVALUE || hash == Constants.HASH_DS_SIGNEDINFO || hash == Constants.HASH_DS_REFERENCE || hash == Constants.HASH_DS_KEYINFO || hash == Constants.HASH_DS_OBJECT || hash == Constants.HASH_DS_MANIFEST || hash == Constants.HASH_DS_SIGNATUREPROPS || hash == Constants.HASH_DS_SIGNATUREPROP) {
                    idAttrValue = IdUtils.getInstance().makeUniqueId(context);
                    idname = idAttrValue.getStringValue();
                    part.setAttributeToSortedSet(Utf8ByteConstantsQNames.AttributeDefaultNS.QN_ID, idAttrValue.getVariablePartValue());
                }
            } else if (nsHash == Constants.HASH_ENC && (hash == Constants.HASH_ENC_ENCRYPTEDKEY || hash == Constants.HASH_ENC_ENCRYPTEDDATA || hash == Constants.HASH_ENC_ENCRYPTIONPROPS || hash == Constants.HASH_ENC_ENCRYPTIONPROP)) {
                idAttrValue = IdUtils.getInstance().makeUniqueId(context);
                idname = idAttrValue.getStringValue();
                part.setAttributeToSortedSet(Utf8ByteConstantsQNames.AttributeDefaultNS.QN_ID, idAttrValue.getVariablePartValue());
            }
            if (idname == null) {
                idAttrValue = IdUtils.getInstance().makeUniqueId(context);
                idname = idAttrValue.getStringValue();
                part.setAttributeToSortedSet(Utf8ByteConstantsQNames.WSU.QN_ID, idAttrValue.getVariablePartValue());
            }
        } else {
            idAttrValue = IdUtils.getInstance().getIdAttributeValue(idname);
        }
        if (idToPart != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding to the idToPart Map: id = " + idname + ", part = " + part.getQName());
            }
            idToPart.put(idname, wrapper);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addWsuId(Document doc,XMLElement wrapper,WSSObjectElement part,String nsWsu,Map idToPart) returns IdAttributeValue[" + idname + "]");
        }
        return idAttrValue;
    }

    private static void addTransforms(WSSObjectReference ref, XMLElement part, List config2, boolean addIncNS, boolean isGoldenPath, WSSObjectDocumentImpl wssObjectDocument) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTransforms(WSSObjectReference ref[" + ref + "]," + "XMLElement part," + "List config[" + config2 + "]," + "boolean addIncNS[" + addIncNS + "]," + "boolean isGoldenPath[" + isGoldenPath + "]," + "WSSObjectDocumentImpl wssObjectDocument[" + wssObjectDocument + "]" + ")");
        }
        for (AlgorithmConfig aconfig : config2) {
            String transform = aconfig.getAlgorithm();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding the transform [" + transform + "]...");
            }
            if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(transform)) {
                Transform tr = WSSObjectSignatureGenerator.createInclusiveTransform(wssObjectDocument, part, transform, addIncNS, isGoldenPath);
                ref.addTransform(tr);
                continue;
            }
            ref.addTransform(transform);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTransforms(WSSObjectReference ref,XMLElement part,List config,boolean addIncNS,boolean isGoldenPath,WSSObjectDocumentImpl wssObjectDocument)");
        }
    }

    private static Transform createInclusiveTransform(WSSObjectDocumentImpl doc, XMLElement part, String transform, boolean addIncNS, boolean isGoldenPath) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createInclusiveTransform(WSSObjectDocumentImpl doc,XMLElement part,String transform[" + transform + "]," + "boolean addIncNS[" + addIncNS + "]," + "boolean isGoldenPath[" + isGoldenPath + "])");
        }
        Transform tr = new Transform(doc);
        tr.setAlgorithm(Utf8ByteConstantsVariableParts.VPA_C14N_EXCLUSIVE);
        if (addIncNS) {
            Object el;
            String prefixList = null;
            if (part.getType() == 1) {
                OMNode child;
                el = (OMElement)part.getOMNode();
                if (isGoldenPath && el instanceof SOAPBody && (child = el.getFirstOMChild()) != null && child instanceof OMSourcedElementImpl) {
                    return tr;
                }
                prefixList = WSSObjectSignatureGenerator.getPrefixList((OMElement)el);
            } else if (part.getType() == 2) {
                el = part.getWSSObject();
                prefixList = WSSObjectSignatureGenerator.getPrefixList((WSSObjectElement)el);
            }
            InclusiveNamespaces inc = WSSObjectSignatureGenerator.createInclusiveNamespaces(doc, prefixList);
            if (inc != null) {
                tr.addChild(inc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createInclusiveTransform(WSSObjectDocumentImpl doc,XMLElement part,String transform,boolean addIncNS,boolean isGoldenPath) returns Element[" + tr + "]");
        }
        return tr;
    }

    private static InclusiveNamespaces createInclusiveNamespaces(WSSObjectDocumentImpl doc, String prefixList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createInclusiveNamespaces(WSSObjectDocumentImpl doc,String prefixList[" + prefixList + "])");
        }
        InclusiveNamespaces inc = null;
        if (prefixList != null && !prefixList.isEmpty()) {
            inc = new InclusiveNamespaces(doc);
            inc.setPrefixList(VariablePartFactory.getInstance().createAttrValueWithString(prefixList));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createInclusiveNamespaces(WSSObjectDocumentImpl doc, String prefixList) returns InclusiveNamespaces[" + inc + "]");
        }
        return inc;
    }

    private static String getPrefixList(OMElement part) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrefixList(OMElement part[" + DOMUtils.getDisplayName(part) + "])");
        }
        StringBuffer buffer = null;
        if (part != null && part instanceof SOAPElementImpl) {
            Iterator nsListIter = ((SOAPElementImpl)((Object)part)).getNamespacePrefixes();
            if (nsListIter != null) {
                buffer = new StringBuffer();
                OMNamespace attr = null;
                while (nsListIter.hasNext()) {
                    attr = (OMNamespace)nsListIter.next();
                    if (attr instanceof OMNamespaceWithOwner) continue;
                    String prefix = attr.getPrefix();
                    if (prefix == null || prefix.length() == 0) {
                        buffer.append("#default ");
                        continue;
                    }
                    buffer.append(prefix);
                    buffer.append(" ");
                }
            }
        } else {
            OMNode cur = part;
            HashSet<String> prefixes = new HashSet<String>();
            while (cur != null && cur.getType() == 1) {
                Iterator i = cur.getAllDeclaredNamespaces();
                while (i.hasNext()) {
                    OMNamespace ns = (OMNamespace)i.next();
                    if (ns instanceof OMNamespaceWithOwner) continue;
                    String prefix = ns.getPrefix();
                    if (prefix == null || prefix.length() == 0) {
                        prefixes.add("#default");
                        continue;
                    }
                    prefixes.add(prefix);
                }
                OMContainer parent = cur.getParent();
                if (parent instanceof OMDocument) break;
                cur = (OMNode)((Object)parent);
            }
            WSSObjectSignatureGenerator.scanNamespaceDecls(part, prefixes);
            if (prefixes.size() > 0) {
                buffer = new StringBuffer();
                Iterator iter = prefixes.iterator();
                while (iter.hasNext()) {
                    buffer.append(iter.next());
                    buffer.append(" ");
                }
            }
        }
        String prefixList = null;
        if (buffer != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node search generated PrefixList: " + buffer);
            }
            prefixList = new String(buffer);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "node search generated an empty list");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrefixList(OMElement part) returns String[" + prefixList + "]");
        }
        return prefixList;
    }

    private static String getPrefixList(WSSObjectElement part) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrefixList(WSSObjectElement part[" + part.getQName() + "])");
        }
        StringBuffer buffer = null;
        NamespacePrefixPairSortedSet utilizedNamespaces = new NamespacePrefixPairSortedSet();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "gathering utilized namespaces for element " + part.getQName());
        }
        part.gatherUtilizedNamespaces(utilizedNamespaces);
        Parent parent = part.getParent();
        while (parent != null && parent instanceof WSSObjectElement) {
            WSSObjectElement el = (WSSObjectElement)parent;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "gathering utilized namespaces for parent element " + el.getQName());
            }
            el.gatherUtilizedNamespaces(utilizedNamespaces);
            parent = el.getParent();
        }
        if (utilizedNamespaces != null && utilizedNamespaces.size() > 0) {
            buffer = new StringBuffer();
            for (int i = 0; i < utilizedNamespaces.size(); ++i) {
                NamespacePrefixPair nspp = utilizedNamespaces.getNamespacePrefixPair(i);
                String prefix = nspp.getPrefix();
                if (prefix == null || prefix.length() == 0) {
                    buffer.append("#default ");
                    continue;
                }
                buffer.append(prefix);
                buffer.append(" ");
            }
        }
        String prefixList = null;
        if (buffer != null) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "node search generated PrefixList: " + buffer);
            }
            prefixList = new String(buffer);
        } else if (tc.isEntryEnabled()) {
            Tr.debug(tc, "node search generated an empty list");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrefixList(WSSObjectElement part) returns String[" + prefixList + "]");
        }
        return prefixList;
    }

    private static void scanNamespaceDecls(OMNode node, Set<String> prefixes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "scanNamespaceDecls(OMNode node[" + DOMUtils.getDisplayName(node) + "]," + "Set prefixes[" + prefixes + "])");
        }
        if (node.getType() == 1) {
            Iterator nss = ((OMElement)node).getAllDeclaredNamespaces();
            while (nss.hasNext()) {
                OMNamespace ns = (OMNamespace)nss.next();
                if (ns instanceof OMNamespaceWithOwner) continue;
                String prefix = ns.getPrefix();
                if (prefix == null || prefix.length() == 0) {
                    prefixes.add("#default");
                    continue;
                }
                prefixes.add(prefix);
            }
            for (OMNode n = ((OMElement)node).getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
                if (n.getType() != 1) continue;
                WSSObjectSignatureGenerator.scanNamespaceDecls(n, prefixes);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "scanNamespaceDecls(OMNode node, Set prefixes)");
        }
    }

    protected static void prepareTransform(SigningReferenceConfig srconfig, Map<Object, Object> selectorMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTransform(SigningReferenceConfig srconfig],Map selectorMap)");
        }
        boolean existSTRTransform = false;
        for (AlgorithmConfig aconfig : srconfig.getTransforms()) {
            String transform = aconfig.getAlgorithm();
            if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(transform)) continue;
            existSTRTransform = true;
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "STR-Transform transform found.");
        }
        if (existSTRTransform) {
            selectorMap.put("security.wssecurity.integraldialectelementselector.existstrtransform", Boolean.toString(existSTRTransform));
        } else {
            selectorMap.remove("security.wssecurity.integraldialectelementselector.existstrtransform");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTransform(SigningReferenceConfig srconfig,Map selectorMap)");
        }
    }

    public static Key callKeyInfoGenerator(KeyInfoGeneratorConfig config2, String keytype, Map<Object, Object> type, Map<Object, Object> properties, OMDocument doc, WSSObjectElement parent, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callKeyInfoGenerator(KeyInfoGeneratorConfig config,String keytype[" + keytype + "]," + "Map type," + "Map properties," + "OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "WSSObjectElement parent[" + parent.getQName() + "]," + "Map context)");
        }
        KeyInfoGeneratorComponent gen = (KeyInfoGeneratorComponent)properties.get(KeyInfoGenerator.class);
        type.clear();
        type.put(com.ibm.wsspi.wssecurity.core.Constants.WSSECURITY_KEY_TYPE, keytype);
        context.put("com.ibm.ws.wssecurity.impl.config.keyinfoGenerator.configKey", config2);
        context.put("com.ibm.ws.wssecurity.WSSObjectKeyInfoParent", parent);
        Key key = gen.getKey(doc, null, type, context);
        context.remove("com.ibm.ws.wssecurity.WSSObjectKeyInfoParent");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callKeyInfoGenerator(KeyInfoGeneratorConfig config,String keytype,Map type,Map properties,OMDocument doc,WSSObjectElement parent,Map context) returns Key[" + key + "]");
        }
        return key;
    }

    private static WSSObjectElement insertSignatureElement(Security parent, WSSObjectElement elem) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insertSignatureElement(Security parent[" + parent + "]," + "WSSObjectElement elem[" + elem + "])");
        }
        WSSObject nextElem = null;
        WSSObject lastElem = null;
        ArrayList<WSSObject> children = null;
        if (parent != null && (children = parent.getChildren()) != null && children.size() > 0) {
            Iterator<WSSObject> iter = children.iterator();
            WSSObject el = null;
            while (iter.hasNext()) {
                lastElem = el = iter.next();
                if (!(el instanceof Signature) && !(el instanceof EncryptedKey) && !(el instanceof ReferenceList)) continue;
                nextElem = el;
                break;
            }
        }
        if (lastElem == null) {
            parent.addChild(elem);
        } else if (nextElem == null) {
            parent.addChild(elem);
        } else {
            int index = children.indexOf(nextElem);
            parent.insertChildBefore(index, elem);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insertSignatureElement(Security parent,WSSObjectElement elem) returns WSSObjectElement[" + elem + "]");
        }
        return elem;
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        public void showSignedResource(OMElement owner, int count, String uri, String type, byte[] content, String encoding) {
            ByteArrayInputStream in = new ByteArrayInputStream(content);
            if (count < 0) {
                Tr.debug(tc, "ResourceShower logs sign-SignedInfo: ");
                CommonLogUtils.logDebug(in, encoding, tc);
            } else if (uri == null || uri.length() == 0) {
                Tr.debug(tc, "ResourceShower logs sign-resource_" + count + ": ");
                CommonLogUtils.logDebug(in, encoding, tc);
            } else {
                Tr.debug(tc, "ResourceShower logs sign-" + uri + ": ");
                CommonLogUtils.logDebug(in, encoding, tc);
            }
            try {
                in.close();
            }
            catch (Exception e) {
                Tr.debug(tc, "Caugh exception closing input stream: e=" + e.getMessage());
            }
        }

        public void showSignedResource(OMElement owner, int count, String uri, String type, byte[] content, int offset, int length, String encoding) {
            ByteArrayInputStream in = new ByteArrayInputStream(content, offset, length);
            if (count < 0) {
                Tr.debug(tc, "ResourceShower logs sign-SignedInfo: ");
                CommonLogUtils.logDebug(in, encoding, tc);
            } else if (uri == null || uri.length() == 0) {
                Tr.debug(tc, "ResourceShower logs sign-resource_" + count + ": ");
                CommonLogUtils.logDebug(in, encoding, tc);
            } else {
                Tr.debug(tc, "ResourceShower logs sign-" + uri + ": ");
                CommonLogUtils.logDebug(in, encoding, tc);
            }
            try {
                in.close();
            }
            catch (Exception e) {
                Tr.debug(tc, "Caugh exception closing input stream: e=" + e.getMessage());
            }
        }
    }
}

