/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.dsig;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.common.WSSAlgorithmFactory;
import com.ibm.ws.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.wssecurity.config.CallerConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.SignatureConsumerConfig;
import com.ibm.ws.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.core.ResultMessagePool;
import com.ibm.ws.wssecurity.core.WSSConsumerComponent;
import com.ibm.ws.wssecurity.dsig.PartList;
import com.ibm.ws.wssecurity.dsig.SignatureGenerator;
import com.ibm.ws.wssecurity.dsig.VerificationResult;
import com.ibm.ws.wssecurity.dsig.VerifiedConfig;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.wssecurity.token.AuthResult;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.QNameHeaderSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifiedPartChecker
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(VerifiedPartChecker.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private Map<Object, Object> _selectors = null;
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map)");
        }
    }

    @Override
    public void invoke(OMNode target, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("invoke(");
            buf.append("OMNode target[").append(DOMUtils.getDisplayName(target)).append("], ");
            buf.append("Map context)");
            Tr.entry(tc, buf.toString());
        }
        if (target == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s11", "soapenv:Envelope");
        }
        Object obj = context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        String nsWsu = Constants.NAMESPACES[1][wssVersion];
        HashMap<String, OMElement> verifiedNonceMap = new HashMap<String, OMElement>(2);
        context.put("com.ibm.ws.wssecurity.constants.verifiedNonceMap", verifiedNonceMap);
        IDResolver resolver2 = (IDResolver)context.get("com.ibm.ws.wssecurity.util.selector.IDResolver");
        OMDocument doc = null;
        doc = DOMUtil.getOwnerDocument(target);
        HashMap<SignatureConsumerConfig, OMDocument> docMap = new HashMap<SignatureConsumerConfig, OMDocument>(2);
        Result[] results = ResultPool.get(context, VerificationResult.class);
        if (results != null && results.length > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, results.length + " verified results found.");
            }
            for (int i = 0; i < results.length; ++i) {
                VerificationResult result = (VerificationResult)results[i];
                docMap.put(result._sconfig, result._copiedDOM);
            }
        }
        WSSConsumerConfig gconfig = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        NonceManager nmanager = gconfig.getNonceManager();
        Set<RequiredParts> requiredParts = VerifiedPartChecker.preprocess(doc, docMap, gconfig, this._selectors, context, resolver2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing the verified results...");
        }
        HashSet<ReferencePartConfig> rset = new HashSet<ReferencePartConfig>();
        if (results != null && results.length > 0) {
            for (int i = 0; i < results.length; ++i) {
                VerificationResult result = (VerificationResult)results[i];
                rset.clear();
                for (VerificationResult.VerifiedPart vpart : result._verifiedParts) {
                    RequiredPart rpart = VerifiedPartChecker.getRelatedPart(result, vpart, requiredParts, context);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "VerifiedPart [" + vpart + "], RequiredPart [" + rpart + "]");
                    }
                    if (rpart == null) continue;
                    if (rpart._requiredNonce) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking required nonce...");
                        }
                        if (vpart._nonce == null) {
                            throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.VerifiedPartChecker.s02", rpart._pconfig.getKeyword());
                        }
                        NonceUtil.checkNonce(vpart._nonce, nsWsse, nmanager);
                        String value = DOMUtils.getStringValue(vpart._nonce);
                        if (value != null && value.length() > 0) {
                            verifiedNonceMap.put(value, vpart._object);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Added verified nonce value of " + value + " for element " + vpart._object + " to map.");
                            }
                        }
                    }
                    if (rpart._requiredTimestamp) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking required timestamp...");
                        }
                        if (vpart._timestamp == null) {
                            throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.TimestampChecker.s02", rpart._pconfig.getKeyword());
                        }
                        NonceUtil.checkTimestamp(vpart._timestamp, nsWsu, gconfig.getTimestampMaxAge(), gconfig.getTimestampClockSkew(), false);
                    }
                    rpart._processed = true;
                    rpart._tokenWrappers.add(result._tokenWrapper);
                    rset.add(rpart._rconfig);
                }
                VerifiedPartChecker.checkCaller(result, rset, gconfig, context);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Checking whether all required integrity is processed...");
        }
        for (RequiredParts rparts : requiredParts) {
            RequiredPart[] rpart = rparts._parts;
            for (int j = 0; j < rpart.length; ++j) {
                if (rpart[j]._processed) continue;
                String keyword = rpart[j]._pconfig.getKeyword();
                if (keyword == null) {
                    String headerName = rpart[j]._pconfig.getHeaderName();
                    keyword = headerName != null ? rpart[j]._pconfig.getHeaderNamespace() + ":" + headerName : rpart[j]._pconfig.getHeaderNamespace();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Required integrity not processed with keyword[" + keyword + "]");
                }
                throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.VerifiedPartChecker.s01", keyword);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(OMNode, Map)");
        }
    }

    private static Set<RequiredParts> preprocess(OMDocument doc, Map<SignatureConsumerConfig, OMDocument> docMap, WSSConsumerConfig gconfig, Map<Object, Object> selectors, Map<Object, Object> context, IDResolver idResolver) throws SoapSecurityException {
        RequiredParts rparts2;
        int j;
        RequiredPart[] rpartList;
        ArrayList<OMNode> parts;
        OMDocument useDoc;
        Map<Object, Object> cpSelectorMap;
        ReferencePartConfig rconfig;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("preprocess(");
            buf.append("OMDocument doc[").append(DOMUtils.getDisplayName(doc)).append("], ");
            buf.append("Map docMap, WSSConsumerConfig gconfig, ");
            buf.append("Map selectors, Map context, IDResolver idResolver)");
            Tr.entry(tc, buf.toString());
        }
        Set<ReferencePartConfig> requiredIntegrity = gconfig.getRequiredIntegralParts();
        Set<SignatureConsumerConfig> sconsumers = gconfig.getSignatureConsumers();
        WSSAlgorithmFactory afactory = gconfig.getAlgorithmFactory();
        HashSet<RequiredParts> requiredParts = new HashSet<RequiredParts>();
        HashSet<ReferencePartConfig.PartConfig> nonces = null;
        HashMap<ReferencePartConfig.PartConfig, Map<Object, Object>> nonces2 = null;
        HashMap<ReferencePartConfig.PartConfig, ReferencePartConfig> nonces3 = null;
        HashMap<ReferencePartConfig.PartConfig, OMDocument> nonces4 = null;
        Iterator<ReferencePartConfig> i1 = requiredIntegrity.iterator();
        while (i1.hasNext()) {
            rconfig = i1.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing ReferencePartConfig [" + rconfig + "]...");
            }
            cpSelectorMap = new HashMap<Object, Object>(context);
            cpSelectorMap.put(NonceManager.class, gconfig.getNonceManager());
            cpSelectorMap.put("com.ibm.ws.wssecurity.util.selector.IDResolver", idResolver);
            cpSelectorMap.put("com.ibm.ws.wssecurity.util.selector.config", gconfig.getTokenConsumers());
            useDoc = VerifiedPartChecker.setNecessaryInfo(cpSelectorMap, sconsumers, rconfig, doc, docMap);
            for (ReferencePartConfig.PartConfig pconfig : rconfig.getParts()) {
                if (pconfig.isTimestamp() || pconfig.isNonce()) {
                    if (nonces == null) {
                        nonces = new HashSet<ReferencePartConfig.PartConfig>();
                        nonces2 = new HashMap<ReferencePartConfig.PartConfig, Map<Object, Object>>();
                        nonces3 = new HashMap<ReferencePartConfig.PartConfig, ReferencePartConfig>();
                        nonces4 = new HashMap<ReferencePartConfig.PartConfig, OMDocument>();
                    }
                    nonces.add(pconfig);
                    nonces2.put(pconfig, cpSelectorMap);
                    nonces3.put(pconfig, rconfig);
                    nonces4.put(pconfig, useDoc);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing PartConfig [" + pconfig + "]...");
                }
                String dialect = pconfig.getDialect();
                String keyword = pconfig.getKeyword();
                Class elemSelector = IntegralDialectElementSelector.class;
                if (dialect.equals(Constants.DIALECT_HEADER)) {
                    cpSelectorMap.put("com.ibm.ws.wssecurity.util.selector.headername", pconfig.getHeaderName());
                    cpSelectorMap.put("com.ibm.ws.wssecurity.util.selector.headernamespace", pconfig.getHeaderNamespace());
                    elemSelector = QNameHeaderSelector.class;
                }
                if ((parts = SignatureGenerator.getMessagePart(useDoc, dialect, keyword, "verification_mode", selectors, elemSelector, cpSelectorMap)) == null || parts.size() <= 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, parts.size() + " parts found.");
                }
                ArrayList[] transformedParts = null;
                boolean isTransformed = false;
                try {
                    for (SignatureConsumerConfig sconsumer : sconsumers) {
                        List<SigningReferenceConfig> slist = sconsumer.getReferences();
                        for (int m = 0; m < slist.size(); ++m) {
                            SigningReferenceConfig sreference = slist.get(m);
                            ReferencePartConfig srpart = sreference.getReference();
                            for (ReferencePartConfig.PartConfig spconfig : srpart.getParts()) {
                                if (pconfig != spconfig) continue;
                                List<AlgorithmConfig> slist2 = sreference.getTransforms();
                                for (int n = 0; n < slist2.size(); ++n) {
                                    AlgorithmConfig aconfig = slist2.get(n);
                                    String algo = aconfig.getAlgorithm();
                                    Map<Object, Object> properties = aconfig.getProperties();
                                    OMFactory omfactory = doc.getOMFactory();
                                    OMElement transElem = null;
                                    if ("http://www.w3.org/2002/06/xmldsig-filter2".equals(algo)) {
                                        transElem = SignatureGenerator.createXPath2Transform(omfactory, algo, properties);
                                    } else if ("http://www.w3.org/TR/1999/REC-xpath-19991116".equals(algo)) {
                                        transElem = SignatureGenerator.createXPathTransform(omfactory, algo, properties);
                                    } else if (!"http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(algo)) continue;
                                    SignatureContext scontext = new SignatureContext();
                                    Transform transformer = afactory.getTransform(algo);
                                    transformer.setParameter(DOMUtil.getFirstChildElement(transElem));
                                    if (idResolver != null) {
                                        scontext.setIDResolver(idResolver);
                                    }
                                    transformedParts = new ArrayList[parts.size()];
                                    for (int l = 0; l < parts.size(); ++l) {
                                        TransformContext tcontext = new TransformContext(scontext, parts.get(l));
                                        transformer.transform(tcontext);
                                        isTransformed = true;
                                        transformedParts[l] = tcontext.getNodeset();
                                    }
                                }
                            }
                        }
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    throw new SoapSecurityException(e);
                }
                catch (TransformException e) {
                    throw new SoapSecurityException(e);
                }
                if (parts instanceof PartList) {
                    rpartList = new RequiredPart[]{new RequiredPart(rconfig, pconfig, parts)};
                } else if (isTransformed) {
                    rpartList = new RequiredPart[parts.size()];
                    for (j = 0; j < rpartList.length; ++j) {
                        rpartList[j] = new RequiredPart(rconfig, pconfig, (ArrayList<OMNode>)transformedParts[j]);
                    }
                } else {
                    rpartList = new RequiredPart[parts.size()];
                    for (j = 0; j < rpartList.length; ++j) {
                        rpartList[j] = new RequiredPart(rconfig, pconfig, (OMElement)parts.get(j));
                    }
                }
                rparts2 = new RequiredParts(rpartList);
                requiredParts.add(rparts2);
            }
        }
        if (nonces != null) {
            i1 = nonces.iterator();
        }
        while (nonces != null && i1.hasNext()) {
            ReferencePartConfig.PartConfig pconfig;
            pconfig = (ReferencePartConfig.PartConfig)((Object)i1.next());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing PartConfig [" + pconfig + "]...");
            }
            cpSelectorMap = (Map)nonces2.get(pconfig);
            rconfig = (ReferencePartConfig)nonces3.get(pconfig);
            useDoc = (OMDocument)nonces4.get(pconfig);
            if (!pconfig.isTimestamp() && !pconfig.isNonce() || (parts = SignatureGenerator.getNoncePart(useDoc, null, pconfig, "verification_mode", selectors, IntegralDialectElementSelector.class, cpSelectorMap)) == null || parts.size() <= 0) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, parts.size() + " parts found.");
            }
            boolean found = false;
            for (j = 0; j < parts.size(); ++j) {
                OMNode node = parts.get(j);
                if (node.getType() != 1) continue;
                OMElement el = (OMElement)node;
                block14: for (RequiredParts rparts2 : requiredParts) {
                    for (int k = 0; k < rparts2._parts.length; ++k) {
                        RequiredPart rpart = rparts2._parts[k];
                        if (!DOMUtils.equals(el, rpart._element)) continue;
                        if (pconfig.isTimestamp()) {
                            rpart._requiredTimestamp = pconfig.isTimestamp();
                        }
                        if (pconfig.isNonce()) {
                            rpart._requiredNonce = pconfig.isNonce();
                        }
                        found = true;
                        continue block14;
                    }
                }
                if (found) continue;
                rpartList = new RequiredPart[]{new RequiredPart(rconfig, pconfig, el)};
                rpartList[0]._requiredTimestamp = pconfig.isTimestamp();
                rpartList[0]._requiredNonce = pconfig.isNonce();
                rparts2 = new RequiredParts(rpartList);
                requiredParts.add(rparts2);
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("preprocess(");
            buf.append("OMDocument, Map, Set, Set, Map, Map)");
            buf.append(" returns Set [").append(requiredParts).append("]");
            Tr.exit(tc, buf.toString());
        }
        return requiredParts;
    }

    private static OMDocument setNecessaryInfo(Map<Object, Object> selectorMap, Set<SignatureConsumerConfig> sconsumers, ReferencePartConfig rconfig, OMDocument doc, Map<SignatureConsumerConfig, OMDocument> docMap) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("setNecessaryInfo(");
            buf.append("Map selectorMap, Set sconsumers, ");
            buf.append("ReferencePartConfig rconfig[").append(rconfig).append("], ");
            buf.append("OMDocument doc[").append(DOMUtils.getDisplayName(doc)).append("], ");
            buf.append("Map docMap)");
            Tr.entry(tc, buf.toString());
        }
        boolean found = false;
        OMDocument useDoc = doc;
        SigningReferenceConfig srconfig2 = null;
        for (SignatureConsumerConfig sconfig : sconsumers) {
            for (SigningReferenceConfig srconfig2 : sconfig.getReferences()) {
                if (!srconfig2.getReference().equals(rconfig)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            OMDocument d = docMap.get(sconfig);
            if (d == null) break;
            useDoc = d;
            break;
        }
        if (found) {
            SignatureGenerator.prepareTransform(srconfig2, selectorMap);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("setNecessaryInfo(");
            buf.append("Map, Set, ReferencePartConfig, OMDocument, Map)");
            buf.append(" returns OMDocument [").append(useDoc).append("]");
            Tr.exit(tc, buf.toString());
        }
        return useDoc;
    }

    private static RequiredPart getRelatedPart(VerificationResult vresult, VerificationResult.VerifiedPart vpart, Set<RequiredParts> requiredParts, Map<Object, Object> context) throws SoapSecurityException {
        boolean isNode;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getRelatedPart(");
            buf.append("VerificationResult vresult, ");
            buf.append("VerifiedPart vpart[").append(vpart).append("], ");
            buf.append("Set requiredParts, Map context)");
            Tr.entry(tc, buf.toString());
        }
        boolean isNodeset = vpart._nodeset != null;
        boolean bl = isNode = vpart._node != null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Is the verified part is nodeset?: " + isNodeset);
            Tr.debug(tc, "Is the verified part is node?: " + isNode);
            Tr.debug(tc, requiredParts.size() + " required parts found.");
        }
        SoapSecurityException lastException = null;
        RequiredPart rpart = null;
        for (RequiredParts rparts : requiredParts) {
            RequiredPart[] part = rparts._parts;
            for (int j = 0; j < part.length; ++j) {
                if (part[j]._processed) continue;
                SoapSecurityException sse = VerifiedPartChecker.checkBinding(part[j]._rconfig.getBindings(), vresult);
                if (sse == null) {
                    OMElement decreptedVpart;
                    if (part[j]._isNodeset) {
                        ArrayList nodeset;
                        if (isNodeset) {
                            if (part[j]._nodeset == null) {
                                part[j]._nodeset = XPathCanonicalizer.toNodeset(part[j]._element, null, false);
                            }
                            if (!DOMUtils.includeNodeset(vpart._nodeset, part[j]._nodeset)) continue;
                            rpart = part[j];
                            break;
                        }
                        if (isNode) {
                            nodeset = XPathCanonicalizer.toNodeset(vpart._node, null, false);
                            if (!DOMUtils.includeNodeset(nodeset, part[j]._nodeset)) continue;
                            rpart = part[j];
                            break;
                        }
                        nodeset = XPathCanonicalizer.toNodeset(vpart._object, null, false);
                        if (!DOMUtils.includeNodeset(nodeset, part[j]._nodeset)) continue;
                        rpart = part[j];
                        break;
                    }
                    if (isNodeset) {
                        if (part[j]._nodeset == null) {
                            part[j]._nodeset = XPathCanonicalizer.toNodeset(part[j]._element, null, false);
                        }
                        if (!DOMUtils.includeNodeset(vpart._nodeset, part[j]._nodeset)) continue;
                        rpart = part[j];
                        break;
                    }
                    if (isNode) {
                        if (VerifiedPartChecker.hasSameUri(part[j]._element, vpart._node) || DOMUtils.equals(part[j]._element, vpart._node)) {
                            rpart = part[j];
                            break;
                        }
                        decreptedVpart = ResultMessagePool.getElement(context, vpart._node);
                        if (decreptedVpart == null || !VerifiedPartChecker.hasSameUri(part[j]._element, decreptedVpart) && !DOMUtils.equals(part[j]._element, decreptedVpart)) continue;
                        rpart = part[j];
                        break;
                    }
                    if (VerifiedPartChecker.hasSameUri(part[j]._element, vpart._object) || DOMUtils.equals(part[j]._element, vpart._object)) {
                        rpart = part[j];
                        break;
                    }
                    decreptedVpart = ResultMessagePool.getElement(context, vpart._object);
                    if (decreptedVpart == null || !VerifiedPartChecker.hasSameUri(part[j]._element, decreptedVpart) && !DOMUtils.equals(part[j]._element, decreptedVpart)) continue;
                    rpart = part[j];
                    break;
                }
                lastException = sse;
            }
            if (rpart == null) continue;
            lastException = null;
            break;
        }
        if (lastException != null) {
            throw lastException;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getRelatedPart(");
            buf.append("VerificationResult, VerifiedPart, Set, Map)");
            buf.append(" returns RequiredPart [").append(rpart).append("]");
            Tr.exit(tc, buf.toString());
        }
        return rpart;
    }

    private static boolean hasSameUri(OMElement rpart, OMElement vpart) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("hasSameUri(");
            buf.append("OMElement rpart[").append(DOMUtils.getDisplayName(rpart)).append("], ");
            buf.append("OMElement vpart[").append(DOMUtils.getDisplayName(vpart)).append("])");
            Tr.entry(tc, buf.toString());
        }
        boolean ret = false;
        String ruri = IdUtils.getInstance().getId(rpart);
        String vuri = IdUtils.getInstance().getId(vpart);
        if (ruri != null && ruri.length() > 0 && vuri != null && vuri.length() > 0 && ruri.equals(vuri)) {
            ret = true;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("hasSameUri(OMElement, OMElement)");
            buf.append(" returns boolean [").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    private static void checkCaller(VerificationResult vresult, Set<ReferencePartConfig> rpconfigs, WSSConsumerConfig gconfig, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("checkCaller(");
            buf.append("VerificationResult vresult, Set rpconfigs, ");
            buf.append("WSSConsumerConfig  gconfig, Map context)");
            Tr.entry(tc, buf.toString());
        }
        if (vresult._tokenWrapper == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The token used for signature verification not found...");
            }
        } else {
            List<CallerConfig> cconfigs;
            QName token_qn = vresult._tokenWrapper.getValueType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The value type of the token: " + token_qn);
            }
            if ((cconfigs = gconfig.getCallers()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, cconfigs.size() + " Callers found, so start to process it...");
                }
                for (CallerConfig cconfig : cconfigs) {
                    boolean requiredTrustedIdentityChecking;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing a CallerConfig [" + cconfig + "]...");
                    }
                    QName caller_qn = cconfig.getCallerIdentity();
                    QName tidentity_qn = cconfig.getTrustedIdentity();
                    ReferencePartConfig spart = cconfig.getRequiredSigningPartReference();
                    boolean requiredCallerIdentityChecking = caller_qn != null && caller_qn.equals(token_qn) && spart != null && tidentity_qn == null;
                    boolean bl = requiredTrustedIdentityChecking = tidentity_qn != null && tidentity_qn.equals(token_qn) && spart != null;
                    if (!requiredCallerIdentityChecking && !requiredTrustedIdentityChecking) continue;
                    boolean callerIdentityCandidate = false;
                    boolean trustedIdentityCandidate = false;
                    if (requiredCallerIdentityChecking) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking the caller identity [" + caller_qn + "]...");
                        }
                        if (spart.isOneOfIntegralParts()) {
                            if (rpconfigs.contains(spart)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Linked the token[" + vresult._tokenWrapper + "] and the Caller[" + cconfig + "].");
                                }
                                callerIdentityCandidate = true;
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ReferencePart of Caller Config is not integral part.");
                        }
                    }
                    if (requiredTrustedIdentityChecking) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking the trusted identity [" + tidentity_qn + "]...");
                        }
                        if (spart.isOneOfIntegralParts()) {
                            if (rpconfigs.contains(spart)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Linked the token[" + vresult._tokenWrapper + "] and the Caller[" + cconfig + "].");
                                }
                                trustedIdentityCandidate = true;
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ReferencePart of Caller Config is not integral part.");
                        }
                    }
                    if (!callerIdentityCandidate && !trustedIdentityCandidate) continue;
                    AuthResult aresult = new AuthResult(vresult._tokenWrapper, cconfig, callerIdentityCandidate, trustedIdentityCandidate, false);
                    ResultPool.add(context, aresult);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added AuthResult[" + aresult + "] into the ResultPool.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCaller(VerificationResult, Set, WSSConsumerConfig, Map)");
        }
    }

    private static SoapSecurityException checkBinding(Set<Object> bindings, VerificationResult vresult) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("checkBinding(");
            buf.append("Set bindings, VerificationResult vresult)");
            Tr.entry(tc, buf.toString());
        }
        Throwable lastException = null;
        boolean ret = bindings.contains(vresult._sconfig);
        if (ret) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The configuration of signature consumer used for verification was found in the bindings.");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The configuration of signature consumer used for verification was NOT found in the bindings.");
            }
            Iterator<Object> i = bindings.iterator();
            block0: while (!ret && i.hasNext()) {
                SignatureConsumerConfig sconfig = (SignatureConsumerConfig)i.next();
                Iterator<SigningReferenceConfig> j = sconfig.getReferences().iterator();
                while (!ret && j.hasNext()) {
                    SigningReferenceConfig srconfig = j.next();
                    KeyInfoResult r = vresult._identities.get(new VerifiedConfig(sconfig, srconfig));
                    if (r == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "There is no keyinfo result corresponding to the SigningReferenceConfig.");
                        continue;
                    }
                    Exception e = r.getError();
                    if (e == null) {
                        SecurityTokenWrapper tokenWrapper;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The keyinfo result has no exception.");
                        }
                        if ((tokenWrapper = (SecurityTokenWrapper)vresult._kresults.get(r)) == null) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "There is no token corresponding to the keyinfo result.");
                            continue;
                        }
                        if (tokenWrapper.getError() == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The token [" + tokenWrapper + "] has no exception.");
                            }
                            ret = true;
                            continue block0;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The token [" + tokenWrapper + "] has the exception [" + e.getMessage() + "].");
                        }
                        lastException = tokenWrapper.getError();
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The keyinfo result has the exception [" + e.getMessage() + "].");
                    }
                    if (e instanceof SoapSecurityException) {
                        lastException = (SoapSecurityException)e;
                        continue;
                    }
                    lastException = SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKey04", new String[]{e.getMessage()}, (Throwable)e);
                }
            }
            if (ret) {
                lastException = null;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("checkBinding(");
            buf.append("Set, VerificationResult)");
            buf.append(" returns SoapSecurityException [");
            buf.append(lastException == null ? "null" : lastException.toString());
            buf.append("]");
            Tr.exit(tc, buf.toString());
        }
        return lastException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequiredPart {
        private ReferencePartConfig _rconfig;
        private ReferencePartConfig.PartConfig _pconfig;
        private OMElement _element;
        private ArrayList<OMNode> _nodeset;
        private Set<SecurityTokenWrapper> _tokenWrappers;
        private boolean _isNodeset;
        private boolean _requiredTimestamp;
        private boolean _requiredNonce;
        private boolean _processed;

        RequiredPart(ReferencePartConfig rconfig, ReferencePartConfig.PartConfig pconfig, OMElement element) {
            this._rconfig = rconfig;
            this._pconfig = pconfig;
            this._element = element;
            this._nodeset = null;
            this._isNodeset = false;
            this._tokenWrappers = new HashSet<SecurityTokenWrapper>();
            this._processed = false;
            this._requiredTimestamp = false;
            this._requiredNonce = false;
        }

        RequiredPart(ReferencePartConfig rconfig, ReferencePartConfig.PartConfig pconfig, ArrayList<OMNode> nodeset) {
            this._rconfig = rconfig;
            this._pconfig = pconfig;
            this._element = null;
            this._nodeset = nodeset;
            this._isNodeset = true;
            this._tokenWrappers = new HashSet<SecurityTokenWrapper>();
            this._processed = false;
            this._requiredTimestamp = false;
            this._requiredNonce = false;
        }
    }

    private static class RequiredParts {
        private RequiredPart[] _parts;

        RequiredParts(RequiredPart[] parts) {
            this._parts = parts;
        }
    }
}

