/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.dsig;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.config.KeyInfoConsumerConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.dsig.SignatureConsumer;
import com.ibm.ws.wssecurity.dsig.XMLDTKeyInfoResolver;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.wssecurity.util.CertificateUtil;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import com.ibm.wsspi.wssecurity.wssapi.OMStructure;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STRDTKeyInfoResolver {
    private static final TraceComponent tc = Tr.register(STRDTKeyInfoResolver.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private Collection<Configuration> _dsigKinfoSet;
    private Collection<Configuration> _encKinfoSet;
    private boolean _generation = false;
    private Map<Object, Object> _context;
    private Map<Object, Object> _selectors;
    private Collection<SecurityTokenWrapper> _stokens = null;
    private Result[] _results = null;
    private boolean _storedToken = false;

    protected STRDTKeyInfoResolver() {
    }

    protected void setDsigKeyInfoSet(Collection<Configuration> dsigKinfoSet) {
        this._dsigKinfoSet = dsigKinfoSet;
    }

    protected void setEncKeyInfoSet(Collection<Configuration> encKInfoSet) {
        this._encKinfoSet = encKInfoSet;
    }

    protected void setGeneration(boolean generation) {
        this._generation = generation;
    }

    protected void setContext(Map<Object, Object> context) {
        this._context = context;
    }

    protected void setSelectors(Map<Object, Object> selectors) {
        this._selectors = selectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OMElement resolve(OMElement secTokenRef, String keyInfoType) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("resolve(");
            buf.append("OMElement secTokenRef[").append(DOMUtils.getDisplayName(secTokenRef)).append("],");
            buf.append("String keyInfoType[").append(keyInfoType).append("])");
            Tr.entry(tc, buf.toString());
        }
        SecurityTokenManagerImpl securityTokenManager = (SecurityTokenManagerImpl)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        OMElement element = null;
        try {
            HashMap<Object, Object> type = new HashMap<Object, Object>();
            int wssVersion = 0;
            Object obj = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
            if (obj != null && obj instanceof Integer) {
                wssVersion = (Integer)obj;
            }
            String nsWsse = Constants.NAMESPACES[0][wssVersion];
            if (this._generation) {
                element = STRDTKeyInfoResolver.getElementInSubject(secTokenRef, keyInfoType, nsWsse, securityTokenManager);
            } else {
                if (!this._storedToken) {
                    this._stokens = XMLDTKeyInfoResolver.storeSubject(securityTokenManager);
                    this._results = XMLDTKeyInfoResolver.storeResult(this._context);
                    this._storedToken = true;
                }
                if ((element = STRDTKeyInfoResolver.getElementInSubject(secTokenRef, keyInfoType, nsWsse, securityTokenManager)) == null) {
                    element = STRDTKeyInfoResolver.getElement(secTokenRef, this._dsigKinfoSet, this._encKinfoSet, type, this._selectors, securityTokenManager, this._context);
                }
            }
        }
        finally {
            if (this._storedToken) {
                XMLDTKeyInfoResolver.restoreSubject(securityTokenManager, this._stokens);
                XMLDTKeyInfoResolver.restoreResult(this._context, this._results);
                this._storedToken = false;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("resolve(");
            buf.append("OMElement, String)");
            buf.append(" returns OMElement[").append(DOMUtils.getDisplayName(element)).append("]");
            Tr.exit(tc, buf.toString());
        }
        return element;
    }

    private static OMElement getElementInSubject(OMElement secTokenRef, String keyInfoType, String nsWsse, SecurityTokenManagerImpl securityTokenManager) throws SoapSecurityException {
        String id;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getElementInSubject(");
            buf.append("OMElement secTokenRef[").append(DOMUtils.getDisplayName(secTokenRef)).append("],");
            buf.append("String keyInfoType[").append(keyInfoType).append("], ");
            buf.append("String nsWsse[").append(nsWsse).append("], ");
            buf.append("SecurityTokenManagerImpl securityTokenManager)");
            Tr.entry(tc, buf.toString());
        }
        OMElement element = null;
        Collection<SecurityToken> tokens = securityTokenManager.getTokens();
        if (tokens != null && (id = STRDTKeyInfoResolver.getIdInSubject(secTokenRef, keyInfoType, nsWsse)) != null) {
            for (SecurityToken token : tokens) {
                OMStructure om;
                if (!id.equals(token.getId()) || (om = (OMStructure)token.getXML()) == null) continue;
                element = om.getNode();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getElementInSubject(");
            buf.append("OMElement, String, String, ");
            buf.append("SecurityTokenManagerImpl)");
            buf.append(" returns OMElement[").append(DOMUtils.getDisplayName(element)).append("]");
            Tr.exit(tc, buf.toString());
        }
        return element;
    }

    private static String getIdInSubject(OMElement secTokenRef, String keyInfoType, String nsWsse) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getIdInSubject(");
            buf.append("OMElement secTokenRef[").append(DOMUtils.getDisplayName(secTokenRef)).append("],");
            buf.append("String keyInfoType[").append(keyInfoType).append("], ");
            buf.append("String nsWsse[").append(nsWsse).append("])");
            Tr.entry(tc, buf.toString());
        }
        String id = null;
        OMElement element = null;
        if (ConfigUtil.isKeyInfoKeyid(keyInfoType) || ConfigUtil.isKeyInfoThumbprint(keyInfoType)) {
            element = DOMUtils.getOneElement(secTokenRef, nsWsse, "KeyIdentifier");
            id = DOMUtils.getStringValue(element);
        } else if (ConfigUtil.isKeyInfoX509issuer(keyInfoType)) {
            String issuerSerial;
            element = DOMUtils.getOneElement(secTokenRef, Constants.NS_DSIG, "X509IssuerName");
            String issuerName = DOMUtils.getStringValue(element);
            if (issuerName != null) {
                issuerName = KeyInfo.X509Data.encodeDName(issuerName);
            }
            if ((issuerSerial = DOMUtils.getStringValue(element = DOMUtils.getOneElement(secTokenRef, Constants.NS_DSIG, "X509SerialNumber"))) != null) {
                try {
                    new BigInteger(issuerSerial);
                }
                catch (NumberFormatException nfee) {
                    try {
                        BigInteger bint = CertificateUtil.convertSerialNumber(issuerSerial);
                        issuerSerial = bint.toString();
                    }
                    catch (ParseException pe) {
                        throw SoapSecurityException.format("security.wssecurity.X509LoginModule.s04", issuerSerial, (Throwable)pe);
                    }
                }
            }
            id = issuerName + ":" + issuerSerial;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getIdInSubject(");
            buf.append("OMElement, String, String)");
            buf.append(" returns String[").append(id).append("]");
            Tr.exit(tc, buf.toString());
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OMElement getElement(OMElement secTokenRef, Collection<Configuration> dsigKinfoSet, Collection<Configuration> encKinfoSet, Map<Object, Object> type, Map<Object, Object> properties, SecurityTokenManagerImpl securityTokenManager, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getElement(");
            buf.append("OMElement secTokenRef[").append(DOMUtils.getDisplayName(secTokenRef)).append("],");
            buf.append("Collection dsigKinfoSet, Collection encKinfoSet, Map type, ");
            buf.append("Map properties, SecurityTokenManagerImpl securityTokenManager, ");
            buf.append("Map context)");
            Tr.entry(tc, buf.toString());
        }
        OMElement element = null;
        Collection<SecurityTokenWrapper> lockedTokens = STRDTKeyInfoResolver.lockTokenWrappers(securityTokenManager);
        try {
            OMElement keyInfo = STRDTKeyInfoResolver.getKeyInfoElement(secTokenRef);
            KeyInfoResult kresult = STRDTKeyInfoResolver.callKeyInfoConsumer(dsigKinfoSet, encKinfoSet, type, properties, keyInfo, context);
            if (kresult == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WEARNING: Unable to get the KeyInfoResult.");
                }
            } else {
                String id = kresult.getIdInSubject();
                SecurityToken token = securityTokenManager.getToken(kresult.getKeyInfoContentConsumer().getTokenConsumer(), id);
                SecurityTokenWrapper tokenWrapper = securityTokenManager.getTokenWrapper(token);
                if (tokenWrapper == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WEARNING: Unable to extract the token with the token identifier [" + id + "].");
                    }
                } else {
                    if (tokenWrapper.getError() != null) {
                        throw tokenWrapper.getError();
                    }
                    OMStructure om = (OMStructure)token.getXML();
                    if (om != null) {
                        element = om.getNode();
                    }
                }
            }
        }
        finally {
            STRDTKeyInfoResolver.restoreTokenWrappers(securityTokenManager, lockedTokens);
            STRDTKeyInfoResolver.removeKeyInfoResults(context);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getElement(");
            buf.append("OMElement, Collection, Collection, Map, Map, ");
            buf.append("SecurityTokenManagerImpl, Map)");
            buf.append(" returns OMElement[").append(DOMUtils.getDisplayName(element)).append("]");
            Tr.exit(tc, buf.toString());
        }
        return element;
    }

    private static OMElement getKeyInfoElement(OMNode node) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getKeyInfoElement(");
            buf.append("OMNode node[").append(DOMUtils.getDisplayName(node)).append("])");
            Tr.entry(tc, buf.toString());
        }
        OMElement element = null;
        OMContainer n = node.getParent();
        if (n != null && n instanceof OMElement) {
            element = DOMUtils.equals((OMElement)n, Constants.NS_DSIG, "KeyInfo") ? (OMElement)n : STRDTKeyInfoResolver.getKeyInfoElement((OMElement)n);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getKeyInfoElement(OMNode)");
            buf.append(" returns OMElement[").append(DOMUtils.getDisplayName(element)).append("]");
            Tr.exit(tc, buf.toString());
        }
        return element;
    }

    private static KeyInfoResult callKeyInfoConsumer(Collection<Configuration> dsigKinfoSet, Collection<Configuration> encKinfoSet, Map<Object, Object> type, Map<Object, Object> properties, OMElement target, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("callKeyInfoConsumer(");
            buf.append("Collection dsigKinfoSet, Collection encKinfoSet, Map type, ");
            buf.append("Map properties, ");
            buf.append("OMElement target[").append(DOMUtils.getDisplayName(target)).append("],");
            buf.append("Map context)");
            Tr.entry(tc, buf.toString());
        }
        KeyInfoResult kresult = null;
        boolean succeeded = false;
        Exception lastException = null;
        for (KeyInfoConsumerConfig keyInfoConsumerConfig : dsigKinfoSet) {
            try {
                SignatureConsumer.callKeyInfoConsumer(keyInfoConsumerConfig, "VerifyingKey", type, properties, target, context);
                succeeded = true;
                break;
            }
            catch (Exception e) {
                lastException = e;
                STRDTKeyInfoResolver.removeKeyInfoResults(context);
            }
        }
        if (succeeded) {
            KeyInfoResult[] keyInfoResultArray = SignatureConsumer.getKeyInfoResults(context);
            kresult = STRDTKeyInfoResolver.getProcessedResult(keyInfoResultArray, dsigKinfoSet);
        } else {
            for (KeyInfoConsumerConfig keyInfoConsumerConfig : encKinfoSet) {
                try {
                    SignatureConsumer.callKeyInfoConsumer(keyInfoConsumerConfig, "DecryptingKey", type, properties, target, context);
                    succeeded = true;
                    break;
                }
                catch (Exception e) {
                    lastException = e;
                    STRDTKeyInfoResolver.removeKeyInfoResults(context);
                }
            }
        }
        if (!succeeded) {
            throw SoapSecurityException.format("security.wssecurity.DTKeyInfoResolver.s01", new String[]{lastException.getMessage()}, (Throwable)lastException);
        }
        KeyInfoResult[] keyInfoResultArray = SignatureConsumer.getKeyInfoResults(context);
        kresult = STRDTKeyInfoResolver.getProcessedResult(keyInfoResultArray, encKinfoSet);
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("callKeyInfoConsumer(");
            stringBuffer.append("Collection, Collection, Map, Map, OMElement, Map)");
            stringBuffer.append(" returns KeyInfoResult[").append(kresult).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return kresult;
    }

    private static KeyInfoResult getProcessedResult(KeyInfoResult[] results, Collection keyInfoSet) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getProcessedResult(");
            buf.append("KeyInfoResult[] results, Collection keyInfoSet)");
            Tr.entry(tc, buf.toString());
        }
        KeyInfoResult result = null;
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                KeyInfoResult r = results[i];
                KeyInfoContentConsumerConfig kic = r.getKeyInfoContentConsumer();
                for (KeyInfoConsumerConfig config2 : keyInfoSet) {
                    if (!config2.getContentConsumers().contains(kic) || r.getError() != null) continue;
                    result = r;
                    break;
                }
                if (result != null) break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getProcessedResult(");
            buf.append("KeyInfoResult[], Collection)");
            buf.append(" returns KeyInfoResult[").append(result).append("]");
            Tr.exit(tc, buf.toString());
        }
        return result;
    }

    private static Collection<SecurityTokenWrapper> lockTokenWrappers(SecurityTokenManagerImpl securityTokenManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lockTokenWrappers(SecurityTokenManagerImpl securityTokenManager)");
        }
        HashSet<SecurityTokenWrapper> set = new HashSet<SecurityTokenWrapper>(securityTokenManager.getTokenWrappers());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lockTokenWrappers(SecurityTokenManagerImpl)");
        }
        return set;
    }

    private static void removeKeyInfoResults(Map<Object, Object> context) {
        Result[] results;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeKeyInfoResults(Map)");
        }
        if ((results = ResultPool.get(context, KeyInfoResult.class)) != null && results.length > 0) {
            ResultPool.remove(context, results);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeKeyInfoResults(Map context)");
        }
    }

    private static void restoreTokenWrappers(SecurityTokenManagerImpl securityTokenManager, Collection<SecurityTokenWrapper> tokenWrappers) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("restoreTokenWrappers(");
            buf.append("SecurityTokenManagerImpl securityTokenManager, ");
            buf.append("Collection tokenWrappers)");
            Tr.entry(tc, buf.toString());
        }
        securityTokenManager.removeAllTokens();
        securityTokenManager.addTokenWrappers(tokenWrappers);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreTokenWrappers(SecurityTokenManagerImpl, Collection)");
        }
    }
}

