/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.dsig;

import com.ibm.ws.wssecurity.dsig.Canonicalizer;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.io.BufferExportableByteArrayOutputStream;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.util.io.WriterChainHolder;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.BufferedWriter;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMAttributeWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMNamespaceWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;

class ExclusiveCanonicalizer {
    private static final TraceComponent tc = Tr.register(ExclusiveCanonicalizer.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = ExclusiveCanonicalizer.class.getName();

    private ExclusiveCanonicalizer() {
    }

    public static void serializeSubset(Hashtable prefixList, ArrayList nodeList, boolean withComments, Map replNodeSets, Writer wr) throws IOException {
        ExclusiveCanonicalizer.serializeSubset(prefixList, nodeList, withComments, replNodeSets, wr, null);
    }

    private static void serializeSubset(Hashtable prefixList, ArrayList nodeList, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serializeSubset(Hashtable prefixList[" + prefixList + ", ArrayList nodeList[" + nodeList + "], boolean withComments[" + withComments + "], Map replNodeSets[" + replNodeSets + "], Writer wr[" + wr + "], Set apexNodes[" + apexNodes + "])");
        }
        Vector<Object> nodeVector = new Vector<Object>(nodeList.size());
        block0: for (int i = 0; i < nodeList.size(); ++i) {
            Object obj2;
            Object obj = nodeList.get(i);
            if (replNodeSets.containsKey(obj)) {
                nodeVector.add(new Canonicalizer.ReplacedNode((OMNode)obj));
                int l = nodeList.size();
                for (int j = i + 1; j <= l; ++j) {
                    if (j < l && DOMUtil.isDescendantNode(nodeList.get(j), (OMNode)obj)) continue;
                    i = j - 1;
                    continue block0;
                }
                continue;
            }
            if (obj instanceof OMNode) {
                Object attr;
                Object ns;
                OMNode node = (OMNode)obj;
                nodeVector.addElement(node);
                if (node.getType() != 1) continue;
                Hashtable namespaces = new Hashtable();
                if (i + 1 < nodeList.size() && (ns = nodeList.get(i + 1)) instanceof OMNamespace && Canonicalizer.isOwnerElement(node, (OMNamespace)ns)) {
                    Object obj22;
                    ++i;
                    while (i < nodeList.size() && (obj22 = nodeList.get(i)) instanceof OMNamespace && Canonicalizer.isOwnerElement(node, (OMNamespace)obj22)) {
                        namespaces.put(((OMNamespace)obj22).getPrefix(), obj22);
                        ++i;
                    }
                    if (namespaces.containsKey("") && ((OMNamespace)namespaces.get("")).getName().length() == 0) {
                        namespaces.remove("");
                    }
                    --i;
                }
                nodeVector.addElement(new Canonicalizer.OMNamespaces(node, namespaces));
                Hashtable attributes = new Hashtable();
                if (i + 1 < nodeList.size() && (attr = nodeList.get(i + 1)) instanceof OMAttribute && Canonicalizer.isOwnerElement(node, (OMAttribute)attr)) {
                    Object obj23;
                    ++i;
                    while (i < nodeList.size() && (obj23 = nodeList.get(i)) instanceof OMAttribute && Canonicalizer.isOwnerElement(node, (OMAttribute)obj23)) {
                        attributes.put(((OMAttribute)obj23).getQName(), obj23);
                        ++i;
                    }
                    --i;
                }
                nodeVector.addElement(new Canonicalizer.OMAttributes(node, attributes));
                continue;
            }
            if (obj instanceof OMNamespaceWithOwner) {
                OMElement owner = ((OMNamespaceWithOwner)obj).getOwnerElement();
                Hashtable namespaces = new Hashtable();
                while (i < nodeList.size() && (obj2 = nodeList.get(i)) instanceof OMNamespaceWithOwner && owner == ((OMNamespaceWithOwner)obj2).getOwnerElement()) {
                    namespaces.put(((OMNamespace)obj2).getPrefix(), obj2);
                    ++i;
                }
                nodeVector.addElement(new Canonicalizer.OMNamespaces(owner, namespaces));
                --i;
                continue;
            }
            if (!(obj instanceof OMAttributeWithOwner)) continue;
            OMElement owner = ((OMAttributeWithOwner)obj).getOwnerElement();
            Hashtable attributes = new Hashtable();
            while (i < nodeList.size() && (obj2 = nodeList.get(i)) instanceof OMAttributeWithOwner && owner == ((OMAttributeWithOwner)obj2).getOwnerElement()) {
                attributes.put(((OMAttribute)obj2).getQName(), obj2);
                ++i;
            }
            nodeVector.addElement(new Canonicalizer.OMAttributes(owner, attributes));
            --i;
        }
        Stack nStack = new Stack();
        Stack aStack = new Stack();
        for (int i = 0; i < nodeVector.size(); ++i) {
            ExclusiveCanonicalizer.serializeSubset(nStack, aStack, prefixList, nodeVector, i, withComments, replNodeSets, wr, apexNodes);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serializeSubset(Hashtable prefixList, ArrayList nodeList, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes)");
        }
    }

    private static void serializeSubset(Stack nStack, Stack aStack, Hashtable prefixList, Vector nodeVector, int i, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes) throws IOException {
        OMContainer parent;
        String prefix;
        Object obj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serializeSubset(Stack nStack[" + nStack + "], Stack aStack[" + aStack + "], Hashtable prefixList{" + prefixList + "], ArrayList nodeVector[" + nodeVector + "], int i[" + i + "], boolean withComments[" + withComments + "], Map replNodeSets[" + replNodeSets + "], Writer wr[" + wr + "], Set apexNodes[" + apexNodes + "])");
        }
        if ((obj = nodeVector.elementAt(i)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "serializeSubset(Stack nStack, Stack aStack, Hashtable prefixList, ArrayList nodeVector, int i, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes)");
            }
            return;
        }
        if (obj instanceof Canonicalizer.OMNamespaces) {
            nodeVector.setElementAt(null, i);
            ((Canonicalizer.OMNamespaces)obj).serialize(null, prefixList, null, wr);
            return;
        }
        if (obj instanceof Canonicalizer.OMAttributes) {
            nodeVector.setElementAt(null, i);
            ((Canonicalizer.OMAttributes)obj).serialize(null, prefixList, null, wr);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "serializeSubset(Stack nStack, Stack aStack, Hashtable prefixList, ArrayList nodeVector, int i, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes)");
            }
            return;
        }
        if (obj instanceof Canonicalizer.ReplacedNode) {
            OMNode n = ((Canonicalizer.ReplacedNode)obj).getNode();
            ArrayList nl = (ArrayList)replNodeSets.get(n);
            HashSet<OMNode> s = new HashSet<OMNode>();
            int j = 0;
            int l = nl.size();
            block0: while (j < l) {
                OMNode n2 = (OMNode)nl.get(j);
                s.add(n2);
                for (int k = j + 1; k <= l; ++k) {
                    if (k < l && DOMUtil.isDescendantNode(nl.get(k), n2)) continue;
                    j = k;
                    continue block0;
                }
            }
            ExclusiveCanonicalizer.serializeSubset(prefixList, nl, false, replNodeSets, wr, s);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "serializeSubset(Stack nStack, Stack aStack, Hashtable prefixList, ArrayList nodeVector, int i, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes)");
            }
            return;
        }
        OMNode node = (OMNode)obj;
        int type = node.getType();
        if (type != 1) {
            Canonicalizer.serializeNode(null, node, null, withComments, true, wr);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "serializeSubset(Stack nStack, Stack aStack, Hashtable prefixList, ArrayList nodeVector, int i, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes)");
            }
            return;
        }
        wr.write("<");
        OMElement elem = (OMElement)node;
        String string = prefix = elem.getNamespace() == null ? null : elem.getNamespace().getPrefix();
        if (prefix != null && prefix.length() != 0) {
            wr.write(prefix);
            wr.write(":");
        }
        wr.write(elem.getLocalName());
        Canonicalizer.OMNamespaces ancestorNss = nStack.empty() ? null : (Canonicalizer.OMNamespaces)nStack.peek();
        Canonicalizer.OMNamespaces nss = null;
        int next = i + 1;
        boolean printXmlns = prefixList == null || prefixList.get("") == null ? prefix == null : true;
        if (next >= nodeVector.size() || nodeVector.elementAt(next) instanceof OMNode || nodeVector.elementAt(next) instanceof Canonicalizer.ReplacedNode) {
            parent = elem.getParent();
            if (apexNodes != null && apexNodes.contains(node) || printXmlns && !(parent instanceof OMDocument) && ancestorNss != null && ancestorNss.contains("")) {
                wr.write(" xmlns=\"\"");
            }
        } else if (nodeVector.elementAt(next) instanceof Canonicalizer.OMNamespaces) {
            nss = (Canonicalizer.OMNamespaces)nodeVector.elementAt(next);
            if (!nss.contains("")) {
                parent = elem.getParent();
                if (apexNodes != null && apexNodes.contains(node) || printXmlns && !(parent instanceof OMDocument) && ancestorNss != null && ancestorNss.contains("")) {
                    wr.write(" xmlns=\"\"");
                }
            }
            if (prefix == null) {
                prefix = "";
            }
            nss.serialize(nStack, prefixList, prefix, wr);
            nodeVector.setElementAt(null, next);
            ++next;
        }
        Canonicalizer.OMAttributes ancestorAttrs = aStack.empty() ? null : (Canonicalizer.OMAttributes)aStack.peek();
        Canonicalizer.OMAttributes attrs = null;
        if (next < nodeVector.size() && nodeVector.elementAt(next) instanceof Canonicalizer.OMAttributes) {
            attrs = (Canonicalizer.OMAttributes)nodeVector.elementAt(next);
            if (prefix == null) {
                prefix = "";
            }
            attrs.serialize(aStack, prefixList, prefix, wr);
            nodeVector.setElementAt(null, next);
        }
        wr.write(">");
        nStack.push(nss);
        aStack.push(attrs);
        while (next < nodeVector.size()) {
            if (nodeVector.elementAt(next) == null) {
                ++next;
                continue;
            }
            if (!Canonicalizer.isAncestor(nodeVector.elementAt(next), node)) break;
            ExclusiveCanonicalizer.serializeSubset(nStack, aStack, prefixList, nodeVector, next, withComments, replNodeSets, wr, apexNodes);
            nodeVector.setElementAt(null, next++);
        }
        nStack.pop();
        aStack.pop();
        wr.write("</");
        if (prefix != null && prefix.length() != 0) {
            wr.write(prefix);
            wr.write(":");
        }
        wr.write(elem.getLocalName());
        wr.write(">");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serializeSubset(Stack nStack, Stack aStack, Hashtable prefixList, ArrayList nodeVector, int i, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes)");
        }
    }

    public static ByteArrayHolder serializeSubset(Hashtable prefixList, ArrayList nodeList, boolean withComments, Map replNodeSets) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serializeSubset(Hashtable prefixList[" + prefixList + ", ArrayList nodeList[" + nodeList + "], boolean withComments[" + withComments + "], Map replNodeSets[" + replNodeSets + "])");
        }
        try {
            BufferExportableByteArrayOutputStream bebaos = new BufferExportableByteArrayOutputStream(0);
            WriterChainHolder wch = (WriterChainHolder)WriterChainHolder.getUtf8WriterChainHolderFactory().getObject();
            wch.getProxyOutputStream().setOutputStream(bebaos);
            BufferedWriter wr = wch.getBufferedWriter();
            ExclusiveCanonicalizer.serializeSubset(prefixList, nodeList, withComments, replNodeSets, wr);
            ((Writer)wr).flush();
            ByteArrayHolder bah = bebaos.getByteArrayHolder();
            WriterChainHolder.getUtf8WriterChainHolderFactory().releaseObject(wch);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "serializeSubset(Hashtable prefixList, ArrayList nodeList, boolean withComments, Map replNodeSets)");
            }
            return bah;
        }
        catch (IOException ioe) {
            RuntimeException e = new RuntimeException("Internal Error: " + ioe);
            e.initCause(ioe);
            throw e;
        }
    }

    public static Hashtable parsePrefixList(String ssv) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parsePrefixList(String ssv[" + ssv + "])");
        }
        Hashtable<String, String> prefixList = null;
        if (ssv == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(ssv, " \t\r\n");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (prefixList == null) {
                prefixList = new Hashtable<String, String>();
            }
            if (tok.equals("#default")) {
                tok = "";
            }
            prefixList.put(tok, tok);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parsePrefixList(String ssv) returns prefixList[" + prefixList + "]");
        }
        return prefixList;
    }

    public static String serializePrefixList(Hashtable prefixList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serializePrefixList(Hashtable prefixList[" + prefixList + "])");
        }
        String ssv = null;
        if (prefixList != null && !prefixList.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            boolean b = false;
            Enumeration e = prefixList.elements();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                if ("".equals(s)) {
                    s = "#default";
                }
                if (b) {
                    sb.append(" ");
                } else {
                    b = true;
                }
                sb.append(s);
            }
            ssv = sb.toString();
        }
        return ssv;
    }
}

