/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.dsig;

import com.ibm.ws.wssecurity.util.io.BufferExportableByteArrayOutputStream;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.util.io.WriterChainHolder;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.BufferedWriter;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.C14nUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMAttributeWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMNamespaceProxy;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMNamespaceWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;

class Canonicalizer {
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";

    Canonicalizer() {
    }

    public static ByteArrayHolder serializeSubset(ArrayList nodeList, boolean withComments, Map replNodeSets) {
        try {
            BufferExportableByteArrayOutputStream bebaos = new BufferExportableByteArrayOutputStream(0);
            WriterChainHolder wch = (WriterChainHolder)WriterChainHolder.getUtf8WriterChainHolderFactory().getObject();
            wch.getProxyOutputStream().setOutputStream(bebaos);
            BufferedWriter wr = wch.getBufferedWriter();
            Canonicalizer.serializeSubset(nodeList, withComments, replNodeSets, wr);
            ((Writer)wr).flush();
            ByteArrayHolder bah = bebaos.getByteArrayHolder();
            WriterChainHolder.getUtf8WriterChainHolderFactory().releaseObject(wch);
            return bah;
        }
        catch (IOException ioe) {
            RuntimeException e = new RuntimeException("Internal Error: " + ioe);
            e.initCause(ioe);
            throw e;
        }
    }

    public static void serializeSubset(ArrayList nodeList, boolean withComments, Map replNodeSets, Writer wr) throws IOException {
        Canonicalizer.serializeSubset(nodeList, withComments, replNodeSets, wr, null);
    }

    static void serializeSubset(ArrayList nodeList, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes) throws IOException {
        Vector<Object> nodeVector = new Vector<Object>(nodeList.size());
        block0: for (int i = 0; i < nodeList.size(); ++i) {
            Object obj2;
            Object obj = nodeList.get(i);
            if (replNodeSets.containsKey(obj)) {
                nodeVector.add(new ReplacedNode((OMNode)obj));
                int l = nodeList.size();
                for (int j = i + 1; j <= l; ++j) {
                    if (j < l && DOMUtil.isDescendantNode(nodeList.get(j), (OMNode)obj)) continue;
                    i = j - 1;
                    continue block0;
                }
                continue;
            }
            if (obj instanceof OMNode) {
                Object attr;
                Object ns;
                OMNode node = (OMNode)obj;
                nodeVector.addElement(node);
                if (node.getType() != 1) continue;
                Hashtable namespaces = null;
                if (i + 1 < nodeList.size() && (ns = nodeList.get(i + 1)) instanceof OMNamespace && Canonicalizer.isOwnerElement(node, (OMNamespace)ns)) {
                    Object obj22;
                    if (namespaces == null) {
                        namespaces = new Hashtable();
                    }
                    ++i;
                    while (i < nodeList.size() && (obj22 = nodeList.get(i)) instanceof OMNamespace && Canonicalizer.isOwnerElement(node, (OMNamespace)obj22)) {
                        namespaces.put(((OMNamespace)obj22).getPrefix(), obj22);
                        ++i;
                    }
                    if (namespaces.containsKey("") && ((OMNamespace)namespaces.get("")).getName().length() == 0) {
                        namespaces.remove("");
                    }
                    --i;
                    nodeVector.addElement(new OMNamespaces(node, namespaces));
                } else if (namespaces != null) {
                    nodeVector.addElement(new OMNamespaces(node, namespaces));
                }
                Hashtable attributes = Canonicalizer.collectXMLPrefixAttributesInAncestors(node);
                if (i + 1 < nodeList.size() && (attr = nodeList.get(i + 1)) instanceof OMAttribute && Canonicalizer.isOwnerElement(node, (OMAttribute)attr)) {
                    Object obj23;
                    if (attributes == null) {
                        attributes = new Hashtable();
                    }
                    ++i;
                    while (i < nodeList.size() && (obj23 = nodeList.get(i)) instanceof OMAttribute && Canonicalizer.isOwnerElement(node, (OMAttribute)obj23)) {
                        attributes.put(((OMAttribute)obj23).getQName(), obj23);
                        ++i;
                    }
                    --i;
                    nodeVector.addElement(new OMAttributes(node, attributes));
                    continue;
                }
                if (attributes == null) continue;
                nodeVector.addElement(new OMAttributes(node, attributes));
                continue;
            }
            if (obj instanceof OMNamespaceWithOwner) {
                OMElement owner = ((OMNamespaceWithOwner)obj).getOwnerElement();
                Hashtable namespaces = new Hashtable();
                while (i < nodeList.size() && (obj2 = nodeList.get(i)) instanceof OMNamespaceWithOwner && owner == ((OMNamespaceWithOwner)obj2).getOwnerElement()) {
                    namespaces.put(((OMNamespace)obj2).getPrefix(), obj2);
                    ++i;
                }
                nodeVector.addElement(new OMNamespaces(owner, namespaces));
                --i;
                continue;
            }
            if (!(obj instanceof OMAttributeWithOwner)) continue;
            OMElement owner = ((OMAttributeWithOwner)obj).getOwnerElement();
            Hashtable attributes = new Hashtable();
            while (i < nodeList.size() && (obj2 = nodeList.get(i)) instanceof OMAttributeWithOwner && owner == ((OMAttributeWithOwner)obj2).getOwnerElement()) {
                attributes.put(((OMAttribute)obj2).getQName(), obj2);
                ++i;
            }
            nodeVector.addElement(new OMAttributes(owner, attributes));
            --i;
        }
        Stack nStack = new Stack();
        Stack aStack = new Stack();
        for (int i = 0; i < nodeVector.size(); ++i) {
            Canonicalizer.serializeSubset(nStack, aStack, nodeVector, i, withComments, replNodeSets, wr, apexNodes);
        }
    }

    private static void serializeSubset(Stack nStack, Stack aStack, Vector nodeVector, int i, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes) throws IOException {
        OMContainer parent;
        String prefix;
        Object obj = nodeVector.elementAt(i);
        if (obj == null) {
            return;
        }
        if (obj instanceof OMNamespaces) {
            nodeVector.setElementAt(null, i);
            ((OMNamespaces)obj).serialize(null, wr);
            return;
        }
        if (obj instanceof OMAttributes) {
            nodeVector.setElementAt(null, i);
            ((OMAttributes)obj).serialize(null, wr);
            return;
        }
        if (obj instanceof ReplacedNode) {
            ArrayList nl = (ArrayList)replNodeSets.get(((ReplacedNode)obj).getNode());
            HashSet<OMNode> s = new HashSet<OMNode>();
            int j = 0;
            int l = nl.size();
            block0: while (j < l) {
                OMNode n = (OMNode)nl.get(j);
                s.add(n);
                for (int k = j + 1; k <= l; ++k) {
                    if (k < l && DOMUtil.isDescendantNode(nl.get(k), n)) continue;
                    j = k;
                    continue block0;
                }
            }
            Canonicalizer.serializeSubset(nl, false, replNodeSets, wr, s);
            return;
        }
        OMNode node = (OMNode)obj;
        int type = node.getType();
        if (type != 1) {
            Canonicalizer.serializeNode(null, node, null, withComments, true, wr);
            return;
        }
        wr.write("<");
        OMElement elem = (OMElement)node;
        String string = prefix = elem.getNamespace() == null ? null : elem.getNamespace().getPrefix();
        if (prefix != null && prefix.length() != 0) {
            wr.write(prefix);
            wr.write(":");
        }
        wr.write(elem.getLocalName());
        OMNamespaces ancestorNss = nStack.empty() ? null : (OMNamespaces)nStack.peek();
        OMNamespaces nss = null;
        int next = i + 1;
        if (next >= nodeVector.size() || nodeVector.elementAt(next) instanceof OMNode || nodeVector.elementAt(next) instanceof ReplacedNode) {
            parent = node.getParent();
            if (!(parent instanceof OMDocument) && ancestorNss != null && ancestorNss.contains("") || apexNodes != null && apexNodes.contains(node)) {
                wr.write(" xmlns=\"\"");
            }
        } else if (nodeVector.elementAt(next) instanceof OMNamespaces) {
            nss = (OMNamespaces)nodeVector.elementAt(next);
            if (!nss.contains("") && (!((parent = node.getParent()) instanceof OMDocument) && ancestorNss != null && ancestorNss.contains("") || apexNodes != null && apexNodes.contains(node))) {
                wr.write(" xmlns=\"\"");
            }
            nss.serialize(ancestorNss, wr);
            nodeVector.setElementAt(null, next);
            ++next;
        }
        OMAttributes ancestorAttrs = aStack.empty() ? null : (OMAttributes)aStack.peek();
        OMAttributes attrs = null;
        if (next < nodeVector.size() && nodeVector.elementAt(next) instanceof OMAttributes) {
            attrs = (OMAttributes)nodeVector.elementAt(next);
            attrs.serialize(ancestorAttrs, wr);
            nodeVector.setElementAt(null, next);
        }
        wr.write(">");
        nStack.push(nss);
        aStack.push(attrs);
        while (next < nodeVector.size()) {
            if (nodeVector.elementAt(next) == null) {
                ++next;
                continue;
            }
            if (!Canonicalizer.isAncestor(nodeVector.elementAt(next), node)) break;
            Canonicalizer.serializeSubset(nStack, aStack, nodeVector, next, withComments, replNodeSets, wr, apexNodes);
            nodeVector.setElementAt(null, next++);
        }
        nStack.pop();
        aStack.pop();
        wr.write("</");
        if (prefix != null && prefix.length() != 0) {
            wr.write(prefix);
            wr.write(":");
        }
        wr.write(elem.getLocalName());
        wr.write(">");
    }

    static boolean isAncestor(Object me, OMNode anc) {
        OMNode parent = me instanceof OMAttributes ? ((OMAttributes)me).parent : (me instanceof OMNamespaces ? ((OMNamespaces)me).parent : (me instanceof ReplacedNode ? ((ReplacedNode)me).getNode() : (OMNode)me));
        while (parent != anc) {
            OMContainer cont = parent.getParent();
            if (cont instanceof OMDocument) {
                return false;
            }
            parent = (OMNode)((Object)cont);
        }
        return true;
    }

    static boolean isOwnerElement(OMNode parent, OMAttribute child) {
        if (!(parent instanceof OMElement)) {
            return false;
        }
        if (child instanceof OMAttributeWithOwner && ((OMAttributeWithOwner)child).getOwnerElement() == parent) {
            return true;
        }
        OMElement elem = (OMElement)parent;
        Iterator ite = elem.getAllAttributes();
        while (ite.hasNext()) {
            if (child != ite.next()) continue;
            return true;
        }
        return false;
    }

    static boolean isOwnerElement(OMNode parent, OMNamespace child) {
        if (!(parent instanceof OMElement)) {
            return false;
        }
        if (child instanceof OMNamespaceWithOwner && ((OMNamespaceWithOwner)child).getOwnerElement() == parent) {
            return true;
        }
        OMElement elem = (OMElement)parent;
        Iterator ite = elem.getAllDeclaredNamespaces();
        while (ite.hasNext()) {
            if (child != ite.next()) continue;
            return true;
        }
        return false;
    }

    static void serializeNode(OMNode topNode, OMNode node, OMNode exceptedNode, boolean withComments, boolean xmlAttributes, Writer wr) throws IOException {
        Canonicalizer.serializeNode(topNode, null, null, node, exceptedNode, withComments, xmlAttributes, wr);
    }

    private static void serializeNode(OMNode topNode, Stack nStack, Stack aStack, OMNode node, OMNode exceptedNode, boolean withComments, boolean xmlAttributes, Writer wr) throws IOException {
        if (exceptedNode == node) {
            return;
        }
        boolean lesser = false;
        boolean greater = false;
        switch (node.getType()) {
            case 1: {
                String prefix;
                if (nStack == null) {
                    nStack = new Stack();
                }
                if (aStack == null) {
                    aStack = new Stack();
                }
                wr.write("<");
                OMElement elem = (OMElement)node;
                String string = prefix = elem.getNamespace() == null ? null : elem.getNamespace().getPrefix();
                if (prefix != null && prefix.length() != 0) {
                    wr.write(prefix);
                    wr.write(":");
                }
                wr.write(elem.getLocalName());
                Canonicalizer.serializeNamespaces(topNode, nStack, elem, wr);
                Canonicalizer.serializeAttributes(topNode, aStack, elem, xmlAttributes, wr);
                wr.write(">");
                for (OMNode child = elem.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
                    Canonicalizer.serializeNode(topNode, nStack, aStack, child, exceptedNode, withComments, xmlAttributes, wr);
                }
                nStack.pop();
                aStack.pop();
                wr.write("</");
                if (prefix != null && prefix.length() != 0) {
                    wr.write(prefix);
                    wr.write(":");
                }
                wr.write(elem.getLocalName());
                wr.write(">");
                break;
            }
            case 4: 
            case 12: {
                String text = ((OMText)node).getText();
                for (int i = 0; i < text.length(); ++i) {
                    char ch = text.charAt(i);
                    if (ch == '<') {
                        wr.write("&lt;");
                        continue;
                    }
                    if (ch == '>') {
                        wr.write("&gt;");
                        continue;
                    }
                    if (ch == '&') {
                        wr.write("&amp;");
                        continue;
                    }
                    if (ch == '\r') {
                        wr.write("&#xD;");
                        continue;
                    }
                    wr.write(ch);
                }
                break;
            }
            case 9: {
                for (OMNode child = ((OMElement)node).getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
                    Canonicalizer.serializeNode(topNode, nStack, aStack, child, exceptedNode, withComments, xmlAttributes, wr);
                }
                break;
            }
            case 3: {
                if (node.getParent() instanceof OMDocument) {
                    OMNode prev = node;
                    while ((prev = prev.getPreviousOMSibling()) != null && prev.getType() != 1) {
                    }
                    if (prev == null) {
                        lesser = true;
                    } else {
                        greater = true;
                    }
                }
                OMProcessingInstruction pi = (OMProcessingInstruction)node;
                if (greater) {
                    wr.write("\n");
                }
                wr.write("<?");
                wr.write(pi.getTarget());
                if (pi.getValue() != null && pi.getValue().length() > 0) {
                    wr.write(" ");
                    String data = pi.getValue();
                    int start = 0;
                    for (int index = 0; index < data.length(); ++index) {
                        if (data.charAt(index) != '\r') continue;
                        if (index > start) {
                            wr.write(data, start, index - start);
                        }
                        wr.write("&#xD;");
                        start = index + 1;
                    }
                    if (start < data.length()) {
                        wr.write(data, start, data.length() - start);
                    }
                }
                wr.write("?>");
                if (!lesser) break;
                wr.write("\n");
                break;
            }
            case 5: {
                if (!withComments) break;
                if (node.getParent() instanceof OMDocument) {
                    OMNode prev = node;
                    while ((prev = prev.getPreviousOMSibling()) != null && prev.getType() != 1) {
                    }
                    if (prev == null) {
                        lesser = true;
                    } else {
                        greater = true;
                    }
                }
                if (greater) {
                    wr.write("\n");
                }
                wr.write("<!--");
                wr.write(((OMComment)node).getValue());
                wr.write("-->");
                if (!lesser) break;
                wr.write("\n");
            }
        }
    }

    private static boolean isTopElement(OMNode topNode, OMElement element) {
        if (topNode == element) {
            return true;
        }
        OMContainer parent = element.getParent();
        if (parent != null) {
            if (parent instanceof OMDocument) {
                return true;
            }
            if (parent instanceof OMElement) {
                return false;
            }
            throw new RuntimeException("Internal Error: Unexpected node type: " + ((OMNode)((Object)parent)).getType());
        }
        return true;
    }

    private static void serializeAttributes(OMNode topNode, Stack stack, OMElement element, boolean xmlAttributes, Writer wr) throws IOException {
        Hashtable xmlattrs;
        Hashtable<QName, OMAttribute> nsattrs = new Hashtable<QName, OMAttribute>();
        Iterator attrsIte = element.getAllAttributes();
        while (attrsIte.hasNext()) {
            OMAttribute a = (OMAttribute)attrsIte.next();
            nsattrs.put(a.getQName(), a);
        }
        if (xmlAttributes && (xmlattrs = Canonicalizer.collectXMLPrefixAttributesInAncestors(element)) != null) {
            Enumeration en = xmlattrs.elements();
            while (en.hasMoreElements()) {
                OMAttribute attr = (OMAttribute)en.nextElement();
                nsattrs.put(attr.getQName(), attr);
            }
        }
        Hashtable parentAttrs = stack.isEmpty() ? null : (Hashtable)stack.peek();
        stack.push(nsattrs);
        int atlen = nsattrs.size();
        String[] as = new String[atlen];
        int[] indexMap = new int[atlen];
        OMAttribute[] attrs = new OMAttribute[atlen];
        int i = 0;
        Enumeration en = nsattrs.elements();
        while (en.hasMoreElements()) {
            OMAttribute attr = (OMAttribute)en.nextElement();
            indexMap[i] = i;
            attrs[i] = attr;
            as[i] = Canonicalizer.createSortedString(attr, (OMNode)element);
            ++i;
        }
        C14nUtil.heapSort(indexMap, as, atlen);
        for (int j = 0; j < atlen; ++j) {
            OMAttribute xa;
            OMAttribute a = attrs[indexMap[j]];
            QName attrName = a.getQName();
            if (attrName.getPrefix() != null && attrName.getPrefix().equals("xml") && parentAttrs != null && (xa = (OMAttribute)parentAttrs.get(attrName)) != null && xa.getAttributeValue() != null && xa.getAttributeValue().equals(a.getAttributeValue())) continue;
            Canonicalizer.serializeAttribute(a, wr);
        }
    }

    private static void serializeNamespaces(OMNode topNode, Stack stack, OMElement element, Writer wr) throws IOException {
        Hashtable nsattrs = Canonicalizer.collectNamespaceNodesInAncestors(element, false);
        Iterator nssIte = element.getAllDeclaredNamespaces();
        while (nssIte.hasNext()) {
            OMNamespace ns = (OMNamespace)nssIte.next();
            nsattrs.put(ns.getPrefix(), ns);
        }
        Hashtable parentNss = stack.isEmpty() ? null : (Hashtable)stack.peek();
        stack.push(nsattrs);
        int nslen = nsattrs.size();
        String[] as = new String[nslen];
        int[] indexMap = new int[nslen];
        OMNamespace[] nss = new OMNamespace[nslen];
        int i = 0;
        Enumeration en = nsattrs.elements();
        while (en.hasMoreElements()) {
            OMNamespace ns = (OMNamespace)en.nextElement();
            indexMap[i] = i;
            nss[i] = ns;
            as[i] = Canonicalizer.createSortedString(ns, (OMNode)element);
            ++i;
        }
        C14nUtil.heapSort(indexMap, as, nslen);
        for (int j = 0; j < nslen; ++j) {
            OMNamespace _ns;
            OMNamespace ns = nss[indexMap[j]];
            String prefix = ns.getPrefix();
            if (prefix.equals("xml")) continue;
            if (prefix.length() == 0 && (ns.getName() == null || ns.getName().length() == 0)) {
                if (Canonicalizer.isTopElement(topNode, element)) continue;
                boolean found = false;
                for (int depth = stack.size() - 1; depth >= 0; --depth) {
                    Hashtable nss2 = (Hashtable)stack.elementAt(depth);
                    OMNamespace ns2 = (OMNamespace)nss2.get("");
                    if (ns2 == null || ns2.getName() == null || ns2.getName().length() <= 0) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (parentNss != null && (_ns = (OMNamespace)parentNss.get(prefix)) != null && _ns.getName() != null && _ns.getName().equals(ns.getName())) continue;
            Canonicalizer.serializeNamespace(ns, wr);
        }
    }

    private static void serializeAttribute(OMAttribute attr, Writer wr) throws IOException {
        String prefix = attr.getNamespace() == null ? null : attr.getNamespace().getPrefix();
        wr.write(" ");
        if (prefix != null && prefix.length() != 0) {
            wr.write(prefix);
            wr.write(":");
        }
        wr.write(attr.getLocalName());
        wr.write("=\"");
        String value = attr.getAttributeValue();
        for (int j = 0; j < value.length(); ++j) {
            char ch = value.charAt(j);
            if (ch == '&') {
                wr.write("&amp;");
                continue;
            }
            if (ch == '<') {
                wr.write("&lt;");
                continue;
            }
            if (ch == '\"') {
                wr.write("&quot;");
                continue;
            }
            if (ch == '\t') {
                wr.write("&#x9;");
                continue;
            }
            if (ch == '\n') {
                wr.write("&#xA;");
                continue;
            }
            if (ch == '\r') {
                wr.write("&#xD;");
                continue;
            }
            wr.write(ch);
        }
        wr.write("\"");
    }

    private static void serializeNamespace(OMNamespace ns, Writer wr) throws IOException {
        String prefix = ns.getPrefix();
        if (prefix != null && prefix.length() != 0) {
            wr.write(" xmlns:");
            wr.write(prefix);
        } else {
            wr.write(" xmlns");
        }
        wr.write("=\"");
        String value = ns.getName();
        boolean hasColon = false;
        for (int j = 0; j < value.length(); ++j) {
            char ch = value.charAt(j);
            if (ch == '&') {
                wr.write("&amp;");
                continue;
            }
            if (ch == '<') {
                wr.write("&lt;");
                continue;
            }
            if (ch == '\"') {
                wr.write("&quot;");
                continue;
            }
            if (ch == '\t') {
                wr.write("&#x9;");
                continue;
            }
            if (ch == '\n') {
                wr.write("&#xA;");
                continue;
            }
            if (ch == '\r') {
                wr.write("&#xD;");
                continue;
            }
            if (ch == ':') {
                hasColon = true;
            } else if (ch == '/' && !hasColon) {
                throw new RuntimeException("Found a relative URI: " + value);
            }
            wr.write(ch);
        }
        if (value.length() > 0 && !hasColon) {
            throw new RuntimeException("Found a relative URI: " + value);
        }
        wr.write("\"");
    }

    public static Hashtable collectNamespaceNodesInAncestors(OMNode startNode, boolean useProxy) {
        OMNode node = startNode;
        Hashtable<String, OMNamespace> nsnodes = new Hashtable<String, OMNamespace>();
        OMFactory factory = startNode.getOMFactory();
        if (node.getType() == 1 && ((OMElement)node).findNamespaceURI("xml") == null) {
            if (useProxy) {
                nsnodes.put("xml", new OMNamespaceProxy(startNode, factory, XML_NAMESPACE, "xml"));
            } else {
                OMNamespace xa = factory.createOMNamespace(XML_NAMESPACE, "xml");
                nsnodes.put("xml", xa);
            }
        }
        if (node.getType() != 1) {
            OMContainer cont = node.getParent();
            node = cont instanceof OMDocument ? null : (OMElement)cont;
        }
        while (node != null) {
            OMContainer cont;
            Iterator nsList = ((OMElement)node).getAllDeclaredNamespaces();
            if (nsList != null) {
                while (nsList.hasNext()) {
                    OMNamespace newNs;
                    OMNamespace ns = (OMNamespace)nsList.next();
                    String prefix = ns.getPrefix();
                    if (nsnodes.containsKey(prefix)) continue;
                    if (node == startNode) {
                        nsnodes.put(prefix, ns);
                        continue;
                    }
                    if (useProxy) {
                        newNs = new OMNamespaceProxy(startNode, factory, ns.getName(), prefix);
                        nsnodes.put(prefix, newNs);
                        continue;
                    }
                    newNs = factory.createOMNamespace(ns.getName(), prefix);
                    nsnodes.put(prefix, newNs);
                }
            }
            if ((cont = node.getParent()) instanceof OMDocument) {
                node = null;
                continue;
            }
            node = (OMNode)((Object)cont);
        }
        return nsnodes;
    }

    public static Hashtable collectXMLPrefixAttributesInAncestors(OMNode startNode) {
        Iterator attributeList;
        Hashtable<QName, OMAttribute> attrs = null;
        OMContainer node = startNode.getParent();
        while (node instanceof OMElement) {
            Iterator attributeList2 = ((OMElement)node).getAllAttributes();
            if (attributeList2 != null) {
                while (attributeList2.hasNext()) {
                    OMAttribute attr = (OMAttribute)attributeList2.next();
                    QName qname = attr.getQName();
                    if (!"xml".equals(qname.getPrefix()) || attrs != null && attrs.containsKey(qname)) continue;
                    if (attrs == null) {
                        attrs = new Hashtable<QName, OMAttribute>();
                    }
                    attrs.put(qname, attr);
                }
            }
            node = ((OMElement)node).getParent();
        }
        if (attrs != null && (attributeList = ((OMElement)startNode).getAllAttributes()) != null) {
            while (attributeList.hasNext()) {
                OMAttribute attr = (OMAttribute)attributeList.next();
                QName qname = attr.getQName();
                if (!"xml".equals(qname.getPrefix()) || !attrs.containsKey(qname)) continue;
                attrs.remove(qname);
            }
        }
        return attrs;
    }

    private static String createSortedString(OMAttribute node, OMNode element) {
        String local = node.getLocalName();
        String uri = node.getNamespace() == null ? null : node.getNamespace().getName();
        String ret = uri == null || uri.length() == 0 ? "\u0001" + local : uri + "\u0001" + local;
        return ret;
    }

    private static String createSortedString(OMNamespace node, OMNode element) {
        String prefix = node.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            return "\u0000";
        }
        return "\u0000" + prefix;
    }

    static class ReplacedNode {
        private OMNode fNode;

        ReplacedNode(OMNode node) {
            this.fNode = node;
        }

        OMNode getNode() {
            return this.fNode;
        }
    }

    static class OMNamespaces {
        OMNode parent;
        Hashtable namespaces;

        OMNamespaces(OMNode node, Hashtable nss) {
            this.parent = node;
            this.namespaces = nss;
            if (this.namespaces == null) {
                this.namespaces = new Hashtable();
            }
        }

        boolean contains(String prefix) {
            return this.namespaces.containsKey(prefix);
        }

        void serialize(OMNamespaces parent, Writer wr) throws IOException {
            OMNamespace ns;
            int j;
            int nsLength = this.namespaces.size();
            String[] as = new String[nsLength];
            int[] indexMap = new int[nsLength];
            OMNamespace[] nsArray = new OMNamespace[nsLength];
            Enumeration en = this.namespaces.elements();
            for (j = 0; j < nsLength; ++j) {
                ns = (OMNamespace)en.nextElement();
                indexMap[j] = j;
                nsArray[j] = ns;
                as[j] = Canonicalizer.createSortedString(ns, this.parent);
            }
            C14nUtil.heapSort(indexMap, as, nsLength);
            for (j = 0; j < nsLength; ++j) {
                ns = nsArray[indexMap[j]];
                String prefixName = ns.getPrefix();
                if (prefixName.equals("xml") || parent != null && parent.contains(prefixName) && parent.get(prefixName).getName().equals(ns.getName())) continue;
                Canonicalizer.serializeNamespace(ns, wr);
            }
        }

        Enumeration enumeration() {
            return this.namespaces.elements();
        }

        OMNamespace get(String prefix) {
            return (OMNamespace)this.namespaces.get(prefix);
        }

        private void remove(String prefix) {
            Object ns = this.namespaces.remove(prefix);
            if (ns == null) {
                System.err.println("Internal logic error: No prefix named " + prefix);
            }
        }

        private boolean usePrefix(String prefix) {
            if (prefix.length() == 0) {
                return false;
            }
            Enumeration en = this.enumeration();
            while (en.hasMoreElements()) {
                OMNamespace ns = (OMNamespace)en.nextElement();
                String p = ns.getPrefix();
                if (p == null || !p.equals(prefix)) continue;
                return true;
            }
            return false;
        }

        static boolean inAncestors(Stack ancestors, String name, String ns) {
            if (ancestors == null || ancestors.isEmpty()) {
                return false;
            }
            for (int i = ancestors.size() - 1; i >= 0; --i) {
                OMNamespaces nss = (OMNamespaces)ancestors.elementAt(i);
                if (!nss.contains(name) || !nss.get(name).getName().equals(ns)) continue;
                return true;
            }
            return false;
        }

        void serialize(Stack ancestors, Hashtable prefixList, String elprefix, Writer wr) throws IOException {
            OMNamespace ns;
            int j;
            int nsLength = this.namespaces.size();
            String[] as = new String[nsLength];
            int[] indexMap = new int[nsLength];
            OMNamespace[] nsArray = new OMNamespace[nsLength];
            Enumeration en = this.namespaces.elements();
            for (j = 0; j < nsLength; ++j) {
                ns = (OMNamespace)en.nextElement();
                indexMap[j] = j;
                nsArray[j] = ns;
                as[j] = Canonicalizer.createSortedString(ns, this.parent);
            }
            C14nUtil.heapSort(indexMap, as, nsLength);
            for (j = 0; j < nsLength; ++j) {
                ns = nsArray[indexMap[j]];
                String prefixName = ns.getPrefix();
                if (prefixName.equals("xml")) {
                    this.remove(prefixName);
                    continue;
                }
                if (OMNamespaces.inAncestors(ancestors, prefixName, ns.getName())) {
                    this.remove(prefixName);
                    continue;
                }
                if (!(prefixList != null && prefixList.get(prefixName) != null || elprefix == null || elprefix.equals(prefixName) || this.usePrefix(prefixName))) {
                    this.remove(prefixName);
                    continue;
                }
                Canonicalizer.serializeNamespace(ns, wr);
            }
        }

        public String toString() {
            return "OMNamespaces[#=" + this.namespaces.size() + "]";
        }
    }

    static class OMAttributes {
        OMNode parent;
        Hashtable attributes;

        OMAttributes(OMNode node, Hashtable attrs) {
            this.parent = node;
            this.attributes = attrs;
            if (this.attributes == null) {
                this.attributes = new Hashtable();
            }
        }

        boolean contains(QName attrname) {
            return this.attributes.containsKey(attrname);
        }

        void serialize(OMAttributes parent, Writer wr) throws IOException {
            OMAttribute attr;
            int j;
            int attrLength = this.attributes.size();
            String[] as = new String[attrLength];
            int[] indexMap = new int[attrLength];
            OMAttribute[] attrArray = new OMAttribute[attrLength];
            Enumeration en = this.attributes.elements();
            for (j = 0; j < attrLength; ++j) {
                attr = (OMAttribute)en.nextElement();
                indexMap[j] = j;
                attrArray[j] = attr;
                as[j] = Canonicalizer.createSortedString(attr, this.parent);
            }
            C14nUtil.heapSort(indexMap, as, attrLength);
            for (j = 0; j < attrLength; ++j) {
                String prefix;
                attr = attrArray[indexMap[j]];
                QName attrName = attr.getQName();
                String string = prefix = attr.getNamespace() == null ? null : attr.getNamespace().getPrefix();
                if (prefix != null && prefix.equals("xml") && parent != null && parent.contains(attrName) && parent.get(attrName).getAttributeValue().equals(attr.getAttributeValue())) continue;
                Canonicalizer.serializeAttribute(attr, wr);
            }
        }

        Enumeration enumeration() {
            return this.attributes.elements();
        }

        OMAttribute get(QName name) {
            return (OMAttribute)this.attributes.get(name);
        }

        private void remove(QName name) {
            Object attr = this.attributes.remove(name);
            if (attr == null) {
                System.err.println("Internal logic error: No attribute named " + name);
            }
        }

        private boolean usePrefix(String prefix) {
            if (prefix.length() == 0) {
                return false;
            }
            Enumeration en = this.enumeration();
            while (en.hasMoreElements()) {
                OMAttribute attr = (OMAttribute)en.nextElement();
                String p = attr.getNamespace() == null ? null : attr.getNamespace().getPrefix();
                if (p == null || !p.equals(prefix)) continue;
                return true;
            }
            return false;
        }

        static boolean inAncestors(Stack ancestors, QName name, String ns) {
            if (ancestors == null || ancestors.isEmpty()) {
                return false;
            }
            for (int i = ancestors.size() - 1; i >= 0; --i) {
                OMAttributes attrs = (OMAttributes)ancestors.elementAt(i);
                if (!attrs.contains(name) || !attrs.get(name).getAttributeValue().equals(ns)) continue;
                return true;
            }
            return false;
        }

        void serialize(Stack ancestors, Hashtable prefixList, String elprefix, Writer wr) throws IOException {
            OMAttribute attr;
            int j;
            int attrLength = this.attributes.size();
            String[] as = new String[attrLength];
            int[] indexMap = new int[attrLength];
            OMAttribute[] attrArray = new OMAttribute[attrLength];
            Enumeration en = this.attributes.elements();
            for (j = 0; j < attrLength; ++j) {
                attr = (OMAttribute)en.nextElement();
                indexMap[j] = j;
                attrArray[j] = attr;
                as[j] = Canonicalizer.createSortedString(attr, this.parent);
            }
            C14nUtil.heapSort(indexMap, as, attrLength);
            for (j = 0; j < attrLength; ++j) {
                attr = attrArray[indexMap[j]];
                Canonicalizer.serializeAttribute(attr, wr);
            }
        }

        public String toString() {
            return "OMAttributes[#=" + this.attributes.size() + "]";
        }
    }
}

