/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.ws.wssecurity.core.WSSecurityPlatformContext;
import com.ibm.ws.wssecurity.core.WSSecurityPlatformContextImpl;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.Permission;
import java.security.SecurityPermission;

public final class WSSecurityPlatformContextFactory {
    private static final TraceComponent tc = Tr.register(WSSecurityPlatformContextFactory.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final Permission SETSERVER_PERM = new SecurityPermission("wssecurity.setServer");
    private static boolean initialized = false;

    public static final WSSecurityPlatformContext getInstance() {
        return WSSecurityPlatformContextHolder.instance;
    }

    public static final void setServer() throws SoapSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SETSERVER_PERM);
        }
        if (initialized) {
            throw SoapSecurityException.format("security.wssecurity.WSEC0133E");
        }
        initialized = true;
        ((WSSecurityPlatformContextImpl)WSSecurityPlatformContextHolder.instance).setServer();
    }

    private WSSecurityPlatformContextFactory() {
    }

    private static class WSSecurityPlatformContextHolder {
        private static final WSSecurityPlatformContext instance = new WSSecurityPlatformContextImpl();

        private WSSecurityPlatformContextHolder() {
        }

        static {
            initialized = true;
        }
    }
}

