/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;

public class WSSecurityDefaultConfiguration {
    private static final TraceComponent tc = Tr.register(WSSecurityDefaultConfiguration.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected boolean useNonceCache = true;
    protected String nonceCacheName = "NonceDistributionCacheMap";
    protected int nonceCacheSize = 1024;
    protected int nonceCacheTimeout = 600;
    protected int nonceLength = 128;
    protected int nonceMaxAge = 300;
    protected int nonceClockSkew = 0;
    protected boolean nonceCacheDistributed = false;
    protected boolean useCertCache = true;
    protected String certCacheName = "WSSCertCache";
    protected int certCacheSize = 128;
    protected int certCacheTimeOut = 900;
    protected boolean useConfigCache = true;
    protected String configCacheName = "WSSReqGeneratorConfigMap";
    protected int configCacheSize = 128;
    protected int configCacheTimeToLive = 900;
    protected boolean useHardwareAcceleration = false;
    protected String hardwareConfigName = null;
    protected String useOffloadAllCrypto = "false";
    protected boolean offloadRSAPublicKeyCrypto = true;
    protected int hardwareCacheSize = 1000;
    protected boolean useTokenCache = true;
    protected String tokenCacheName = "WSSTokenCache";
    protected int tokenCacheSize = 128;
    protected int tokenCacheTimeOut = 900;
    protected long tokenCacheCushion = 600000L;
    protected WSSGeneratorConfig gconfig = null;
    protected WSSConsumerConfig cconfig = null;
    protected SoapSecurityException defaultBindingsLoadingException = null;

    public boolean getNonceCacheDistributed() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonceCacheDistributed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonceCacheDistributed", Boolean.toString(this.nonceCacheDistributed));
        }
        return this.nonceCacheDistributed;
    }

    public void setNonceCacheDistributed(boolean nonceCacheDistributed) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setNonceCacheDistributed");
        }
        this.nonceCacheDistributed = nonceCacheDistributed;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setNonceCacheDistributed", Boolean.toString(this.nonceCacheDistributed));
        }
    }

    public int getNonceCacheTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonceCacheTimeout");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonceCacheTimeout", new Integer(this.nonceCacheTimeout));
        }
        return this.nonceCacheTimeout;
    }

    public void setNonceCacheTimeout(int nonceCacheTimeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonceCacheTimeout");
        }
        this.nonceCacheTimeout = nonceCacheTimeout;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setNonceCacheTimeout to", new Integer(this.nonceCacheTimeout));
        }
    }

    public void setNonceMaxAge(int nonceMaxAge) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setNonceMaxAge");
        }
        this.nonceMaxAge = nonceMaxAge;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setNonceMaxAge", this.nonceMaxAge);
        }
    }

    public int getNonceMaxAge() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonceMaxAge");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonceMaxAge", this.nonceMaxAge);
        }
        return this.nonceMaxAge;
    }

    public int getNonceClockSkew() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonceClockSkew");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonceClockSkew", new Integer(this.nonceClockSkew));
        }
        return this.nonceClockSkew;
    }

    public void setNonceClockSkew(int nonceClockSkew) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setNonceClockSkew");
        }
        this.nonceClockSkew = nonceClockSkew;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setNonceClockSkew", new Integer(this.nonceClockSkew));
        }
    }

    public WSSConsumerConfig getDefaultConsumerBinding() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultConsumerBinding");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultConsumerBinding", this.cconfig);
        }
        return this.cconfig;
    }

    public void setDefaultConsumerBinding(WSSConsumerConfig defaultConsumerConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDefaultConsumerBinding");
        }
        this.cconfig = defaultConsumerConfig;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDefaultConsumerBinding", this.cconfig);
        }
    }

    public WSSGeneratorConfig getDefaultGeneratorBinding() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultGeneratorBinding");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultGeneratorBinding", this.gconfig);
        }
        return this.gconfig;
    }

    public void setDefaultGeneratorBinding(WSSGeneratorConfig defaultGeneratorConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDefaultGeneratorBinding");
        }
        this.gconfig = defaultGeneratorConfig;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDefaultGeneratorBinding", this.gconfig);
        }
    }

    public String toString() {
        return "Configuration( NonceCacheName = " + this.nonceCacheName + " NonceCacheSize = " + this.nonceCacheSize + " NonceCacheTimeout = " + this.nonceCacheTimeout + " NonceLength = " + this.nonceLength + " NonceMaxAge = " + this.nonceMaxAge + " NonceClockSkew = " + this.nonceClockSkew + " NonceCacheDistributed = " + this.nonceCacheDistributed + " CertCacheName = " + this.certCacheName + " CertCacheSize = " + this.certCacheSize + " CertCacheTimeout = " + this.certCacheTimeOut + " TokenCacheName = " + this.tokenCacheName + " TokenCacheSize = " + this.tokenCacheSize + " TokenCacheTimeout = " + this.tokenCacheTimeOut + " TokenCacheCushion = " + this.tokenCacheCushion + " DefaultGeneratorBinding = " + this.gconfig + " DefaultConsumerBindig = " + this.cconfig + " Hardware Acceleration = " + this.useHardwareAcceleration + " HardwareConfigName = " + this.hardwareConfigName + " OffloadAllCrypto  = " + this.useOffloadAllCrypto + " HardwareCacheSize  = " + this.hardwareCacheSize + " OffloadRSAPublicKeyCrypto  = " + this.offloadRSAPublicKeyCrypto + ")";
    }

    public boolean getUseHardwareAcceleration() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUseHardwareAcceleration");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUseHardwareAcceleration", this.useHardwareAcceleration);
        }
        return this.useHardwareAcceleration;
    }

    public void setUseHardwareAcceleration(boolean useHardwareAcceleration) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setUseHardwareAcceleration");
        }
        this.useHardwareAcceleration = useHardwareAcceleration;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setUseHardwareAcceleration", this.useHardwareAcceleration);
        }
    }

    public String getHardwareConfigName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHardwareConfigName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHardwareConfigName", this.hardwareConfigName);
        }
        return this.hardwareConfigName;
    }

    public void setHardwareConfigName(String hardwareConfigName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setHardwareConfigName");
        }
        this.hardwareConfigName = hardwareConfigName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setHardwareConfigName", this.hardwareConfigName);
        }
    }

    public int getCertCacheTimeOut() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertCacheTimeOut");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertCacheTimeOut", this.useConfigCache);
        }
        return this.certCacheTimeOut;
    }

    public void setCertCacheTimeOut(int certCacheTimeOut) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCertCacheTimeOut");
        }
        this.certCacheTimeOut = certCacheTimeOut;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCertCacheTimeOut", this.certCacheTimeOut);
        }
    }

    public void setConfigCacheTimeToLive(int configCacheTimeToLive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setConfigCacheTimeToLive");
        }
        this.configCacheTimeToLive = configCacheTimeToLive;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setConfigCacheTimeToLive", this.configCacheTimeToLive);
        }
    }

    public int getConfigCacheTimeToLive() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigCacheTimeToLive");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigCacheTimeToLive", this.configCacheTimeToLive);
        }
        return this.configCacheTimeToLive;
    }

    public int getTokenCacheTimeOut() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenCacheTimeOut");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenCacheTimeOut", this.tokenCacheTimeOut);
        }
        return this.tokenCacheTimeOut;
    }

    public void setTokenCacheTimeOut(int tokenCacheTimeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenCacheTimeOut");
        }
        this.tokenCacheTimeOut = tokenCacheTimeout;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTokenCacheTimeOut", this.tokenCacheTimeOut);
        }
    }

    public void setTokenCacheCushion(long tokenCacheCushion) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenCacheCushion");
        }
        this.tokenCacheCushion = tokenCacheCushion;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTokenCacheCushion", this.tokenCacheCushion);
        }
    }

    public long getTokenCacheCushion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenCacheCushion");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenCacheCushion", this.tokenCacheCushion);
        }
        return this.tokenCacheCushion;
    }

    public boolean getUseConfigCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUseConfigCache");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUseConfigCache", this.useConfigCache);
        }
        return this.useConfigCache;
    }

    public void setUseConfigCache(boolean useConfigCache) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setUseConfigCache");
        }
        this.useConfigCache = useConfigCache;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setUseConfigCache", this.useConfigCache);
        }
    }

    public String getUseOffloadAllCrypto() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUseOffloadAllCrypto");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUseOffloadAllCrypto", this.useOffloadAllCrypto);
        }
        return this.useOffloadAllCrypto;
    }

    public void setUseOffloadAllCrypto(String useOffloadAllCrypto) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setUseOffloadAllCrypto");
        }
        this.useOffloadAllCrypto = useOffloadAllCrypto;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setUseOffloadAllCrypto", this.useOffloadAllCrypto);
        }
    }

    public boolean getOffloadRSAPublicKeyCrypto() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOffloadRSAPublicKeyCrypto");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOffloadRSAPublicKeyCrypto", this.offloadRSAPublicKeyCrypto);
        }
        return this.offloadRSAPublicKeyCrypto;
    }

    public void setOffloadRSAPublicKeyCrypto(boolean offloadRSAPublicKeyCrypto) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setOffloadRSAPublicKeyCrypto");
        }
        this.offloadRSAPublicKeyCrypto = offloadRSAPublicKeyCrypto;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setOffloadRSAPublicKeyCrypto", this.offloadRSAPublicKeyCrypto);
        }
    }

    public int getHardwareCacheSize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHardwareCacheSize");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHardwareCacheSize", this.hardwareCacheSize);
        }
        return this.hardwareCacheSize;
    }

    public void setHardwareCacheSize(int hardwareCacheSize) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setHardwareCacheSize");
        }
        this.hardwareCacheSize = hardwareCacheSize;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setHardwareCacheSize", this.hardwareCacheSize);
        }
    }

    public void setUseCertCache(boolean useCertCache) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setUseCertCache");
        }
        this.useCertCache = useCertCache;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setUseCertCache", this.useCertCache);
        }
    }

    public boolean getUseCertCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUseCertCache");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUseCertCache", this.useCertCache);
        }
        return this.useCertCache;
    }

    public void setUseTokenCache(boolean useTokenCache) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setUseTokenCache");
        }
        this.useTokenCache = useTokenCache;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setUseTokenCache", this.useTokenCache);
        }
    }

    public boolean getUseTokenCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUseTokenCache");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUseTokenCache", this.useTokenCache);
        }
        return this.useTokenCache;
    }

    public void setNonceCacheName(String nonceCacheName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setNonceCacheName");
        }
        this.nonceCacheName = nonceCacheName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setNonceCacheName", this.nonceCacheName);
        }
    }

    public String getNonceCacheName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonceCacheName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonceCacheName", this.nonceCacheName);
        }
        return this.nonceCacheName;
    }

    public void setCertCacheName(String certCacheName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCertCacheName");
        }
        this.certCacheName = certCacheName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCertCacheName", this.certCacheName);
        }
    }

    public String getCertCacheName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertCacheName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertCacheName", this.certCacheName);
        }
        return this.certCacheName;
    }

    public void setConfigCacheName(String configCacheName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setConfigCacheName");
        }
        this.configCacheName = configCacheName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setConfigCacheName", this.configCacheName);
        }
    }

    public String getConfigCacheName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigCacheName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigCacheName", this.configCacheName);
        }
        return this.certCacheName;
    }

    public void setTokenCacheName(String tokenCacheName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenCacheName");
        }
        this.tokenCacheName = tokenCacheName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTokenCacheName", this.tokenCacheName);
        }
    }

    public String getTokenCacheName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenCacheName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenCacheName", this.tokenCacheName);
        }
        return this.tokenCacheName;
    }

    public void setNonceCacheSize(int nonceCacheSize) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setNonceCacheSize");
        }
        this.nonceCacheSize = nonceCacheSize;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setNonceCacheSize", this.nonceCacheSize);
        }
    }

    public int getNonceCacheSize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonceCacheSize");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonceCacheSize", this.nonceCacheSize);
        }
        return this.nonceCacheSize;
    }

    public void setCertCacheSize(int certCacheSize) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCertCacheSize");
        }
        this.certCacheSize = certCacheSize;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCertCacheSize", this.certCacheSize);
        }
    }

    public int getCertCacheSize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertCacheSize");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertCacheSize", this.certCacheSize);
        }
        return this.certCacheSize;
    }

    public void setConfigCacheSize(int configCacheSize) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setConfigCacheSize");
        }
        this.configCacheSize = configCacheSize;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setConfigCacheSize", this.configCacheSize);
        }
    }

    public int getConfigCacheSize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigCacheSize");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigCacheSize", this.configCacheSize);
        }
        return this.configCacheSize;
    }

    public void setTokenCacheSize(int tokenCacheSize) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenCacheSize");
        }
        this.tokenCacheSize = tokenCacheSize;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTokenCacheSize", this.tokenCacheSize);
        }
    }

    public int getTokenCacheSize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenCacheSize");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenCacheSize", this.tokenCacheSize);
        }
        return this.tokenCacheSize;
    }

    public boolean getUseNonceCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUseNonceCache");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUseNonceCache", this.useNonceCache);
        }
        return this.useNonceCache;
    }

    public int getNonceLength() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonceLength");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonceLength", this.nonceLength);
        }
        return this.nonceLength;
    }

    public void setDefaultBindingsLoadingException(SoapSecurityException e) {
        this.defaultBindingsLoadingException = e;
    }

    public SoapSecurityException getDefaultBindingsLoadingException() {
        return this.defaultBindingsLoadingException;
    }
}

