/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.security.auth.Subject;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.ThreadContextMigrator;

public class WSSecurityContextMigrator
implements ThreadContextMigrator {
    private static final TraceComponent tc = Tr.register(WSSecurityContextMigrator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityContextMigrator.class.getName();
    private final String WSSECURITY_INITIAL_SENDER_SUBJECT = "com.ibm.ws.wssecurity.initial.sender.subject";
    private final String WSSECURITY_INITIAL_SENDER_CERTIFICATE = "com.ibm.ws.wssecurity.initial.sender.x509certificate";
    private final String WSSECURITY_INITIAL_SENDER = "com.ibm.ws.wssecurity.initial.sender";

    public void migrateContextToThread(MessageContext mc) throws AxisFault {
        ContextManager ctxMgr;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "migrateContextToThread(MessageContext mc)" + mc.getMessageID());
        }
        if ((ctxMgr = ContextManagerFactory.getInstance()) == null) {
            Tr.error(tc, "security.wssecurity.ctxmgr.isnull");
        } else {
            HashMap obj = (HashMap)mc.getProperty("com.ibm.ws.wssecurity.initial.sender");
            if (obj == null || obj.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "no Initial sender need migration.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "migrateContextToThread(MessageContext mc)" + mc.getMessageID());
                }
                return;
            }
            if (obj.containsKey("com.ibm.ws.wssecurity.initial.sender.subject")) {
                Subject subject = (Subject)obj.get("com.ibm.ws.wssecurity.initial.sender.subject");
                if (subject != null) {
                    ctxMgr.put("com.ibm.wsspi.wssecurity.username.initialSenderId", subject);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Initial Sender is set to TLS.");
                    }
                }
            } else if (ctxMgr.get("com.ibm.wsspi.wssecurity.username.initialSenderId") != null) {
                ctxMgr.put("com.ibm.wsspi.wssecurity.username.initialSenderId", null);
            }
            if (obj.containsKey("com.ibm.ws.wssecurity.initial.sender.x509certificate")) {
                X509Certificate cert = (X509Certificate)obj.get("com.ibm.ws.wssecurity.initial.sender.x509certificate");
                if (cert != null) {
                    ctxMgr.put("com.ibm.wsspi.wssecurity.username.initialSenderCert", cert);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Initial Cert is set to TLS.");
                    }
                }
            } else if (ctxMgr.get("com.ibm.wsspi.wssecurity.username.initialSenderCert") != null) {
                ctxMgr.put("com.ibm.wsspi.wssecurity.username.initialSenderCert", null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "migrateContextToThread((MessageContext mc))" + mc.getMessageID());
        }
    }

    public void cleanupThread(MessageContext mc) {
        ContextManager contextManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupThread(MessageContext[" + mc.getMessageID() + "])");
        }
        if ((contextManager = ContextManagerFactory.getInstance()) == null) {
            Tr.error(tc, "com.ibm.ws.security.core.ContextManagerFactory.getInstance() returned null");
        } else {
            if (contextManager.get("com.ibm.wsspi.wssecurity.username.initialSenderId") != null) {
                contextManager.put("com.ibm.wsspi.wssecurity.username.initialSenderId", null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSSECURITY_INITIAL_SENDER_ID removed from contextManager");
                }
            }
            if (contextManager.get("com.ibm.wsspi.wssecurity.username.initialSenderCert") != null) {
                contextManager.put("com.ibm.wsspi.wssecurity.username.initialSenderCert", null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSSECURITY_INITIAL_SENDER_CERT removed from contextManager");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupThread(MessageContext[" + mc.getMessageID() + "])");
        }
    }

    public void migrateThreadToContext(MessageContext mc) throws AxisFault {
        ContextManager ctxMgr;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "migrateThreadToContext(MessageContext mc)" + mc.getMessageID());
        }
        if ((ctxMgr = ContextManagerFactory.getInstance()) == null) {
            Tr.error(tc, "security.wssecurity.ctxmgr.isnull");
        } else {
            X509Certificate cert;
            HashMap<String, Serializable> obj = new HashMap<String, Serializable>();
            Subject subject = (Subject)ctxMgr.get("com.ibm.wsspi.wssecurity.username.initialSenderId");
            if (subject != null) {
                obj.put("com.ibm.ws.wssecurity.initial.sender.subject", subject);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initial Sender is set to context.");
                }
            } else if (obj.get("com.ibm.ws.wssecurity.initial.sender.subject") != null) {
                obj.put("com.ibm.ws.wssecurity.initial.sender.subject", null);
            }
            if ((cert = (X509Certificate)ctxMgr.get("com.ibm.wsspi.wssecurity.username.initialSenderCert")) != null) {
                obj.put("com.ibm.ws.wssecurity.initial.sender.x509certificate", cert);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initial Cert is set to context.");
                }
            } else if (obj.get("com.ibm.ws.wssecurity.initial.sender.x509certificate") != null) {
                obj.put("com.ibm.ws.wssecurity.initial.sender.x509certificate", null);
            }
            if (!obj.isEmpty()) {
                mc.setProperty("com.ibm.ws.wssecurity.initial.sender", obj);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "migrateThreadToContext((MessageContext mc))" + mc.getMessageID());
        }
    }

    public void cleanupContext(MessageContext mc) {
    }
}

