/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.ws.wssecurity.core.WSSComponent;
import com.ibm.ws.wssecurity.core.WSSFactory;
import com.ibm.ws.wssecurity.dsig.SignatureConfirmationGenerator;
import com.ibm.ws.wssecurity.dsig.SignatureConsumer;
import com.ibm.ws.wssecurity.dsig.SignatureGenerator;
import com.ibm.ws.wssecurity.enc.EncryptionConsumer;
import com.ibm.ws.wssecurity.enc.EncryptionGenerator;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoConsumer;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoGenerator;
import com.ibm.ws.wssecurity.time.TimestampConsumer;
import com.ibm.ws.wssecurity.time.TimestampGenerator;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.CommonContentGenerator;
import com.ibm.ws.wssecurity.wssapi.token.impl.CommonTokenGenerator;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSFactorySOAPImpl
extends WSSFactory {
    private static final TraceComponent tc = Tr.register(WSSFactorySOAPImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";

    protected WSSFactorySOAPImpl() {
    }

    @Override
    public WSSComponent createGenerator(Map<Object, Object> type, final Map<Object, Object> properties) throws SoapSecurityException {
        ClassLoader appClassLoader;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createGenerator(Map type, Map properties)");
        }
        Object t = type.get("com.ibm.ws.wssecurity.impl.core.wssfactory.type");
        Object cp = type.get("com.ibm.ws.wssecurity.impl.core.wssfactory.classname");
        ClassLoader classLoader = appClassLoader = type.containsKey("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader") ? (ClassLoader)type.get("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader") : null;
        if (tc.isDebugEnabled()) {
            if (appClassLoader != null) {
                Tr.debug(tc, "type [" + type + "], classname [" + cp + "], classloader [" + appClassLoader.getClass().getName() + "].");
            } else {
                Tr.debug(tc, "type [" + type + "], classname [" + cp + "].");
            }
        }
        WSSComponent component = null;
        if (t == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s01");
        }
        if (t.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.timestamp")) {
            component = new TimestampGenerator();
        } else if (t.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.signature")) {
            component = new SignatureGenerator();
        } else if (t.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.encryption")) {
            component = new EncryptionGenerator();
        } else if (t.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.keyinfo")) {
            component = new KeyInfoGenerator();
        } else if (t.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.keyinfoContent")) {
            component = new CommonContentGenerator();
        } else if (t.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.token")) {
            component = new CommonTokenGenerator();
        } else if (t.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.signatureConfirmation")) {
            component = new SignatureConfirmationGenerator();
        } else if (!t.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.custom")) {
            throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s02", t.toString());
        }
        if (component == null) {
            if (cp == null) {
                throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s03");
            }
            final String classname = cp.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Instantiating the component [" + classname + "]...");
            }
            try {
                component = (WSSComponent)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws SoapSecurityException {
                        WSSComponent c = (WSSComponent)ConfigUtil.instantiate(classname, WSSComponent.class, properties, appClassLoader);
                        return c;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable th = e.getCause();
                if (th instanceof SoapSecurityException) {
                    throw (SoapSecurityException)th;
                }
                throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s04", classname, th);
            }
        } else {
            component.init(properties);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createGenerator(Map type, Map properties) returns " + component);
        }
        return component;
    }

    @Override
    public WSSComponent createConsumer(Map<Object, Object> type, final Map<Object, Object> properties) throws SoapSecurityException {
        ClassLoader appClassLoader;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConsumer(Map type, Map properties)");
        }
        Object t = type.get("com.ibm.ws.wssecurity.impl.core.wssfactory.type");
        Object cp = type.get("com.ibm.ws.wssecurity.impl.core.wssfactory.classname");
        ClassLoader classLoader = appClassLoader = type.containsKey("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader") ? (ClassLoader)type.get("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader") : null;
        if (tc.isDebugEnabled()) {
            if (appClassLoader != null) {
                Tr.debug(tc, "type [" + type + "], classname [" + cp + "], classloader [" + appClassLoader.getClass().getName() + "].");
            } else {
                Tr.debug(tc, "type [" + type + "], classname [" + cp + "].");
            }
        }
        WSSComponent component = null;
        if (t == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s01");
        }
        if (t.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.timestamp")) {
            component = new TimestampConsumer();
        } else if (t.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.encryption")) {
            component = new EncryptionConsumer();
        } else if (t.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.signature")) {
            component = new SignatureConsumer();
        } else if (t.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.keyinfo")) {
            component = new KeyInfoConsumer();
        } else if (!t.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.custom")) {
            throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s02");
        }
        if (component == null) {
            if (cp == null) {
                throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s03");
            }
            final String classname = cp.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Instantiating the component [" + classname + "]...");
            }
            try {
                component = (WSSComponent)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws SoapSecurityException {
                        WSSComponent c = (WSSComponent)ConfigUtil.instantiate(classname, WSSComponent.class, properties, appClassLoader);
                        return c;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable th = e.getCause();
                if (th instanceof SoapSecurityException) {
                    throw (SoapSecurityException)th;
                }
                throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s04", classname, th);
            }
        } else {
            component.init(properties);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConsumer(Map type, Map properties) returns " + component);
        }
        return component;
    }
}

