/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.ws.wssecurity.core.WSSComponent;
import com.ibm.ws.wssecurity.core.WSSFactorySOAPImpl;
import com.ibm.ws.wssecurity.core.WSSFactoryWSSObjectImpl;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WSSFactory {
    public static final String TYPE = "com.ibm.ws.wssecurity.impl.core.wssfactory.type";
    public static final String TIMESTAMP = "com.ibm.ws.wssecurity.impl.core.wssfactory.timestamp";
    public static final String SIGNATURE = "com.ibm.ws.wssecurity.impl.core.wssfactory.signature";
    public static final String ENCRYPTION = "com.ibm.ws.wssecurity.impl.core.wssfactory.encryption";
    public static final String KEYINFO = "com.ibm.ws.wssecurity.impl.core.wssfactory.keyinfo";
    public static final String PLUGGABLE = "com.ibm.ws.wssecurity.impl.core.wssfactory.custom";
    public static final String KEYINFO_CONTENT = "com.ibm.ws.wssecurity.impl.core.wssfactory.keyinfoContent";
    public static final String TOKEN = "com.ibm.ws.wssecurity.impl.core.wssfactory.token";
    public static final String SIGNATURE_CONFIRMATION = "com.ibm.ws.wssecurity.impl.core.wssfactory.signatureConfirmation";
    public static final String CLASSNAME = "com.ibm.ws.wssecurity.impl.core.wssfactory.classname";
    public static final String CLASSLOADER = "com.ibm.ws.wssecurity.impl.core.wssfactory.classloader";
    private static final String TYPE_SOAP = "soap";
    private static final String TYPE_WSSOBJECT = "WSSObject";
    private static final TraceComponent tc = Tr.register(WSSFactory.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static Map<String, WSSFactory> _instances = new Hashtable<String, WSSFactory>();

    public static WSSFactory getInstance(String type) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance(String type[" + type + "])");
        }
        WSSFactory factory = null;
        if (type.equals(TYPE_SOAP)) {
            factory = _instances.get(TYPE_SOAP);
            if (factory == null) {
                factory = new WSSFactorySOAPImpl();
                _instances.put(TYPE_SOAP, factory);
            }
        } else if (type.equals(TYPE_WSSOBJECT)) {
            factory = _instances.get(TYPE_WSSOBJECT);
            if (factory == null) {
                factory = new WSSFactoryWSSObjectImpl();
                _instances.put(TYPE_WSSOBJECT, factory);
            }
        } else {
            throw SoapSecurityException.format("security.wssecurity.WSSFactory.s01", type);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance(String type) returns " + factory);
        }
        return factory;
    }

    public abstract WSSComponent createGenerator(Map<Object, Object> var1, Map<Object, Object> var2) throws SoapSecurityException;

    public abstract WSSComponent createConsumer(Map<Object, Object> var1, Map<Object, Object> var2) throws SoapSecurityException;
}

