/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.ws.wssecurity.handler.token.TokenCacheManagerImpl;
import com.ibm.ws.wssecurity.token.TokenCacheManager;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.Permission;
import java.security.SecurityPermission;

public class TokenCacheManagerFactory {
    private static final TraceComponent tc = Tr.register(TokenCacheManagerFactory.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String clsName = TokenCacheManagerFactory.class.getName();
    private static final String comp = "security.wssecurity";
    private static final Permission INIT_PERMISSION = new SecurityPermission("wssecurity.TokenCacheManagerFactory.init");
    private static final Permission GET_INSTANCE_PERMISSION = new SecurityPermission("wssecurity.TokenCacheManagerFactory.getInstance");
    private static TokenCacheManager _instance;
    private static boolean _initialized;

    private TokenCacheManagerFactory() {
    }

    public static TokenCacheManager getInstance() throws SoapSecurityException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance()");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GET_INSTANCE_PERMISSION);
        }
        TokenCacheManager instance = null;
        if (!_initialized) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: The token manager is not initialized.");
            }
        } else {
            instance = _instance;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance() returns TokenCacheManager[" + instance + "]");
        }
        return instance;
    }

    protected static synchronized void init(boolean useCache, String cacheName, int cacheSize, int cacheTimeout, long cushion) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(boolean useCache[" + useCache + "]," + "String cacheName[" + cacheName + "]," + "int cacheSize[" + cacheSize + "]," + "int cacheTimeout[" + cacheTimeout + "]" + "long cushion[" + cushion + "])");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(INIT_PERMISSION);
        }
        if (!_initialized) {
            _instance = useCache ? new TokenCacheManagerImpl(cacheName, cacheSize, cacheTimeout, cushion) : null;
            _initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(boolean useCache, String cacheName, int cacheSize, int cacheTimeout)");
        }
    }

    public String toString() {
        return clsName;
    }

    static {
        _initialized = false;
    }
}

