/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;

public class SecurityTokenServiceAdmin {
    private static final String CLASS_NAME = SecurityTokenServiceAdmin.class.getName();
    private static final TraceComponent tc = Tr.register(SecurityTokenServiceAdmin.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    SecurityTokenServiceAdmin() {
    }

    public boolean refresh() {
        String method = "refresh";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        boolean success = false;
        STSConfigUtil stsConfigUtil = STSConfigUtil.getSingletonInstance();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Calling STSConfigService.loadSTSConfiguration()");
        }
        try {
            success = stsConfigUtil.loadSTSConfiguration();
        }
        catch (SoapSecurityException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error loading STSConfiguration: " + e.getLocalizedMessage());
            }
            FFDCFilter.processException(e, CLASS_NAME + ".loadSTSConfiguration", "53");
            success = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return success;
    }
}

