/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.ws.wssecurity.handler.token.WSNonceManagerImpl;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.Permission;
import java.security.SecurityPermission;

public class NonceManagerFactory {
    private static final TraceComponent tc = Tr.register(NonceManagerFactory.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = NonceManagerFactory.class.getName();
    private static final Permission INIT_PERMISSION = new SecurityPermission("wssecurity.NonceManagerFactory.init");
    private static final Permission GET_INSTANCE_PERMISSION = new SecurityPermission("wssecurity.NonceManagerFactory.getInstance");
    private static boolean _initialized = false;
    private static boolean _useCache = false;
    private static String _cacheName = null;
    private static int _cacheSize = -1;
    private static int _cacheTimeout = -1;
    private static int _nonceLength = -1;
    private static boolean _cacheDistributed = false;

    private NonceManagerFactory() {
    }

    public static NonceManager getInstance() throws SoapSecurityException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance()");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GET_INSTANCE_PERMISSION);
        }
        if (!_initialized) {
            NonceManagerFactory.init(true, "NonceDistributionCacheMap", 1024, 600, 128, false);
        }
        NonceManager instance = NonceInstance.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance() returns NonceManager[" + instance + "]");
        }
        return instance;
    }

    public static synchronized void init(boolean useCache, String cacheName, int cacheSize, int cacheTimeout, int nonceLength, boolean cacheDistributed) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("init(");
            buf.append("boolean useCache[").append(useCache).append("], ");
            buf.append("String cacheName[").append(cacheName).append("], ");
            buf.append("int cacheSize[").append(cacheSize).append("], ");
            buf.append("int cacheTimeout[").append(cacheTimeout).append("], ");
            buf.append("int nonceLength[").append(nonceLength).append("], ");
            buf.append("boolean cacheDistributed[").append(cacheDistributed).append("])");
            Tr.entry(tc, buf.toString());
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(INIT_PERMISSION);
        }
        _useCache = useCache;
        _cacheName = cacheName;
        _cacheSize = cacheSize;
        _cacheTimeout = cacheTimeout;
        _nonceLength = nonceLength;
        _cacheDistributed = cacheDistributed;
        _initialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(boolean, String, int, int, int, boolean)");
        }
    }

    public String toString() {
        return clsName;
    }

    public static boolean isInitialized() {
        return _initialized;
    }

    private static class NonceInstance {
        private static boolean _instantiated = false;
        private static NonceManager _instance = null;

        private NonceInstance() {
        }

        static synchronized NonceManager getInstance() {
            if (!_instantiated) {
                if (tc.isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer("Initializing the WSNonceManagerImpl instance with ");
                    buf.append("boolean useCache[").append(_useCache).append("], ");
                    buf.append("String cacheName[").append(_cacheName).append("], ");
                    buf.append("int cacheSize[").append(_cacheSize).append("], ");
                    buf.append("int cacheTimeout[").append(_cacheTimeout).append("], ");
                    buf.append("int nonceLength[").append(_nonceLength).append("], ");
                    buf.append("boolean cacheDistributed[").append(_cacheDistributed).append("]");
                    Tr.debug(tc, buf.toString());
                }
                _instance = _useCache ? new WSNonceManagerImpl(_cacheName, _cacheSize, _cacheTimeout, _nonceLength, _cacheDistributed) : null;
                _instantiated = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSNonceManagerImpl instance initialized [" + _instance + "]");
                }
            }
            return _instance;
        }
    }
}

