/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.ws.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.wssecurity.handler.token.WSCertCacheManagerImpl;
import com.ibm.ws.wssecurity.token.CertCacheManager;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.Permission;
import java.security.SecurityPermission;

public class CertManagerFactory {
    private static final TraceComponent tc = Tr.register(CertManagerFactory.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = CertManagerFactory.class.getName();
    private static final Permission INIT_PERMISSION = new SecurityPermission("wssecurity.CertManagerFactory.init");
    private static final Permission GET_INSTANCE_PERMISSION = new SecurityPermission("wssecurity.CertManagerFactory.getInstance");
    private static boolean _initialized = false;
    private static boolean _useCache = false;
    private static String _cacheName = null;
    private static int _cacheSize = -1;
    private static int _cacheTimeout = -1;

    private CertManagerFactory() {
    }

    public static CertCacheManager getInstance() throws SoapSecurityException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance()");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GET_INSTANCE_PERMISSION);
        }
        if (!_initialized) {
            boolean server = WSSecurityPlatformContextFactory.getInstance().isServer();
            if (server) {
                throw SoapSecurityException.format("security.wssecurity.WSEC6840E");
            }
            CertManagerFactory.init(true, "WSSCertCache", 128, 900);
        }
        CertCacheManager instance = CertInstance.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance() returns CertManager[" + instance + "]");
        }
        return instance;
    }

    public static synchronized void init(boolean useCache, String cacheName, int cacheSize, int cacheTimeout) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("init(");
            buf.append("boolean useCache[").append(useCache).append("], ");
            buf.append("String cacheName[").append(cacheName).append("], ");
            buf.append("int cacheSize[").append(cacheSize).append("], ");
            buf.append("int cacheTimeout[").append(cacheTimeout).append("])");
            Tr.entry(tc, buf.toString());
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(INIT_PERMISSION);
        }
        _useCache = useCache;
        _cacheName = cacheName;
        _cacheSize = cacheSize;
        _cacheTimeout = cacheTimeout;
        _initialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(boolean, String, int, int)");
        }
    }

    public String toString() {
        return clsName;
    }

    public static boolean isInitialized() {
        return _initialized;
    }

    private static class CertInstance {
        private static boolean _instantiated = false;
        private static CertCacheManager _instance = null;

        private CertInstance() {
        }

        static synchronized CertCacheManager getInstance() {
            if (!_instantiated) {
                if (tc.isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer("Initializing the WSNonceManagerImpl instance with ");
                    buf.append("boolean useCache[").append(_useCache).append("], ");
                    buf.append("String cacheName[").append(_cacheName).append("], ");
                    buf.append("int cacheSize[").append(_cacheSize).append("], ");
                    buf.append("int cacheTimeout[").append(_cacheTimeout).append("]");
                    Tr.debug(tc, buf.toString());
                }
                _instance = _useCache ? new WSCertCacheManagerImpl(_cacheName, _cacheSize, _cacheTimeout) : null;
                _instantiated = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSCertCacheManagerImpl instance initialized [" + _instance + "]");
                }
            }
            return _instance;
        }
    }
}

