/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.ws.wssecurity.token.CacheableToken;
import com.ibm.ws.wssecurity.token.CacheableTokenCache;
import com.ibm.ws.wssecurity.token.CacheableTokenCacheFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;

public class CacheableTokenMBean {
    private static final TraceComponent tc = Tr.register(CacheableTokenMBean.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public CacheableToken getLocalToken(String identifier) {
        String method = "getLocalToken";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalToken", identifier);
        }
        CacheableToken token = null;
        CacheableTokenCache tokenCache = CacheableTokenCacheFactory.getInstance();
        if (tokenCache != null) {
            token = tokenCache.getLocalToken(identifier);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cache is null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalToken", token);
        }
        return token;
    }

    public CacheableToken removeLocalToken(String identifier) {
        String method = "removeLocalToken";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeLocalToken", identifier);
        }
        CacheableToken token = null;
        CacheableTokenCache tokenCache = CacheableTokenCacheFactory.getInstance();
        if (tokenCache != null) {
            token = tokenCache.removeLocalToken(identifier);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cache is null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeLocalToken", token);
        }
        return token;
    }

    public boolean updateLocalToken(String identifier, CacheableToken token, long cacheTimeout) {
        String method = "updateLocalToken";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateLocalToken", identifier);
        }
        boolean success = false;
        CacheableTokenCache tokenCache = CacheableTokenCacheFactory.getInstance();
        if (tokenCache != null) {
            success = tokenCache.updateLocalToken(identifier, token, cacheTimeout);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cache is null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateLocalToken", success);
        }
        return success;
    }
}

