/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.common;

import com.ibm.ws.wssecurity.core.EngineFactory;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.ConfigValidation;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSAlgorithmFactory
extends AlgorithmFactory {
    private static final TraceComponent tc = Tr.register(WSSAlgorithmFactory.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    protected boolean _fipsMode = false;

    protected WSSAlgorithmFactory(String provider) {
        super(provider);
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000601", "com.ibm.ws.wssecurity.dsig.WSSW3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000613", "com.ibm.ws.wssecurity.dsig.WSSW3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20001011", "com.ibm.ws.wssecurity.dsig.WSSW3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/CR-xml-c14n-20001026", "com.ibm.ws.wssecurity.dsig.WSSW3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "com.ibm.ws.wssecurity.dsig.WSSW3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20001011#WithComments", "com.ibm.ws.wssecurity.dsig.WSSW3CCanonicalizer2WC");
        this.transformTable.put("http://www.w3.org/TR/2000/CR-xml-c14n-20001026#WithComments", "com.ibm.ws.wssecurity.dsig.WSSW3CCanonicalizer2WC");
        this.transformTable.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", "com.ibm.ws.wssecurity.dsig.WSSW3CCanonicalizer2WC");
        this.transformTable.put("http://www.w3.org/2001/10/xml-exc-c14n#", "com.ibm.ws.wssecurity.dsig.WSSExclusiveC11r");
        this.transformTable.put("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", "com.ibm.ws.wssecurity.dsig.WSSExclusiveC11rWC");
        this.transformTable.put("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", "com.ibm.ws.wssecurity.dsig.STRDereferenceTransformer");
        this.transformTable.put("http://www.w3.org/2002/07/decrypt#XML", "com.ibm.ws.wssecurity.dsig.XMLDecryptionTransformer");
        if (ConfigValidation.isFipsEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFipsEnabled() is true");
            }
            this._fipsMode = true;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFipsEnabled() is false");
            }
            this._fipsMode = false;
        }
    }

    public static AlgorithmFactory getInstance() {
        return new WSSAlgorithmFactory(null);
    }

    public EngineFactory addPluggableFactory(String factoryName, Set<String> algorithmURIs, ClassLoader appClassLoader) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addPluggableFactory(String factoryName[" + factoryName + "]," + "Set algorithmURIs[" + algorithmURIs + "]," + "ClassLoader appClassLoader[" + appClassLoader + "])");
        }
        if (ConfigValidation.isFipsEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFipsEnabled() is true; disabling pluggable factory");
            }
            Tr.error(tc, "security.wssecurity.WSEC0146E", factoryName);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addPluggableFactory() returning null");
            }
            return null;
        }
        EngineFactory factory = null;
        if (factoryName != null && factoryName.length() > 0) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Instantiating a new engine factory [" + factoryName + "]...");
                }
                factory = (EngineFactory)ConfigUtil.instantiate(factoryName, EngineFactory.class, appClassLoader);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Succeeded to instantiate a new engine factory [" + factoryName + "].");
                }
            }
            catch (SoapSecurityException e) {
                // empty catch block
            }
            if (factory != null) {
                this.childFactory.add(factory);
                if (algorithmURIs != null) {
                    this.childFactoryURIs.put(factory, algorithmURIs);
                    Iterator<String> i = algorithmURIs.iterator();
                    while (i.hasNext()) {
                        String uri = i.next().toString();
                        if (!this.supportedSignature.contains(uri) && !this.supportedDigest.contains(uri) && !this.supportedDataEncryption.contains(uri) && !this.supportedKeyEncryption.contains(uri)) continue;
                        Tr.debug(tc, "You can't overwrite the default URI supported by WAS: " + uri);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added the engine factory [" + factoryName + "] into the list.");
                    Tr.debug(tc, "A set of the supported algorithms is [" + algorithmURIs + "].");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addPluggableFactory(String factoryName, Set algorithmURIs, ClassLoader appClassLoader)");
        }
        return factory;
    }
}

