/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands.properties;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSConfigGroup;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSProperty;
import java.util.Iterator;
import java.util.List;

public class DeleteSTSProperty
extends AbstractSTSCommand {
    private static TraceComponent tc = Tr.register(DeleteSTSProperty.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public DeleteSTSProperty(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public DeleteSTSProperty(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        String method = "execute";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String propertyName = (String)this.getTargetObject();
        STSConfigGroup configGroup = null;
        try {
            configGroup = this.loadConfig();
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        STSConfigGroup propertiesConfigGroup = DeleteSTSProperty.getConfiguration(configGroup, new String[]{"TrustServiceProperties"});
        List<STSProperty> propertyList = propertiesConfigGroup.getSTSProperty();
        Iterator<STSProperty> iter = propertyList.iterator();
        boolean deleted = false;
        while (iter.hasNext()) {
            STSProperty current = iter.next();
            String currentName = current.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  Found property: " + currentName);
            }
            if (!propertyName.equals(currentName)) continue;
            String currentType = current.getType();
            if (currentType != null && currentType.equals("undeletable")) {
                this.processError(DeleteSTSProperty.instantiateCommandException("wssecurity.admin.sts.CWWSI9090E"));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return;
            }
            iter.remove();
            deleted = true;
            break;
        }
        if (!deleted) {
            this.processError(DeleteSTSProperty.instantiateCommandException("wssecurity.admin.sts.CWWSI9087E"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        try {
            this.updateConfig(configGroup);
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        this.setResult(DeleteSTSProperty.getMessage("wssecurity.admin.sts.CWWSI9075I"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }
}

