/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands.properties;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSConfigGroup;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSProperty;
import java.util.List;

public class AddSTSProperty
extends AbstractSTSCommand {
    private static TraceComponent tc = Tr.register(AddSTSProperty.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public AddSTSProperty(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public AddSTSProperty(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        String method = "execute";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String propertyName = (String)this.getTargetObject();
        String propertyValue = null;
        try {
            propertyValue = (String)this.getParameter("propertyValue");
        }
        catch (InvalidParameterNameException e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        STSConfigGroup configGroup = null;
        try {
            configGroup = this.loadConfig();
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        STSConfigGroup propertiesConfigGroup = AddSTSProperty.getConfiguration(configGroup, new String[]{"TrustServiceProperties"});
        List<STSProperty> propertyList = propertiesConfigGroup.getSTSProperty();
        for (STSProperty current : propertyList) {
            String currentName = current.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  Found property: " + currentName);
            }
            if (!propertyName.equals(currentName)) continue;
            this.processError(AddSTSProperty.instantiateCommandException("wssecurity.admin.sts.CWWSI9088E"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        STSProperty newProperty = new STSProperty();
        newProperty.setName(propertyName);
        newProperty.setValue(propertyValue);
        propertyList.add(newProperty);
        try {
            this.updateConfig(configGroup);
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        this.setResult(AddSTSProperty.getMessage("wssecurity.admin.sts.CWWSI9075I"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }
}

