/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.admin.sts.commands.Constants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Configuration;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Extension;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Property;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.STSExtensionMap;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class UpdateSTSTokenTypeConfiguration
extends AbstractSTSCommand {
    private static final String[] PARAMETERS = new String[]{"lifetimeMinutes", "distributedCache", "tokenCacheFactory", "postdatable", "renewableAfterExpiration", "renewalWindowMinutes"};
    private static final TraceComponent tc = Tr.register(UpdateSTSTokenTypeConfiguration.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String CLASS_NAME = UpdateSTSTokenTypeConfiguration.class.getName();

    public UpdateSTSTokenTypeConfiguration(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public UpdateSTSTokenTypeConfiguration(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        String method = CLASS_NAME + ".execute()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String localName = (String)this.getTargetObject();
        String uri = null;
        STSExtensionMap extensionMap = null;
        try {
            uri = (String)this.getParameter("URI");
            extensionMap = this.loadPlugins();
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        List<Extension> extensionList = extensionMap.getExtension();
        Iterator<Extension> extensionIter = extensionList.iterator();
        Extension extension = null;
        while (extensionIter.hasNext()) {
            Extension currentExtension = extensionIter.next();
            if (localName.equals(currentExtension.getLocalName())) {
                extension = currentExtension;
                continue;
            }
            if (uri == null || !uri.equals(currentExtension.getURI())) continue;
            this.processError(UpdateSTSTokenTypeConfiguration.instantiateCommandException("wssecurity.admin.sts.CWWSI9043W"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (extension == null) {
            this.processError(UpdateSTSTokenTypeConfiguration.instantiateCommandException("wssecurity.admin.sts.CWWSI9044W"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        String handlerFactory = null;
        try {
            handlerFactory = (String)this.getParameter("HandlerFactory");
        }
        catch (InvalidParameterNameException e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (uri != null) {
            extension.setURI(uri);
        }
        if (handlerFactory != null) {
            extension.setHandlerFactory(handlerFactory);
        }
        Properties customProperties = null;
        try {
            customProperties = (Properties)this.getParameter("customProperties");
        }
        catch (InvalidParameterNameException e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (customProperties == null) {
            customProperties = new Properties();
        }
        Enumeration<Object> customPropertyNames = customProperties.keys();
        while (customPropertyNames.hasMoreElements()) {
            String propertyName = (String)customPropertyNames.nextElement();
            if (!this.isDefaultProperty(propertyName)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "customProperties parameter cannot include a default property name.");
            }
            this.processError(UpdateSTSTokenTypeConfiguration.instantiateCommandException("wssecurity.admin.sts.CWWSI9074W"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        boolean isDistCacheUsed = false;
        boolean isDistCache = false;
        for (String paramName : PARAMETERS) {
            try {
                Object paramValue = this.getParameter(paramName);
                if (paramValue == null) continue;
                if (paramName.equals("lifetimeMinutes") && Integer.parseInt(paramValue.toString()) < Constants.MIN_VALUE_PROPERTY_LIFETIME_MINUTES) {
                    this.processError(UpdateSTSTokenTypeConfiguration.instantiateCommandException("wssecurity.admin.sts.CWWSI9086E", new String[]{"lifetimeMinutes", Constants.MIN_VALUE_PROPERTY_LIFETIME_MINUTES.toString()}));
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, method);
                    }
                    return;
                }
                if (paramName.equals("renewalWindowMinutes") && Integer.parseInt(paramValue.toString()) < Constants.MIN_VALUE_PROPERTY_RENEWAL_WINDOW_MINUTES) {
                    this.processError(UpdateSTSTokenTypeConfiguration.instantiateCommandException("wssecurity.admin.sts.CWWSI9086E", new String[]{"renewalWindowMinutes", Constants.MIN_VALUE_PROPERTY_RENEWAL_WINDOW_MINUTES.toString()}));
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, method);
                    }
                    return;
                }
                if (paramName.equals("distributedCache") || paramName.equals("tokenCacheFactory")) {
                    String warning = UpdateSTSTokenTypeConfiguration.getMessage("wssecurity.admin.sts.CWWSI9092W", new String[]{paramName});
                    Tr.warning(tc, warning);
                    this.addWarning(warning);
                    if (paramName.equals("distributedCache")) {
                        isDistCacheUsed = true;
                        if ("true".equalsIgnoreCase(paramValue.toString())) {
                            isDistCache = true;
                        }
                    }
                }
                customProperties.setProperty(paramName, paramValue.toString());
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
        }
        Configuration config2 = extension.getConfiguration();
        List<Property> properties = config2.getProperty();
        for (Property currentProperty : properties) {
            String propName = currentProperty.getName();
            String newPropValue = (String)customProperties.remove(propName);
            if (newPropValue == null) continue;
            currentProperty.setValue(newPropValue);
        }
        Enumeration<Object> newProperties = customProperties.keys();
        while (newProperties.hasMoreElements()) {
            Property newProperty = new Property();
            String newPropName = (String)newProperties.nextElement();
            newProperty.setName(newPropName);
            newProperty.setValue(customProperties.getProperty(newPropName));
            properties.add(newProperty);
        }
        if (isDistCache) {
            try {
                String cmdName = "updateDistributedCacheProperty";
                CommandMetadata cmd1 = CommandMgr.getCommandMgr().getCommandMetadata(cmdName);
                AdminCommand cmd = CommandMgr.getCommandMgr().createCommand(cmdName);
                cmd.setParameter("notUpdate", "stsplugins.xml");
                cmd.setParameter("distributedCache", isDistCache);
                cmd.setConfigSession(this.getConfigSession());
                cmd.execute();
                CommandResult createCommandResult = cmd.getCommandResult();
                if (!createCommandResult.isSuccessful()) {
                    Tr.warning(tc, "Fail to run updateDistributedCacheProperty command. All the necessary configurations might not have been updated successfully!!");
                }
            }
            catch (Exception e) {
                Tr.warning(tc, "Fail to run updateDistributedCacheProperty command. All the necessary configurations might not have been updated successfully!!" + e);
            }
        }
        try {
            this.udpatePlugins(extensionMap);
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        this.setResult(UpdateSTSTokenTypeConfiguration.getMessage("wssecurity.admin.sts.CWWSI9075I"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }
}

