/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Extension;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.STSExtensionMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.AssignedTokenType;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Target;
import java.util.Iterator;
import java.util.List;

public class UpdateSTSEndpointTokenType
extends AbstractSTSCommand {
    private static TraceComponent tc = Tr.register(UpdateSTSEndpointTokenType.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public UpdateSTSEndpointTokenType(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public UpdateSTSEndpointTokenType(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        String method = "execute";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String endpointURI = (String)this.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command target (endpointURI) - " + endpointURI);
        }
        String localName = null;
        String newLocalName = null;
        boolean defaultLocalName = false;
        String issuerURI = null;
        String newIssuer = null;
        boolean nullIssuer = false;
        try {
            localName = (String)this.getParameter("LocalName");
            newLocalName = (String)this.getParameter("newLocalName");
            defaultLocalName = (Boolean)this.getParameter("defaultLocalName");
            issuerURI = (String)this.getParameter("issuer");
            newIssuer = (String)this.getParameter("newIssuer");
            nullIssuer = (Boolean)this.getParameter("nullIssuer");
        }
        catch (InvalidParameterNameException e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command arg (localName) - " + localName);
            Tr.debug(tc, "Command arg (newLocalName) - " + newLocalName);
            Tr.debug(tc, "Command arg (defaultLocalName) - " + defaultLocalName);
            Tr.debug(tc, "Command arg (issuerURI) - " + issuerURI);
            Tr.debug(tc, "Command arg (newIssuer) - " + newIssuer);
            Tr.debug(tc, "Command arg (nullIssuer) - " + nullIssuer);
        }
        if (newLocalName == null && newIssuer == null && !nullIssuer && !defaultLocalName) {
            this.processError(UpdateSTSEndpointTokenType.instantiateCommandException("wssecurity.admin.sts.CWWSI9069W"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        STSTargetMap targetMap = null;
        try {
            targetMap = this.loadTargets();
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        String tokenTypeURI = null;
        String newTokenTypeURI = null;
        boolean defaulted = false;
        if (defaultLocalName) {
            newTokenTypeURI = targetMap.getDefaultTokenTypeURI();
            if (newTokenTypeURI == null) {
                this.processError(UpdateSTSEndpointTokenType.instantiateCommandException("wssecurity.admin.sts.CWWSI9047W"));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return;
            }
            defaulted = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using default token type.");
            }
        }
        STSExtensionMap extensionMap = null;
        try {
            extensionMap = this.loadPlugins();
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Searching through extensions for local names.");
        }
        List<Extension> extensionList = extensionMap.getExtension();
        for (Extension currentExtension : extensionList) {
            String currentLocalName = currentExtension.getLocalName();
            String currentTokenTypeURI = currentExtension.getURI();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found extension:");
                Tr.debug(tc, "  LocalName: " + currentLocalName);
                Tr.debug(tc, "  TokenTypeURI: " + currentTokenTypeURI);
            }
            if (currentLocalName == null || currentTokenTypeURI == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "An Extension element in the configuration contains a null LocalName or null URI attribute, both of which are required. Skipping this entry.");
                continue;
            }
            if (currentLocalName.equals(localName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Match found for localName.");
                }
                tokenTypeURI = currentTokenTypeURI;
            }
            if (defaulted || newLocalName == null || !currentLocalName.equals(newLocalName)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Match found for newLocalName.");
            }
            newTokenTypeURI = currentTokenTypeURI;
        }
        if (tokenTypeURI == null || !defaulted && newLocalName != null && newTokenTypeURI == null) {
            this.processError(UpdateSTSEndpointTokenType.instantiateCommandException("wssecurity.admin.sts.CWWSI9044W"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Searching through configuration for specified target.");
        }
        List<Target> targetList = targetMap.getTarget();
        Iterator<Target> targetIter = targetList.iterator();
        Target target = null;
        while (targetIter.hasNext()) {
            Target currentTarget = targetIter.next();
            if (!endpointURI.equals(currentTarget.getAppliesTo())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Target found.");
            }
            target = currentTarget;
            break;
        }
        if (target == null) {
            this.processError(UpdateSTSEndpointTokenType.instantiateCommandException("wssecurity.admin.sts.CWWSI9045W"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Searching assigned token types for specified assignment.");
        }
        boolean updated = false;
        List<AssignedTokenType> assignedTokenTypes = target.getAssignedTokenType();
        for (AssignedTokenType currentTT : assignedTokenTypes) {
            String currentTTURI = currentTT.getTokenTypeURI();
            String currentIssuerURI = currentTT.getIssuerURI();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found assigned token type:");
                Tr.debug(tc, "  TokenTypeURI: " + currentTTURI);
                Tr.debug(tc, "  IssuerURI: " + currentIssuerURI);
            }
            if (currentTTURI == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "An AssignedTokenType element in the configuration contains a null TokenTypeURI, which is required. Skipping this entry.");
                continue;
            }
            if (currentTTURI.equals(newTokenTypeURI) && (newIssuer == null ? currentIssuerURI == null : newIssuer.equals(currentIssuerURI))) {
                this.processError(UpdateSTSEndpointTokenType.instantiateCommandException("wssecurity.admin.sts.CWWSI9048W"));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return;
            }
            if (!currentTTURI.equals(tokenTypeURI) || !(issuerURI == null ? currentIssuerURI == null : issuerURI.equals(currentIssuerURI))) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Match found.");
            }
            if (newTokenTypeURI != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting new TokenTypeURI: " + newTokenTypeURI);
                }
                currentTT.setTokenTypeURI(newTokenTypeURI);
            }
            if (nullIssuer) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting new IssuerURI: null");
                }
                currentTT.setIssuerURI(null);
            } else if (newIssuer != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting new IssuerURI: " + newIssuer);
                }
                currentTT.setIssuerURI(newIssuer);
            }
            updated = true;
        }
        if (!updated) {
            this.processError(UpdateSTSEndpointTokenType.instantiateCommandException("wssecurity.admin.sts.CWWSI9072W", new String[]{endpointURI}));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        String result = UpdateSTSEndpointTokenType.getMessage(defaulted ? "wssecurity.admin.sts.CWWSI9078I" : "wssecurity.admin.sts.CWWSI9075I");
        try {
            this.updateTargets(targetMap);
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        this.setResult(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }
}

