/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Extension;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.STSExtensionMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.AssignedTokenType;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Target;
import java.util.Iterator;
import java.util.List;

public class UnassignSTSEndpointTokenType
extends AbstractSTSCommand {
    private static TraceComponent tc = Tr.register(UnassignSTSEndpointTokenType.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public UnassignSTSEndpointTokenType(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public UnassignSTSEndpointTokenType(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        String method = "execute";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String endpointURI = (String)this.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command target (endpointURI) - " + endpointURI);
        }
        String localName = null;
        String issuerURI = null;
        try {
            localName = (String)this.getParameter("LocalName");
            issuerURI = (String)this.getParameter("issuer");
        }
        catch (InvalidParameterNameException e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command arg (localName) - " + localName);
            Tr.debug(tc, "Command arg (issuerURI) - " + issuerURI);
        }
        STSTargetMap targetMap = null;
        STSExtensionMap extensionMap = null;
        try {
            targetMap = this.loadTargets();
            extensionMap = this.loadPlugins();
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Searching through configuration for specified target.");
        }
        List<Target> targetList = targetMap.getTarget();
        Iterator<Target> targetIter = targetList.iterator();
        Target target = null;
        while (targetIter.hasNext()) {
            Target currentTarget = targetIter.next();
            if (!endpointURI.equals(currentTarget.getAppliesTo())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found target.");
            }
            target = currentTarget;
            break;
        }
        if (target == null) {
            this.processError(UnassignSTSEndpointTokenType.instantiateCommandException("wssecurity.admin.sts.CWWSI9045W"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Searching through extensions for local name: " + localName);
        }
        String tokenTypeURI = null;
        List<Extension> extensions = extensionMap.getExtension();
        for (Extension currentExtension : extensions) {
            String currentLocalName = currentExtension.getLocalName();
            String currentTokenTypeURI = currentExtension.getURI();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found extension:");
                Tr.debug(tc, "  LocalName: " + currentLocalName);
                Tr.debug(tc, "  TokenTypeURI: " + currentTokenTypeURI);
            }
            if (currentLocalName == null || currentTokenTypeURI == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "An Extension element in the configuration contains a null LocalName or null TokenTypeURI, both of which are required. Skipping this entry.");
                continue;
            }
            if (!currentLocalName.equals(localName)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Match found.");
            }
            tokenTypeURI = currentTokenTypeURI;
            break;
        }
        if (tokenTypeURI == null) {
            this.processError(UnassignSTSEndpointTokenType.instantiateCommandException("wssecurity.admin.sts.CWWSI9044W"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Searching assigned token types for specified assignment.");
        }
        boolean removed = false;
        List<AssignedTokenType> assignedTokenTypes = target.getAssignedTokenType();
        Iterator<AssignedTokenType> assignedTTsIter = assignedTokenTypes.iterator();
        while (assignedTTsIter.hasNext()) {
            AssignedTokenType currentTT = assignedTTsIter.next();
            String currentTTURI = currentTT.getTokenTypeURI();
            String currentIssuerURI = currentTT.getIssuerURI();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found assigned token type:");
                Tr.debug(tc, "  TokenTypeURI: " + currentTTURI);
                Tr.debug(tc, "  IssuerURI: " + currentIssuerURI);
            }
            if (currentTTURI == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "An AssignedTokenType element in the configuration contains a null TokenTypeURI, which is required. Skipping this entry.");
                continue;
            }
            if (!currentTTURI.equals(tokenTypeURI) || !(issuerURI == null ? currentIssuerURI == null : issuerURI.equals(currentIssuerURI))) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Match found. Removing entry.");
            }
            assignedTTsIter.remove();
            removed = true;
        }
        if (!removed) {
            this.processError(UnassignSTSEndpointTokenType.instantiateCommandException("wssecurity.admin.sts.CWWSI9072W", new String[]{endpointURI}));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        try {
            this.updateTargets(targetMap);
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        this.setResult(UnassignSTSEndpointTokenType.getMessage("wssecurity.admin.sts.CWWSI9075I"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }
}

