/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProvider;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.admin.sts.commands.Constants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STSCommandProvider
extends CommandProvider {
    public static final String FFDC_ID_1 = "FFDC-1";
    public static final String FFDC_ID_2 = "FFDC-2";
    public static final String FFDC_ID_3 = "FFDC-3";
    public static final String FFDC_ID_4 = "FFDC-4";
    public static final String FFDC_ID_5 = "FFDC-5";
    public static final String FFDC_ID_6 = "FFDC-6";
    public static final String FFDC_ID_7 = "FFDC-7";
    private static HashMap<String, Class> classMap;
    private static HashMap<String, Constructor> creationMap;
    private static HashMap<String, Constructor> loadMap;
    private static TraceComponent tc;
    private static String className;

    @Override
    public AbstractAdminCommand createCommand(CommandMetadata metadata) throws CommandNotFoundException {
        Constructor constructor;
        String cmdName = metadata.getName();
        String method = className + ".createCommand(commandName=" + cmdName + ")";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        if ((constructor = creationMap.get(cmdName)) == null) {
            CommandException t;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            if ((t = new CommandException(AbstractSTSCommand.getMessage("wssecurity.admin.sts.CWWSI9053W"))) != null) {
                Tr.processException(t, className, FFDC_ID_1);
            }
            Tr.error(tc, "WSEC0002E", new String[]{cmdName});
            throw new CommandNotFoundException(cmdName);
        }
        AbstractAdminCommand command = null;
        try {
            command = (AbstractAdminCommand)constructor.newInstance(metadata);
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            if (e != null) {
                Tr.processException(e, className, FFDC_ID_2);
            }
            Tr.error(tc, "WSEC0002E", new String[]{cmdName});
            throw new CommandNotFoundException(cmdName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return command;
    }

    @Override
    public AbstractAdminCommand loadCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        Constructor constructor;
        String cmdName = cmdData.getName();
        String method = className + ".loadCommand(commandName=" + cmdName + ")";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        if ((constructor = loadMap.get(cmdName)) == null) {
            CommandException t;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            if ((t = new CommandException(AbstractSTSCommand.getMessage("wssecurity.admin.sts.CWWSI9053W"))) != null) {
                Tr.processException(t, className, FFDC_ID_3);
            }
            Tr.error(tc, "WSEC0002E", new String[]{cmdName});
            throw new CommandNotFoundException(cmdName);
        }
        AbstractAdminCommand command = null;
        try {
            command = (AbstractAdminCommand)constructor.newInstance(cmdData);
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            if (e != null) {
                Tr.processException(e, className, FFDC_ID_4);
            }
            Tr.error(tc, "WSEC0002E", new String[]{cmdName});
            throw new CommandNotFoundException(cmdName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return command;
    }

    private static void initialize() {
        className = STSCommandProvider.class.getName();
        tc = Tr.register(STSCommandProvider.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
        String method = className + ".initialize()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        classMap = STSCommandProvider.initializeClassMap();
        creationMap = new HashMap();
        loadMap = new HashMap();
        Set<Map.Entry<String, Class>> entries = classMap.entrySet();
        for (Map.Entry<String, Class> current : entries) {
            Constructor constructor;
            String commandName = current.getKey();
            Class commandClass = current.getValue();
            try {
                constructor = commandClass.getConstructor(CommandMetadata.class);
                creationMap.put(commandName, constructor);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to access constructor(CommandMetadata) for " + commandName);
                }
                FFDCFilter.processException((Throwable)e, className, "WSEC0002E", FFDC_ID_5);
            }
            try {
                constructor = commandClass.getConstructor(CommandData.class);
                loadMap.put(commandName, constructor);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to access constructor(CommandData) for " + commandName);
                }
                FFDCFilter.processException((Throwable)e, className, "WSEC0002E", FFDC_ID_6);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }

    private static HashMap<String, Class> initializeClassMap() {
        String method = "initializeClassMap";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        HashMap<String, Class> map = new HashMap<String, Class>();
        Field[] fields = Constants.class.getFields();
        HashMap<String, Field> fieldSuffixToCommandNameField = new HashMap<String, Field>();
        HashMap<String, Field> fieldSuffixToCommandClassField = new HashMap<String, Field>();
        for (Field field : fields) {
            String fieldName = field.getName();
            if (fieldName.startsWith("COMMAND_")) {
                fieldSuffixToCommandNameField.put(fieldName.substring("COMMAND_".length()), field);
                continue;
            }
            if (!fieldName.startsWith("CLASS_")) continue;
            fieldSuffixToCommandClassField.put(fieldName.substring("CLASS_".length()), field);
        }
        Set fieldSuffixes = fieldSuffixToCommandNameField.keySet();
        for (String fieldSuffix : fieldSuffixes) {
            Field classField = (Field)fieldSuffixToCommandClassField.get(fieldSuffix);
            if (classField == null) continue;
            Field nameField = (Field)fieldSuffixToCommandNameField.get(fieldSuffix);
            try {
                map.put((String)nameField.get(null), (Class)classField.get(null));
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not retrieve fields for command class: " + classField.getName());
                }
                FFDCFilter.processException((Throwable)e, className, "WSEC0002E", FFDC_ID_7);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return map;
    }

    static {
        STSCommandProvider.initialize();
    }
}

