/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Extension;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.STSExtensionMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.AssignedTokenType;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Target;
import java.util.Iterator;
import java.util.List;

public class RemoveSTSTokenTypeConfiguration
extends AbstractSTSCommand {
    private static TraceComponent tc = Tr.register(RemoveSTSTokenTypeConfiguration.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public RemoveSTSTokenTypeConfiguration(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public RemoveSTSTokenTypeConfiguration(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        String method = "execute";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String localName = (String)this.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command target (localName) - " + localName);
        }
        if (localName.equals("Security Context Token")) {
            this.processError(RemoveSTSTokenTypeConfiguration.instantiateCommandException("wssecurity.admin.sts.CWWSI9091E"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        STSExtensionMap extensionMap = null;
        try {
            extensionMap = this.loadPlugins();
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Searching through extensions configuration for local name: " + localName);
        }
        List<Extension> extensionList = extensionMap.getExtension();
        Iterator<Extension> extensionIter = extensionList.iterator();
        Extension extension = null;
        String tokenTypeURI = null;
        while (extensionIter.hasNext()) {
            Extension currentExtension = extensionIter.next();
            String currentLocalName = currentExtension.getLocalName();
            String currentTTURI = currentExtension.getURI();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found extensions:");
                Tr.debug(tc, "  LocalName: " + currentLocalName);
                Tr.debug(tc, "  URI: " + currentTTURI);
            }
            if (currentLocalName == null || currentTTURI == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "An Extension element in the configuration contains a null LocalName or a null URI, both of which are required. Skipping this entry.");
                continue;
            }
            if (!localName.equals(currentLocalName)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Match found.");
            }
            extension = currentExtension;
            tokenTypeURI = currentTTURI;
            break;
        }
        if (extension == null) {
            this.processError(RemoveSTSTokenTypeConfiguration.instantiateCommandException("wssecurity.admin.sts.CWWSI9044W"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        STSTargetMap targetMap = null;
        try {
            targetMap = this.loadTargets();
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        String defaultTokenTypeURI = targetMap.getDefaultTokenTypeURI();
        if (defaultTokenTypeURI == null) {
            this.processError(RemoveSTSTokenTypeConfiguration.instantiateCommandException("wssecurity.admin.sts.CWWSI9047W"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (defaultTokenTypeURI.equals(tokenTypeURI)) {
            this.processError(RemoveSTSTokenTypeConfiguration.instantiateCommandException("wssecurity.admin.sts.CWWSI9050W"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Searching through targets to make sure none are assigned to this token type.");
        }
        List<Target> targets = targetMap.getTarget();
        for (Target currentTarget : targets) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Searching assigned token types under target: " + currentTarget.getAppliesTo());
            }
            List<AssignedTokenType> assignedTokenTypes = currentTarget.getAssignedTokenType();
            for (AssignedTokenType currentAssignedTT : assignedTokenTypes) {
                String currentTTURI = currentAssignedTT.getTokenTypeURI();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found AssignedTokenType:");
                    Tr.debug(tc, "  TokenTypeURI: " + currentTTURI);
                }
                if (currentTTURI == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "An AssignedTokenType element in the configuration contains a null TokenTypeURI, which is a required element. Skipping this entry.");
                    continue;
                }
                if (!currentTTURI.equals(tokenTypeURI)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token type in use!");
                }
                this.processError(RemoveSTSTokenTypeConfiguration.instantiateCommandException("wssecurity.admin.sts.CWWSI9062W"));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Token type is not in use. Removing token type.");
        }
        extensionList.remove(extension);
        try {
            this.udpatePlugins(extensionMap);
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        this.setResult(RemoveSTSTokenTypeConfiguration.getMessage("wssecurity.admin.sts.CWWSI9075I"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }
}

