/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSTrustAuthenticationCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.DefaultIssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Identity;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IdentityList;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Target;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.TokenTypeRule;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;

public class RemoveSTSEndpointTrustAuthenticationRule
extends AbstractSTSTrustAuthenticationCommand {
    private static final TraceComponent tc = Tr.register(RemoveSTSEndpointTrustAuthenticationRule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public RemoveSTSEndpointTrustAuthenticationRule(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public RemoveSTSEndpointTrustAuthenticationRule(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        boolean nullIdentity;
        String method = "execute";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String endpointURI = (String)this.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command target (endpointURI) - " + endpointURI);
        }
        String issuerURI = null;
        String tokenTypeURI = null;
        Properties identity = null;
        boolean defaultIssuer = false;
        try {
            issuerURI = (String)this.getParameter("issuer");
            tokenTypeURI = (String)this.getParameter("tokenTypeURI");
            identity = (Properties)this.getParameter("identity");
            defaultIssuer = (Boolean)this.getParameter("nullIssuer");
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command arg (issuerURI) - " + issuerURI);
            Tr.debug(tc, "Command arg (tokenTypeURI) - " + tokenTypeURI);
            Tr.debug(tc, "Command arg (identity) - " + identity);
            Tr.debug(tc, "Command arg (nullIssuer) - " + defaultIssuer);
        }
        boolean nullIssuer = issuerURI == null;
        boolean nullTokenType = tokenTypeURI == null;
        boolean bl = nullIdentity = identity == null;
        if (!defaultIssuer && nullIssuer) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Either nullIssuer must be true or issuerURI must be specified.");
            }
            this.processError(RemoveSTSEndpointTrustAuthenticationRule.instantiateCommandException("wssecurity.admin.sts.CWWSI9066W"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (nullTokenType && !nullIdentity) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tokenTypeURI must be specified if identity is specified.");
            }
            this.processError(RemoveSTSEndpointTrustAuthenticationRule.instantiateCommandException("wssecurity.admin.sts.CWWSI9064W"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        STSTargetMap targetMap = null;
        try {
            targetMap = this.loadTargets();
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        Target target = null;
        try {
            target = this.findTarget(targetMap, endpointURI);
        }
        catch (NoSuchElementException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Specified endpoint not found: " + e.getLocalizedMessage());
            }
            this.processError(RemoveSTSEndpointTrustAuthenticationRule.instantiateCommandException(e.getMessage()));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        Identity id = null;
        List<Identity> identityList = null;
        TokenTypeRule ttRule = null;
        List<TokenTypeRule> ttRules = null;
        IssuerRule iRule = null;
        if (!defaultIssuer) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Searching for IssuerRule: " + issuerURI);
            }
            try {
                iRule = this.findIssuerRule(targetMap, target, null, issuerURI);
            }
            catch (NoSuchElementException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not find IssuerRule with issuerURI: " + issuerURI);
                }
                this.processError(RemoveSTSEndpointTrustAuthenticationRule.instantiateCommandException(e.getMessage()));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return;
            }
            ttRules = iRule.getTokenTypeRule();
        } else {
            DefaultIssuerRule diRule;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "issuerURI not specified. Using DefaultIssuerRule.");
            }
            if ((diRule = target.getDefaultIssuerRule()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not find DefaultIssuerRule under target: " + endpointURI);
                }
                this.processError(RemoveSTSEndpointTrustAuthenticationRule.instantiateCommandException("wssecurity.admin.sts.CWWSI9071W"));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return;
            }
            ttRules = diRule.getTokenTypeRule();
        }
        if (!nullTokenType) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Searching for TokenTypeRule: " + tokenTypeURI);
            }
            try {
                ttRule = this.findRule(targetMap, ttRules, null, null, tokenTypeURI);
            }
            catch (NoSuchElementException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not find TokenTypeRule with tokenTypeURI: " + tokenTypeURI);
                }
                this.processError(RemoveSTSEndpointTrustAuthenticationRule.instantiateCommandException(e.getMessage()));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return;
            }
            IdentityList idList = ttRule.getIdentityList();
            if (idList == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "IdentityList not found for TokenTypeRule: " + tokenTypeURI);
                }
                this.processError(RemoveSTSEndpointTrustAuthenticationRule.instantiateCommandException("wssecurity.admin.sts.CWWSI9071W"));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return;
            }
            identityList = idList.getIdentity();
        }
        if (!nullIdentity) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Searching for Identity: " + identity);
            }
            try {
                id = this.findIdentity(targetMap, ttRule, null, null, null, identity);
            }
            catch (NoSuchElementException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not find Identity: " + identity);
                }
                this.processError(RemoveSTSEndpointTrustAuthenticationRule.instantiateCommandException(e.getMessage()));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return;
            }
        }
        int whichPossibility = (nullIdentity ? 0 : 1) + (nullTokenType ? 0 : 1);
        switch (whichPossibility) {
            case 2: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removing specified Identity.");
                }
                identityList.remove(id);
                if (!identityList.isEmpty()) break;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "IdentityList is empty. Remove containing TokenTypeRule.");
                }
            }
            case 1: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removing specified TokenTypeRule.");
                }
                ttRules.remove(ttRule);
                if (!ttRules.isEmpty()) break;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TokenTypeRule list is empty. Remove containing (Default)IssuerRule.");
                }
            }
            case 0: {
                if (iRule == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Removing DefaultIssuerRule.");
                    }
                    target.setDefaultIssuerRule(null);
                    break;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removing specified IssuerRule.");
                }
                List<IssuerRule> iRulesList = target.getIssuerRule();
                iRulesList.remove(iRule);
                break;
            }
            default: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Control flow should not have reached here.");
                }
                this.processError(new Exception());
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return;
            }
        }
        try {
            this.updateTargets(targetMap);
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        this.setResult(RemoveSTSEndpointTrustAuthenticationRule.getMessage("wssecurity.admin.sts.CWWSI9075I"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }
}

