/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSConfigGroup;
import java.util.Iterator;
import java.util.List;

public class RemoveSTSConfigurationGroup
extends AbstractSTSCommand {
    private static TraceComponent tc = Tr.register(RemoveSTSConfigurationGroup.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public RemoveSTSConfigurationGroup(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public RemoveSTSConfigurationGroup(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        String method = "execute";
        RemoveSTSConfigurationGroup.trEntry(method);
        String[] groupPathParam = (String[])this.getTargetObject();
        if (groupPathParam.length < 1) {
            this.processError(RemoveSTSConfigurationGroup.instantiateCommandException("wssecurity.admin.sts.CWWSI9057W"));
            RemoveSTSConfigurationGroup.trExit(method);
            return;
        }
        String groupName = groupPathParam[groupPathParam.length - 1];
        STSConfigGroup configGroup = null;
        try {
            configGroup = this.loadConfig();
        }
        catch (Exception e) {
            this.processError(e);
            RemoveSTSConfigurationGroup.trExit(method);
            return;
        }
        STSConfigGroup subRoot = configGroup;
        if (groupPathParam.length > 1) {
            String[] groupPath = new String[groupPathParam.length - 1];
            System.arraycopy(groupPathParam, 0, groupPath, 0, groupPath.length);
            subRoot = RemoveSTSConfigurationGroup.getConfiguration(configGroup, groupPath);
            if (subRoot == null) {
                this.processError(RemoveSTSConfigurationGroup.instantiateCommandException("wssecurity.admin.sts.CWWSI9055W"));
                RemoveSTSConfigurationGroup.trExit(method);
                return;
            }
        }
        List<STSConfigGroup> childrenGroups = subRoot.getSTSConfigGroup();
        Iterator<STSConfigGroup> iter = childrenGroups.iterator();
        boolean removed = false;
        while (iter.hasNext()) {
            if (!groupName.equals(iter.next().getName())) continue;
            iter.remove();
            removed = true;
            break;
        }
        if (!removed) {
            this.processError(RemoveSTSConfigurationGroup.instantiateCommandException("wssecurity.admin.sts.CWWSI9054W"));
            RemoveSTSConfigurationGroup.trExit(method);
            return;
        }
        try {
            this.updateConfig(configGroup);
        }
        catch (Exception e) {
            this.processError(e);
            RemoveSTSConfigurationGroup.trExit(method);
            return;
        }
        this.setResult(RemoveSTSConfigurationGroup.getMessage("wssecurity.admin.sts.CWWSI9075I"));
        RemoveSTSConfigurationGroup.trExit(method);
    }

    private static void trEntry(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, msg);
        }
    }

    private static void trExit(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, msg);
        }
    }
}

