/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSTrustAuthenticationCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.DefaultIssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Target;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.TokenTypeRule;
import java.util.ArrayList;
import java.util.List;

public class ListSTSTrustAuthenticationConfiguredEndpoints
extends AbstractSTSTrustAuthenticationCommand {
    private static final TraceComponent tc = Tr.register(ListSTSTrustAuthenticationConfiguredEndpoints.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public ListSTSTrustAuthenticationConfiguredEndpoints(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public ListSTSTrustAuthenticationConfiguredEndpoints(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        String method = "execute";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        STSTargetMap targetMap = null;
        try {
            targetMap = this.loadTargets();
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Searching through configuration for targets configured with trust authentication rules.");
        }
        ArrayList<String> endpointList = new ArrayList<String>();
        List<Target> targets = targetMap.getTarget();
        block2: for (Target currentTarget : targets) {
            String currentEndpoint = currentTarget.getAppliesTo();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found target with endpointURI: " + currentEndpoint);
            }
            if (currentEndpoint == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Found target with null appliesTo attribute, which is required. Skipping entry.");
                continue;
            }
            List<IssuerRule> iRules = currentTarget.getIssuerRule();
            DefaultIssuerRule defaultRule = currentTarget.getDefaultIssuerRule();
            if (defaultRule != null) {
                List<TokenTypeRule> ttRules;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found DefaultIssuerRule.");
                }
                if ((ttRules = defaultRule.getTokenTypeRule()) == null || ttRules.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No TokenTypeRule elements found.");
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found trust authentication configured endpoint: " + currentEndpoint);
                    }
                    endpointList.add(currentEndpoint);
                    continue;
                }
            }
            if (iRules == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Iterating over issuer rules.");
            }
            for (IssuerRule currentIRule : iRules) {
                String currentIssuer = currentIRule.getIssuerURI();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found IssuerRule with issuerURI: " + currentIssuer);
                }
                if (currentIssuer == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Found IssuerRule with null IssuerURI, which is required. Skipping entry.");
                    continue;
                }
                List<TokenTypeRule> ttRules = currentIRule.getTokenTypeRule();
                if (ttRules == null || ttRules.isEmpty()) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No TokenTypeRule elements found.");
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found trust authentication configured endpoint: " + currentEndpoint);
                }
                endpointList.add(currentEndpoint);
                continue block2;
            }
        }
        String[] endpoints = new String[endpointList.size()];
        endpoints = endpointList.toArray(endpoints);
        this.setResult(endpoints);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }
}

